""" read from a Dacapo calculator """

import os
from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms
import Numeric as num
from ASE.Utilities.Tests import ReportTest

def read(atoms):
    calc = atoms.GetCalculator()
   
    # IBZKpoints
    kpoints = calc.GetIBZKPoints()
    ReportTest("Number of kpoints",len(kpoints),1,0)
 

    # eigenvalues
    eigenvalues = calc.GetEigenvalues()
    ReportTest("Energy of first eigenvalue ",eigenvalues[0],-27.8615103,0.00001)

    # wavefunction
    wf = calc.GetWaveFunctionArray(band=0)
    shape = num.shape(wf)
    maxwf = max(max(max(abs(wf))))
    ReportTest("Shape of wavefunction ",len(shape),3,0.0)

    # total energy
    energy = atoms.GetPotentialEnergy()
    ReportTest("Total energy ",energy,-591.39007,0.00001)

    # forces
    forces = atoms.GetCartesianForces()
    ReportTest("Forces ",forces[0][0],-8.5829322,0.0001)

    # spin
    spin = calc.GetSpinPolarized()
    ReportTest("Reading spinpolarized ",spin,0,0)

    # exc functional
    exc = calc.GetXCFunctional()
    ok = 0
    if exc=='PW91': 
	ok = 1 
    ReportTest("Reading xc functional ",ok,1,0)

    # number of bands
    nbands = calc.GetNumberOfBands()
    ReportTest("Reading number of bands ",nbands,10,0)
    

atoms = ListOfAtoms([Atom('C', (2, 2, 2)),
                     Atom('O', (3.1, 2, 2))],
                     cell=(4, 4, 4), periodic=1)

# remove out file if any 
os.system('rm -f CO_in_a_box.txt CO_in_a_box.nc')

# start from scratch
calc = Dacapo(planewavecutoff=300,    # in eV
		nbands=10,            # 5 extra empty bands
		out='CO_in_a_box.nc',txtout='CO_in_a_box.txt')

atoms.SetCalculator(calc)

calc.StayAliveOff()

# read
print 'Reading from scratch ..'
read(atoms)


# start from file
print 'Reading from file ..'
atoms = Dacapo.ReadAtoms('CO_in_a_box.nc')
read(atoms)

ReportTest.Summary()



