"""  loop over lattice constant for Al.
Test that the calculator will restart then unitcell is changed.  
"""

import sys
from Dacapo import Dacapo
from ASE import Atom,ListOfAtoms
from ASE.Visualization.gnuplot import gnuplot
import os

bulk = ListOfAtoms([Atom('Al', (0,    0,     0))] )
a0_fcc = 4.05
b = a0_fcc/2.
bulk.SetUnitCell([(0, b, b), (b, 0, b), (b, b, 0)])

# remove output files
calc = Dacapo(
              kpts=(6,6,6),              # set the k-points Monkhorst-Pack 
              planewavecutoff=200,       # planewavecutoff in eV
              nbands=6,                  # set the number of electronic bands
              usesymm=True,              # use symmetry to reduce the k-point set
              out='Al-fcc.nc',           # define the out netcdf file
              txtout='Al-fcc.txt',       # define the ascii out file
              infile = 'in.nc' )      

calc.SetDensityCutoff(400)

bulk.SetCalculator(calc)

latticeconstants = [3.90,3.95,4.00,4.05,4.10,4.15,4.20]
latticeconstants = [3.90,3.95]
# make a plot of the convergence with respect to k-points
energies = []
for a in latticeconstants:

    b = a/2.
    bulk.SetUnitCell([(0, b, b), (b, 0, b), (b, b, 0)])
    energy = calc.GetPotentialEnergy() 
    energies.append((a,energy))

plot1 = gnuplot(energies) 

# now the same with stayalive off
calc.StayAliveOff() 

# energies = []
# for a in latticeconstants:

 #    b = a/2.
 #    bulk.SetUnitCell([(0, b, b), (b, 0, b), (b, b, 0)])
 #    energy = calc.GetPotentialEnergy()
 #    energies.append((a,energy))

# plot2 = gnuplot(energies)


