"""CO dimer in a box."""

import os
from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms

atoms = ListOfAtoms([Atom('C', (2, 2, 2)),
                     Atom('O', (3.1, 2, 2))],
                     cell=(4, 4, 4), periodic=1)

calc = Dacapo(planewavecutoff=300,    # in eV
	      nbands=10,              # 5 extra empty bands
	      out='CO_relaxed_in_a_box.nc', 
              txtout='CO_relaxed_in_a_box.txt')

atoms.SetCalculator(calc) 

calc.StayAliveOn()

from ASE.Dynamics.MDMin import MDMin

dyn = MDMin(atoms, dt=0.04, fmax=0.05)
dyn.Converge()
