#include "definitions.h"
#define DEBUGINIT 1

      module init_wave_function

      contains
!======================================================================
!     wfcinit.F
!     Initialize wave function for this one k-point
!
!     printout of debug info : define preprocessor symbol  DEBUGINIT
!=======================================================================
      subroutine wfinit(ndcbyt,recc,&
            nplwkp,&
            nelect,occ,&
            mmaxx,nlnum,mmax,rlog,radius,rdensr, &
            charge_density_initialized,&
            phiatm,phir2v,wtkpt,width,eigen,lmastr,&
            cptwfp,&
#           include "potential_args.h"
#           include "apply_h_args.h"
            ,timer,nconso)
!=======================================================================
#ifdef PARAL
      use par_functions_module
#endif PARAL
      implicit none
!=======================================================================
#     include "apply_h_decl.h"
#     include "potential_decl.h"
      integer  ndcbyt
      integer nconso
      real*8  recc(3,3)
      integer nplwkp
      real*8    nelect
      real*8    occ(nbands,nkprun)
      integer   mmaxx
      integer   nlnum(nspec)
      integer   mmax(nspec)
      real*8    rlog(nspec)
      real*8    radius(mmaxx,nspec),rdensr(nplwv,*)
      logical*4 charge_density_initialized,lmastr
      real*8    phiatm(mmaxx,0:2,nspec)
      real*8    phir2v(mmaxx)
      real*8 wtkpt(nkprun),width,eigen(nbands,nkprun)
      real*8  timer(*)
      complex*WF_PRECISION cptwfp(nrplwv,nbands,*)

!     locals
      complex*WF_PRECISION, allocatable :: psi(:,:)    
      real*8 dwor12(nrplwv,3)
      integer nn,nbandx,nsp,nk,nb,nnn,npos,mm,iproj,nwfct,icheck
      integer nwork1(nbands,nkprun),nkpeff
      real*8  enfrec,ocvar,efermi,zero,energy,lasterg
      real*8    worint(mmaxx)
      parameter(zero=0.0d0) 
#ifdef PARAL
      integer offset(par_pw_np),nlocal(par_pw_np)
#endif        
      integer irank,n_local

      call geteff(nkp,nkpmem,nconso,nkpeff)
!======================================================================
#ifdef PARAL
!     find lenght of wavefunction array for this process
      call  par_defwfk (nrplwv,nrplwv_global,nplwkp,nlocal,&
                        offset,n_local,&
#include PARAL_ARGS
        , nconso)
      call par_rank_pw(irank,&
#include PARAL_ARGS
        ,nconso   )
#else
      irank = 1
      n_local = nplwkp
#endif                                                
!=======================================================================
! Generate the wavefunctions from scratch
! Using LCAO method.

! First set the max number of initial wavefunctions 
      nbandx = 0   
      do nsp = 1,nspec
         nbandx = nbandx + nionsp(nsp)*(nlnum(nsp))**2
      enddo

#ifdef DEBUGINIT
      write(nconso,*) 'WFG: ',nbandx,  &
         'atomic wavefunctions used to initialize wavefunctions'
        call uflush(nconso)
#endif DEBUGINIT 

!     allocate room for initial set of wavefunctions
      allocate(psi(nrplwv,max(nbandx,nbands)),STAT=icheck)
      if (icheck.gt.0) call abort_calc(nconso,&
       'wfinop: error allocating psi. error = ' // as_string4(icheck))

      call wfinop(psi,recc, rdensr,charge_density_initialized,&
           nplwkp,n_local,&
           dwor12,mmaxx,nlnum,mmax,rlog,radius,&
           phiatm,phir2v,worint,nbandx,eigen(1,nkp),lmastr,&
#include   "potential_args.h"
#include   "apply_h_args.h" 
           ,timer,nconso)

!     If nbands is greater that the number of setup wavefunctions 
!     generated from the LCAO method (nbandx) intialize the 
!     rest of the bands. 
      if (nbandx.lt.nbands) then 
!=======================================================================
! initialise the wavefunctions above nbandx to zero (i.e. the c(n,k+g) )
!=======================================================================
      nbandx = nbandx + 1
      do nb=nbandx,nbands
        do mm=1,nrplwv
          psi(mm,nb)=(0.0d0,0.0d0)
        enddo   
      enddo   
!=======================================================================
! initialise the energies of the basis states to a large value so that
! lower energy basis states will be found
!=======================================================================
      do nb=nbandx,nbands
        eigen(nb,nkp)=1000.0d0
      enddo   
!=======================================================================
! Find the nbands lowest kinetic energy plane waves
!=======================================================================
!     only do this for master node 
      if (irank==1) then 
        do 2100 nnn=1,n_local
         energy=pwkine(nnn,nkp)
!=======================================================================
! Determine if this is a low kinetic plane wave
! However make sure that the energy is bigger compared to the eigen 
! values allready found
!=======================================================================
         if (energy.lt.eigen(nbands,nkp)) then
           lasterg = -1000.0d0
           if (energy.gt.lasterg) then 
!=======================================================================
! Find the position
!=======================================================================
            npos=nbands
            do 2110 nb=nbands,nbandx,-1
               if(energy.ge.eigen(nb,nkp)) go to 2200
               npos=nb
 2110       continue
 2200       continue
!=======================================================================
! Shift previous found plane waves and store the present
!=======================================================================
            if (npos.lt.nbands) then
              do 2210 nb=nbands,npos+1,-1
               eigen(nb,nkp)=eigen(nb-1,nkp)
               nwork1(nb,nkp)=nwork1(nb-1,nkp)
 2210         continue
            endif
            eigen(npos,nkp)=energy
            nwork1(npos,nkp)=nnn
           endif
         endif
 2100   continue

!=======================================================================
! from the indices of the lowest energy basis states initialise the
! wavefunctions succesively
!=======================================================================
        do 2500 nb=nbandx,nbands
          psi(nwork1(nb,nkp),nb)=(1.0d0,0.0d0) 
 2500   continue

       endif   ! if irank==1 

      endif  ! (nbandx.lt.nbands) 

!     write nbands wavefunctions to disk 
      call wfswap_put(psi(:,1:nbands),nkp,nrplwv,nbands,nkpmem,&
                      nkprun,ndcbyt)

      cptwfp(1:nrplwv,1:nbands,nkpeff) = psi(1:nrplwv,1:nbands)

      deallocate(psi)

      end subroutine wfinit
!=======================================================================
      subroutine wfinop(psi,recc,rdensr,charge_density_initialized,&
           nplwkp,n_local,&
           dwor12,mmaxx,nlnum,mmax,rlog,radius,&
           phiatm,phir2v,worint,nbandx, eigen,lmastr,&
#include   "potential_args.h"
#include   "apply_h_args.h" 
           ,timer,nconso)
!=======================================================================
! initialise the wavefunctions 
!        First setup the potential from overlap of atomic orbitals
!          call initpot
!
!        repeat for all atoms
!           make atomic wavefunctions for this atom |psi>

!        make <psi|H|psi> and <psi|S|psi>

!        diagonalize H psi = S psi
!        vector rotate psi
!
!=======================================================================
      use module_rmm_diss, only : setup_bhb_bsb
#ifdef PARAL
      use par_functions_module
#endif PARAL
      implicit none
#     include "apply_h_decl.h"
#     include "potential_decl.h"
      real*8  recc(3,3),rdensr(nplwv,*)
      logical*4 charge_density_initialized
      integer   nplwkp,n_local
!=======================================================================
      integer nconso
      real*8 dwor12(nrplwv,3)
      integer nlnum(nspec)
      integer mmaxx,mmax(nspec)
      real*8 rlog(nspec)
      real*8 radius(mmaxx,nspec)
      real*8 phiatm(mmaxx,0:2,nspec)
      real*8 phir2v(mmaxx)
      real*8 worint(mmaxx)
      integer  nbandx,sprod,natm,nwfatm
      real*8   eigen(nbands),eigen1(nbandx)
      logical*4 lmastr
      character*2 atomname
      real*8  timer(*)
!=======================================================================
! Local vars
!=======================================================================
      integer    n,ns,m,n1,nsp,i,j,nbands1,ni,l
!
!     psi_fl holds initial set of wavefunctions for one atom
      complex*WF_PRECISION :: psi_fl(nrplwv_global)

      complex*WF_PRECISION psi(:,:) 

      complex*16  hmat(nbandx,nbandx),smat(nbandx,nbandx)
      complex*16  U(nbandx,nbandx)
      complex*WF_PRECISION czero,cone
      parameter(czero=(0.0d0,0.0d0),cone=(1.0d0,0.0d0) ) 
      
      integer     icheck ,nb,na
      real*8      eig(nbandx),vnltmp
      complex*16  cdum,sdum
      real        NORM2
#ifdef PARAL    
      integer offset(par_pw_np)
      integer nlocal(par_pw_np) 
#endif PARAL 
      logical*4  exists                         

!=======================================================================
! check that there are more basis states than bands
!=======================================================================
      if (nbands.gt.nplwkp) then
         write(nconso,*) 'INI:  Error!  Only ',nplwkp,' plane waves'
         write(nconso,*) 'INI:          but  ',nbands,' bands'
         write(nconso,*) 'INI: Possibly the cutoff is far too small'
         write(nconso,*) 'INI: Possibly the basis vectors are wrong'
         call clexit(nconso)
      endif
!=======================================================================
!     first setup the potential for a superposition of atomic densities 
#ifdef DEBUGINIT
      write(nconso,*) 'WFG: Setup initial potential'
      call uflush(nconso)
#endif DEBUGINIT      

      call potinit( mmaxx,mmax, rlog,radius,&
                    recc,rdensr,charge_density_initialized,&
                    lmastr, & 
#                   include   "potential_args.h"
#                   include "apply_h_args.h" 
                    ,timer )
!=======================================================================
#ifdef PARAL 
      n_global = nplwkp  ! parallel_args
#endif
!=======================================================================
#ifdef DEBUGINIT
      write(nconso,*) 'WFG: Start loop over atoms'
      call uflush(nconso)
#endif DEBUGINIT
!======================================================================
!     now loop over all atoms and setup s,p and d wave functions
      nb = 1
      na = 1
      do nsp=1,nspec
        do natm = 1,nionsp(nsp)

#ifdef DEBUGINIT
          write(nconso,*) 'WFG: init wavefunction nsp = ',nsp, &
                           'natm = ',natm  
          call uflush(nconso)
#endif DEBUGINIT

!         loop over s, p, d orbitals for this atom
          do l = 1, nlnum(nsp)**2

!           find out if this process should handle this band
#ifdef PARAL 
            call par_band_exists_on_this_proc(nb,nbandx,par_pw_np,&
#include PARAL_ARGS
                                              ,exists, nconso)
#else 
            exists = .true.
#endif
            if (exists) then 
             call atomic(l-1,na,nrplwv_global,nplwkp,dnlkg(1,0,nkp),&
              volc,psi_fl,posion(:,natm,nsp),dnlg(1,1,nkp),dirc,mmaxx,&
              mmax(nsp),rlog(nsp),radius(1,nsp),phiatm(:,:,nsp))
            endif 
!           transform hpsiwork back on nodes to hpsi
#ifdef PARAL
            call par_getback(psi_fl,nb,nbandx,par_pw_np,&
#include PARAL_ARGS
                          ,psi,nrplwv,exists,timer,nconso)
#else
            psi(:,nb) = psi_fl(:) 
#endif     
          nb = nb + 1
          enddo  ! loop l                                      
          na = na + 1
        enddo    ! loop natm
      enddo      ! loop nsp
!=======================================================================

      if (n_local<nrplwv) psi(n_local+1:nrplwv,:) = 0.0d0

      ! setup <b|H|b> (hmat) and <b|S|b> (smat)
      call setup_bhb_bsb(psi,nplwkp,nbandx,hmat,smat,&
#include "apply_h_args.h"
                        ,timer, nconso)

      !  diagonalize
      call cdiaghg(nbandx,hmat,smat,nbandx,eigen1,U )
 
      ! vector rotate (b(:,:) = b(:,:)*u(:,:)) cptwfp
      call vec_rotate(psi,nrplwv,n_local,nbandx,nbandx,U,nbandx,timer)         

      eigen(1:min(nbands,nbandx)) = eigen1(1:min(nbands,nbandx))

      end subroutine wfinop

!=======================================================================
      subroutine atomic(l,atomnr,nrplwv,nplwkp,&
                        dnlkg,volc,psi,posion,dnlg,&
                        dirc,mmaxx,&
                        mmax,rlog,radius,phiatm )
!=======================================================================
! Construct the orbitals 
!     l = 0         : s
!     l = 1,2,3     : p_x,p_y,p_z
!     l = 4,5,6,7,8 : d_xxx ...
! centered at the position posion
! The result is returned in psi. 
!=======================================================================
      use run_context
      implicit none
!=======================================================================
      integer l,atomnr,nrplwv,nplwkp
      real*8 dnlkg(nrplwv,0:3),volc
      complex*WF_PRECISION psi(nrplwv)
      real*8 posion(3)
      real*8 dnlg(nrplwv,3)
      real*8 dirc(3,3)
      integer mmaxx,mmax
      real*8 rlog
      real*8 radius(mmaxx)
      real*8 phiatm(mmaxx,0:2)

!     locals 
      real*8 phir2v(mmaxx),worint(mmaxx) 
      real*8 twopi,bohr
      real*8 eps,q1
      parameter (twopi=6.28318531d0,bohr=0.529177d0)
      parameter (eps=1.0d-30)
      complex*WF_PRECISION, allocatable,save :: cphsgr(:)
      complex*16 pf
      integer nb,ir,ig,m,lang
      integer, save :: atomold=0,langold=-1

      real*8 radial(nrplwv),arg,fac,rj1,x,y,z,gdotr,simps
!======================================================================= 
! Set up the normalized s-,p- or d-wave functions (for R=(0,0,0) )
!     s : l = 0
!     p_x,p_y,p_z : l = 1,2,3
!     d_xx        : l = 4,5,6,7,8
!     
!     set the prefactor 
      pf = (0.0d0,-1.0d0)
      pf = dsqrt(2.0d0*twopi*(2.d0*l+1.d0)/volc)*pf**l
!=======================================================================
! calculate the integral of j_l(|kr|)*phi_l(r)r^2
!=====================================================================
!     get nagular momentum
      if (l==0)            lang = 0
      if ((l>0).and.(l<4)) lang = 1
      if (l>3)             lang = 2

      if (.not.allocated(cphsgr)) allocate(cphsgr(nrplwv)) 
!     check if we should recalculate cphsgr
      if ((atomnr/=atomold) .or.(lang/=langold)) then 
        atomold = atomnr
        langold = lang
        do ir=1,mmax
         phir2v(ir)=phiatm(ir,lang)*radius(ir)**2
        enddo
        do 2040 ig=1,nplwkp
         arg=dnlkg(ig,0)*bohr
!=======================================================================
! s-state specific code
!=======================================================================
         if (l.eq.0) then
            if (arg.lt.1.d-4) then
               do 2010 ir=1,mmax
                  worint(ir)=phir2v(ir)
 2010          continue
            else
               do 2020 ir=1,mmax
                  fac=arg*radius(ir)
                  if (fac.lt.eps) then 
                     fac = 1.0d0 
                  else 
                     fac=sin(fac)/fac
                  endif
                  worint(ir)=fac*phir2v(ir)
 2020          continue
            endif
!=======================================================================
! worint now contains something like d_pot*wave*sinc(g*r)
!=======================================================================
              if (radius(1).lt.eps) then 
                call radlg(mmax,worint,radius,rlog,q1)
              else 
                q1 = simps(mmax,worint,rlog) 
              endif
              radial(ig)=q1
!=======================================================================
! p- and d-state specific code
!=======================================================================
         else if ((l>0).and.(l<9)) then    
            if (arg.lt.1.d-4) then
               radial(ig)=0.0d0
            else
               do 2030 ir=1,mmax
                  fac=arg*radius(ir)
                  if (fac.lt.eps) then 
                     fac = 0.0d0 
                  else 
                     rj1=(sin(fac)/fac-cos(fac))/fac
                     if (l<4) then
                       fac=rj1
                     else
!=======================================================================
! j_l+1(kr)=(2*l+1)/kr j_l(kr) - j_l-1(kr)
!=======================================================================
                       fac=(3.*rj1-sin(fac))/fac
                     endif
                  endif
                  worint(ir)=fac*phir2v(ir)
 2030          continue
!=======================================================================
! 
!=======================================================================
              if (radius(1).lt.eps) then 
                call radlg(mmax,worint,radius(1),rlog,q1)
              else 
                q1 = simps(mmax,worint,rlog) 
              endif
              radial(ig)=q1
!             write(nconso,*) 'radial ',l,ig,radial(ig),rlog
!=======================================================================
            endif
         else
            write(nconso,*)'INI: Only s-, p- and d-atomic funcs'
            call clexit(nconso)
         endif
 2040 continue
!=======================================================================
! Initialize phasefactors for atom natm of species nsp
!=======================================================================
         x=posion(1)*dirc(1,1)+posion(2)*dirc(2,1)+posion(3)*dirc(3,1)
         y=posion(1)*dirc(1,2)+posion(2)*dirc(2,2)+posion(3)*dirc(3,2)
         z=posion(1)*dirc(1,3)+posion(2)*dirc(2,3)+posion(3)*dirc(3,3)
         do 3000 m=1,nplwkp
            gdotr=dnlg(m,1)*x+dnlg(m,2)*y+dnlg(m,3)*z
            cphsgr(m)=dcmplx(cos(gdotr),-sin(gdotr))*radial(m)
 3000    continue

      endif ! if atomold /= atomnr .or. langold /= lang 
!=======================================================================
! Construct an s-orbital
!=======================================================================
         psi(:) = 0.0d0
         if (l.eq.0) then
            do 3020 m=1,nplwkp
               psi(m)=cphsgr(m)
 3020       continue
!=======================================================================
! Construct the three p-orbitals
!=======================================================================
         else if ((l>0).and.(l<4)) then
            do 3030 m=1,nplwkp
               psi(m)=cphsgr(m)*dnlkg(m,l)
 3030       continue
!=======================================================================
! Construct the five d-orbitals
!=======================================================================
         else if (l>3) then
!=======================================================================
! The projectors are the normalized versions of:
! 1: Y_20   2: Y_21+Y_2-1   3: Y_21-Y_2-1   4: Y_22+Y_2-2   5: Y_22-Y_2-2
!=======================================================================
            if (l==4) then 
              do  m=1,nplwkp
               psi(m)=cphsgr(m)*(3.d0*dnlkg(m,3)**2-1.0d0)
              enddo
            else if (l==5) then 
              do  m=1,nplwkp
               psi(m)=cphsgr(m)* dnlkg(m,2)*dnlkg(m,3)
              enddo
            else if (l==6) then 
              do  m=1,nplwkp
               psi(m)=cphsgr(m)* dnlkg(m,1)*dnlkg(m,3)
              enddo
            else if (l==7) then 
              do  m=1,nplwkp
               psi(m)=cphsgr(m)*&
                            (dnlkg(m,1)**2-dnlkg(m,2)**2)
              enddo
            else if (l==8) then 
              do  m=1,nplwkp
               psi(m)=cphsgr(m)* dnlkg(m,1)*dnlkg(m,2)
              enddo
            endif
         endif
      end subroutine atomic

!========================================================================

      function as_string4 (i)
!     Cast integer i to a string(len = 4)
 
      integer             :: i
      character(len = 4)  :: the_string
      character(len = 4)  :: as_string4
      write(the_string, '(i4)') i
 
      as_string4=the_string
 
      end function as_string4

      end module init_wave_function
