#include "definitions.h"
      subroutine us_calcqr_id(nconso)
      write(nconso,*) '@(#)us_calcqr.F	1.13 7/1/99'
      return
      end
!----------------------------------------------------------------------
      subroutine calcqr(npw,ngldim,ngl,nspec,volc,q,qr,idbes,&
                        ivjv2index,maxindex)
!----------------------------------------------------------------------
!
!
!  input : 
!      lll     lll(i) is the l-quantum number for the i-beta function
!      qfunc   Q_ij(r) function
!      qfcoef  coefficients to pseudized the Q_ij(r) function 
!              inside rinner radius
!
! 
!  output : 
!      qr     qrad in main program        
!             Qnm(|r|) in reciprocal space. qr is an array on G-shells 
!             ivjv2index: iv,jv -> index into qrad
!             maxindex : max index
!
!
      use basicdata
      implicit none
      include 'readvan.h'
!
      integer npw,ngldim
      integer idbes,ngl
      integer nspec
      real*8  volc,q(npw)
#ifdef QRAD_SWAP
      real*8  qr(ngldim,nbrx2dim,lqx)
#else
      real*8  qr(ngldim,nbrx2dim,lqx,nspec)
#endif QRAD_SWAP
      integer ivjv2index(nbrx,nbrx,nspec)
      integer maxindex(nspec)

!     locals
      integer ik,  msh, i, np, np1,m, k, l,igl,nqrad
      real*8  jl(ndm), ql,jlp1(ndm),aux(ndm),sum
      integer ilmin,ilmax,iv,jv
      integer ndbyte,recno
      real*8      eps,diff
      parameter   (eps=1.0d-9, ndbyte=8)

#ifdef QRAD_SWAP
      if (nspec.gt.1) then 
!       use swap-file for qrad       
        call openqrad(ngl) 
      endif
#endif QRAD_SWAP
      
      maxindex(:) = 0
      do np = 1,nspec    ! loop over different pseudopotentials

      if (nbeta(np).eq.0 ) cycle
 
      msh=kkbeta(np)
      if (tvanp(np)) then
          nqrad = 1
          do iv =1, nbeta(np)
             do jv =iv, nbeta(np)
                  ilmin = iabs(lll(iv,np)-lll(jv,np))
                  ilmax = iabs(lll(iv,np)+lll(jv,np))
!       only need to calculate for for lmin,lmin+2 ...lmax-2,lmax
                  do l = ilmin,ilmax,2
                     do i =  msh,2,-1
                        if (r(i,np) .lt. rinner(l+1,np)) goto 100
                        aux(i) = qfunc(i,iv,jv,np)
                     enddo
 100                 call setqf(qfcoef(1,l+1,iv,jv,np),aux(1),r(1,np)&
                          ,nqf(np),l,i)

                     igl=1
                     do ik=1, npw
                        if (ik .gt. 1) then
!                          find the different G-shells
                           if (q(ik) .lt. q(ik-1)+EPS) goto 10
                        endif
                        ql = dsqrt(q(ik))*tpiba
                        ql = ql*bohr
                        if (idbes .eq. 1) then
                           call dbess(ql,l+1,msh,r(1,np),&
                                jl)
                        else
                           call bess(ql,l+1,msh,r(1,np),&
                                jl)
                        endif
! jl is now the derivative of the Bessel functions
! now integrate beta*jl*r^2
                        do i=1, msh
                           jlp1(i) = jl(i)*aux(i)
                        enddo
                        if (tlog(np)) then
                           if(tvanp(np)) then
                              call radlg1(msh,jlp1,rab(1,np),sum) 
                           else
                              call radlg(msh,jlp1,r(1,np),dx(np),sum)
                           endif
                        else
                           call radin(msh,dx(np),jlp1,sum)
                        endif
!                      unit for qq is Angstrom     
#ifdef QRAD_SWAP
                         qr(igl,nqrad,l+1)    = &
#else
                         qr(igl,nqrad,l+1,np) = &
#endif QRAD_SWAP
                sum*fpi*bohr/((rydb1_eva1)**2)
                        igl = igl+1
 10                  end do
      
                     if (igl .ne. ngl+1) &
                       call report_error('calcqr','igl.ne.ngl ',igl)

                  end do  !  do l 
                  ivjv2index(iv,jv,np) = nqrad
                  ivjv2index(jv,iv,np) = nqrad
                  nqrad = nqrad + 1

              end do      !  do jv
            enddo         !  do iv
         endif

         maxindex(np) = ivjv2index(nbeta(np),nbeta(np),np) 

! if swapping is used for qrad write to disk for species np
#ifdef QRAD_SWAP
         if (nspec.gt.1) then 
!          write qrad for specie np to disk
           recno = 1
           do np1 = 2,np
             recno = recno + maxindex(np1-1)*lqx*(np1-1)
           enddo
           do nqrad = 1,maxindex(np)
             do l = 1,lqx
                write(44,rec=recno)(qr(igl,nqrad,l),igl=1,ngl) 
                recno = recno + 1
             enddo
           enddo
         endif
#endif QRAD_SWAP

         enddo   ! np = 1,nspec

#ifdef QRAD_SWAP
         if (nspec.gt.1) close(UNIT=44)
#endif QRAD_SWAP

!
!                      if ((iv.eq.1).and.(jv.eq.1)) then 
!                      write(*,*) 'calcqr,qr(G) ',
!    &                       iv,jv,l,ql,qr(igl,jv,iv,l+1,np) 
!                      endif
!                    write(*,*) 'calcqr,qr(G=0) ',
!    &                     iv,jv,l,qr(1,jv,iv,l+1,np) 

      return
      end

     
!----------------------------------------------------------------------
      subroutine readqrad(ngldim,ngl,np,qrad,maxindex) 
!----------------------------------------------------------------------
      use basicdata
      implicit none
      integer  ngldim,ngl,np,maxindex(*)
      include 'readvan.h'
      real*8  qrad(ngldim,nbrx2dim,lqx)
! 
      integer iv,jv,l,recno,ndbyte,igl,np1,nqrad
      parameter(ndbyte=8)
!     read qrad 
      recno = 1
      do np1 = 2,np
        recno = recno + maxindex(np1-1)*lqx*(np1-1)
      enddo

      do nqrad = 1,maxindex(np)
        do l = 1,lqx
          read(44,rec=recno)(qrad(igl,nqrad,l),igl=1,ngl)
          recno = recno + 1
        enddo
      enddo
      
      return 
      end

!----------------------------------------------------------------------
      subroutine openqrad(ngl)
!----------------------------------------------------------------------  
      use run_context
      implicit none
      integer ngl
     
      integer ndbyte
      parameter(ndbyte=8)
      open(UNIT=44,file=qrad_swap_filename,access='direct',&
        form='unformatted',recl=ndbyte*ngl)

      return  
      end


!----------------------------------------------------------------------
      subroutine calcvq(npw,npw_dim,nspec,q,vq,idbes)
!----------------------------------------------------------------------
!
!   
!     Fourier transform the betar(r) functions and return the 
!     result in vq(G)
!   
!----------------------------------------------------------------------
      use basicdata
      implicit none
      include 'readvan.h' 

      integer  npw, npw_dim, nspec, idbes
      real *8  q(npw_dim), vq(npw_dim,nbrx,nspec)
!
!     locals 
      real*8  jl(ndm), ql, jlp1(ndm), sum,eps,zero 
      parameter (eps=1.0d-9,zero=0.0d0)
      integer ik,  msh, i, m, k, l, n, np
!
         do np = 1,nspec    ! loop over different pseudo-potentials

         msh=kkbeta(np)
         do n=1,nbeta(np)

            l = lll(n,np)
            do ik=1, npw
               ql = zero
               if (q(ik) .gt. EPS) ql = dsqrt(q(ik))
               ql = ql*bohr
!              NOT SORTED SKAL RETTES
!              if (ik .gt. 1) then
!                 if (q(ik) .lt. q(ik-1)+EPS) goto 10
!              endif
               if (idbes .eq. 1) then
                  call dbess(ql,l+1,msh,r(1,np),jl)
               else
                  call bess(ql,l+1,msh,r(1,np),jl)
               endif
! jl is now the derivative of the Bessel functions
! now integrate beta*jl*r^2
               do i=1, msh
                  jlp1(i) = jl(i)*betar(i,n,np) *r(i,np)
               enddo
               if (tlog(np)) then
                  if(tvanp(np)) then
                     call radlg1(msh,jlp1,rab(1,np),sum) 
                  else
                     call radlg(msh,jlp1,r(1,np),dx(np),sum)
                  endif
               else
                  call radin(msh,dx(np),jlp1,sum)
               endif
 10            vq(ik,n,np) = sum
            end do
!           write(*,*) 'calcvq: vq(G=0) ',np,n,l,vq(1,n,np)
         end do

         end do   ! np = 1,nspec
!
      return
      end




!----------------------------------------------------------------------
      subroutine dvus_bessel(nplwkp,nrplwv_global,nrplwv,nspec,nkbp,&
                 nhm,vq,dvkb,ylm,nh,indv,nhtol,nhtom,volc,vkbreal&
#ifdef PARAL
                         ,&
#include                 PARAL_ARGS
#endif
                         )                  
!----------------------------------------------------------------------
      use basicdata
      use run_context
!
!
!     dvkb(G) =  vq(G) * YLM
!
!     for parallel program 
!       dvkb (vkb in main program) is distributed out on nodes) 
!
      implicit none 
#ifdef PARAL 
#include  PARAL_DECL
#endif

      integer     nplwkp,nrplwv_global,nrplwv,nspec,nkbp,nhm
      integer     nh(nspec),indv(nhm,nspec),nhtol(nhm,nspec)
      integer     nhtom(nhm,nspec)
      real*8      vq(nrplwv_global,nbrx,nspec)
      real*8      ylm(nrplwv_global,(lmaxx+1)**2)
      real*8      volc
      real*8      dvkb(nrplwv,nkbpmaxatom,nspec)
      logical*4   vkbreal(nkbpmaxatom,nspec)

!     locals 
      integer     ik, na, msh, i, np, m, k, l,  jkb,i1
      integer     nplwkp_local,offs
      complex*16  pref
      integer     lm,n,iv
      real*8      eps
      parameter   (eps=1.0d-9)
#ifdef PARAL
      integer     nlocal(par_pw_np),offset(par_pw_np)
#endif              


#ifdef SERIAL
      nplwkp_local = nplwkp
      offs = 0
#else
!     For parallel job set offset for skb and vkb (full lenght arrays)
!     and define the number of planewaves on this node (nlocal)
!
      call par_defwfk (nrplwv,nrplwv_global,nplwkp,nlocal,offset,&
                         nplwkp_local,&
#include PARAL_ARGS
        , nconso)
      offs = offset(par_process+1)
#endif                    

!**

      jkb = 1
      do np = 1,nspec 

      do iv=1,nh(np)
            n = indv(iv,np)
            l = nhtol(iv,np)
            m = nhtom(iv,np)
            lm = l*l+m
            pref = (0.0d0,-1.0d0)
! correct prefactor is fpi/sqrt(omega) (-i)^l
            pref = fpi/dsqrt(volc)*pref**l
            if (vkbreal(iv,np)) then
              do ik=1,nplwkp_local
                dvkb(ik,iv,np) = &
                  dreal(pref*ylm(ik+offs,lm)*vq(ik+offs,n,np))
              enddo
            else
              do ik=1,nplwkp_local
                dvkb(ik,iv,np) = &
                  dimag(pref*ylm(ik+offs,lm)*vq(ik+offs,n,np))
              enddo
            endif
           
            jkb = jkb+1
      enddo

      enddo   ! np = 1,nspec
      if (jkb.ne.nkbp+1) &
          call report_error('dvus_bessel','unexpected error',jkb)
!**
      return
      end




!-----------------------------------------------------------------------
!
      subroutine setqf(qfcoef,rho,r,nqf,ltot,i2)
!
!-----------------------------------------------------------------------
!
      implicit double precision(a-h,o-z)
!
!.....logarithmic radial mesh information
      dimension r(i2)
!.....q pseudization coefficients
      dimension qfcoef(nqf)
!.....scratch
      dimension rho(i2)
!
!-----------------------------------------------------------------------
!
!     s e t  q f u n c  f o r  t h i s  l t o t  =  l m i n
!
!
      do 500 ir = 1,i2
        rr = r(ir)**2
        rho(ir)=qfcoef(1)
        do 510 iqf=2,nqf
          rho(ir)=rho(ir)+qfcoef(iqf)*rr**(iqf-1)
  510   continue
        rho(ir) = rho(ir)*r(ir)**(ltot+2)
  500 continue
!
!
      return
      end
