#include "definitions.h"

      subroutine qvan2(ng1,ngy,iv,jv,is,nqgm,qg,ylm,qr,ngdens,&
                    nspec,ngldim,igtongl,nhm,indv,nhtol,nhtom,&
                    ap,lpx,lpl,ivjv2index,nbrx,nlx,mx,nbrx2dim,lqx)

!     Q(G,L,K) = SUM_LM (-I)^L AP(LM,L,K) YR_LM(G^) QRAD(G,L,L,K)

!     use basicdata, only : nbrx,nlx,mx,nbrx2dim,lqx
      implicit none

      integer nbrx,nlx,mx,nbrx2dim,lqx
      integer ng1,ngy,iv,jv,is
      integer nqgm
      integer ngldim,ngdens,nspec,igtongl(ngdens)
      real*8  ylm(nqgm,*)
      complex*16   qg(*)
      integer nhm   
      integer indv(nhm,nspec),nhtol(nhm,nspec),nhtom(nhm,nspec)
      integer ivjv2index(nbrx,nbrx,nspec)

      real*8    ap(25,nlx,nlx)
      integer   lpx(nlx,nlx),lpl(nlx,nlx,mx)
#ifdef QRAD_SWAP
      real*8    qr(ngldim,nbrx2dim,*)
#else
      real*8    qr(ngldim,nbrx2dim,lqx,nspec)
#endif QRAD_SWAP

!     Local variables
      complex*16 sig,h
      integer ivs,jvs,ivl,jvl,ig,lp,l,i,nqrad
!     Extraction of angular momentum l from lp (array contains l+1):
      integer,save :: ll(25)
      data ll /1, 3*2, 5*3, 7*4, 9*5/
!     The complex constant (-i) to the power 0..4
      complex*16, save ::  cil(5)
      data cil / (1.0d0,0.0d0), (0.0d0,-1.0d0), (-1.0d0,0.0d0),&
        (0.0d0,1.0d0), (1.0d0,0.0d0) /

!       IV  = 1..8    ! s_1 p_x1 p_y1 p_z1 s_2 p_x2 p_z2 p_y2
!       IVS = 1..4    ! s_1 s_2 p_1 p_2
!       IVL = 1..4    ! s p_x p_y p_z

!  NOTE :   IV  = 1..8 (sppp sppp)   IVS = 1..4 (sspp) OR 1..2 (sp)
!           IVL = 1..4 (sppp)

      ivs = indv(iv,is)
      jvs = indv(jv,is)
      nqrad = ivjv2index(ivs,jvs,is)
      ivl = nhtol(iv,is)*nhtol(iv,is)+nhtom(iv,is)
      jvl = nhtol(jv,is)*nhtol(jv,is)+nhtom(jv,is)

      qg(1:nqgm) = (0.0d0,0.0d0)

      do i=1,lpx(ivl,jvl)
        lp = lpl(ivl,jvl,i)
        l = ll(lp)
!       note:        (-i)^l
!       sig = (0.d0,-1.d0)**(l-1)
        sig = cil(l)
        sig = sig*ap(lp,ivl,jvl)
        do ig=ng1+1,ngy
          h = sig*ylm(ig-ng1,lp)*qr(igtongl(ig),nqrad,l)
          qg(ig-ng1)=qg(ig-ng1) + h
! #ifdef QRAD_SWAP
!                      qr(igtongl(ig),nqrad,l)
! #else 
!                      qr(igtongl(ig),nqrad,l,is)
! #endif QRAD_SWAP

        end do
      end do
      return
      end

!         if (IG.eq.1)
!         write(*,100) I,LP,L,SIG,Ylm(IG,LP),QR(igtongl(IG),
!    $          nqrad,L,IS)
! 100       format(5x,3(i2,1x),1('(',f7.3,f7.3,')'),1x,2(f7.3,1x))  

