!=======================================================================
      subroutine pwid(nconso)
      write(nconso,*) '@(#)pw.F	1.12 6/15/99'
      return
      end
!
!   subroutines generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991).  they are keyed to the "programmable
!       expressions" in the notes of 1/23/91.
!
! The pw() is called with two flags, lcalvx and lgga:
!
!  lgga   lcalvx  E_LDA  V_LDA  E_GGA  V_GGA  
!   FALSE  TRUE    yes    yes    no     no
!   TRUE   FALSE   yes    no     yes    no
!   TRUE   TRUE    no     no     yes    yes
!
      subroutine pw(lgga,lcalvx, &
           nconso,dn,volc,recc,lpctx,lpcty,lpctz,&
           excc,exc,ex,vxc,&
           cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc)

      use stress_module, only : xc_spin_gga_stress 

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      logical*4 lcalvx
      integer nconso,nplwv,npwxc,nspin
      dimension dn(nplwv,nspin)
      real*8 volc
      dimension recc(3,3)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 exc,ex(2)
      dimension vxc(nplwv,nspin)
      dimension dnlg0(nplwv,3)
      dimension cwork1(nplwv)
      logical*4 lgga
      integer ngx,ngy,ngz
! Local work arrays
! work arrays required no matter what lcalvx is
      dimension absnab(nplwv,2)
      dimension cab(nplwv)
      dimension divnab(nplwv)
! work arrays required when lcalvx is TRUE (in this case
! npwxc==nplwv)
      dimension dnabln(npwxc,nspin,3)
      dimension df2(npwxc,nspin)
      dimension dfud(npwxc)
!
! locals
!
      real*8 denmin
      real*8 exlda,exgga
!
      data pi,thrd,thrd2/3.14159265d0,0.333333333333d0,0.666666666667d0/
      data hartre/27.2116d0/
!
! make sure that negative and very small densities are omitted

      if (lgga) then
         denmin=0.0d0
         do i=1,nplwv
            if (dn(i,1).le.1.0d-10) then
               denmin = min(denmin,dn(i,1))
               vxc(i,1)=max(dn(i,2)/100.0d0,1.0d-10)
            else
               vxc(i,1)=dn(i,1)
            endif
            if (dn(i,2).le.1.0d-10) then
               denmin = min(denmin,dn(i,2))
               vxc(i,2)=max(dn(i,1)/100.0d0,1.0d-10)
            else
               vxc(i,2)=dn(i,2)
            endif
         enddo
      endif                    
!
! if lgga: the real space density is in vxc()
!=======================================================================
! 
!=======================================================================
      bohr = 0.529177d0
      angs = 1.0d0/bohr
      rconf = (3.d0*pi**2)**thrd
      rconrs = (3.d0/(4.d0*pi))**thrd
      vol = volc / (bohr**3)
      rinplw=1.0d0/dble(nplwv)

!
! find the density gradient terms
!
      if (lgga.and.lcalvx) then
!
! we have planty of workspaces
!
! loop over spin. n(up)->dn(n,1), n(down)->dn(n,2)
!
!
! Initialize Gx,Gy,Gz array
         do 1999 ispin=1,2
            do 1500 n=1,nplwv
               cab(n)=vxc(n,ispin)*rinplw
 1500       continue
         call fft3d(cab,ngx,ngy,ngz,-1)
!
! loop over x,y,z to get nabla n(spin) -> dnabln(n,spin,1..3)
! and |nabla n(spin)|^2 -> absnab(n,spin)
!
         do 1504 i=1,3
            do 1506 n=1,nplwv
               cwork1(n)=(0.0d0,1.0d0)*dnlg0(n,i)*cab(n)
 1506       continue
            call fft3d(cwork1,ngx,ngy,ngz,1)
!           For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1 .and. ispin.eq.1) then
              do 1508 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=dble(cwork1(n))**2
 1508         continue
            else if (i.eq. 1 .and. ispin.eq.2) then
              do 1518 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=dble(cwork1(n))**2
 1518         continue
            else if (i.eq. 2 .and. ispin.eq.1) then
              do 1509 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
 1509         continue
            else if (i.eq. 2 .and. ispin.eq.2) then
              do 1519 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
 1519         continue
            else if (i.eq. 3 .and. ispin.eq.1) then
              do 1510 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                absnab(n,ispin)=max (1.0d-20, absnab(n,ispin)) 
                absnab(n,ispin)=sqrt(absnab(n,ispin))
 1510         continue
            else if (i.eq. 3 .and. ispin.eq.2) then
              do 1520 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                absnab(n,ispin)=max (1.0d-20, absnab(n,ispin)) 
                absnab(n,ispin)=sqrt(absnab(n,ispin))
 1520         continue
            endif
 1504    continue
 1999 continue
!=======================================================================
! end of spin-loop
!=======================================================================
!     1 / (|nabla(up)+nabla(down)|**2)
      do 1614 n=1,nplwv
         divnab(n)=(dnabln(n,1,1)+dnabln(n,2,1))**2&
                  +(dnabln(n,1,2)+dnabln(n,2,2))**2&
                  +(dnabln(n,1,3)+dnabln(n,2,3))**2
!        Might omit this truncation ?
         divnab(n) = max (1.0d-10**2, divnab(n))
         divnab(n)=1.0d0 / sqrt(divnab(n))
 1614 continue

      else if (lgga.and..not.lcalvx) then
!
! do the same thing as above, but without workspaces, dnlg0 and dnabln
!
! loop over spin. n(up)->vx(n,1), n(down)->vx(n,2)
!
         do ispin=1,2
            do  n=1,nplwv
               cab(n)=vxc(n,ispin)*rinplw
            enddo
            call fft3d(cab,ngx,ngy,ngz,-1)
!
! loop over x,y,z to get nabla n(spin) -> dnabln(n,spin,1..3)
! and |nabla n(spin)|^2 -> absnab(n,spin)
!
            do i=1,3
               n=1
               do nz=1,ngz
                  g3i=recc(3,i)*lpctz(nz)
                  do ny=1,ngy
                     g2i=recc(2,i)*lpcty(ny)
                     do nx=1,ngx
                        g1i=recc(1,i)*lpctx(nx)
                        cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                        n=n+1
                     enddo
                  enddo
               enddo
               call fft3d(cwork1,ngx,ngy,ngz,1)
! For efficiency reasons we sum up according to the value of i /OHN
               if (i.eq. 1 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=dble(cwork1(n))**2
                  enddo
               else if (i.eq. 1 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=dble(cwork1(n))**2
                  enddo
               else if (i.eq. 2 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                  enddo
               else if (i.eq. 2 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                  enddo
               else if (i.eq. 3 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                     absnab(n,ispin)=sqrt(absnab(n,ispin))
                  enddo
               else if (i.eq. 3 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                     absnab(n,ispin)=sqrt(absnab(n,ispin))
                  enddo
               endif
            enddo
         enddo
!
! now calculate:   1 / (|nabla(up)+nabla(down)|**2)
!
         do n=1,nplwv
            cab(n)=(vxc(n,1)+vxc(n,2))*rinplw
         enddo
         call fft3d(cab,ngx,ngy,ngz,-1)
         do i=1,3
            n=1
            do nz=1,ngz
               g3i=recc(3,i)*lpctz(nz)
               do ny=1,ngy
                  g2i=recc(2,i)*lpcty(ny)
                  do nx=1,ngx
                     g1i=recc(1,i)*lpctx(nx)
                     cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                     n=n+1
                  enddo
               enddo
            enddo
            call fft3d(cwork1,ngx,ngy,ngz,1)
            if (i.eq.1) then
! cwork1: nabla(n(up)+n(down)_x
               do n=1,nplwv
                  divnab(n)=dble(cwork1(n))**2
               enddo
            else if (i.eq.2) then
! cwork1: nabla(n(up)+n(down)_y
               do n=1,nplwv
                  divnab(n)=divnab(n)+dble(cwork1(n))**2
               enddo
            else if (i.eq.3) then
! cwork1: nabla(n(up)+n(down)_z
               do n=1,nplwv
                  divnab(n)=divnab(n)+dble(cwork1(n))**2
! Might omit this truncation ?
                  divnab(n)=max (1.0d-10**2, divnab(n))
                  divnab(n)=1.0d0 / sqrt(divnab(n))
               enddo
            endif
         enddo
      endif

      exclda = 0.0d0
      excgga = 0.0d0
      ex(1)  = 0.0d0            
      ex(2)  = 0.0d0 
      if (lcalvx) then
         enxcc1l=0.0d0
         enxcc1g=0.0d0
      endif
!=====================================================================
! loop over all real space grid points in the super cell
!=====================================================================
      do 9000 n=1,nplwv
!=====================================================================
! exchange
!=====================================================================
!        do 1600 ispin=1,2
! Manually unrolled this loop for VPP-500 vectorization /OHN, 12-Oct-1995
         ispin = 1
            if (lgga) then
               d1=vxc(n,1)
               d2=vxc(n,2)
            else
               d1=max(1.0d-10,dn(n,1))
               d2=max(1.0d-10,dn(n,2))
            endif
            d=2.0d0*d1/vol
            dthrd=exp(thrd*log(d))
            fk=rconf*dthrd
            if (lgga) then
              s=absnab(n,ispin)/(d*vol*fk*angs)
            else
               s = 0.0d0
            endif
            call exch1(d,dthrd,s,exlda,exgga,exdlda,exdgga,exdd)
            exclda=exclda+exlda*0.5d0
            excgga=excgga+exgga*0.5d0
            ex(1) = ex(1)+exlda*0.5d0          
            ex(2) = ex(2)+exgga*0.5d0   
            if(lcalvx) then
               enxcc1l=enxcc1l-exdlda*d*0.5d0*vol
               enxcc1g=enxcc1g-exdgga*d*0.5d0*vol
               if(lgga) then
                  vxc(n,ispin)=exdgga*hartre
! df2 contains:
!                    d f_x(rho_up,|nabla rho_up|)        1
!                    ---------------------------- x ------------
!                    d |nabla rho_up|               |nabla rho_up|
                  df2(n,ispin)=exdd*hartre/absnab(n,ispin)
               else
                  vxc(n,ispin)=exdlda*hartre
               endif
            endif
         ispin = 2
            d=2.0d0*d2/vol
            dthrd=exp(thrd*log(d))
            fk=rconf*dthrd
            if (lgga) then
              s=absnab(n,ispin)/(d*vol*fk*angs)
            else
               s = 0.0d0
            endif
            call exch1(d,dthrd,s,exlda,exgga,exdlda,exdgga,exdd)
            exclda=exclda+exlda*0.5d0
            excgga=excgga+exgga*0.5d0
            ex(1) = ex(1)+exlda*0.5d0          
            ex(2) = ex(2)+exgga*0.5d0   
            if(lcalvx) then
               enxcc1l=enxcc1l-exdlda*d*0.5d0*vol
               enxcc1g=enxcc1g-exdgga*d*0.5d0*vol
               if(lgga) then
                  vxc(n,ispin)=exdgga*hartre
! df2 contains:
!                    d f_x(rho_down,|nabla rho_down|)        1
!                    -------------------------------- x ------------
!                    d |nabla rho_down|                 |nabla rho_down|
                  df2(n,ispin)=exdd*hartre/absnab(n,ispin)
               else
                  vxc(n,ispin)=exdlda*hartre
               endif
            endif


!1600    continue
!
!  local correlation:
!
         d=(d1+d2)/vol
         zet=(d1-d2)/(d*vol)
         rs=rconrs/exp(thrd*log(d))
         call corlsd(rs,zet,ec,vcup,vcdn,ecrs,eczet,alfc)
         exclda=exclda+ec*d
         excgga=excgga+ec*d
         if(lcalvx) then
            enxcc1l=enxcc1l-vcup*d1-vcdn*d2
            enxcc1g=enxcc1g-vcup*d1-vcdn*d2
            vxc(n,1)=vxc(n,1)+vcup*hartre
            vxc(n,2)=vxc(n,2)+vcdn*hartre
         endif
!
!  nonlocal correlation:
!
         if (lgga) then
            fk = 1.91915829d0/rs
            sk = dsqrt(4.d0*fk/pi)
            G = (exp(THRD2*log(1.D0+ZET))&
                +exp(THRD2*log(1.D0-ZET)))/2.D0
            t=1.0d0/(divnab(n)*d*vol*2.0d0*sk*g*angs)
            CALL CORGGA(RS,ZET,T,H,DVCUP,DVCDN,&
              FK,SK,G,EC,ECRS,ECZET,ec1dd)
            excgga=excgga+h*d
            if(lcalvx) then
               enxcc1g=enxcc1g-dvcup*d1-dvcdn*d2
               vxc(n,1)=vxc(n,1)+dvcup*hartre
               vxc(n,2)=vxc(n,2)+dvcdn*hartre
!
! dfud contains:
!                    d f_c(rho_up+rho_down,|nabla(rho_up+rho_down)|)
!                    -----------------------------------------------
!                    d |nabla(rho_up+rho_down)|
!                                                            1
!                                                x ----------------------
!                                                  |nabla(rho_up+rho_down)|
               dfud(n)=ec1dd*hartre*divnab(n)
            endif
         endif
!
! store the positive densities in absnab
!
         if (lgga.and.lcalvx) then
            absnab(n,1)=d1
            absnab(n,2)=d2
         endif
 9000 continue
!-----------------------------------------------------------------------
! Now it is time to evaluate the spin-polarized version of Eq. (10) in
! White and Bird, Phys. Rev. B 50, 4954 (1994), i.e. the two last terms
! in:
!
!              d f_x(rho_up,|nabla rho_up|)
!  v_xc,up(r)= ----------------------------
!              d rho_up
!
!              d f_c(rho_up+rho_down,|nabla (rho_up+rho_down)|)
!            + ------------------------------------------------
!              d (rho_up+rho_down)
!  
!                    d f_x(rho_up,|nabla rho_up|)   nabla rho_up
!            - nabla ---------------------------- x ------------
!                    d |nabla rho_up|               |nabla rho_up|
!
!                    d f_c(rho_up+rho_down,|nabla(rho_up+rho_down)|)
!            - nabla -----------------------------------------------
!                    d |nabla(rho_up+rho_down)|
!
!                                                  nabla(rho_up+rho_down)
!                                                x ----------------------
!                                                  |nabla(rho_up+rho_down)|
!
      enxcc2=0.0d0
      if(lgga.and.lcalvx) then
         do 7080 ispin=1,nspin
         do 7010 i=1,3
            do 7020 m=1,nplwv
               cwork1(m)=-rinplw*(&
                    df2(m,ispin)*dnabln(m,ispin,i)&
                   +dfud(m)*(dnabln(m,1,i)+dnabln(m,2,i))&
                                 )
 7020       continue
            call fft3d(cwork1,ngx,ngy,ngz,-1)
            if (i .eq. 1) then
              do 7029 m=1,nplwv
                cab(m)=dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7029         continue
            else
              do 7030 m=1,nplwv
                cab(m)=cab(m)+dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7030         continue
            endif
 7010    continue
         call fft3d(cab,ngx,ngy,ngz,1)
            do 7060 m=1,nplwv
               vxc(m,ispin)=vxc(m,ispin)+dble(cab(m))*bohr
               enxcc2=enxcc2-dble(cab(m))*absnab(m,ispin)
 7060       continue
 7080    enddo

!        calculate stress contribution from gradient terms
         call xc_spin_gga_stress(ngx,ngy,ngz,df2,dfud,dnabln,absnab,volc)
         
      endif
!=======================================================================
      exclda=exclda*hartre*vol/nplwv
      excgga=excgga*hartre*vol/nplwv
      ex(1) =ex(1)*hartre*vol/nplwv
      ex(2) =ex(2)*hartre*vol/nplwv
      if (lcalvx) then
         enxcc1l=enxcc1l*hartre/nplwv
         enxcc1g=enxcc1g*hartre/nplwv
         enxcc2=enxcc2*bohr/nplwv
      endif
!
      if(lcalvx) then
         if (lgga) then
            exc=excgga
            excc=exc+enxcc1g+enxcc2
         else
            exc=exclda
            excc=exc+enxcc1l
         endif
      else
         excc=exclda
         exc=excgga
      endif
!
      if (lgga) then
         if (denmin.lt.0.0d0.and.nconso.ne.0) then
            write(nconso,8000)denmin
         endif
 8000    format(1x,'XCPW: WARNING! Negative densities. Minimum value:',&
              f18.12)
      endif
      return
      end
!=======================================================================
      SUBROUTINE CORLSD(RS,ZET,EC,VCUP,VCDN,ECRS,ECZET,ALFC)
!  UNIFORM-GAS CORRELATION OF PERDEW AND WANG 1991
!  INPUT: SEITZ RADIUS (RS), RELATIVE SPIN POLARIZATION (ZET)
!  OUTPUT: CORRELATION ENERGY PER ELECTRON (EC), UP- AND DOWN-SPIN
!     POTENTIALS (VCUP,VCDN), DERIVATIVES OF EC WRT RS (ECRS) & ZET (ECZET)
!  OUTPUT: CORRELATION CONTRIBUTION (ALFC) TO THE SPIN STIFFNESS
      IMPLICIT REAL*8 (A-H,O-Z)
      DATA GAM,FZZ/0.5198421D0,1.709921D0/
      DATA THRD,THRD4/0.333333333333D0,1.333333333333D0/
      F = (exp(THRD4*log(1.D0+ZET))&
          +exp(THRD4*log(1.D0-ZET))-2.D0)/GAM
      CALL GCOR(0.0310907D0,0.21370D0,7.5957D0,3.5876D0,1.6382D0,&
          0.49294D0,1.00D0,RS,EU,EURS)
      CALL GCOR(0.01554535D0,0.20548D0,14.1189D0,6.1977D0,3.3662D0,&
          0.62517D0,1.00D0,RS,EP,EPRS)
      CALL GCOR(0.0168869D0,0.11125D0,10.357D0,3.6231D0,0.88026D0,&
          0.49671D0,1.00D0,RS,ALFM,ALFRSM)
!  ALFM IS MINUS THE SPIN STIFFNESS ALFC
      ALFC = -ALFM
      Z4 = ZET**4
      EC = EU*(1.D0-F*Z4)+EP*F*Z4-ALFM*F*(1.D0-Z4)/FZZ
!  ENERGY DONE. NOW THE POTENTIAL:
      ECRS = EURS*(1.D0-F*Z4)+EPRS*F*Z4-ALFRSM*F*(1.D0-Z4)/FZZ
      FZ = THRD4*(exp(THRD*log(1.D0+ZET))&
                 -exp(THRD*log(1.D0-ZET)))/GAM
      ECZET = 4.D0*(ZET**3)*F*(EP-EU+ALFM/FZZ)+FZ*(Z4*EP-Z4*EU&
              -(1.D0-Z4)*ALFM/FZZ)
      COMM = EC -RS*ECRS/3.D0-ZET*ECZET
      VCUP = COMM + ECZET
      VCDN = COMM - ECZET
      RETURN
      END
      SUBROUTINE GCOR(A,A1,B1,B2,B3,B4,P,RS,GG,GGRS)
!  CALLED BY SUBROUTINE CORLSD
      IMPLICIT REAL*8 (A-H,O-Z)
      P1 = P + 1.D0
      Q0 = -2.D0*A*(1.D0+A1*RS)
      RS12 = DSQRT(RS)
      RS32 = RS12**3
      RSP = RS**P
      Q1 = 2.D0*A*(B1*RS12+B2*RS+B3*RS32+B4*RS*RSP)
      Q2 = DLOG(1.D0+1.D0/Q1)
      GG = Q0*Q2
      Q3 = A*(B1/RS12+2.D0*B2+3.D0*B3*RS12+2.D0*B4*P1*RSP)
      GGRS = -2.D0*A*A1*Q2-Q0*Q3/(Q1**2+Q1)
      RETURN
      END
      SUBROUTINE CORGGA(RS,ZET,T,H,DVCUP,DVCDN,&
        FK,SK,G,EC,ECRS,ECZET,ec1dd)
!  GGA91 CORRELATION
!  INPUT RS: SEITZ RADIUS
!  INPUT ZET: RELATIVE SPIN POLARIZATION
!  INPUT T: ABS(GRAD D)/(D*2.*KS*G)
!  OUTPUT H: NONLOCAL PART OF CORRELATION ENERGY PER ELECTRON
!  OUTPUT DVCUP,DVCDN:  NONLOCAL PARTS OF CORRELATION POTENTIALS
      IMPLICIT REAL*8 (A-H,O-Z)
      DATA XNU,CC0,CX,ALF/15.75592D0,0.004235D0,-0.001667212D0,0.09D0/
      DATA C1,C2,C3,C4/0.002568D0,0.023266D0,7.389D-6,8.723D0/
      DATA C5,C6,A4/0.472D0,7.389D-2,100.D0/
      DATA THRDM,THRD2/-0.333333333333D0,0.666666666667D0/
      BET = XNU*CC0
      DELT = 2.D0*ALF/BET
      G3 = G**3
      G4 = G3*G
      PON = -DELT*EC/(G3*BET)
      B = DELT/(DEXP(PON)-1.D0)
      B2 = B*B
      T2 = T*T
      T4 = T2*T2
      T6 = T4*T2
      RS2 = RS*RS
      RS3 = RS2*RS
      Q4 = 1.D0+B*T2
      Q5 = 1.D0+B*T2+B2*T4
      Q6 = C1+C2*RS+C3*RS2
      Q7 = 1.D0+C4*RS+C5*RS2+C6*RS3
      CC = -CX + Q6/Q7
      R0 = (SK/FK)**2
      R1 = A4*R0*G4
      COEFF = CC-CC0-3.D0*CX/7.D0
      R2 = XNU*COEFF*G3
      R3 = DEXP(-R1*T2)
      H0 = G3*(BET/DELT)*DLOG(1.D0+DELT*Q4*T2/Q5)
      H1 = R3*R2*T2
      H = H0+H1
!  LOCAL CORRELATION OPTION:
!     H = 0.0D0
!  ENERGY DONE. NOW THE POTENTIAL:
      CCRS = (C2+2.*C3*RS)/Q7 - Q6*(C4+2.*C5*RS+3.*C6*RS2)/Q7**2
      RSTHRD = RS/3.D0
      R4 = RSTHRD*CCRS/COEFF
      GZ = (exp(THRDM*log(1.D0+ZET))&
           -exp(THRDM*log(1.D0-ZET)))/3.D0
      FAC = DELT/B+1.D0
      BG = -3.D0*B2*EC*FAC/(BET*G4)
      BEC = B2*FAC/(BET*G3)
      Q8 = Q5*Q5+DELT*Q4*Q5*T2
      Q9 = 1.D0+2.D0*B*T2
      H0B = -BET*G3*B*T6*(2.D0+B*T2)/Q8
      H0RS = -RSTHRD*H0B*BEC*ECRS
      H0Z = 3.D0*GZ*H0/G + H0B*(BG*GZ+BEC*ECZET)
      H0T = 2.*BET*G3*Q9/Q8
      H1RS = R3*R2*T2*(-R4+R1*T2/3.D0)
      H1Z = GZ*R3*R2*T2*(3.D0-4.D0*R1*T2)/G
      H1T = 2.D0*R3*R2*(1.D0-R1*T2)
      HRS = H0RS+H1RS
      HT = H0T+H1T
      HZ = H0Z+H1Z
      COMM = H+HRS-7.0d0/6.0d0*T2*HT
      PREF = HZ-GZ*T2*HT/G
      COMM = COMM-PREF*ZET
      DVCUP = COMM + PREF
      DVCDN = COMM - PREF
      ec1dd=0.5d0/(sk*g)*t*ht
      RETURN
      END
