
! Precision of the wavefunction arrays: complex*8 or complex*16
! Version @(#)precision.h	1.5 11/22/98

#ifdef CRAY
!     CRAY vectorprocessor words are always 64 bits.
#define WF_PRECISION 16

#else
!     Beware: The wavefunction file cannot handle different precisions !
!     #define WF_PRECISION 16
#define WF_PRECISION 16
#endif

!     Define the BLAS and LAPACK single/double precision subroutines

#if WF_PRECISION == 8

!	Complex are complex*8, Reals are real*4
#	define	C_PRECISION	8
#	define	R_PRECISION	4
!	BLAS and LAPACK subroutine prefix is "C"
#	define	BLAS_AXPY	CAXPY
#	define	BLAS_COPY	CCOPY
#	define	BLAS_DOTC	CDOTC
#	define	BLAS_GEADD	CGEADD
#	define	BLAS_GEMM	CGEMM
#	define	BLAS_GEMV	CGEMV
#	define	BLAS_GERC	CGERC
#	define	BLAS_SCAL	CSCAL
#	define	BLAS_SWAP	CSWAP
#	define	LAPACK_HEEV	CHEEV
#	define	LAPACK_HESV	CHESV
#	define	LAPACK_LAMCH	SLAMCH
#	define	LAPACK_GESVD	CGESVD
#	define	NORM2		SCNRM2
#       define  BLAS_RSCAL      CSSCAL
!       Mixed-precision wavefunction/subspace subroutines
#	define	CCZ_GEMM	CCZGEMM
#	define	CZC_GEMM	CZCGEMM2
#	define	CCZ_GEMV	CCZGEMV
#	define	CZC_GEMV	CZCGEMV
#       define  CC_ZGEMUL       CGEMUL

#else
!	Complex are complex*16, Reals are real*8
#	define	C_PRECISION	16
#	define	R_PRECISION	8
!	BLAS and LAPACK subroutine prefix is "Z"
#	define	BLAS_AXPY	ZAXPY
#	define	BLAS_COPY	ZCOPY
#	define	BLAS_DOTC	ZDOTC
#	define	BLAS_GEADD	ZGEADD
#	define	BLAS_GEMM	ZGEMM
#	define	BLAS_GEMV	ZGEMV
#	define	BLAS_GERC	ZGERC
#	define	BLAS_SCAL	ZSCAL
#	define	BLAS_SWAP	ZSWAP
#	define	LAPACK_HEEV	ZHEEV
#	define	LAPACK_HESV	ZHESV
#	define	LAPACK_LAMCH	DLAMCH
#	define	LAPACK_GESVD	ZGESVD
#	define	NORM2		DZNRM2
#       define  BLAS_RSCAL      ZDSCAL
!       Mixed-precision wavefunction/subspace subroutines: default to BLAS
#	define	CCZ_GEMM	ZGEMM
#	define	CZC_GEMM	ZGEMM
#	define	CCZ_GEMV	ZGEMV
#	define	CZC_GEMV	ZGEMV
#       define  CC_ZGEMUL       ZGEMUL

#endif WF_PRECISION
