#ifdef PVM
!     Include the PVM 3.3 header file
      include 'fpvm3.h'

!     Add the LOGICAL4 data type, assume all logicals sent through
!     PVM is of type logical*4
      integer LOGICAL4
      parameter (LOGICAL4 = INTEGER4)
#endif PVM

#ifdef PARMACS
!     Include the PARMACS 6.X header file
#ifdef MASTER
      include 'pmhost.inc'
#else
      include 'pmnode.inc'
#endif MASTER
#endif PARMACS

#ifdef MPI
!     Include MPI header file
#include "mpif.h"
#endif MPI


!     Global variables:
      integer MXHOST
      parameter (MXHOST = 1024)
!     slvtid ... TID of all tasks (master may be any one of these)
      integer slvtid(MXHOST)
!     mytid .... This process' TID
!     matid .... Master process TID
!     nhosts ... Number of machines, including master
!     ms_time .. Accumulated time spent in message-passing calls
!     ms_debug . Message-passing debug flag
!     lslave ... Logical switch: True on slave process
!     lmaster .. Logical switch: True on master process

      integer nhosts, matid, mytid, msdebug
      real*8 ms_time
      logical*4 lmaster, lslave
      common /MSPASS/ lmaster, lslave, nhosts, matid, mytid, slvtid,&
        msdebug, ms_time

!     Local workspace for timer
      real*4 time(2)

!     Magic value used for checking sanity
      integer MAGIC
      parameter (MAGIC = 123456789)

!     Message tags used in libtos for identifying messages

!     Maximum tag value
      integer MAX_TAG
      parameter (MAX_TAG = 550)

      integer MSG_SETUP, MSG_SLSTOP, MSG_FLAGS, MSG_WF, MSG_RDENSR
      integer MSG_KINL, MSG_POSION, MSG_EIGOCC, MSG_FNL, MSG_ESIN
      integer MSG_SEND_OK, MSG_MESSAGE, MSG_ARRAY, MSG_MSSUM
      integer MSG_CLINE,MSG_BECP
      parameter (MSG_SETUP   =  1)
      parameter (MSG_FLAGS   =  2)
      parameter (MSG_WF      =  3)
      parameter (MSG_RDENSR  =  4)
      parameter (MSG_KINL    =  5)
      parameter (MSG_POSION  =  6)
      parameter (MSG_EIGOCC  =  7)
      parameter (MSG_FNL     =  8)
      parameter (MSG_ESIN    =  9)
      parameter (MSG_SEND_OK = 10)
      parameter (MSG_ARRAY   = 11)
      parameter (MSG_CLINE   = 12 )
      parameter (MSG_BECP    = 14 )
      parameter (MSG_MESSAGE = 98)
      parameter (MSG_SLSTOP  = 99)
!     Reserve numbers 500 until 550 for collective communication in mssum()
      parameter (MSG_MSSUM   = 500)
