      subroutine mach_id(nconso)
      write(nconso,*) '@(#)mach.F	1.8 11/6/97'
      return
      end

! =====================================================================
! =====================================================================
!                    Operating system dependent code
! =====================================================================
! =====================================================================
! In this piece below we try to provide an interface for
! interactions with the operating system beyond facilities in required
! by the Fortran standard, but is reasonable service functions to expect 
! from the operating system. Works for architectures accessible to us.
! If _ever_ the code is ported to, say,  a DOS environment, this is the 
! only place, where modification is needed.
! Then, lift the pp directive OPSYS_<> into the makefile
! We adopt the convention that these interface references are postceded
! by _opsys_interface
! =====================================================================
#define OPSYS_IN_UNIXFAMILY

#ifdef OPSYS_IN_UNIXFAMILY
!===================================================
      integer function iargc_opsys_interface()
! --------------------------------------------------
! --- inquire the number of command line arguments -
! --------------------------------------------------
      implicit none
#ifndef GFORTRAN
      integer  iargc
      external iargc
#endif
      iargc_opsys_interface = iargc()
      end function iargc_opsys_interface
!===================================================
      subroutine  getarg_opsys_interface(iarg,str)
! --------------------------------------------------
! --- retrieve command line arg number iarg into str
! --------------------------------------------------
      implicit none
      integer        iarg
      character*(*)  str
      call getarg(iarg,str)
      end subroutine getarg_opsys_interface
!===================================================
      subroutine  system_opsys_interface(syscmd)
! --------------------------------------------------
! --- perform an unspecific operating system call --
! --------------------------------------------------
      implicit none
      character*(*)  syscmd
      call system(syscmd)
      end subroutine system_opsys_interface
!===================================================
      integer function getpid_opsys_interface()
! --------------------------------------------------
! --- get the process ID ---------------------------
! --------------------------------------------------
      implicit none
#ifndef GFORTRAN
      integer  getpid
      external getpid 
#endif
      getpid_opsys_interface = getpid()
      end function getpid_opsys_interface
!===================================================
      function getenv_opsys_interface(env_varname)
! --------------------------------------------------
! --- get the content of the enviroment variable 
! --- env_varname  
! --------------------------------------------------
      implicit none
      character*200 getenv_opsys_interface,str 
      character*(*) env_varname
#ifndef GFORTRAN
      external getenv 
#endif
    
      str = " "
!     call getenv(env_varname,str) 
      call getenv("DACAPOPATH",str) 
      write(*,*) 'str = ',str
      getenv_opsys_interface = str
      end function getenv_opsys_interface              
!==================================================
#endif OPSYS_IN_UNIXFAMILY


! =====================================================================
! =====================================================================
!                    Machine dependent code
! =====================================================================
! =====================================================================
#include "definitions.h"
!======================================================================
! Utility routines for IBM AIX XLF Fortran compiler
!=======================================================================
#ifdef IBM 
      subroutine uttime(time)
      implicit double precision (a-b,d-h,o-z)
#include "etime.h"
      time(1)=dble(mclock())/100.0d0
      time(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush_(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
      ishost = hostnm_ (name)
      write(nconso,*) '& This job was run on host: ', name
      return
      end
!=======================================================================
      subroutine utdate(nconso)
      character*8 date
      external date
      write(nconso,*) '& This job was run on ', date()
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using IBM AIX intrinsic erfc'
      return
      end
#endif IBM 


!======================================================================
! Utility routines for SUN f77
!=======================================================================
#ifdef SUN 
      subroutine uttime(time)
#include "etime.h"
      call etime(time)
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
      ishost = hostnm (name)
      write(nconso,*) '& This job was run on host: ', name
      return
      end
!=======================================================================
      subroutine utdate(nconso)
      character*24 date, fdate
      external fdate
      write(nconso,*) '& This job was run on ', fdate(date)
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using SUN f77 intrinsic erfc'
      return
      end

#endif SUN 


!=======================================================================
! Utility routines for VPP500
!=======================================================================
#ifdef VPP500

      subroutine uttime(time)
      implicit none
      real*4 oldtim
#include "etime.h"
      real*8 tclock
      integer ifirst
      data ifirst/1/
      save oldtim,ifirst
      if (ifirst.eq.1) then
         ifirst=0
         call clock(tclock,1,2)
         oldtim=tclock*0.001
      else
         call clock(tclock,1,2)
         time(1)=tclock*0.001-oldtim
      endif
      time(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
!      close(n)
!      open(n,status='old',access='append')
!     This has some flushing effects on VPP-500:
      endfile (n)
      backspace (n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*10 name
!     The hostname() subroutine is a locally written utility at JRCAT:
!     Contact: Koichi Sato <sato@jrcat.or.jp>
!     Link to the library:
!     frtpx (-Wx ....) -L/usr/local/lib -lhostname source.f
      name = '          '
      call hostname (name)
      write(nconso,*) '& This job was run on VPP-500 node: ', name
!     write(nconso,*) '& This job was run on host: VPP-500/32'
      return
      end
!=======================================================================
      subroutine utdate(nconso)
      character*8 dt
      call date(dt)
      write(nconso,*) '& This job was run on: ',dt
      return
      end
!=======================================================================
      subroutine utfix()
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using Fujitsu Fortran77 EX intrinsic erfc'
      return
      end

#endif VPP

!======================================================================
! Generic utility routines
!=======================================================================
#ifdef GENERIC
      subroutine uttime(time)
      implicit double precision (a-b,d-h,o-z)
#include "etime.h"
      time(1)=etime(time)
      time(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
!     ishost = hostnm_ (name)
      write(nconso,*) '& This job was run on host: ', 'not implemented'
      return
      end
!=======================================================================
      subroutine utdate(nconso)
!     character*8 date
!     external date
      write(nconso,*) '& This job was run on ', 'not implemented'
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using intrinsic erfc'
      return
      end
#endif GENERIC                                                      

!======================================================================
! PGLINUX utility routines
!=======================================================================
#if PGLINUX || INTELLINUX
      subroutine uttime(time)
      implicit double precision (a-b,d-h,o-z)
#include "etime.h"
      time(1)=etime(time)
      time(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
!     ishost = hostnm_ (name)
      write(nconso,*) '& This job was run on host: ', 'not implemented'
      return
      end
!=======================================================================
      subroutine utdate(nconso)
!     character*8 date
!     external date
      write(nconso,*) '& This job was run on ', 'not implemented'
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using intrinsic erfc'
      return
      end
#endif PGLINUX
                                                                          

!======================================================================
! Utility routines for DEC ALPHA
!=======================================================================
#ifdef DECALPHA
      subroutine uttime(ttime)
      implicit double precision (a-b,d-h,o-z)
      real*4 ttime(2),etime,actual
      external etime
      actual=etime(ttime)
      ttime(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
      integer  ishost, hostnm
      external hostnm
      ishost = hostnm (name)
      write(nconso,*) '& This job was run on host: ', name
      return
      end
!=======================================================================
      subroutine utdate(nconso)
      character*24 date
      call fdate(date)
      write(nconso,*) '& This job was run on ', date
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using erfc in erfc.F'
      return
      end
#endif DECALPHA

!======================================================================
! Utility routines for CRAY f90 Fortran compiler
!=======================================================================
#ifdef CRAY
      subroutine uttime(time)
      implicit double precision (a-b,d-h,o-z)
#include "etime.h"
      time(1)=second()
      time(2)=0.0d0
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
      integer gethost, ishost
      ishost = gethost (name)
      if (ishost .gt. 0) then
        write(nconso,*) '& This job was run on host: ', name
      endif
      return            
      end
!=======================================================================
      subroutine utdate(nconso)
      character*8 d
      call date(d)
      write(nconso,*) '& This job was run on ', d
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using f90 intrinsic erfc'
      return
      end
#endif

!======================================================================
! Utility routines for SGI f77
!=======================================================================

#ifdef SGI
      subroutine uttime(time)
#include "etime.h"
      call etime(time)
      return
      end
!=======================================================================
      subroutine uflush(n)
      integer n  
      call flush(n)
      return
      end
!=======================================================================
      subroutine uthost(nconso)
      character*32 name
! Don't know if a hostname routine is available
      name='unknown SGI-machine'
      write(nconso,*) '& This job was run on host: ', name
      return
      end
!=======================================================================
      subroutine utdate(nconso)
      character*24 date, fdate
      external fdate   
      write(nconso,*) '& This job was run on ', fdate(date)
      return
      end
!=======================================================================
      subroutine erfcid(nconso)
      write(nconso,*) 'Using SGI f77 intrinsic erfc'
      return
      end
         
#endif SGI

