      module external_pot_module

      
      logical,    save, private  :: init = .true.
      logical,    save, private  :: lstop = .false.
      real*8,     save, private, pointer  :: ext_pot(:,:,:) !(ngx,ngy,ngz)
      complex*16, save, private, pointer  :: vpot(:) !(ngdens_max)

      contains
      subroutine extern_pot(ngx,ngy,ngz,dirc,nions,nspec,nionsp,posion,&
           icharg,g,ngdens_max,ipwpadG,deltav,edipc,ffield,nconso)
      
      implicit none


!     input
      integer, intent(in) :: ngx,ngy,ngz,ngdens_max,nconso
      integer ipwpadG(ngdens_max,0:3) ! ngdens_max,0:3
      integer, intent(in) :: nions,nspec
      integer, intent(in) :: nionsp(:),icharg(:) !nspec 
      real*8,  intent(in) :: dirc(3,3) !3,3
      real*8,  intent(in) :: posion(:,:,:) !3,nions,nspec
      real*8,  intent(in) :: g(:,:) !ngdens_max,3

!     locals
      integer    i,n,ng,na,nz,nx,ny,ns,ni,status,ncid
      real*8     pp(ngz)
      real*8     gdotri
      complex*16 workpot(ngx,ngy,ngz),com
      complex*16 vext(nions),dvext(3,nions)
      real*8     r(3),rions(3,nions)
      real*8     en_cor,force(3,nions,nspec)

!     output
      complex*16 deltav(ngx,ngy,ngz)
      real*8     edipc
      real*8     ffield(3,nions,nspec)

!      deltav(:,:,:) = (0.d0,0.d0)
      edipc =0.d0
!      ffield(:,:,:) = 0.d0

      if(lstop)return


!     read the external potential from netcdf 
      if(init)then
         allocate(ext_pot(ngx,ngy,ngz))
         allocate(vpot(ngdens_max))
         call read_potential(ext_pot,ngx,ngy,ngz,lstop)
         if(lstop)return
!     fourier transform of the constant external potential
         workpot(:,:,:)=(0.d0,0.d0)
         vpot(:)= (0.d0,0d0)
         workpot(:,:,:)=ext_pot(:,:,:)/dble(ngx*ngy*ngz)
         call fft3d(workpot,ngx,ngy,ngz,-1)
         call uflush(nconso)
         do i = 1,ngdens_max 
            vpot(i)=workpot(ipwpadG(i,1),ipwpadG(i,2),ipwpadG(i,3))
         enddo
         init = .false.
      endif

!     add external field to correction of the field: deltav
            
      deltav(:,:,:) = deltav(:,:,:)+ext_pot(:,:,:)
    
      write(nconso,*)'EXTERNAL-POTENTIAL-IN Z'
      do nz = 1,ngz      
         pp(nz)=0
         do nx = 1,ngx
            do ny = 1,ngy
               pp(nz) = ext_pot(nx,ny,nz)/dble(ngx*ngy) + pp(nz)
            enddo
         enddo
         write(nconso,*)'zpot',pp(nz)
      enddo
      
!     The potential correction in the positions of the ions


!     get realspace potential for this ion
      na = 1
      do ns = 1,nspec 
         do ni = 1,nionsp(ns)
            call xyzpos(posion(1,ni,ns),dirc,r) !position
            rions(:,na)=r(:)
            na = na+1
         enddo
      enddo
      
!     The potential and the field in the points of the ions
!     the one dimensional fourier transform is used.
      do i=1,nions
         vext(i)=0.d0
         dvext(:,i)=0.d0
         do ng=1,ngdens_max
            call uflush(nconso)
            gdotri=dot_product(g(ng,:),rions(:,i)) 
            com=(0.d0,1.d0)*gdotri
            vext(i)=vpot(ng)*exp(com)+vext(i)
            dvext(:,i)=vpot(ng)*exp((com))*&
                 (0.d0,1.d0)*g(ng,:)+dvext(:,i)
         enddo
         write(nconso,*)'dvexternal',i,dvext(:,i)
         write(nconso,*)'vexternal',i,vext(i)
      enddo


!     loop over ions to add ionic contribution (second term in Eq. 9) 
!     and calculate the force on the ions to  get the force correction 
!     in ffield (Eq. 11)
 
      en_cor = 0.0d0 
      force(:,:,:) = 0.0d0
      na = 1
      do ns = 1,nspec 
         do ni = 1,nionsp(ns)

!     calculate the ion contribution to the energy 
!     (-Z_na*vext(R_na))
            en_cor = en_cor-icharg(ns)*vext(na)
         
!     calculate the ionic contribution to the forces
!     (-Z_na*field(R_na))  
            force(:,ni,ns) = -icharg(ns)*(-dvext(:,na))
            
!            write(nconso,*) 'field_forces',na,force(:,ni,ns)
           

            na = na + 1
         enddo 
      enddo 
  
      ffield(:,:,:) = ffield(:,:,:) + force(:,:,:)
      edipc = edipc + en_cor
      end subroutine extern_pot


! ===============================================================
! ===============================================================

      subroutine read_potential(ext_pot,ngx,ngy,ngz,lstop)

      use netcdfinterface
      use run_context
      
      implicit none
      
      logical lstop
      integer status,ncid,ngx,ngy,ngz
      real*8 a(ngx,ngy,ngz)
      real*8, pointer ::  ext_pot(:,:,:)
      
! 
!     parallel send should be implemented
      status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)  
!      if (status /= nf_noerr) call abort_calc(nconso, &
!                 "read_structure -> nf_open : error opening nc-file")
      if (status /= nf_noerr) then 
          write(nconso,*) &
          "read potential -> nf_open : error opening nc-file"
         lstop = .true. 
         return 
      endif

      status = nfget(ncid, "ExternalPotential",a)  
      if (status == nfif_OK) then
         ext_pot(:,:,:)=a(:,:,:)
      else
         lstop = .true.
      endif
     

      return
      end subroutine read_potential
      
      end module external_pot_module 













