!=======================================================================
      subroutine eferid(nconso)
      write(nconso,*) '@(#)efertr.F	1.2 9/24/96'
      return
      end
!=======================================================================
      subroutine efertr (nelect,nbands,width,nkpts,wtkpt,occ,efermi,&
                 eigen,sort,nconso,iprint,occold,icall,occmix)
!=======================================================================
! subroutine efertr calculates the occupancy of each band for
! all k-points. the result in occ() is used to weighten the bands
! when calculating the charge-density in chsp and when summing
! eigenvalues etc.
!=======================================================================
!     written by richard needs on 9th december 1983
!     given the eigenvalues in eigen and the weights of the
!     k-points in wtkpt this subroutine calculates the fermi level
!     efermi and the occupancy of the states occ.
!
!     method: c-l fu and k-m ho, phys. rev. b 28, 5480 (1983)
!     gaussian smearing of eigenvalues when computing occupation
!     note: for sum of bands we do not smear eigenvalues,
!     as was done by fu and ho. the difference is easily
!     calculated.
!
!     nelect ..... number of electrons per unit cell
!     nbands ..... number of bands for each k-point
!     width ...... width of gaussian smearing function
!     nkpts ...... number of k-points
!     wtkpt ...... the weight of each k-point
!     occ ........ the occupancy of each state
!     efermi ......... the fermi energy
!     sort ....... the eigenvalues are written into sort which is
!                  then sorted into ascending numerical value, from
!                  which bounds on efermi can easily be obtained
!     eigen ...... contains the best eigenvalues available
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension sort(nkpts*nbands)
      dimension occ(nbands*nkpts)
      dimension occold(nbands*nkpts)
      dimension wtkpt(nkpts)
      dimension eigen(nbands*nkpts)
!
      parameter ( ncycle = 20, ndiv = 9 , eps=1.0d-13 )
!=======================================================================
!
      if (nbands*2.eq.nelect) return
      eps10=eps/10.0d0
      dsor = 1.0d0 /ndiv
      z    = nelect
!=======================================================================
!     copy eigen() into sort()
!=======================================================================
      neig = 0
      do 20  j=1, nbands
        do 10 nkp=1, nkpts
          neig = neig+1
          sort(neig) = eigen(j+(nkp-1)*nbands)
  10    continue
  20  continue
!=======================================================================
! sort the records with 'straight insertion'-method (not a too bad
! choice of sort-algorithm as the energies are allmost already sorted)
!=======================================================================
      do 26 n=2,nkpts*nbands
        en=sort(n)
        do 22 nn=n-1,1,-1
          if (sort(nn).le.en) go to 24
          sort(nn+1)=sort(nn)
  22    continue
        nn=0
  24    sort(nn+1)=en
  26  continue
!=======================================================================
!     find an upper bound e2 and a lower bound e1 on the
!     fermi energy
!=======================================================================
      int = nelect*nkpts
      if ( mod(int,2) .eq. 1) then
        i1 = int/2
        i2 = int/2 + 2
      else
        i1 = int/2 - 1
        i2 = int/2 + 1
      endif
      i1 = max(i1, 1)
      i2 = min(i2, neig)
!
  30  e1 = sort(i1)
!
      z1 = 0.0d0
      nn=0
      do 50 nkp = 1,nkpts
        do 40 j = 1,nbands
          nn=nn+1
          x = (e1 - eigen(nn))/width
          z1 = z1 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
  40    continue
  50  continue
!
      if (z1 .gt. z-eps) then
        i1 = i1 - 1
        if (i1 .gt. 0) then
          goto 30
        else
          i1 = 1
          e1 = sort(i1) - width
          write (nconso,*) 'efermi *** lower bound on efermi set to',e1
          goto 60
        endif
      endif
!
  60  e2 = sort(i2)
!
      z2 = 0.0d0
      nn=0
      do 80 nkp = 1, nkpts
        do 70 j = 1,nbands
          nn=nn+1
          x = (e2 - eigen(nn))/width
          z2 = z2 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
  70    continue
  80  continue
!
      if (z2 .lt. z + eps) then
        i2 = i2 + 1
        if (i2 .le. neig) then
          goto 60
        else
          i2 = neig
          e2 = sort(i2) + width
!          write (nconso,1100) e2
1100      format(' efermi *** warning ***'/&
            ' fermi level upper bound is > largest eigenvalue, e2=',&
            f12.4,' ev')
        endif
      endif
!=======================================================================
!     find fermi energy energy between bounds e1 and e2
!=======================================================================
      do 90 iloop = 1,ncycle
        div = (e2-e1)*dsor
        do 100 i = 1,ndiv
          z2 = 0.0d0
          eup = e1 + dble(i)*div
          nn=0
          do 120 nkp = 1,nkpts
            do 110 j = 1,nbands
              nn=nn+1
              x = (eup - eigen(nn))/width
              z2 = z2 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
 110        continue
 120      continue
          if (z1 .gt. z) then
            write(nconso,*) '***** error *****'
        write(nconso,*) 'fermi energy less than lower search bound set'
            call clexit(nconso)
          endif
          if (z2 .gt. z) goto 130
!=======================================================================
!           this test is needed to catch semiconductors
!=======================================================================
          if (abs(z2-z) .lt. eps10) goto 150
          z1 = z2
 100    continue
        write(nconso,*) '***** error *****'
      write(nconso,*) 'fermi energy greater than upper search bound set'
        call clexit(nconso)
!
 130    if ( z2-z1 .lt. eps) goto 160
        e1 = eup - div
        e2 = eup
  90  continue
!      write(nconso,*) '***warning*** fermi energy may not be accurate'
!      write(nconso,140) ncycle
 140  format(' after',i6,' cycles, required convergence not obtained')
      goto 160
!=======================================================================
!     write out fermi energy
!=======================================================================
 150  efermi = eup
      goto 170
 160  efermi = eup - 0.5d0*div
 170  continue
!=======================================================================
!     form occupations occ(nbds,nkpts)
!=======================================================================
      amix=1.0d0
      if (icall.eq.1) then
        amix=occmix
      endif
      if (amix.gt.1.0d0) amix=1.0d0
      if (amix.lt.0.0d0) amix=0.0d0
      nn=0
      ocvar=0.0d0
      do 1200 nkp = 1,nkpts
        do 1190 j = 1,nbands
          nn=nn+1
          x = ( efermi-eigen(nn))/width
          occdum = 2.0d0-erfc(x)
          octmp=(occold(nn)-occdum)**2
          ocvar=ocvar+octmp*wtkpt(nkp)
          occ(nn) = occold(nn)*(1.0d0-amix)+(2.0d0 - erfc(x))*amix
 1190   continue
 1200 continue
      ocvar=sqrt(ocvar)
      iprt=0
      write(nconso,2602) &
               'ocvar',iprt,' amix efermi   ',ocvar,amix,efermi
 2602 format(1x,a5,i1,a15,3f12.6)
!=======================================================================
!     test whether occupancy adds up to z
!=======================================================================
      test = 0.0d0
      nn=0
      do 215 nkp = 1,nkpts
        do 210 j = 1,nbands
          nn=nn+1
          test = test + wtkpt(nkp)*occ(nn)
 210    continue
 215  continue
      if ( abs(test-z) .gt. 1.0d-5) then
        write(nconso,*) '*** warning ***'
        write(nconso,220) test,nelect
 220    format(' sum of occupancies =',f15.12 ,' but nelect =',i5)
      else
!        write(nconso,230) test
 230    format(' total charge = ',f12.8)
      endif
!=======================================================================
!     test whether the material is a semiconductor
!=======================================================================
      if ( mod(nelect,2) .eq. 1) return
      inel = nelect/2
      elow = eigen(inel+1)
      do 310 nkp = 2,nkpts
        elow = min( elow, eigen(inel+1+(nkp-1)*nbands))
310   continue
      do 320 nkp = 1,nkpts
        if (elow .lt. eigen(inel+(nkp-1)*nbands)) return
320   continue
!      write (nconso,*) 'material may be a semiconductor'
      return
      end
!=======================================================================
      subroutine locfer(nelect,nbands,width,nkpts,wtkpt,occ,efermi,&
                 eigen,sort,nconso,occmix,nkp,occold)
!=======================================================================
! subroutine efertr calculates the occupancy of each band for
! all k-points. the result in occ() is used to weighten the bands
! when calculating the charge-density in chsp and when summing
! eigenvalues etc.
!=======================================================================
!     written by richard needs on 9th december 1983
!     given the eigenvalues in eigen and the weights of the
!     k-points in wtkpt this subroutine calculates the fermi level
!     efermi and the occupancy of the states occ.
!
!     method: c-l fu and k-m ho, phys. rev. b 28, 5480 (1983)
!     gaussian smearing of eigenvalues when computing occupation
!     note: for sum of bands we do not smear eigenvalues,
!     as was done by fu and ho. the difference is easily
!     calculated.
!
!     nelect ..... number of electrons per unit cell
!     nbands ..... number of bands for each k-point
!     width ...... width of gaussian smearing function
!     nkpts ...... number of k-points
!     wtkpt ...... the weight of each k-point
!     occ ........ the occupancy of each state
!     efermi ......... the fermi energy
!     sort ....... the eigenvalues are written into sort which is
!                  then sorted into ascending numerical value, from
!                  which bounds on efermi can easily be obtained
!     eigen ...... contains the best eigenvalues available
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension sort(nbands)
      dimension occ(nbands)
      dimension occold(nbands)
      dimension wtkpt(nkpts)
      dimension eigen(nbands)
!
      parameter ( ncycle = 20, ndiv = 9 , eps=1.0d-13 )
!=======================================================================
!
      if (nbands*2.eq.nelect) return
      eps10=eps/10.0d0
      z=0.0d0
      do 10 j=1,nbands
        z=z+occ(j)
  10  continue
      write(nconso,9011) z,wtkpt(nkp)*z
 9011 format(1x,'z,w*z',f13.7,f15.7)
      if (z+1.0d-3.ge.dble(2*nbands)) return
      if (z-0.5d0.le.0.0d0) return
      z=z*wtkpt(nkp)
      dsor = 1.0d0 /ndiv
!=======================================================================
!     copy eigen() into sort()
!=======================================================================
      do 20  j=1,nbands
        sort(j) = eigen(j)
  20  continue
!=======================================================================
! sort the records with 'straight insertion'-method (not a too bad
! choice of sort-algorithm as the energies are allmost already sorted)
!=======================================================================
      do 26 n=2,nbands
        en=sort(n)
        do 22 nn=n-1,1,-1
          if (sort(nn).le.en) go to 24
          sort(nn+1)=sort(nn)
  22    continue
        nn=0
  24    sort(nn+1)=en
  26  continue
!     do 4040 j=1,nbands
!     write(nconso,*) 'eig',sort(j)
!4040 continue
!=======================================================================
!     find an upper bound e2 and a lower bound e1 on the
!     fermi energy
!=======================================================================
!     int = nelecs*nkpts
!     if ( mod(int,2) .eq. 1) then
!       i1 = int/2
!       i2 = int/2 + 2
!     else
!       i1 = int/2 - 1
!       i2 = int/2 + 1
!     endif
!     i1 = max(i1, 1)
!     i2 = min(i2, nbands)
      i1=1
      i2=nbands
!
  30  e1 = sort(i1)
!
      z1 = 0.0d0
        do 40 j = 1,nbands
          x = (e1 - eigen(j))/width
          z1 = z1 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
  40    continue
!
      if (z1 .gt. z-eps) then
        i1 = i1 - 1
        if (i1 .gt. 0) then
          goto 30
        else
          i1 = 1
          e1 = sort(i1) - width
          write (nconso,*) 'efermi *** lower bound on efermi set to',e1
          goto 60
        endif
      endif
!
  60  e2 = sort(i2)
!
      z2 = 0.0d0
        do 70 j = 1,nbands
          x = (e2 - eigen(j))/width
          z2 = z2 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
  70    continue
!
      if (z2 .lt. z + eps) then
        i2 = i2 + 1
        if (i2 .le. nbands) then
          goto 60
        else
          i2 = nbands
          e2 = sort(i2) + 10.0d0*width
!          write (nconso,1100) e2
1100      format(' efermi *** warning ***'/&
            ' fermi level upper bound is > largest eigenvalue, e2=',&
            f12.4,' ev')
        endif
      endif
!=======================================================================
!     find fermi energy energy between bounds e1 and e2
!=======================================================================
      do 90 iloop = 1,ncycle
        div = (e2-e1)*dsor
        do 100 i = 1,ndiv
          z2 = 0.0d0
          eup = e1 + dble(i)*div
            do 110 j = 1,nbands
              x = (eup - eigen(j))/width
              z2 = z2 + wtkpt(nkp)*( 2.0d0 - erfc(x) )
 110        continue
          if (z1 .gt. z) then
            write(nconso,*) '***** error *****'
        write(nconso,*) 'fermi energy less than lower search bound set'
            call clexit(nconso)
          endif
          if (z2 .gt. z) goto 130
!=======================================================================
!           this test is needed to catch semiconductors
!=======================================================================
          if (abs(z2-z) .lt. eps10) goto 150
          z1 = z2
 100    continue
        write(nconso,*) '***** error *****'
      write(nconso,*) 'fermi energy greater than upper search bound set'
        call clexit(nconso)
!
 130    if ( z2-z1 .lt. eps) goto 160
        e1 = eup - div
        e2 = eup
  90  continue
!      write(nconso,*) '***warning*** fermi energy may not be accurate'
!      write(nconso,140) ncycle
 140  format(' after',i6,' cycles, required convergence not obtained')
      goto 160
!=======================================================================
!     write out fermi energy
!=======================================================================
 150  efermi = eup
      goto 170
 160  efermi = eup - 0.5d0*div
 170  continue
!=======================================================================
!     form occupations occ(nbds,nkpts)
!=======================================================================
      amix=occmix
      ocvar=0.0d0
        do 1190 j = 1,nbands
          x = ( efermi-eigen(j))/width
          occdum = 2.0d0-erfc(x)
          octmp=(occold(j)-occdum)**2
          ocvar=ocvar+octmp*wtkpt(nkp)
          occ(j) = occold(j)*(1.0d0-amix)+(2.0d0 - erfc(x))*amix
 1190   continue
      ocvar=sqrt(ocvar)
      iprt=0
      write(nconso,2602) &
               'ocvor',iprt,' amix efermi   ',ocvar,amix,efermi
 2602 format(1x,a5,i1,a15,3f12.6)
!=======================================================================
!     test whether occupancy adds up to z
!=======================================================================
      test = 0.0d0
        do 210 j = 1,nbands
          test = test + wtkpt(nkp)*occ(j)
 210    continue
      if ( abs(test-z) .gt. 1.0d-5) then
        write(nconso,*) '*** warning ***'
        write(nconso,220) test,z
 220    format(' sum of occupancies =',f15.12 ,' but nelecs =',f15.12)
      endif
      return
      end
