!=======================================================================
      subroutine dipoid(nconso)
      write(nconso,*) '@(#)dipole.F	1.22 7/1/99'
      return
      end
!=======================================================================
! For slab calculations:
!     Add a Fermi-function shaped potential to Veff in the vacuum region
!     in order to cancel the artificial field arising from the different
!     surface workfunctions of the two slab surfaces.
!     ( J.Neugebauer and M.Scheffler, PRB 46, 16067 (1992) )
!=======================================================================
      subroutine dipole(nconso,ngx,ngy,ngz,cveff,rdensr,&
              dirc,&
              nspec,nionsp,icharg,nions,posion,idipol,vext,volc,ffield,&
              endipc,zdip,efermi,cwork1,nplwv,enxcc,enxc,&
              excdat,xcfdat,xcpdat,nxc,&
              dip0,extfie,dipmix,lworkp,extpot,&
              recc,lpctx,lpcty,lpctz,vxc,&
              nspin,dirdat,cvion,idebug,lmastr)
!     implicit complex*16 (c)
!     implicit double precision (a,b,d-h,o-z)
      implicit none
!=======================================================================
      integer nconso,ngx,ngy,ngz,nspin
      complex*16 cveff(ngx,ngy,ngz,nspin)
      real*8 rdensr(ngx,ngy,ngz,nspin)
      real*8 dirc(3,3)
      integer nspec
      integer nionsp(nspec)
      integer icharg(nspec)
      integer nions
      real*8 posion(3,nions,nspec)
      integer idipol
      real*8 vext(ngz)
      real*8 volc
      real*8 ffield(3,nions,nspec)
      real*8 endipc
      real*8 zdip
      real*8 efermi
      complex*16 cwork1(ngx,ngy,ngz)
      integer nplwv
      real*8 enxcc
      real*8 enxc
      integer nxc
      real*8 excdat(nxc),xcfdat(nxc),xcpdat(nxc)
      real*8 dip0
      real*8 extfie
      real*8 dipmix
      logical*4 lworkp
      real*8 extpot
      real*8 recc(3,3)
      real*8 lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 vxc(nplwv,2)
      real*8 dirdat(nplwv)
      complex*16 cvion(nplwv)
      integer idebug
      logical*4 lmastr
!=======================================================================
! locals
      integer nsp,m,nz,ni,nion,nzzero,nzmin,nzmax,nzmi2,nzma2,zindex,iz
      real*8 avdens(ngz),avVeff(ngz),avVels(ngz),vdip
      logical*4 lfirst,ldipol
      real*8 dipold,znz,dz,vj,vjmax,zzero,field1,field2 
      real*8 zsumax,zsum,dipnew,vjump,z,field 
      real*8 pi,eV,angst
      data lfirst,ldipol/.true.,.true./
      data dipold/0.0d0/
      data pi,eV,angst/3.1415926536d0,27.2116d0,0.529177d0/
      save lfirst,ldipol,nzzero,dipold
!=======================================================================
      do nsp = 1,nspec
        do ni = 1,nionsp(nsp) 
           do m = 1,3 
            ffield(m,ni,nsp) = 0.0d0
           enddo 
        enddo 
      enddo 
      if (idipol.eq.0) ldipol=.false.
      if ((.not.ldipol).and.(.not.lworkp)) return
!=======================================================================
! Check that dipole-correction can be made
!=======================================================================
      if (lfirst) then
         if ((dirc(1,3)**2+dirc(2,3)**2+&
              dirc(3,1)**2+dirc(3,2)**2).gt.1.0d-10) then
            if (ldipol) then
               ldipol=.false.
               write(nconso,*)'DIP: No dipole-correction can be made'
            else
               lworkp=.false.
               write(nconso,*)'DIP: No workfunctions can be calculated'
            endif
            write(nconso,*)'DIP: A3 must be || with Z and perp. ',&
                           'DIP: to A1 and A2 - sorry!'
            return
         endif
         if (dirc(3,3).lt.0.0d0) then
            if (ldipol) then
               ldipol=.false.
               write(nconso,*)'DIP: No dipole-correction can be made'
            else
               lworkp=.false.
               write(nconso,*)'DIP: No workfunctions can be calculated'
            endif
            write(nconso,*)'DIP: A3.Z must be positive'
            return
         endif
!=======================================================================
! Find the Z for which the ions are furthest away
! - or
! if zdip!=0.000 find the nz closest to zdip (input by the user)
!=======================================================================
         zsumax=0.0d0
         do 1030 nz=1,ngz
            znz=dble(nz-1)/dble(ngz)*dirc(3,3)
            zsum=0.0d0
            do 1020 nsp=1,nspec
               do 1010 nion=1,nionsp(nsp)
                  z=posion(3,nion,nsp)*dirc(3,3)
                  dz=mod(z-znz,dirc(3,3))
                  if (dz.gt. 0.5d0*dirc(3,3)) dz=dz-dirc(3,3)
                  if (dz.lt.-0.5d0*dirc(3,3)) dz=dz+dirc(3,3)
                  zsum=zsum+abs(dz)
 1010          continue
 1020       continue
!           Sometimes values are almost bit-identical,
!           so we demand that zsum must be epsilon greater /OHN, 29-Sep-1995
            if (nz .eq. 1 .or. zsum .gt. zsumax + 1.0d-10) then
               zsumax=zsum
               nzzero=nz
            endif
!           write (nconso,1025) nz, zsum, zsumax
!1025       format (' DIP: nz, zsum, zsumax = ', i4, 2f20.14)
 1030    continue

! if zdip!=0.000 find the nz closest to zdip (input by the user)
         if (zdip.lt.-1.0d-5) zdip=zdip+1.0d0
         if (zdip.gt.1.0d-5.and.zdip.le.1.0d0) nzzero=nint(ngz*zdip)+1
      endif
      zzero=dble(nzzero-1)/dble(ngz)*dirc(3,3)
!
! calculate the electrostatic potential
!
      call  elspot(nplwv,cwork1,rdensr,ngx,ngy,ngz,&
                 dirdat,cveff,cvion,nspin)
!
! average the electrostatic potential over x and y
!
      call elsave(ngx,ngy,ngz,nspin,cveff,rdensr,avdens,&
                        avVels)
!
! Now subtract the external [as calculated by dipole()] electrostatic
! potential
!
      call extadd(ngx,ngy,ngz,cvion,vext,-1.0d0)
!=======================================================================
! Calculate the slab dipole
!=======================================================================
      if (ldipol) then
         dipnew=0.0d0
         do 2000 nz=nzzero,nzzero+ngz-1
            z=dble(nz-1)/dble(ngz)*dirc(3,3)
            zindex = mod(nz-1,ngz)+1
            dipnew=dipnew-z*avdens(zindex)/dble(ngz)
 2000    continue
         do 2020 nsp=1,nspec
            do 2010 nion=1,nionsp(nsp)
               z=posion(3,nion,nsp)*dirc(3,3)
 2005          if (z.lt.zzero) then
                  z=z+dirc(3,3)
                  goto 2005
               endif
 2006          if (z-zzero.gt.dirc(3,3)) then 
                  z=z-dirc(3,3) 
                  goto 2006
               endif
               dipnew=dipnew+z*icharg(nsp)
 2010       continue
 2020    continue
!=======================================================================
! If the dipole is calculated for the first time, only accept anything
! from the dipole if it is small (hinting that this is a continuation-run
!=======================================================================
         if (lfirst) then
            dipold=dip0
            if (abs(dipnew-dipold).lt.0.1d0) then
               dipold=dipnew
            endif
         else
!=======================================================================
! make sure the potential-jump only change by at most 0.1 V per iteration
!=======================================================================
            vjmax=0.20d0
            vj=4.0d0*pi/(volc/dirc(3,3)/angst**2)&
                 *((dipnew-dipold)*dipmix/angst)*eV
            if (abs(vj).lt.vjmax) then
               dipold=dipold+(dipnew-dipold)*dipmix
            else
               dipold=dipold+(dipnew-dipold)*(dipmix*vjmax/abs(vj))
            endif
         endif
!=======================================================================
! Find external potential that removes this slab-dipole induced field
!=======================================================================
         vdip = 0.0d0
         if (idipol.eq.1) then
            vdip=4.0d0*pi/(volc/dirc(3,3)/angst**2)*(dipold/angst)*eV
            vjump=vdip+extfie*dirc(3,3)
         elseif (idipol.eq.2) then
            dipold=dipnew
            vjump=extpot
         else
            write(nconso,*)'DIP: unexepected in dipole.f: idipol=',&
                           idipol
            call clexit(nconso)
         endif
         field=vjump/dirc(3,3)
         vext(nzzero)=0.0d0
         do 3000 nz=nzzero+1,nzzero+(ngz-1)/2
            z=dble(nz-1)/dble(ngz)*dirc(3,3)
            vext(mod(nz-1,ngz)+1)=-vjump*((z-zzero)/dirc(3,3)-0.5d0)
 3000    continue
         if (mod(ngz,2).eq.0)&
              vext(mod(nzzero+ngz/2-1,ngz)+1)=0.0d0
         do 3010 nz=nzzero+ngz-(ngz-1)/2,nzzero+ngz-1
            z=dble(nz-1)/dble(ngz)*dirc(3,3)
            vext(mod(nz-1,ngz)+1)=-vjump*((z-zzero)/dirc(3,3)-0.5d0)
 3010    continue

! New dipole energy correction:
 
!        endipc = int_z pho_i(z) V_ext(z) dz  (external source)
!          + 1/2 int_z (pho_i(z)-pho_e(z)) V_dip(z) dz (internal source)
!
!  / Lennart 980311
         endipc=0.0d0
         do 3030 nsp=1,nspec
            do 3020 nion=1,nionsp(nsp)
               z=posion(3,nion,nsp)*dirc(3,3)
 3050          if ((z-zzero).gt.dirc(3,3)) then
                  z=z-dirc(3,3)
                  goto 3050
               endif
 3060          if ((z-zzero).lt.0.0d0) then
                  z=z+dirc(3,3)
                  goto 3060
               endif
               endipc=endipc-dble(icharg(nsp))* (-(vjump-vdip)*((z-zzero)/dirc(3,3)-0.5d0))
               endipc=endipc+0.5d0*(dble(icharg(nsp))*vdip*((z-zzero)/dirc(3,3)-0.5d0))
               ffield(1,nion,nsp)=0.0d0
               ffield(2,nion,nsp)=0.0d0
               ffield(3,nion,nsp)=-dble(icharg(nsp))*field
 3020       continue
 3030    continue
         do nz = nzzero,nzzero+ngz-1
            z=dble(nz-1)/dble(ngz)*dirc(3,3)
            iz = mod(nz-1,ngz)+1
            endipc=endipc+0.5d0*avdens(iz)/dble(ngz)*vdip*((z-zzero)/dirc(3,3)-0.5d0)
         enddo
      endif

      nzmin=nzzero-1
      if (nzmin.eq.0) nzmin=ngz
      nzmax=nzzero+1
      if (nzmax.gt.ngz) nzmax=1
! Corrected / Lennart
      nzmi2=nzmin-1
      if (nzmi2.eq.0) nzmi2=ngz
      nzma2=nzmax+1
      if (nzma2.gt.ngz) nzma2=1
      if (lfirst) then
         write(nconso,3045)zzero,nzzero,nzmi2,nzmin,nzmax,nzma2
 3045 format(1x,'DIP: Z_0 [A]',f12.6,' nzzero:',5i4)
         write(nconso,*)'DIP:'
         write(nconso,*)'DIP:   u_damp       u    Field_1  Field_2',&
                             '  Work_f1  Work_f2  V_jump   E_dip  '
         write(nconso,*)'DIP:     [eA]     [eA]    [V/A]    [V/A] ',&
                             '    [eV]     [eV]     [V]     [eV]  '
      endif
      if (ldipol.and.lfirst) then
         write(nconso,3065)dipold,dipnew,vjump,endipc
 3065    format(1x,'DIP: ',2f9.3,6x,'-',8x,'-',8x,'-',8x,'-',2x,2f9.3)
      elseif (ldipol.and.(.not.lfirst)) then
         field1=(avVels(nzmin)-avVels(nzmi2))/(dirc(3,3)/dble(ngz))
         field2=(avVels(nzma2)-avVels(nzmax))/(dirc(3,3)/dble(ngz))
         if (abs(extfie).lt.1.d-5.and.&
              abs(field1)+abs(field2).lt.0.1d0) then
            write(nconso,3040)dipold,dipnew,field1,field2,&
                 avVels(nzmin)-efermi,&
                 avVels(nzmax)-efermi,vjump,endipc
 3040       format(1x,'DIP: ',8f9.3)
         else
            write(nconso,3055)dipold,dipnew,field1,field2,&
                 vjump,endipc
 3055       format(1x,'DIP: ',4f9.3,6x,'-',8x,'-',2x,2f9.3)
         endif
      elseif (lworkp.and.lfirst) then
         write(nconso,3085)
      elseif (lworkp.and.(.not.lfirst)) then
         field1=(avVels(nzmin)-avVels(nzmi2))/(dirc(3,3)/dble(ngz))
         field2=(avVels(nzma2)-avVels(nzmax))/(dirc(3,3)/dble(ngz))
         if (abs(extfie).lt.1.d-5.and.&
              abs(field1)+abs(field2).lt.0.1d0) then
            write(nconso,3075) field1,field2,avVels(nzmin)-efermi,&
                               avVels(nzmax)-efermi
         else
            write(nconso,3095) field1,field2
         endif
 3085    format(1x,'DIP: ',6x,'-',8x,'-',8x,'-',8x,'-',&
                           8x,'-',8x,'-',8x,'-',8x,'-')
 3075    format(1x,'DIP: ',6x,'-',8x,'-',2x,4f9.3,6x,'-',8x,'-')
 3095    format(1x,'DIP: ',6x,'-',8x,'-',2x,2f9.3,6x,'-',8x,'-',&
                                                  8x,'-',8x,'-')
      else
         write(nconso,*)'Unexpected in dipol.f'
      endif
      lfirst=.false.

! master node saves dipole information for faster restart
! from old wf/chdens
      if (ldipol.and.lmastr) call save_dipole_restart_info(dipnew)

!
! Now add the external [as calculated by dipole()] electrostatic
! potential
!
      call extadd(ngx,ngy,ngz,cvion,vext, 1.0d0)
      return
      end
!=======================================================================
      subroutine extadd(ngx,ngy,ngz,cpot,vext,one)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      complex*16 cpot(ngx,ngy,ngz)
      real*8 vext(ngz)
!=======================================================================
      do 1020 nz=1,ngz
         do 1010 ny=1,ngy
            do 1000 nx=1,ngx
               cpot(nx,ny,nz)=cpot(nx,ny,nz)+one*vext(nz)
 1000       continue
 1010    continue
 1020 continue
      return
      end


!=======================================================================
      subroutine save_dipole_restart_info(dipval)
!=======================================================================
!  Save current dipole info to netCDF attribute
!  DipoleCorrection%RestartValue for faster restart
!  Only master should invoke this call
!=======================================================================
      use netcdfinterface
      use run_context
      implicit none

      real*8           dipval
      integer          ncid, status
! ----------------------------------------------------------------------
      status = nf_open(netCDF_output_filename, NF_WRITE, ncid)
      if (status /= nf_noerr) stop "nf_open: error in save_dipole"

      status = nfput(ncid,"DipoleCorrection%RestartValue", dipval)
      if (status /= nfif_ok) stop "nfput DipoleCorrection%RestartValue"

      status = nf_close(ncid) 
      if (status /= nf_noerr) stop "nf_close: error"
! ----------------------------------------------------------------------
      end subroutine save_dipole_restart_info


      subroutine magnetic(nconso,ngx,ngy,ngz,nspin,nplwv,volc,dirc,&
                          rdensr,nspec,nionsp,nions,posion)
!=======================================================================
! For spin-polarized calculations :
!     Calculate total and local magnetic moment.
!=======================================================================

      integer nconso,ngx,ngy,ngz,nspin
      integer nplwv
      real*8  volc
      real*8  dirc(3,3)
      real*8  rdensr(ngx,ngy,ngz,nspin)
      integer nspec
      integer nionsp(nspec)
      integer nions
      real*8  posion(3,nions,nspec)

      integer nx,ny,nz,i
      real*8  mom(2)


!     get the total magnetic moment
      do i = 1,nspin
        mom(i) = 0.0d0
        do nx = 1,ngx
          do ny = 1,ngy
            do nz = 1,ngz
               mom(i) = mom(i) + rdensr(nx,ny,nz,i)
            enddo
          enddo
        enddo
        mom(i) = mom(i)/dble(nplwv)
      enddo
      write(nconso,*) 'MOM ',dabs(mom(1)-mom(2)),'(',mom(1),mom(2),')'

      return
      end



      subroutine elsave(ngx,ngy,ngz,nspin,cveff,rdensr,avdens,&
                        avVels)
!
      implicit none
!
      integer ngx,ngy,ngz
      integer nspin
      complex*16 cveff(ngx,ngy,ngz,nspin)
      real*8 rdensr(ngx,ngy,ngz,nspin)
      real*8 avdens(ngz)
      real*8 avVels(ngz)
!
! locals
!
      integer i,nx,ny,nz

!
! calculate the x-y averaged charge density, electrostatic and
! effective potential
!
      do 7050 nz=1,ngz
         avdens(nz)=0.0d0
         avVels(nz)=0.0d0
         do 7055 i=1,nspin
            do 7060 ny=1,ngy
               do 7070 nx=1,ngx
                  avdens(nz)=avdens(nz)+rdensr(nx,ny,nz,i)
                  avVels(nz)=avVels(nz)+dble(cveff(nx,ny,nz,i))
 7070          continue
 7060       continue
 7055    continue
         avdens(nz)=avdens(nz)/dble(ngx*ngy)
         avVels(nz)=avVels(nz)/dble(ngx*ngy*nspin)
 7050 continue


      return
      end


      subroutine chdave(nconso,ngx,ngy,ngz,cveff,rdensr,&
              rho_core, dirc,nplwv,npwxc,volc,enxcc,enxc,&
              excdat,xcfdat,xcpdat,nxc,efermi,&
              recc,lpctx,lpcty,lpctz,vxc,dnlg0,cwork1,&
              iscxc,nspin,dirdat,cvion,idebug,&
              netcdf,ncid, &
              timer)
      implicit none
      integer nconso
      integer ngx,ngy,ngz
      integer iscxc,nspin, nplwv, npwxc
      integer nxc
      complex*16 cveff(ngx,ngy,ngz,nspin)
      real*8 rdensr(ngx,ngy,ngz,nspin)
      real*8 rho_core(nplwv)
      real*8 dirc(3,3)
      real*8 volc
      real*8 enxcc
      real*8 enxc
      real*8 excdat(nxc),xcfdat(nxc),xcpdat(nxc)
      real*8 efermi
      real*8 recc(3,3)
      real*8 lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 vxc(ngx,ngy,ngz,2)
      real*8 dnlg0(npwxc,3)
      real*8 dirdat(nplwv)
      complex*16 cvion(nplwv)
      complex*16 cwork1(nplwv)
      integer    idebug 
      logical*4  netcdf 
      integer    ncid
      real*8     timer(*)
! locals
      real*8 avdens(ngz)
      real*8 avVels(ngz)
      real*8 avmom
      real*8 avVeff
      integer nx,ny,nz,i
      real*8 enhac
      real*8 eps 
      parameter(eps = 1d-5)
!
! calculate the electrostatic potential
!

      if (dabs(dirc(3,3)).lt.eps) then 
        write(nconso,*) 'AVE: Can not calculate xy average (Lz=0)'
        return 
      endif
      call  elspot(nplwv,cwork1,rdensr,ngx,ngy,ngz,&
                 dirdat,cveff,cvion,nspin)

! average the electrostatic potential over a1 and a2
!
      call elsave(ngx,ngy,ngz,nspin,cveff,rdensr,avdens,&
                        avVels)
!
! calculate the effective potential
!
      call tidyup(nplwv,npwxc,rdensr,rho_core,&
              enhac,dirdat,cveff,volc,enxcc,&
              enxc,excdat,xcfdat,xcpdat,nxc,cvion,&
              recc,lpctx,lpcty,lpctz,vxc,dnlg0,cwork1,&
              iscxc,nspin,ngx,ngy,ngz,nconso,idebug,timer)

! average the effective potential over a1 and a2
! average the local spin density over a1 and a2
! print out the averages
! The electron density is written so that the integral along z
! gives the total number of electrons. 
!
      write(nconso,*) 'AVE   height (a3)   density       Els pot  ',&
           '   Eff pot        Ef    spin pol'
      write(nconso,*) 'AVE     Angs          -e/A             V     ',&
           '      V           eV    -e/A'
      write(nconso,*) ' Begin Integrated charge density, elec + eff pot'
      do 7050 nz=1,ngz
         avmom=0.0d0
         avVeff=0.0d0
         do 7055 i=1,nspin
            do 7060 ny=1,ngy
               do 7070 nx=1,ngx
                  avmom=avmom+dble(2*i-3)*rdensr(nx,ny,nz,i)
                  avVeff=avVeff+dble(cveff(nx,ny,nz,i))
 7070          continue
 7060       continue
 7055    continue
         avmom=avmom/dble(ngx*ngy)/dirc(3,3)
         avVeff=avVeff/dble(ngx*ngy*nspin)
         if (nspin.eq.1) then
            write (nconso,7080) dble(nz-1)/dble(ngz)*dirc(3,3),&
             avdens(nz)/dirc(3,3),avVels(nz),avVeff,efermi
         else
            write (nconso,7080) dble(nz-1)/dble(ngz)*dirc(3,3),&
             avdens(nz)/dirc(3,3),avVels(nz),avVeff,efermi,&
             avmom
         endif
 7050 continue
 7080 format(1x,'AVE: ',6f12.6)
      write(nconso,*) ' End Integrated charge density, elec + pot'

      return
      end


