#include "definitions.h"

      subroutine diaghid (nconso)
      write(nconso,*) '@(#)davidson.F	1.17 7/1/99'
      return
      end


      subroutine diag_h (lgenev, tolerance, resmax, nextend,&
        ndiapb,  norder, nplwkp,&
        eigen, cptwfp, &
        wfkine, vnl,entot,damconv,&
#include H_TIMES_B_ARGS
        , nconso, timer)

!     Diagonalize the Hamiltonian approximately by an iterative method,
!     finding the lowest eigenvalues using an initial guess for
!     the eigenvectors.

!     lgenev ..... .TRUE. for generalized eigenvalue problem
!                  .FALSE. for standard eigenvalue problem
!     tolerance .. Eigenvalue tolerance (generally between 1d-3 and 1d-6)
!     resmax ..... Output: Maximum residual value
!     nextend .... Output: Number of times the subspace was extended
!     ndiapb ..... Maximum number of iterations.
!     nbsub ...... Block-size of iterative diagonalization.
!     norder ..... Number of extra blocks in the workspace: see below
!     nplwkp ..... Number of vector elements in cptwfp
!     nbands ..... Number of eigenvectors/values requested (in H_TIMES_B_ARGS)
!     cptwfp ..... Eigenvectors:
!                  On input:  contains initial guess.
!                  On output: contains updated eigenvectors.
!     eigen ...... Eigenvalues (output).
!     wfkine ..... Wavefunction kinetic energy (output).
!     vnl ........ Non-local energy (output: dummy - is zeroed).
!     entot ...... Total energy from last iteration
!     nconso ..... Fortran output unit.
!     timer ...... Program timers.

      implicit none
#include H_TIMES_B_DECL
      logical*4 lgenev
      integer ndiapb, norder, nplwkp
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      real*8 tolerance, resmax
      real*8 eigen(nbands), vnl(nbands), wfkine(nbands),entot,damconv
      integer nextend, nconso
      real*8 timer(*)

!     Local vars
      real*8 residual(nbands)
      real*8 sum, temp
      integer j, nn, n,m, nmax, info, maxiter, ns, noresiduals
      integer nbsub1,ndiapb1,norder1,nbsub
#ifdef PARAL
      integer offset(par_pw_np)
      integer nlocal(par_pw_np)
#endif


!     Apply the Davidson algorithm
      nbsub = 4

!     Maximum number of iterations: ndiapb per band
!     maxiter = (ndiapb * nbands) / nbsub
      maxiter = ndiapb

!     Choosing the memory size of workspaces in davidson:
!     Sufficient for norder iterations before restarting
      nmax = nbands + norder * nbsub
      nbsub1  = nbsub 
      norder1 = norder
      ndiapb1 = ndiapb

#ifdef SERIAL
      n = nplwkp
#else
!     find lenght of wavefunction array for this process
      call  par_defwfk (nrplwv,nrplwv_global,nplwkp,nlocal,offset,n,&
#include PARAL_ARGS
        , nconso)
      n_global = nplwkp
#endif
    
!     Standard or generalized eigenvalue problem ?
      if (lgenev) then
        ns = n
      else
        ns = 1
      endif

      vnl(:) = 0.0d0
      call eigsolver(lgenev,n,nbands,eigen,cptwfp,nrplwv,&
            nbsub1,maxiter,ndiapb1, tolerance,&
#include H_TIMES_B_ARGS
              , nconso, timer, info)

!     number of residuals given from subproj
      noresiduals = max(info-nbsub,0)

      if (info .gt. 0) then
        write (nconso,100) 'NOTICE', info
100     format (' diag_h: ', a, ': davidson returned info=', i4,&
          ' unconverged eigenvalues:')
        do j = 1, noresiduals
          if (residual(j) .gt. tolerance*(1.0+abs(eigen(j))) .or.&
              residual(j) .lt. 0.0d0)&
            write(nconso,110) j, eigen(j), residual(j)
110       format (' diag_h: e(', i4, ')=', f15.8, ' residual norm=',&
            f15.8)
        end do
      else if (info .lt. 0) then
        write (nconso,100) 'ERROR', info
        return
      endif

!     Find the maximum residual (divide by 1+abs(eigenvalue))

      resmax = -1.0d10
      do j = 1,  noresiduals
        resmax = max (resmax, residual(j)/(1.0d0+abs(eigen(j))))
      end do
!     In case of unconverged eigenpairs,
!     make sure resmax isn't underestimated:
      if (info .gt. 0) resmax = max (resmax, tolerance)
#ifdef DEBUG
      write (nconso,120) resmax
120   format (' diag_h: resmax = ', f15.8)
#endif

! Do not pretend to calculate the non-local energy vnl correctly (zero it).
      do nn = 1,nbands
         vnl(nn)=0.0d0
      enddo

! Find the kinetic energy.
      call sum_kin_erg(cptwfp,nrplwv,nrplwv_global,nplwkp,nbands,&
                       pwkine(1,nkp),wfkine &
#ifdef PARAL
                       ,&
#include PARAL_ARGS
#endif
                 ,nconso,timer ) 
      call uflush (nconso)

      return
      end


!---------------------------------------------------------------------- 
      subroutine sum_kin_erg(&
                        cptwfp,nrplwv,nrplwv_global,nplwkp,nbands,&
                        pwkine,wfkine &
#ifdef PARAL
                        ,&
#include PARAL_ARGS
#endif
                        ,nconso,timer)
#ifdef PARAL
      use par_functions_module
#endif PARAL
      implicit none
!     Find the kinetic energy wfkine of the plane-wave in cptwfp 
!     for each band nbands. 
!     pwkine is the kinetic energy for each plane-wave component. 
!     For parallel program a global sum is made on all nodes.

      integer nrplwv,nplwkp,nbands,nrplwv_global
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      real*8  wfkine(nbands), timer(*), sum, temp
      integer nconso
#ifdef SERIAL
      real*8  pwkine(nrplwv)
#else
#     include PARAL_DECL
      real*8  pwkine(nrplwv_global)
      integer nlocal(par_pw_np),offset(par_pw_np)
#endif

!     locals 
      integer nn,m,nplwkp_local,offs

#ifdef SERIAL 
      nplwkp_local = nplwkp
      offs = 0
#else
      call par_defwfk (nrplwv,nrplwv_global,nplwkp,nlocal,offset, &
                       nplwkp_local,&
#include PARAL_ARGS
        , nconso)
      offs         = offset(par_process+1)
#endif

      do nn=1,nbands
         sum = 0.0d0
         do  m=1,nplwkp_local
            temp = dble(cptwfp(m,nn)*conjg(cptwfp(m,nn)))
            sum=sum+pwkine(m+offs)*temp
         enddo     
         wfkine(nn)=sum
      enddo    

#ifdef PARAL 
!     Make global sum of partial kinetic energies
      call par_sum_double ('A',wfkine,wfkine,nbands,nbands,1,&
#include PARAL_ARGS
          ,timer )
#endif

      return 
      end  


!------------------------------------------------------------------

      real*8 function get_eigen_value_convergence(eigen,nbands,nkprun) 
! 
!     return convergence in eigen values 
!     as maximum change on any eigenvalue from last iteration.
      implicit none
      integer, intent(in) :: nbands,nkprun 
      real*8, intent(in)  :: eigen(nbands,nkprun) 

      logical, save              :: init=.true. 
      real*8 , save, allocatable :: eigen_old(:,:) 
      real*8                     :: max_change

      if (init) then 
        allocate(eigen_old(nbands,nkprun))
        eigen_old = eigen
        init = .false. 
        get_eigen_value_convergence = 0.0d0
        return 
      else 
        max_change = maxval(dabs(eigen(:,:)-eigen_old(:,:))) 
        eigen_old = eigen
        get_eigen_value_convergence = max_change
        return 
      endif

      end      


