!=======================================================================
      subroutine calvid(nconso)
      write(nconso,*) '@(#)calvps.F	1.3 11/11/96'
      return
      end
!=======================================================================
      subroutine calvps(g,vps,volc,psp,psgmax,icharg,npspts)
!=======================================================================
! this subroutine calculates the local potential formfactor for fourier
! component g
!
!  input:  g : length of reciprocal space vector
!  output: vps: reciprocal space local ionic potential formfactor
!=======================================================================
      use basicdata, only : edeps
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension psp(npspts)
!=======================================================================
      data one,half,sixth / 1.0d0,0.5d0,0.166666666667d0 /
!=======================================================================
!     dacoul=ev/epslon0 = 180.95270
!
!     1ev=1.6021892e-12 erg
!     epslon0(permittivity of vacuum) = 8.85418782e-12 f m-1
!                                     = 8.85418782e-2  f (angstrom)-1
!     now using edeps for dacoul, defined in van_us_def.h
!=======================================================================
      volinv=one/volc
!=======================================================================
! calculate the scaling factor argsc that converts the magnitude of a
! reciprocal lattice vector to the correponding position in the
! pseudopotential arrays
!=======================================================================
      
      argsc=(npspts-1)/psgmax
      encoul=icharg*edeps*(argsc**2)
      arg=(g*argsc)+1
      if(arg.lt.3.0d0) then
         vps=0.0d0
      else
         naddr=int(arg)
         if(naddr.gt.(npspts-2)) then
            vps=0.0d0
         else
            rem=mod(arg,one)
            v1=psp(naddr-1)+(encoul/((naddr-2)**2))
            v2=psp(naddr)+(encoul/((naddr-1)**2))
            v3=psp(naddr+1)+(encoul/((naddr)**2))
            v4=psp(naddr+2)+(encoul/((naddr+1)**2))
            t0=v2
            t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
            t2=(v1+v3-(2*v2))*half
            t3=(v4-v1+(3*(v2-v3)))*sixth
            vps=((-encoul/((arg-1)**2))+t0+&
                 rem*(t1+rem*(t2+rem*t3)))*volinv
         endif
      endif
      return
      end
