! @(#)bfgs.F	1.4 4/27/99
!======================================================================
      subroutine Broyfletgoldshan(nconso,n,posion,etot,force,&
                                  deltim,alpha,dposr)                          
!======================================================================
      implicit none
      integer nconso,n
      real*8  posion(n),force(n),dposr(n)
      real*8  etot
      real*8  deltim,alpha 

!     locals
      logical init
      real*8  deold,detot,eold,x,norm 
      real*8  dg(n)
      real*8,allocatable,save:: posold(:),forceold(:),hessin(:,:),xi(:)
      real*8  linmin,ddot
      integer i,j
      real*8  grad
      real*8  ediff,dediff
      save  eold, deold, init
      data  init /.false./

!     copy posion to dposr 
      do i = 1,n 
        dposr(i) = posion(i) 
      enddo 

      if (.not.init) then 

        if (.not.allocated(posold))   allocate(posold(n))
        if (.not.allocated(forceold)) allocate(forceold(n))
        if (.not.allocated(hessin))   allocate(hessin(n,n))
        if (.not.allocated(xi))       allocate(xi(n))

!       initialize the hessian matrix to the unit matrix
        do i=1,n
          do j=1,n
              hessin(i,j)=0.
          enddo
           hessin(i,i)=1.
        enddo

!       store the current positions and the current forces
!       and move in the direction of the forces
        do i = 1,n
            posold(i) = posion(i)
            forceold(i) = force(i)
            posion(i) = posion(i) + alpha*force(i)*deltim**2
        enddo

!       set the initial direction along the forces
        do i = 1,n
          xi(i) = posion(i) - posold(i)
        enddo

        eold  = etot
        deold = grad(n,force,xi)

!       return change in dposr
        do i = 1,n
          dposr(i) = posion(i)-posold(i)
        enddo

        init = .true.

        return
 
      endif  !   if.not.init

      do i = 1,n 
          write(nconso,*) 'BFGS XI ',i,xi(i)
      enddo 

!     find the gradient in the current direction xi 
      detot = grad(n,force,xi)
!
!     do the 'pseudo' line minimization along xi
!     x = 0 newpos = posold
!     x = 1 newpos = posion
      x = linmin(eold, etot, deold, detot,nconso)

      if (abs(x)<0.0001) then 
!       reset: 
        init = .false. 
  
        do i = 1,n
          dposr(i) = posion(i) - dposr(i)
        enddo 
                               
        return 
      endif

!     try to catch the situation if the two point are very close so that for numerical 
!     reason linmin can not find the correct minimum. 
      dediff = dabs(deold-detot)
      ediff  = dabs(eold-etot)
!     is x in the range -0.5-1.5
      if ((abs(x-1.0d0).gt.0.05).and.(abs(x-0.5).lt.1.0)) then 
!        now check if the two point are  close
         if ((ediff.lt.0.001).and.(dediff.lt.0.001)) x = 1.0d0
      endif
         
!
!     test if last linmin has been sucessfull
      if (abs(x-1.0d0).gt.0.05) then 

!       move to the new point 
!       write(*,*) 'before move posion ',(posion(i),i=1,n)
!       write(*,*) 'before move xi     ',(xi(i),i=1,n)
        call daxpy(n,(x-1.0d0),xi,1,posion,1)
!       update xi
        do i=1,n
          xi(i)  = (x-1.0d0)*xi(i)
        enddo    
        deold = grad(n,force,xi) 
        eold  = etot   

      else 

!       we are at the mimimum along xi
        do i=1,n
          xi(i)    =posion(i)-posold(i)
          posold(i)=posion(i)
        enddo    

!       find diffence in gradients
        do i=1,n
          dg(i)       = force(i) - forceold(i)
          forceold(i) = force(i)
          eold        = etot
        enddo

!       update the hessian 
        call dfpmin(dg,xi,n,hessin,force)

!       write hessian 
        do i = 1,n 
            write(nconso,100) i,(hessin(i,j),j=1,n) 
100         format(1x,'BFGS HESSIAN: ',i3,50(f6.2,1x))
        enddo
        do i = 1,n 
            write(nconso,*) 'BFGS NEW XI ',i,xi(i)
        enddo 

!       take a step in the new direction xi 
!       step length determined by the force in the xi direction
        deold = grad(n,forceold,xi)
        norm = ddot(n,xi,1,xi,1)
        do i = 1,n 
           posion(i) = posion(i) - alpha*deold*xi(i)*deltim**2/norm
        enddo 
!       define xi as the diff. between posion and posold
        do i = 1,n 
          xi(i) = posion(i)-posold(i) 
        enddo  

!       find the gradient at the position posold in the new direction
        deold = grad(n,forceold,xi)

        
      endif
!     return change in dposr
      do i = 1,n
        dposr(i) = posion(i)-dposr(i)
      enddo


      return 
      end

!======================================================================
      real*8 function grad(n,force,xi) 
      implicit none 
      integer n 
      real*8 force(n),xi(n)
      real*8 ddot
      integer i 
      
      grad = -ddot(n,force,1,xi,1)

      return   
      end

!======================================================================
        SUBROUTINE dfpmin(dg,xi,n,hessin,g)
!
!       input : 
!          xi     : The change in the positions
!          dg     : The change in force.
!
!       output : 
!          hessin : The updated Hessian. 
!          xi     : The new direction to do line search in.
!======================================================================
        implicit none
        integer n
        real*8  dg(n),xi(n),hessin(n,n),g(n)

        INTEGER i,its,j
        LOGICAL check
        REAL*8 den,fac,fad,fae,sum,sumdg,sumxi,temp
        REAL*8 test
        REAL*8 hdg(n),EPS 
        parameter(EPS = 1d-6) 
 


        do 19 i=1,n
          hdg(i)=0.
          do 18 j=1,n
            hdg(i)=hdg(i)+hessin(i,j)*dg(j)
18        continue
19      continue
        fac=0.
        fae=0.
        sumdg=0.
        sumxi=0.
        do 21 i=1,n
          fac=fac+dg(i)*xi(i)
          fae=fae+dg(i)*hdg(i)
          sumdg=sumdg+dg(i)**2
          sumxi=sumxi+xi(i)**2
21      continue
        if(fac**2.gt.EPS*sumdg*sumxi) then
          fac=1./fac
          fad=1./fae
          do 22 i=1,n
            dg(i)=fac*xi(i)-fad*hdg(i)
22        continue
          do 24 i=1,n
            do 23 j=1,n
              hessin(i,j)=hessin(i,j)+fac*xi(i)*xi(j)-fad*hdg(i)*hdg(j)+fae*dg(i)*dg(j)
23          continue
24        continue
        endif
        do 26 i=1,n
          xi(i)=0.
          do 25 j=1,n
            xi(i)=xi(i)-hessin(i,j)*g(j)   ! new direction xi 
25        continue
26      continue
      return
      END


!-----------------------------------------------------------------------
      function linmin(eold, etot, deold, detot,nconso)
!-----------------------------------------------------------------------
 
      implicit none
 
      real*8 eold, etot, deold, detot, b, c, c2, d, dbc2, x, x2,&
             enew, denew, linmin
      integer nconso
      real*8 eps 
      parameter(eps = 1.0e-6)

      if ((dabs(detot).lt.eps).and.(etot.lt.eold)) then 
        linmin = 1
        return 
      endif 
      b =  deold
      c =  3*etot - detot - 3*eold - 2*deold
      d = -2*etot + detot + 2*eold +   deold
      dbc2 = 3 * d * b / c**2
      c2 = (detot - deold) / 2.0
      x2  = -b / (2.0 * c2)
      if (dbc2.gt.1.0) then
         write(nconso,'(/5x,''BFGS Linmin: 2nd order interpolation'')')
         x = x2
      else if (abs(dbc2).lt.0.01) then
         write(nconso,'(/5x,''BFGS Linmin: 2nd order interpolation plus 3rd order corrections'')')
         x = -b /(2.0 * c) * (1.0 + dbc2 / 2.0)
      else
         x = c * (-1.0 + sqrt(1.0-dbc2)) /3.0/d
         write(nconso,'(/5x,''BFGS Linmin: 3rd order interpolation'')')
      end if
 
       write(nconso,'('' b, c, d, dbc2 ='',4f10.6)') b, c, d, dbc2
       write(nconso,'('' x, x2 ='',2f12.6)') x, x2

!     check that the 3rd order interpolation is corresponding to the derivative
!     detot and deold 
      if ((detot.gt.0.0 .and. x.gt.1.0) .or.&
          (detot.lt.0.0 .and. x.lt.1.0) .or.&
          (deold.gt.0.0 .and. x.gt.0.0) .or.&
          (deold.lt.0.0 .and. x.lt.0.0) ) then
         write(nconso,'(5x,''BFGS New position on the wrong side! '',/5x,''BFGS Using 2nd order interpolation'')')
         x = x2
!        repeat check 
         if ((detot.gt.0.0 .and. x.gt.1.0) .or.&
             (detot.lt.0.0 .and. x.lt.1.0) .or.&
             (deold.gt.0.0 .and. x.gt.0.0) .or.&
             (deold.lt.0.0 .and. x.lt.0.0) ) then
             write(nconso,'(/5x,a)') 'BFGS No luck! resetting ...'
             x = 0
         end if
      end if
 
      enew  = eold + b*x + c * x**2 + d * x**3
      denew = b + 2.0 * c*x + 3.0*d * x**2
      write(nconso,9000) eold, deold, etot, detot, x, enew,denew
 
! if x is very big, rescale to a more reasonable value
!     linmin = min(x, 10.0)
      if (x.gt.10) x = 4.0
      linmin = x
 
 9000 format (/5x,'BFGS Eold           =',  f14.6,' eV',&
              /5x,'BFGS DEold          =',  f14.6,' eV',&
              /5x,'BFGS Etot           =',  f14.6,' eV',&
              /5x,'BFGS DEtot          =',  f14.6,' eV',&
              /5x,'BFGS x              =',  f14.6,&
              /5x,'BFGS Estimate Enew  =',  f14.6,' eV',&
              /5x,'BFGS Estimate DEnew =',  f14.6,' eV')
 
      return
      end

!======================================================================
      subroutine read_bfgs(n,forceold,posold,hessin,xi,&
                           eold,deold,found)
!======================================================================
!
!     read from bfgs.dat 
!        forceold 
!        posold 
!        hessin 
!        xi 
!        eold
!        deold
      implicit none
      integer    n
      real*8     posold(n),forceold(n)
      real*8     hessin(n,n),xi(n),eold,deold
      logical*4 found
      integer   errno

      open(10,file='bfgs.dat',status='old',iostat=errno,&
           form='unformatted') 
 
      if (errno.gt.0) then 
        found = .false. 
        return 
      else 
!       start reading 
        read(10,err=100,end=100) posold
        read(10,err=100,end=100) forceold
        read(10,err=100,end=100) hessin
        read(10,err=100,end=100) xi
        read(10,err=100,end=100) eold
        read(10,err=100,end=100) deold
        found = .true. 
        close(10)
        return 
      endif

100   found = .false. 

      return 
      end


!======================================================================
      subroutine write_bfgs(n,forceold,posold,hessin,xi,eold,deold)
!======================================================================
!
!     write to bfgs.dat
!        forceold
!        posold
!        hessin
!        xi
!        eold 
!        deold
      implicit none
      integer    n
      real*8     posold(n),forceold(n)
      real*8     hessin(n,n),xi(n),eold,deold
 
      open(10,file='bfgs.dat',status='unknown',form='unformatted')
!     call rewind(10)
 
!     start writing
      write(10) posold
      write(10) forceold
      write(10) hessin
      write(10) xi
      write(10) eold
      write(10) deold
      close(10)
 
      return
      end                                     

        
