from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms


a = 2.87
bulk = ListOfAtoms([Atom('Fe', (0,   0,   0),   magmom=2.2),
                    Atom('Fe', (a/2, a/2, a/2), magmom=-2.2)],
                   cell=(a, a, a))

calc = Dacapo(spinpol=True,
              kpts=(8, 8, 8),
              planewavecutoff=300,
              densitycutoff=500,
              nbands=17,
              usesymm=True,
              out='anti.nc',
              txtout='anti.txt')

bulk.SetCalculator(calc)

print bulk.GetPotentialEnergy()
