#include  "definitions.h"
      subroutine ylmr2_id(nconso)
      write(nconso,*) '@(#)ylmr2.F	1.5 8/24/98'
      return
      end
!-----------------------------------------------------------------------
      SUBROUTINE AAINIT(LLi,mix,lx,AP,LPX,LPL)
!-----------------------------------------------------------------------
      use basicdata
      IMPLICIT REAL*8 (A-H,O-Z)

!
!     NLX= COMBINED ANGULAR MOMENTUM FOR LLi   (FOR S,P AND D STATES NLX=9)
!     LX = MAX 2*LLi-1
!     25 = COMBINED ANGULAR MOMENTUM FOR 2*LLi-1 (FOR S,P AND D STATES)
!     mx = 2*lx-1, mix = 2*lix-1
!     lix = lli

      
      INTEGER    LPX(NLX,NLX), LPL(NLX,NLX,MX)
      REAL*8 AP(25,NLX,NLX)
      INTEGER P
      DIMENSION  CC(lmaxx+1,2*lmaxx+1,lmaxx+1,2*lmaxx+1,lqx)
      COMPLEX*16 AA(lqx,mx,lmaxx+1,2*lmaxx+1,lmaxx+1,2*lmaxx+1)
      COMPLEX*16 U(lqx,mx,mx),SUM
!
!                          ARRAY AA
!
!      CC = < LM | LiMi | LjMj > = sqrt(2L+1/4pi) (-1)^Mj c^L(Li-Mi,LjMj)
!
!      COEFF. c^L FROM WEISSBLUTH 'ATOMS AND MOLEC..'  PAGE 246
!      CC(Li,Mi,Lj,Mj,L)  L  IS FREE INDEX, M=Mj+Mj   (INPUT LiMi LjMj)
!
      LL=2*LLi-1
!     WRITE (*,*)
!     WRITE (*,*) ' AAINIT:  LLi LL ',LLi,LL
!     WRITE (*,*)
!      IF (LLi.GT.LiX) CALL ERROR(' AAINIT ',' LLi .GT. LiX ',LLi)
!
!      DO 1 I=1,Lli*MiX*Lli*MiX*LX
!1       CC(I,1,1,1,1)=0.D0
      call setv(Lli*MiX*Lli*MiX*LX,0.0d0,CC(1,1,1,1,1),1)

                                       !  LiMi  LjMj   -   LM
      CC(1,1,1,1,1)= 1.D0              !   s     s     -   s
 
      IF(LLi.GT.1) THEN
       CC(1,1,2,1,2)= 1.D0             !   s    p_-1   -  p_-1
       CC(1,1,2,2,2)= 1.D0             !   s    p_0    -  p_0
       CC(1,1,2,3,2)= 1.D0             !   s    p_1    -  p_1
 
       CC(2,1,2,1,3)= DSQRT(6.D0/5.D0)      !  p_-1  p_-1   -  d_-2
       CC(2,1,2,2,3)= DSQRT(3.D0/5.D0)      !  p_-1  p_0    -  d_-1
       CC(2,1,2,3,1)=-1.D0               !  p_-1  p_1    -   s
       CC(2,1,2,3,3)= DSQRT(1.D0/5.D0)      !  p_-1  p_1    -  d_0
       CC(2,2,2,2,1)= 1.D0               !  p_0   p_0    -   s
       CC(2,2,2,2,3)= DSQRT(4.D0/5.D0)      !  p_0   p_0    -  d_0
       CC(2,2,2,3,3)= DSQRT(3.D0/5.D0)      !  p_0   p_1    -  d_1
       CC(2,3,2,3,3)= DSQRT(6.D0/5.D0)      !  p_1   p_1    -  d_2
      ENDIF
 
      IF(LLi.GT.2) THEN
       CC(1,1,3,1,3)= 1.D0               !   s    d_-2   -  d_-2
       CC(1,1,3,2,3)= 1.D0               !   s    d_-1   -  d_-1
       CC(1,1,3,3,3)= 1.D0               !   s    d_0    -  d_0
       CC(1,1,3,4,3)= 1.D0               !   s    d_1    -  d_1
       CC(1,1,3,5,3)= 1.D0               !   s    d_2    -  d_2
 
       CC(2,1,3,1,4)= DSQRT(45.D0/35.D0)    !  p_-1  d_-2  -  f_-3
       CC(2,1,3,2,4)= DSQRT(30.D0/35.D0)    !  p_-1  d_-1  -  f_-2
       CC(2,1,3,3,2)=-DSQRT( 1.D0/ 5.D0)    !  p_-1  d_0   -  p_-1
       CC(2,1,3,3,4)= DSQRT(18.D0/35.D0)    !  p_-1  d_0   -  f_-1
       CC(2,1,3,4,2)=-DSQRT( 3.D0/ 5.D0)    !  p_-1  d_1   -  p_0
       CC(2,1,3,4,4)= DSQRT( 9.D0/35.D0)    !  p_-1  d_1   -  f_0
       CC(2,1,3,5,2)=-DSQRT( 6.D0/ 5.D0)    !  p_-1  d_2   -  p_1
       CC(2,1,3,5,4)= DSQRT( 3.D0/35.D0)    !  p_-1  d_2   -  f_1
       CC(2,2,3,1,4)= DSQRT(15.D0/35.D0)    !  p_0   d_-2  -  f_-2
       CC(2,2,3,2,2)= DSQRT( 3.D0/ 5.D0)    !  p_0   d_-1  -  p_-1
       CC(2,2,3,2,4)= DSQRT(24.D0/35.D0)    !  p_0   d_-1  -  f_-1
       CC(2,2,3,3,2)= DSQRT( 4.D0/ 5.D0)    !  p_0   d_0   -  p_0
       CC(2,2,3,3,4)= DSQRT(27.D0/35.D0)    !  p_0   d_0   -  f_0
       CC(2,2,3,4,2)= DSQRT( 3.D0/ 5.D0)    !  p_0   d_1   -  p_1
       CC(2,2,3,4,4)= DSQRT(24.D0/35.D0)    !  p_0   d_1   -  f_1
       CC(2,2,3,5,4)= DSQRT(15.D0/35.D0)    !  p_0   d_2   -  f_2
       CC(2,3,3,1,2)=-DSQRT( 6.D0/ 5.D0)    !  p_1   d_-2  -  p_-1
       CC(2,3,3,1,4)= DSQRT( 3.D0/35.D0)    !  p_1   d_-2  -  f_-1
       CC(2,3,3,2,2)=-DSQRT( 3.D0/ 5.D0)    !  p_1   d_-1  -  p_0
       CC(2,3,3,2,4)= DSQRT( 9.D0/35.D0)    !  p_1   d_-1  -  f_0
       CC(2,3,3,3,2)=-DSQRT( 1.D0/ 5.D0)    !  p_1   d_0   -  p_1
       CC(2,3,3,3,4)= DSQRT(18.D0/35.D0)    !  p_1   d_0   -  f_1
       CC(2,3,3,4,4)= DSQRT(30.D0/35.D0)    !  p_1   d_1   -  f_2
       CC(2,3,3,5,4)= DSQRT(45.D0/35.D0)    !  p_1   d_2   -  f_3
 
       CC(3,1,3,1,5)= DSQRT(70.D0/49.D0)    !  d_-2  d_-2  -  g_-4
       CC(3,1,3,2,5)= DSQRT(35.D0/49.D0)    !  d_-2  d_-1  -  g_-3
       CC(3,1,3,3,3)=-DSQRT(20.D0/49.D0)    !  d_-2  d_0   -  d_-2
       CC(3,1,3,3,5)= DSQRT(15.D0/49.D0)    !  d_-2  d_0   -  g_-2
       CC(3,1,3,4,3)=-DSQRT(30.D0/49.D0)    !  d_-2  d_1   -  d_1
       CC(3,1,3,4,5)= DSQRT( 5.D0/49.D0)    !  d_-2  d_1   -  g_1
       CC(3,1,3,5,1)= 1.D0              !  d_-2  d_2   -  s
       CC(3,1,3,5,3)=-DSQRT(20.D0/49.D0)    !  d_-2  d_2   -  d_0
       CC(3,1,3,5,5)= DSQRT( 1.D0/49.D0)    !  d_-2  d_2   -  g_0
 
       CC(3,2,3,2,3)= DSQRT(30.D0/49.D0)    !  d_-1  d_-1  -  d_-2
       CC(3,2,3,2,5)= DSQRT(40.D0/49.D0)    !  d_-1  d_-1  -  g_-2
       CC(3,2,3,3,3)= DSQRT( 5.D0/49.D0)    !  d_-1  d_0   -  d_-1
       CC(3,2,3,3,5)= DSQRT(30.D0/49.D0)    !  d_-1  d_0   -  g_-1
       CC(3,2,3,4,1)=-1.D0               !  d_-1  d_1   -  s
       CC(3,2,3,4,3)=-DSQRT( 5.D0/49.D0)    !  d_-1  d_1   -  d_0
       CC(3,2,3,4,5)= DSQRT(16.D0/49.D0)    !  d_-1  d_1   -  g_0
       CC(3,2,3,5,3)=-DSQRT(30.D0/49.D0)    !  d_-1  d_2   -  d_1
       CC(3,2,3,5,5)= DSQRT( 5.D0/49.D0)    !  d_-1  d_2   -  g_1
 
       CC(3,3,3,3,1)= 1.D0               !  d_0   d_0   -  s
       CC(3,3,3,3,3)= DSQRT(20.D0/49.D0)    !  d_0   d_0   -  d_0
       CC(3,3,3,3,5)= DSQRT(36.D0/49.D0)    !  d_0   d_0   -  g_0
       CC(3,3,3,4,3)= DSQRT( 5.D0/49.D0)    !  d_0   d_1   -  d_1
       CC(3,3,3,4,5)= DSQRT(30.D0/49.D0)    !  d_0   d_1   -  g_1
       CC(3,3,3,5,3)=-DSQRT(20.D0/49.D0)    !  d_0   d_2   -  d_2
       CC(3,3,3,5,5)= DSQRT(15.D0/49.D0)    !  d_0   d_2   -  g_2
 
       CC(3,4,3,4,3)= DSQRT(30.D0/49.D0)    !  d_1   d_1   -  d_2
       CC(3,4,3,4,5)= DSQRT(40.D0/49.D0)    !  d_1   d_1   -  g_2
       CC(3,4,3,5,5)= DSQRT(35.D0/49.D0)    !  d_1   d_2   -  g_3
 
       CC(3,5,3,5,5)= DSQRT(70.D0/49.D0)    !  d_2   d_2   -  g_4
      ENDIF
!
      NONZ=0
      DO 10 L=1,LL
      DO 10 Li=1,LLi
      DO 10 Mi=1,2*Li-1      !  SYMMETRY   LiMi  <-> LjMj
        DO 20 Lj=1,Li-1
        DO 20 Mj=1,2*Lj-1
20         CC(Li,Mi,Lj,Mj,L)=CC(Lj,Mj,Li,Mi,L)
        DO 30 Mj=1,Mi-1
30         CC(Li,Mi,Li,Mj,L)=CC(Li,Mj,Li,Mi,L)      ! Li = Lj
10    CONTINUE
!TEST
!      DO 110 I=1,Lli*MiX*Lli*MiX*LX
!        CC(I,1,1,1,1)=DSQRT(1.D0/FPI)*CC(I,1,1,1,1)
      call dscal(Lli*MiX*Lli*MiX*LX,DSQRT(1.D0/FPI),CC(1,1,1,1,1),1)
 110  CONTINUE
!
!     TRANSFORM BETWEEN REAL SPHERICAL HARMONICS AND THE ORIGINAL ONES
!                (  Y^R_lm = Sum_n U(l,m,n) Y_ln )
!
!          U(l,m,n)  see  Weissbluth  pages 128 - 130
!          errors of Weissbluth have been corrected:
!          1.)   i/2 has been changed to i/4 for u(4,6,*)
!          2.)  -i/4 has been changed to i/4 for u(5,8,*)

!TEST
!      DO 2 I=1,LX*MX*MX
! 2      U(I,1,1)=DCMPLX(0.D0,0.D0)
      call setv(2*LX*MX*MX,0.D0,U(1,1,1),1)
      U(1,1,1)=DCMPLX(1.D0,0.D0)           ! L = 0
 
      IF(LLI.GT.1) THEN
       Y=1.D0/DSQRT(2.D0)
       U(2,1,1)=DCMPLX(Y,0.D0)        ! L = 1    ORDERING   X   Y   Z
       U(2,1,3)=DCMPLX(-Y,0.D0)       !              M     -1   0   1
       U(2,3,2)=DCMPLX(1.D0,0.D0)     !              M      1   2   3
       U(2,2,1)=DCMPLX(0.D0,Y)
       U(2,2,3)=DCMPLX(0.D0,Y)
 
       U(3,1,1)=DCMPLX(0.D0,Y)        ! L = 2
       U(3,1,5)=DCMPLX(0.D0,-Y)       ! ORDERING  XY   XZ  Z^2  YZ  X^2-Y^2
       U(3,2,2)=DCMPLX(Y,0.D0)        !    M      -2   -1   0    1     2
       U(3,2,4)=DCMPLX(-Y,0.D0)       !    M       1    2   3    4     5
       U(3,3,3)=DCMPLX(1.D0,0.D0)
       U(3,4,2)=DCMPLX(0.D0,Y)
       U(3,4,4)=DCMPLX(0.D0,Y)
       U(3,5,1)=DCMPLX(Y,0.D0)
       U(3,5,5)=DCMPLX(Y,0.D0)
      ENDIF
 
      IF(LLI.GT.2) THEN
       F=DSQRT(5.D0)/4.D0
       T=DSQRT(3.D0)/4.D0
       U(4,1,1)=DCMPLX(F,0.D0)      ! L = 3
       U(4,1,3)=DCMPLX(-T,0.D0)     ! ORDER
       U(4,1,5)=DCMPLX(T,0.D0)      ! X  Y  XYZ  Z  Z(X^2-Y^2) Y(Z^2-X^2) X(Y^2-Z^2)
       U(4,1,7)=DCMPLX(-F,0.D0)     ! 1  2   3   4       5          6          7
       U(4,2,1)=DCMPLX(0.D0,-F)
       U(4,2,3)=DCMPLX(0.D0,-T)
       U(4,2,5)=DCMPLX(0.D0,-T)
       U(4,2,7)=DCMPLX(0.D0,-F)
       U(4,3,2)=DCMPLX(0.D0, Y)
       U(4,3,6)=DCMPLX(0.D0,-Y)
       U(4,4,4)=DCMPLX(1.D0,0.D0)
       U(4,5,2)=DCMPLX(Y,0.D0)
       U(4,5,6)=DCMPLX(Y,0.D0)
       U(4,6,1)=DCMPLX(0.D0,-T)     !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(4,6,3)=DCMPLX(0.D0, F)     !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(4,6,5)=DCMPLX(0.D0, F)     !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(4,6,7)=DCMPLX(0.D0,-T)     !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(4,7,1)=DCMPLX(-T,0.D0)
       U(4,7,3)=DCMPLX(-F,0.D0)
       U(4,7,5)=DCMPLX( F,0.D0)
       U(4,7,7)=DCMPLX( T,0.D0)
 
       S  =DSQRT( 7.D0 )/4.0D0
       FS =DSQRT( 5.D0/6.D0)/2.0D0
       SS =DSQRT( 7.D0/6.D0)/2.0D0
       FTS=DSQRT(14.D0/6.D0)/2.0D0
       TS =DSQRT(10.D0/6.D0)/2.0D0
       U(5,1,1)=DCMPLX(FS,0.D0)       ! L = 4
       U(5,1,5)=DCMPLX(FTS,0.D0)
       U(5,1,9)=DCMPLX(FS,0.D0)
       U(5,2,2)=DCMPLX(0.D0,-0.25D0)
       U(5,2,4)=DCMPLX(0.D0,-S)
       U(5,2,6)=DCMPLX(0.D0,-S)
       U(5,2,8)=DCMPLX(0.D0,-0.25D0)
       U(5,3,2)=DCMPLX(-0.25D0,0.D0)
       U(5,3,4)=DCMPLX( S,0.D0)
       U(5,3,6)=DCMPLX(-S,0.D0)
       U(5,3,8)=DCMPLX( 0.25D0,0.D0)
       U(5,4,3)=DCMPLX(-Y,0.D0)
       U(5,4,7)=DCMPLX(-Y,0.D0)
       U(5,5,1)=DCMPLX(0.D0, Y)
       U(5,5,9)=DCMPLX(0.D0,-Y)
       U(5,6,3)=DCMPLX(0.D0, Y)
       U(5,6,7)=DCMPLX(0.D0,-Y)
       U(5,7,2)=DCMPLX(-S,0.D0)
       U(5,7,4)=DCMPLX(-0.25D0,0.D0)
       U(5,7,6)=DCMPLX( 0.25D0,0.D0)
       U(5,7,8)=DCMPLX( S,0.D0)
       U(5,8,2)=DCMPLX(0.D0, S)      !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(5,8,4)=DCMPLX(0.D0,-0.25D0) !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(5,8,6)=DCMPLX(0.D0,-0.25D0) !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(5,8,8)=DCMPLX(0.D0, S)      !    MISSPRINT IN WEISSBLUTH  (PAGE 129)
       U(5,9,1)=DCMPLX(-SS,0.D0)
       U(5,9,5)=DCMPLX( TS,0.D0)
       U(5,9,9)=DCMPLX(-SS,0.D0)
      ENDIF
 
!TEST
!      DO 3 I=1,LLI*MIX*LLI*MIX*LX*MX
! 3      AA(I,1,1,1,1,1)=DCMPLX(0.D0,0.D0)
      call setv(2*LLI*MIX*LLI*MIX*LX*MX,0.D0,AA(1,1,1,1,1,1),1)
      NONZ=0
      DO 120 LP=1,LL
      DO 120 L=1,LLI
      DO 120 M=1,(2*L-1)
      DO 120 K=1,LLI
      DO 120 N=1,(2*K-1)
        DO 120 NP=1,(2*K-1)
        DO 120 P=1,(2*L-1)
          MP=(P-L)+(NP-K)+LP                       !  M' = P + N'
          IF((MP.GE.1).AND.(MP.LE.(2*LP-1))) THEN
            AA(LP,MP,L,M,K,N)=AA(LP,MP,L,M,K,N)+&
                          U(L,M,P)*U(K,N,NP)*CC(L,P,K,NP,LP)
          ENDIF
120   CONTINUE
!
      DO 4 IK=1,NLX
      DO 4 IL=1,NLX
        DO 14 II=1,MX
14        LPL(IL,IK,II)=0
4       LPX(IL,IK)=0
      NONZ=0
      DO 130 LP=1,LL
      DO 130 MP=1,(2*LP-1)
      DO 130 L=1,LLI
      DO 130 M=1,(2*L-1)        ! DON'T PANIC
      DO 130 K=1,LLI
      DO 130 N=1,(2*K-1)
        SUM=DCMPLX(0.D0,0.D0)
        DO 125 MPP=1,(2*LP-1)
          SUM = SUM + CONJG(U(LP,MP,MPP))*AA(LP,MPP,L,M,K,N)
125     CONTINUE
        IF(ABS(SUM).GT.0.001) THEN
          IL =(L-1)*(L-1)+M
          IK =(K-1)*(K-1)+N
          ILP=(LP-1)*(LP-1)+MP
          IF(ABS(DIMAG(SUM)).GT.0.001) THEN
            WRITE(*,'(A,2F8.5,1X,3I3,2X,I3)')&
              ' !!!  ERROR  !!!   AP(ILP,IL,IK) =  ',SUM,ILP,IL,IK
            STOP
          ENDIF
          AP(ILP,IL,IK)=dble(SUM)
          LPX(IL,IK)=LPX(IL,IK)+1
          LPL(IL,IK,LPX(IL,IK))=ILP
        ENDIF
130   CONTINUE

      RETURN
      END
!
!-----------------------------------------------------------------------
      SUBROUTINE YLMR2(LMAX,NG1,NGY,ngxm,gx,g,ngyx,nanx,ylm)
!-----------------------------------------------------------------------
!     REAL SPHERICAL HARMONICS,  L IS COMBINED INDEX FOR LM (L=1,2...25)
!     ORDER:  S, P_X, P_Y, P_Z, D_XY, D_XZ, D_Z^2, D_YZ, D_X^2-Y^2  ....
!     THE REAL SPHERICAL HARMONICS USED HERE FORM BASES FOR THE
!     IRRIDUCBLE REPRESENTATIONS OF THE GROUP O
!
!     SEE WIESSBLUTH 'ATOMS AND MOLECULES' PAGES 128-130
!     ERRORS IN WEISSBLUTH HAVE BEEN CORRECTED:
!        1.) ELIMINATION OF THE 7'S FROM L=20
!        2.) ADDITION OF THE FACTOR 1./SQRT(12.) TO L=25
!
      IMPLICIT REAL*8 (A-H,O-Z)
      dimension  YLM(NGYX,NANX),GX(NGXM,3), G(NGXM)
      integer NG1,I0,I1
      PI=4.D0*DATAN(1.D0)
      FPI=4.D0*PI
      eps=1e-9

!     Only make ylm for G from I1+1 -> NGY 
     
      I1 = NG1 
      I0 = I1 
! in the parallel program G(1) != 0
      if ((G(1) .lt. eps).and.(I1.eq.0)) I1=1
!
!   NOTE :   Y_LM (G=0) = SQRT(FPI)  WHEN L=0  AND  = 0  WHEN L>0
!
      DO L=1,LMAX
      IF (L.EQ.1) THEN
        C=SQRT(1./FPI)
        YLM(1,L) = C
        DO 101 IG=I1+1,NGY
 101      YLM(IG-I0,L) = C
      ELSE IF (L.EQ.2) THEN
        C=SQRT(3./FPI)
        YLM(1,L)=0.
        DO 102 IG=I1+1,NGY
 102      YLM(IG-I0,L) = C*GX(IG,1)/SQRT(G(IG))   !   X
      ELSE IF (L.EQ.3) THEN
        C=SQRT(3./FPI)
        YLM(1,L)=0.
        DO 103 IG=I1+1,NGY
 103      YLM(IG-I0,L) = C*GX(IG,2)/SQRT(G(IG))   !   Y
      ELSE IF (L.EQ.4) THEN
        C=SQRT(3./FPI)
        YLM(1,L)=0.
        DO 104 IG=I1+1,NGY
 104      YLM(IG-I0,L) = C*GX(IG,3)/SQRT(G(IG))   !   Z
      ELSE IF (L.EQ.5) THEN
        C=SQRT(15./FPI)
        YLM(1,L)=0.
        DO 105 IG=I1+1,NGY
 105      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,2)/G(IG)   !  X*Y
      ELSE IF (L.EQ.6) THEN
        C=SQRT(15./FPI)
        YLM(1,L)=0.
        DO 106 IG=I1+1,NGY
 106      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,3)/G(IG)   !  X*Z
      ELSE IF (L.EQ.7) THEN
        C=SQRT(5.0/FPI/4.0)
        YLM(1,L)=0.
        DO 107 IG=I1+1,NGY
 107      YLM(IG-I0,L) = C*(3.*GX(IG,3)**2/G(IG)-1.)  ! (3.*Z*Z-1.0)
      ELSE IF (L.EQ.8) THEN
        C=SQRT(15./FPI)
        YLM(1,L)=0.
        DO 108 IG=I1+1,NGY
 108      YLM(IG-I0,L) = C*GX(IG,2)*GX(IG,3)/G(IG)   !  Y*Z
      ELSE IF (L.EQ.9) THEN
        C=SQRT(15./FPI/4.)
        YLM(1,L)=0.
        DO 109 IG=I1+1,NGY
 109      YLM(IG-I0,L) = C*(GX(IG,1)**2-GX(IG,2)**2)/G(IG)  ! X*X-Y*Y
      ELSE IF (L.EQ.10) THEN
        C=SQRT(7./FPI)*5./2.
        YLM(1,L)=0.
        DO 110 IG=I1+1,NGY
 110      YLM(IG-I0,L) = C*GX(IG,1)*(GX(IG,1)**2-0.6*G(IG))/&
                    (G(IG)*SQRT(G(IG)))                ! X(X^2-3R^2/5)
      ELSE IF (L.EQ.11) THEN
        C=SQRT(7./FPI)*5./2.
        YLM(1,L)=0.
        DO 111 IG=I1+1,NGY                                ! Y(Y^2-3R^2/5)
 111      YLM(IG-I0,L) = C*GX(IG,2)*(GX(IG,2)**2-0.6*G(IG))/&
                    (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.12) THEN
        C=SQRT(7.*15./FPI)
        YLM(1,L)=0.
        DO 112 IG=I1+1,NGY                                !  XYZ
 112      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,2)*GX(IG,3)/&
                         (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.13) THEN
        C=SQRT(7./FPI)*5./2.
        YLM(1,L)=0.
        DO 113 IG=I1+1,NGY                                ! Z(Z^2-.6R^2)
 113      YLM(IG-I0,L) = C*GX(IG,3)*(GX(IG,3)**2-0.6*G(IG))/&
                    (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.14) THEN
        C=SQRT(7.*15./FPI)/2.
        YLM(1,L)=0.
        DO 114 IG=I1+1,NGY                                ! Z(X^2-Y^2)
 114      YLM(IG-I0,L) = C*GX(IG,3)*(GX(IG,1)**2-GX(IG,2)**2)/&
                    (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.15) THEN
        C=SQRT(7.*15./FPI)/2.
        YLM(1,L)=0.
        DO 115 IG=I1+1,NGY                                ! Y(Z^2-X^2)
 115      YLM(IG-I0,L) = C*GX(IG,2)*(GX(IG,3)**2-GX(IG,1)**2)/&
                    (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.16) THEN
        C=SQRT(7.*15./FPI)/2.
        YLM(1,L)=0.
        DO 116 IG=I1+1,NGY                                ! X(Y^2-Z^2)
 116      YLM(IG-I0,L) = C*GX(IG,1)*(GX(IG,2)**2-GX(IG,3)**2)/&
                    (G(IG)*SQRT(G(IG)))
      ELSE IF (L.EQ.17) THEN
        C=SQRT(3.*7./FPI)*5./4.
        YLM(1,L)=0.
        DO 117 IG=I1+1,NGY                                ! A1
 117      YLM(IG-I0,L) = C*((GX(IG,1)**4+GX(IG,2)**4+GX(IG,3)**4)/&
                    (G(IG)*G(IG))-0.6)
      ELSE IF (L.EQ.18) THEN
        C=SQRT(9.*35./FPI)/2.
        YLM(1,L)=0.
        DO 118 IG=I1+1,NGY                                ! YZ(Y^2-Z^2)
 118      YLM(IG-I0,L) = C*GX(IG,2)*GX(IG,3)*(GX(IG,2)**2-GX(IG,3)**2)/&
                    (G(IG)*G(IG))
      ELSE IF (L.EQ.19) THEN
        C=SQRT(9.*35./FPI)/2.
        YLM(1,L)=0.
        DO 119 IG=I1+1,NGY                                ! ZX(Z^2-X^2)
 119      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,3)*(GX(IG,3)**2-GX(IG,1)**2)/&
                    (G(IG)*G(IG))
      ELSE IF (L.EQ.20) THEN
        C=SQRT(9.*5./FPI)/4.
        YLM(1,L)=0.
        DO 120 IG=I1+1,NGY                                ! E\EPSILON
 120      YLM(IG-I0,L) = C*((GX(IG,1)**4-GX(IG,2)**4)-&
            6.*GX(IG,3)**2*(GX(IG,1)**2-GX(IG,2)**2))/(G(IG)*G(IG))
      ELSE IF (L.EQ.21) THEN
        C=SQRT(9.*35./FPI)/2.
        YLM(1,L)=0.
        DO 121 IG=I1+1,NGY                                ! XY(X^2-Y^2)
 121      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,2)*(GX(IG,1)**2-GX(IG,2)**2)/&
                    (G(IG)*G(IG))
      ELSE IF (L.EQ.22) THEN
        C=SQRT(9.*5./FPI)*7./2.
        YLM(1,L)=0.
        DO 122 IG=I1+1,NGY                                ! XY(Z^2-1/7*R^2)
 122      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,2)*(GX(IG,3)**2-G(IG)/7.)/&
                    (G(IG)*G(IG))
      ELSE IF (L.EQ.23) THEN
        C=SQRT(9.*5./FPI)*7./2.
        YLM(1,L)=0.
        DO 123 IG=I1+1,NGY                                ! ZX(Y^2-1/7*R^2)
 123      YLM(IG-I0,L) = C*GX(IG,1)*GX(IG,3)*(GX(IG,2)**2-G(IG)/7.)/&
                    (G(IG)*G(IG))
      ELSE IF (L.EQ.24) THEN
        C=SQRT(9.*5./FPI)*7./2.
        YLM(1,L)=0.
        DO 124 IG=I1+1,NGY                                ! YZ(X^2-1/7*R^2)
          YLM(IG-I0,L) = C*GX(IG,2)*GX(IG,3)*(GX(IG,1)**2-G(IG)/7.)/&
                    (G(IG)*G(IG))
124     CONTINUE
      ELSE IF (L.EQ.25) THEN
        C=SQRT(9.*5./FPI/3.)*7./2.
        YLM(1,L)=0.
        DO 125 IG=I1+1,NGY                                ! E\THETA
          YLM(IG-I0,L) = C*( GX(IG,3)**4-0.5*(GX(IG,1)**4+GX(IG,2)**4)-&
          6./7.*G(IG)*(GX(IG,3)**2-0.5*(GX(IG,1)**2+GX(IG,2)**2) ))&
            /( G(IG)*G(IG) )
125     CONTINUE
      ELSE IF (L.GE.26) THEN
        CALL REPORT_ERROR(' YLMR2',' HIGHER L NOT PROGRAMMED  L=',L)
      END IF

      END DO

      RETURN
      END




                       
!-----------------------------------------------------------------------
      SUBROUTINE YLMG(LMAX,gx,g,nanx,ylm)
!-----------------------------------------------------------------------
!     REAL SPHERICAL HARMONICS.   
!     Calculate spherical harmonics for the reciprocal lattice vector 
!     (Gx,Gy,Gz). (gx = (Gx,Gy,Gz) and g = |G|) 
! 
!     L IS COMBINED INDEX FOR LM (L=1,2...25)
!     ORDER:  S, P_X, P_Y, P_Z, D_XY, D_XZ, D_Z^2, D_YZ, D_X^2-Y^2  ....
!     THE REAL SPHERICAL HARMONICS USED HERE FORM BASES FOR THE
!     IRRIDUCBLE REPRESENTATIONS OF THE GROUP O
!
!     SEE WIESSBLUTH 'ATOMS AND MOLECULES' PAGES 128-130
!     ERRORS IN WEISSBLUTH HAVE BEEN CORRECTED:
!        1.) ELIMINATION OF THE 7'S FROM L=20
!        2.) ADDITION OF THE FACTOR 1./SQRT(12.) TO L=25
!
      IMPLICIT REAL*8 (A-H,O-Z)
      dimension  YLM(NANX),GX(3)
      integer i1
      PI=4.D0*DATAN(1.D0)
      FPI=4.D0*PI
      eps=1e-9
!
!   NOTE :   Y_LM (G=0) = SQRT(FPI)  WHEN L=0  AND  = 0  WHEN L>0
!
      DO L=1,LMAX

      if (G.lt.eps) then 
!       G = 0 
        if (L.eq.1) then 
            C=SQRT(1./FPI)
            YLM(L) = C 
        else 
            YLM(L) = 0.0d0
        endif
      else 
!       G > 0 
        IF (L.EQ.1) THEN
          C=SQRT(1./FPI)
          YLM(L) = C
        ELSE IF (L.EQ.2) THEN
          C=SQRT(3./FPI)
          YLM(L) = C*GX(1)/SQRT(G)   !   X
        ELSE IF (L.EQ.3) THEN
          C=SQRT(3./FPI)
          YLM(L) = C*GX(2)/SQRT(G)   !   Y
        ELSE IF (L.EQ.4) THEN
          C=SQRT(3./FPI)
          YLM(L) = C*GX(3)/SQRT(G)   !   Z
        ELSE IF (L.EQ.5) THEN
          C=SQRT(15./FPI)
          YLM(L) = C*GX(1)*GX(2)/G   !  X*Y
        ELSE IF (L.EQ.6) THEN
          C=SQRT(15./FPI)
          YLM(L) = C*GX(1)*GX(3)/G   !  X*Z
        ELSE IF (L.EQ.7) THEN
          C=SQRT(5.0/FPI/4.0)
          YLM(L) = C*(3.*GX(3)**2/G-1.)  ! (3.*Z*Z-1.0)
        ELSE IF (L.EQ.8) THEN
          C=SQRT(15./FPI)
          YLM(L) = C*GX(2)*GX(3)/G   !  Y*Z
        ELSE IF (L.EQ.9) THEN
          C=SQRT(15./FPI/4.)
          YLM(L) = C*(GX(1)**2-GX(2)**2)/G  ! X*X-Y*Y
        ELSE IF (L.EQ.10) THEN
          C=SQRT(7./FPI)*5./2.
         YLM(L) = C*GX(1)*(GX(1)**2-0.6*G)/&
                    (G*SQRT(G))                ! X(X^2-3R^2/5)
        ELSE IF (L.EQ.11) THEN
          C=SQRT(7./FPI)*5./2.
          YLM(L) = C*GX(2)*(GX(2)**2-0.6*G)/&
                    (G*SQRT(G))
        ELSE IF (L.EQ.12) THEN
          C=SQRT(7.*15./FPI)
          YLM(L) = C*GX(1)*GX(2)*GX(3)/(G*SQRT(G))
        ELSE IF (L.EQ.13) THEN
          C=SQRT(7./FPI)*5./2.
          YLM(L) = C*GX(3)*(GX(3)**2-0.6*G)/&
                    (G*SQRT(G))
        ELSE IF (L.EQ.14) THEN
          C=SQRT(7.*15./FPI)/2.
          YLM(L) = C*GX(3)*(GX(1)**2-GX(2)**2)/&
                    (G*SQRT(G))
        ELSE IF (L.EQ.15) THEN
          C=SQRT(7.*15./FPI)/2.
          YLM(L) = C*GX(2)*(GX(3)**2-GX(1)**2)/&
                    (G*SQRT(G))
        ELSE IF (L.EQ.16) THEN
          C=SQRT(7.*15./FPI)/2.
          YLM(L) = C*GX(1)*(GX(2)**2-GX(3)**2)/&
                    (G*SQRT(G))
        ELSE IF (L.EQ.17) THEN
          C=SQRT(3.*7./FPI)*5./4.
          YLM(L) = C*((GX(1)**4+GX(2)**4+GX(3)**4)/&
                    (G*G)-0.6)
        ELSE IF (L.EQ.18) THEN
          C=SQRT(9.*35./FPI)/2.
          YLM(L) = C*GX(2)*GX(3)*(GX(2)**2-GX(3)**2)/&
                    (G*G)
        ELSE IF (L.EQ.19) THEN
          C=SQRT(9.*35./FPI)/2.
          YLM(L) = C*GX(1)*GX(3)*(GX(3)**2-GX(1)**2)/&
                    (G*G)
        ELSE IF (L.EQ.20) THEN
          C=SQRT(9.*5./FPI)/4.
          YLM(L) = C*((GX(1)**4-GX(2)**4)-&
            6.*GX(3)**2*(GX(1)**2-GX(2)**2))/(G*G)
        ELSE IF (L.EQ.21) THEN
          C=SQRT(9.*35./FPI)/2.
          YLM(L) = C*GX(1)*GX(2)*(GX(1)**2-GX(2)**2)/&
                    (G*G)
        ELSE IF (L.EQ.22) THEN
          C=SQRT(9.*5./FPI)*7./2.
          YLM(L) = C*GX(1)*GX(2)*(GX(3)**2-G/7.)/&
                    (G*G)
        ELSE IF (L.EQ.23) THEN
          C=SQRT(9.*5./FPI)*7./2.
          YLM(L) = C*GX(1)*GX(3)*(GX(2)**2-G/7.)/&
                    (G*G)
        ELSE IF (L.EQ.24) THEN
          C=SQRT(9.*5./FPI)*7./2.
          YLM(L) = C*GX(2)*GX(3)*(GX(1)**2-G/7.)/&
                    (G*G)
        ELSE IF (L.EQ.25) THEN
          C=SQRT(9.*5./FPI/3.)*7./2.
          YLM(L) = C*( GX(3)**4-0.5*(GX(1)**4+GX(2)**4)-&
          6./7.*G*(GX(3)**2-0.5*(GX(1)**2+GX(2)**2) ))&
            /( G*G )
        ELSE IF (L.GE.26) THEN
          CALL REPORT_ERROR(' YLM',' HIGHER L NOT PROGRAMMED  L=',L)
        END IF

      endif   ! G > 0 

      END DO

      RETURN
      END


!
!-----------------------------------------------------------------------
      SUBROUTINE DYLMR2(LMAX,NG1,NGY,ngxm,gx,g,ngyx,nanx,dylm,gagk,ialpha,ibeta)
!-----------------------------------------------------------------------
!     REAL SPHERICAL HARMONICS,  L IS COMBINED INDEX FOR LM  (L=1,2...9)
!     ORDER:  S, P_X, P_Y, P_Z, D_XY, D_XZ, D_Z^2, D_YZ, D_X^2-Y^2
!     when making the derivatives use that
!     dG_c/dE_ab = -delta(a,c)*G_b
!     d|G|^(-n) = n * gagk * |G|^-n
      IMPLICIT NONE
!     IMPLICIT REAL*8 (A-H,O-Z)
      integer LMAX,NGY,ngyx,nanx,ngxm
      real*8  DYLM(NGYX,NANX),GX(NGXM,3), G(NGXM),gagk(ngyx),C
      INTEGER   iALPHA,iBETA,i1,IG,L,NG1,I0
      real*8 delta(3,3),pi,fpi,eps

      PI=4.D0*DATAN(1.D0)
      FPI=4.D0*PI
       eps=1e-9

!     Only make dylm for G from I1+1 -> NGY

      I1 = NG1
      I0 = I1
! in the parallel program G(1) != 0
      if ((G(1) .lt. eps).and.(I1.eq.0)) I1=1              

!=======================================================================
      delta(1:3,1:3) = 0.0d0 
      delta(1,1) = 1.0d0
      delta(2,2) = 1.0d0
      delta(3,3) = 1.0d0
!=======================================================================

      DO L=1,LMAX
         DYLM(1,L) = 0.D0
      IF (L.EQ.1) THEN
         do ig = I1+1,ngy
            DYLM(IG-I0,L) = 0.D0
         enddo
      ELSE IF (L.EQ.2) THEN
        C=SQRT(3./FPI)
        DO 102 IG=I1+1,NGY
 102      DYLM(IG-I0,L) = C/SQRT(G(IG))*(gagk(ig-I0)*         &  !   X
           GX(IG,1)-delta(ialpha,1)*GX(ig,ibeta))   
      ELSE IF (L.EQ.3) THEN
        C=SQRT(3./FPI)
        DO 103 IG=I1+1,NGY
 103      DYLM(IG-I0,L) = C/SQRT(G(IG))*(gagk(ig-I0)*         &  !   Y
                GX(IG,2)-delta(ialpha,2)*GX(ig,ibeta))   
      ELSE IF (L.EQ.4) THEN
        C=SQRT(3./FPI)
        DO 104 IG=I1+1,NGY
 104      DYLM(IG-I0,L) = C/SQRT(G(IG))*(gagk(ig-I0)*         &  !   Z
                GX(IG,3)-delta(ialpha,3)*GX(ig,ibeta))   
      ELSE IF (L.EQ.5) THEN
        C=SQRT(15./FPI)
        DO 105 IG=I1+1,NGY
 105      DYLM(IG-I0,L) = C/G(IG)*(2.*gagk(ig-I0)*            &   !  X*Y
                GX(IG,1)*GX(IG,2) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,2) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,1))
      ELSE IF (L.EQ.6) THEN
        C=SQRT(15./FPI)
        DO 106 IG=I1+1,NGY
 106       DYLM(IG-I0,L) = C/G(IG)*(2.*gagk(ig-I0)*            &   !  X*Z
                GX(IG,1)*GX(IG,3) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,3) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,1))  
      ELSE IF (L.EQ.7) THEN
        C=SQRT(5.0/FPI/4.0)
        DO 107 IG=I1+1,NGY
 107      DYLM(IG-I0,L) = C*3./G(IG)*(2.*gagk(ig-I0)*          &  ! (3.*Z*Z-1.0)
                GX(IG,3)**2 &
                -delta(ialpha,3)*GX(ig,ibeta)*2.*GX(IG,3))
      ELSE IF (L.EQ.8) THEN
        C=SQRT(15./FPI)
        DO 108 IG=I1+1,NGY
 108       DYLM(IG-I0,L) = C/G(IG)*(2.*gagk(ig-I0)*             & !  Y*Z
                GX(IG,2)*GX(IG,3) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,3) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,2))
      ELSE IF (L.EQ.9) THEN
        C=SQRT(15./FPI/4.)
        DO 109 IG=I1+1,NGY
 109      DYLM(IG-I0,L) = C/G(IG)*(2.*gagk(ig-I0)*           &   ! X*X-Y*Y
            (    GX(IG,1)**2-GX(IG,2)**2 ) &
                -delta(ialpha,1)*GX(ig,ibeta)*2.*GX(IG,1) &
                +delta(ialpha,2)*GX(ig,ibeta)*2.*GX(IG,2))
      ELSE IF (L.EQ.10) THEN
        C=SQRT(7./FPI)*5./2.
        DO 110 IG=I1+1,NGY
 110      DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)*   &! X(X^2-3R^2/5)
                GX(IG,1)*(GX(IG,1)**2-0.6*G(IG)) &
                -delta(ialpha,1)*GX(ig,ibeta)* &
                (3.*GX(IG,1)**2-0.6*G(IG)) &
                +0.6*gagk(ig-I0)*2.*G(IG)*GX(IG,1))

      ELSE IF (L.EQ.11) THEN
        C=SQRT(7./FPI)*5./2.
        DO 111 IG=I1+1,NGY                                ! Y(Y^2-3R^2/5)
 111       DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,2)*(GX(IG,2)**2-0.6*G(IG)) &
                -delta(ialpha,2)*GX(ig,ibeta)* &
                (3.*GX(IG,2)**2-0.6*G(IG)) &
                +0.6*gagk(ig-I0)*2.*G(IG)*GX(IG,2))
      ELSE IF (L.EQ.12) THEN
        C=SQRT(7.*15./FPI)
        DO 112 IG=I1+1,NGY                                !  XYZ
 112      DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,1)*GX(IG,2)*GX(IG,3) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,2)*GX(IG,3) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,1)*GX(IG,3) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,1)*GX(IG,2))
      ELSE IF (L.EQ.13) THEN
        C=SQRT(7./FPI)*5./2.
        DO 113 IG=I1+1,NGY                                ! Z(Z^2-.6R^2)
 113       DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,3)*(GX(IG,3)**2-0.6*G(IG)) &
                -delta(ialpha,3)*GX(ig,ibeta)* &
                (3.*GX(IG,3)**2-0.6*G(IG)) &
                +0.6*gagk(ig-I0)*2.*G(IG)*GX(IG,3))

      ELSE IF (L.EQ.14) THEN
        C=SQRT(7.*15./FPI)/2.
        DO 114 IG=I1+1,NGY                                ! Z(X^2-Y^2)
 114      DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,3)*(GX(IG,1)**2-GX(IG,2)**2) &
                -delta(ialpha,1)*GX(ig,ibeta)*2.*GX(IG,1)*GX(IG,3) &
                +delta(ialpha,2)*GX(ig,ibeta)*2.*GX(IG,2)*GX(IG,3) &
                -delta(ialpha,3)*GX(ig,ibeta)*(GX(IG,1)**2-GX(IG,2)**2))
      ELSE IF (L.EQ.15) THEN
        C=SQRT(7.*15./FPI)/2.
        DO 115 IG=I1+1,NGY                                ! Y(Z^2-X^2)
 115       DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,2)*(GX(IG,3)**2-GX(IG,1)**2) &
                +delta(ialpha,1)*GX(ig,ibeta)*2.*GX(IG,1)*GX(IG,2) &
                -delta(ialpha,3)*GX(ig,ibeta)*2.*GX(IG,3)*GX(IG,2) &
                -delta(ialpha,2)*GX(ig,ibeta)*(GX(IG,3)**2-GX(IG,1)**2))
      ELSE IF (L.EQ.16) THEN
        C=SQRT(7.*15./FPI)/2.
        DO 116 IG=I1+1,NGY                                ! X(Y^2-Z^2)
 116       DYLM(IG-I0,L) = C/(G(IG)*SQRT(G(IG)))*(3.*gagk(ig-I0)* &
                GX(IG,1)*(GX(IG,2)**2-GX(IG,3)**2) &
                -delta(ialpha,2)*GX(ig,ibeta)*2.*GX(IG,2)*GX(IG,1) &
                +delta(ialpha,3)*GX(ig,ibeta)*2.*GX(IG,3)*GX(IG,1) &
                -delta(ialpha,1)*GX(ig,ibeta)*(GX(IG,2)**2-GX(IG,3)**2))
      ELSE IF (L.EQ.17) THEN
        C=SQRT(3.*7./FPI)*5./4.
        DO 117 IG=I1+1,NGY                                ! A1
 117      DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                (GX(IG,1)**4+GX(IG,2)**4+GX(IG,3)**4) &
                -GX(ig,ibeta)*4.*GX(ig,ialpha)**3)
      ELSE IF (L.EQ.18) THEN
        C=SQRT(9.*35./FPI)/2.
        DO 118 IG=I1+1,NGY                                ! YZ(Y^2-Z^2)
 118      DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,2)*GX(IG,3)*(GX(IG,2)**2-GX(IG,3)**2) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,3)* &
                (3.*GX(IG,2)**2-GX(IG,3)**2) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,2)* &
                (GX(IG,2)**2-3.*GX(IG,3)**2))
      ELSE IF (L.EQ.19) THEN
        C=SQRT(9.*35./FPI)/2.
        DO 119 IG=I1+1,NGY                                ! ZX(Z^2-X^2)
 119       DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,1)*GX(IG,3)*(GX(IG,3)**2-GX(IG,1)**2) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,3)* &
                (GX(IG,3)**2-3.*GX(IG,1)**2) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,1)* &
                (3.*GX(IG,3)**2-GX(IG,1)**2))
      ELSE IF (L.EQ.20) THEN
        C=SQRT(9.*5./FPI)/4.
        DO 120 IG=I1+1,NGY                             ! X^4-Y^4-6Z^2(X^2-Y^2)
 120      DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                (GX(IG,1)**4-GX(IG,2)**4- &
            6.*GX(IG,3)**2*(GX(IG,1)**2-GX(IG,2)**2)) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,1)* &
                (4.*GX(IG,1)**2-12.*GX(IG,3)**2) &
                +delta(ialpha,2)*GX(ig,ibeta)*GX(IG,2)* &
                (4.*GX(IG,2)**2-12.*GX(IG,3)**2) &
                +delta(ialpha,3)*GX(ig,ibeta)*12.*GX(IG,3)* &
                (GX(IG,1)**2-GX(IG,2)**2))
      ELSE IF (L.EQ.21) THEN
        C=SQRT(9.*35./FPI)/2.
        DO 121 IG=I1+1,NGY                                ! XY(X^2-Y^2)
 121       DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,1)*GX(IG,2)*(GX(IG,1)**2-GX(IG,2)**2) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,2)* &
                (3.*GX(IG,1)**2-GX(IG,2)**2) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,1)* &
                (GX(IG,1)**2-3.*GX(IG,2)**2))
      ELSE IF (L.EQ.22) THEN
        C=SQRT(9.*5./FPI)*7./2.
        DO 122 IG=I1+1,NGY                                ! XY(Z^2-1/7*R^2)
 122      DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,1)*GX(IG,2)*(GX(IG,3)**2-G(IG)/14.) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,2)* &
                (GX(IG,3)**2-G(IG)/7.) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,1)* &
                (GX(IG,3)**2-G(IG)/7.) &
                -delta(ialpha,3)*GX(ig,ibeta)*2.*GX(IG,3)* &
                GX(IG,1)*GX(IG,2))
      ELSE IF (L.EQ.23) THEN
        C=SQRT(9.*5./FPI)*7./2.
        DO 123 IG=I1+1,NGY                                ! ZX(Y^2-1/7*R^2)
 123       DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,1)*GX(IG,3)*(GX(IG,2)**2-G(IG)/14.) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,3)* &
                (GX(IG,2)**2-G(IG)/7.) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,1)* &
                (GX(IG,2)**2-G(IG)/7.) &
                -delta(ialpha,2)*GX(ig,ibeta)*2.*GX(IG,2)* &
                GX(IG,1)*GX(IG,3))
      ELSE IF (L.EQ.24) THEN
        C=SQRT(9.*5./FPI)*7./2.
        DO 124 IG=I1+1,NGY                                ! YZ(X^2-1/7*R^2)
 124       DYLM(IG-I0,L) = C/(G(IG)*G(IG))*(4.*gagk(ig-I0)* &
                GX(IG,3)*GX(IG,2)*(GX(IG,1)**2-G(IG)/14.) &
                -delta(ialpha,3)*GX(ig,ibeta)*GX(IG,2)* &
                (GX(IG,1)**2-G(IG)/7.) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,3)* &
                (GX(IG,1)**2-G(IG)/7.) &
                -delta(ialpha,1)*GX(ig,ibeta)*2.*GX(IG,1)* &
                GX(IG,3)*GX(IG,2))
      ELSE IF (L.EQ.25) THEN
        C=SQRT(9.*5./FPI/3.)*7./2.
        DO 125 IG=I1+1,NGY        ! Z^4-.5(X^4+Y^4)-6/7*R^2*(Z^2-0.5*(X^2+Y^2))
          DYLM(IG-I0,L) = C/( G(IG)*G(IG) )*(4.*gagk(ig-I0)* &
                (GX(IG,3)**4-0.5*(GX(IG,1)**4+GX(IG,2)**4)- &
                3./7.*G(IG)*(GX(IG,3)**2-0.5*(GX(IG,1)**2+GX(IG,2)**2))) &
                -delta(ialpha,1)*GX(ig,ibeta)*GX(IG,1)* &
                (6./7.*G(IG)-2*GX(IG,1)**2) &
                -delta(ialpha,2)*GX(ig,ibeta)*GX(IG,2)* &
                (6./7.*G(IG)-2*GX(IG,2)**2) &
                +delta(ialpha,3)*GX(ig,ibeta)*GX(IG,3)*2.* &
                (6./7.*G(IG)-2*GX(IG,3)**2))

125     CONTINUE
      ELSE IF (L.GE.26) THEN
        CALL REPORT_ERROR(' DYLMR2',' HIGHER L NOT PROGRAMMED  L=',L)
      END IF

      END DO

      RETURN
      END
