#include "definitions.h"

!    wfinop.F 
!    input/output of wavefunction and density. 
!    This file contains the following routines 
!
!       wfioid
!           version of this file
!       wfswap_get
!           get wf from swap-file
!       wfswap_put
!           write wf to swap-file
!       wfconv
!           conversion of wf file to another grid (presently not used)
!       write_wf
!           parallel write of wf
!       getwf_netcdf
!           get wf from netCDF input file
!       netcdf_write_wf
!           write wf to netCDF output file
!       density_put
!           write density to netCDF output file
!       density_get
!           read density from netCDF input file
!       netcdf_write_becp
!           becp variable (psi|becp> is written to NetCDF file        
!       netcdf_write_ensemble_energies
!           write 4 xc energies
!
!

! --------------------------------------------------------------------
! wfswap_get
! read the wavefunction from swap-file.
! ---------------------------------------------------------------------             
      subroutine wfswap_get(wf,ndcbyt,nkpeff,&
#include <apply_h_args.h>
                           )
      use van_us_data_module, only : nkbpmaxatom,nhm
      use run_context
      use non_local_projectors
      implicit none
      integer ndcbyt,nkpeff
#     include "apply_h_decl.h"  
      complex*WF_PRECISION wf(nrplwv,nbands,*)

!     locals 
      integer nuni,recl,j,rec,np,i,file_index
      real*8 h

      call geteff(nkp,nkpmem,nconso,nkpeff) 

      if (nkpmem.eq.number_kpoints_per_process) return

      file_index = int((nkp-1)/nkpmem)+1    
      file_index = int(mod(nkp-1,number_kpoints_per_process)) + 1

      nuni=31
      open(UNIT=nuni,file=wf_swap_filename,access='direct',&
             form='unformatted',recl=ndcbyt*nrplwv)
      do j=1,nbands
             read(nuni,rec=nbands*(file_index-1)+j)&
                    (wf(i,j,nkpeff),i=1,nrplwv)
      enddo           
      close(UNIT=nuni)

!     a swapfile is used for the projectors for the generalized pseudo-pot.
!     nrplwv_global is the leading dim. of skb,vkb (==nrplwv for serial
!     program).
!     (nhm=nkbpmaxatom*nspec)

#ifdef DEBUG
      write(nconso,*) 'Read swap vkb for k-point ',nkp
#endif

!     get vkb from the file vkb_swap
      open(UNIT=32,file=vkb_swap_filename,FORM='UNFORMATTED',&
              access='direct', recl=16*nrplwv)
      do np = 1,nspec
         do j = 1,nkbpmaxatom
           read(32,rec=(nhm+nions)*(file_index-1)+(np-1)*nkbpmaxatom+j)&
            (vkb(i,j,np,nkpeff),i=1,nrplwv)
         enddo
      enddo
      do j = 1,nions
           read(32,rec=(nhm+nions)*(file_index-1)+j+nhm)&
             (skb(i,j,nkpeff),i=1,nrplwv)
      enddo
      close(32)

      return 
      end

! --------------------------------------------------------------------
! wfswap_put
! write the wavefunction tp swap-file.
! ---------------------------------------------------------------------             
      subroutine wfswap_put(wf,nkp,nrplwv,nbands,nkpmem,nkprun,ndcbyt)
      use run_context
      implicit none

      integer nrplwv,nbands,nkpmem,nkprun
      complex*WF_PRECISION wf(nrplwv,nbands,*)
      integer nkp,ndcbyt

!     locals 
      integer i,j,nkpeff,rec,nuswap,file_index
      data nuswap/31/

      call geteff(nkp,nkpmem,nconso,nkpeff)  
      file_index = int((nkp-1)/nkpmem)+1    
      file_index = int(mod(nkp-1,number_kpoints_per_process)) + 1

      if (nkpmem.eq.number_kpoints_per_process) return

      open(UNIT=nuswap,file=wf_swap_filename,access='direct',&
              form='unformatted',recl=ndcbyt*nrplwv)
      do j=1,nbands
!           write(nconso,*) 'wfswap_put start ',nkp,j,file_index,nkpmem,nkpeff
!           call uflush(nconso)
            write(nuswap,rec=nbands*(file_index-1)+j)&
                     (wf(i,j,nkpeff),i=1,nrplwv)
!           write(nconso,*) 'wfswap_put end ',nkp,j,file_index,nkpmem,nkpeff
!           call uflush(nconso)
      enddo      
      close(UNIT=nuswap)

      return 
      end

!=======================================================================
      subroutine wfconv(ng1,ng2,ng3,ng1in,ng2in,ng3in,&
                        nplwv,nrplwv,npwkpi,nindin,npwkpo,nindou,&
                        nbands,cptwfp,cwork1)
!=======================================================================
! Conversion of the expansion coefficients from one array to another
! only intended to work when going from a small to a larger cutoff
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      complex*16 cwork1(nplwv)
      integer nindin(nrplwv)
      integer nindou(nrplwv)
!=======================================================================
! Reset an FFT grid-sized array
!=======================================================================
      do 1000 nn=1,nplwv
         cwork1(nn)=(0.0d0,0.0d0)
 1000 continue
!=======================================================================
! loop over the bands
!=======================================================================
      do 1600 nb=1,nbands
!=======================================================================
! Set the boundaries for the present FFT grid
!=======================================================================
         ng1max=ng1/2
         ng2max=ng2/2
         ng3max=ng3/2
         ng1min=-(ng1-1)/2
         ng2min=-(ng2-1)/2
         ng3min=-(ng3-1)/2
!=======================================================================
! Set the boundaries for the input FFT grid
!=======================================================================
         ng1imx=ng1in/2
         ng2imx=ng2in/2
         ng3imx=ng3in/2
!=======================================================================
! mm:     counts the index in the input FFT grid
! mmcold: counts the index in the input coefficient-list
!=======================================================================
         mm=1
         mmcold=1
!=======================================================================
! Loop over the input FFT grid-points
! let (n1,n2,n3) be the G1,G2,G3 index with signs
!=======================================================================
         do 1400 nloop3=0,ng3in-1
            n3=nloop3
            if (n3.gt.ng3imx) n3=n3-ng3in
            do 1300 nloop2=0,ng2in-1
               n2=nloop2
               if (n2.gt.ng2imx) n2=n2-ng2in
               do 1200 nloop1=0,ng1in-1
                  n1=nloop1
                  if (n1.gt.ng1imx) n1=n1-ng1in
!=======================================================================
! see if there is a coeffient in the input coefficient list for
! this mm'th input FFT grid point
!=======================================================================
                  if (mmcold.le.npwkpi.and.nindin(mmcold).eq.mm) then
!=======================================================================
! "Carry over" the coefficient if the G1,G2,G3 coordinates fall
! within the present/output reciprocal space FFT-grid
!=======================================================================
                     if (ng1min.le.n1.and.n1.le.ng1max.and.&
                         ng2min.le.n2.and.n2.le.ng2max.and.&
                         ng3min.le.n3.and.n3.le.ng3max) then
                        new1=n1
                        new2=n2
                        new3=n3
                        if (new1.lt.0) new1=new1+ng1
                        if (new2.lt.0) new2=new2+ng2
                        if (new3.lt.0) new3=new3+ng3
                        mmnew=(new3*ng2+new2)*ng1+new1+1
                        cwork1(mmnew)=cptwfp(mmcold,nb)
                     endif
                     mmcold=mmcold+1
                  endif
                  mm=mm+1
 1200          continue
 1300       continue
 1400    continue
!=======================================================================
! Take the coefficients within the cutoff
!=======================================================================
         do 1500 nn=1,npwkpo
            cptwfp(nn,nb)=cwork1(nindou(nn))
 1500    continue
 1600 continue
!=======================================================================
      return
      end


#ifdef PARAL
!=======================================================================
      subroutine write_wf( &
            cptwfp,ndcbyt,&
             wfdim, kphost,ldonkp,lmastr,nplwkp, &
#           include "apply_h_args.h"
            ,timer,nconso )
      use run_context, only : output_wavefunction_to_netcdf
#ifdef PARAL
      use par_functions_module
#endif
!=======================================================================
!  subroutine write_wf is used for the parallel program to collect 
!  the wavefunctions on the master for write out to the netCDF file. 
!  
!  wfdim : this is used to allocate room for nbands wavefunction for 
!          one k-point. If no planewave parallization is done (par_pw_np=1) 
!          then wfdim = 1, so that no extra memory is allocated
!
!
!=======================================================================
      implicit none
!=======================================================================
#     include "apply_h_decl.h"

      integer ndcbyt
      complex*WF_PRECISION cptwfp(nrplwv,nbands,*)
      integer wfdim,kphost(nkprun)
      logical*4 lmastr,ldonkp(nkprun)
      integer nplwkp(nkprun)

      real*8    timer(*)
      integer nconso


!     locals 
!     full lenght workarray (nrplwv_global) then par_pw_np>1
      complex*WF_PRECISION cptwfp_fl(wfdim,nbands)
      integer     nkpeff,idslav,irank,id
      real*4      NORM2

      if (.not.output_wavefunction_to_netcdf) return 

      if (ldonkp(nkp)) then 
         call wfswap_get(cptwfp,ndcbyt,nkpeff,&
#include                   "apply_h_args.h"
                            )                   
      else 
!        just get nkpeff
         call geteff(nkp,nkpmem,nconso,nkpeff)  
      endif

      call par_rank_world (irank,&
#include PARAL_ARGS
        ,nconso)
      id = irank - 1

#ifdef DEBUG
      write(nconso,*) 'write_wf nkp      ',nkp
      write(nconso,*) 'write_wf lmastr   ',lmastr
      write(nconso,*) 'write_wf world id ',id
      write(nconso,*) 'write_wf ldonkp   ',ldonkp(nkp)
      write(nconso,*) 'write_wf kphost   ',kphost(nkp)
      write(nconso,*) 'write_wf nplwkp   ',nplwkp(nkp)
      write(nconso,*) 'write_wf nkpeff   ',nkpeff
      write(nconso,*) 'write_wf nrplwv   ',nrplwv
      write(nconso,*) 'write_wf nrplwv_global ',nrplwv_global
      call uflush(nconso)
#endif
      idslav = kphost(nkp)-1

      if (lmastr) then
!       Master task
!          Send wavefunction from slave to master
           call smwf (nconso,idslav,nkp,cptwfp(1,1,nkpeff),&
              cptwfp_fl,wfdim,nplwkp(nkp),nrplwv,&
              nrplwv_global,nbands,nkprun,ldonkp,lmastr,&
#include   PARAL_ARGS
           ,timer)

!       write wavefunctions to netcdf file 

        if (par_pw_np.eq.1) then 
           call netcdf_write_wf(nkprun,nspin,nbands,nrplwv_global,&
                             kspin,nkp,cptwfp(1,1,nkpeff) )   
        else
!          make sure unused G-vectors are initialized
           if (nrplwv_global.gt.nplwkp(nkp)) then 
              cptwfp_fl(nplwkp(nkp)+1:nrplwv_global,1:nbands) = 0.0
           endif
           call netcdf_write_wf(nkprun,nspin,nbands,nrplwv_global,&
                             kspin,nkp,cptwfp_fl )     
        endif
      else
!          Slave task
!           Send wavefunction from slave to master
            call smwf (nconso, idslav, nkp, cptwfp(1,1,nkpeff),&
             cptwfp_fl,wfdim,nplwkp(nkp),nrplwv, nrplwv_global, &
             nbands,nkprun,ldonkp,lmastr,&
#include     PARAL_ARGS
             ,timer)

      endif

      return 
      end

#endif PARAL


! -------------------------------------------------------------
! getwf_netcdf
! read wavefunction for one k-point using the netCDF variable
! WaveFunction. 
! the resulting wavefunction is written to disk or stored in 
! cptwfp if nkpmem = nkprun
! For parallel program the wavefunction is distributed out. 
! -------------------------------------------------------------          
      subroutine getwf_netcdf(nkp,nbands,nrplwv,nrplwv_global,&
            nplwkp,nkprun,nspin,lkpnew,kspin,ndcbyt,nkpmem, &
            cptwfp,ldonkp,lmastr&
#ifdef PARAL
                        ,kphost,&
#                       include PARAL_ARGS
#endif PARAL
                        ,timer)

      use netcdfinterface
      use run_context
#ifdef PARAL
      use par_functions_module
#endif PARAL

!     read wavefunctions for one k-point
!     For parallel program : distribute wavefunction to all nodes.

      implicit none
      integer nkp,nbands,nrplwv,nrplwv_global,nplwkp,nkprun
      integer nspin,kspin(nkprun)
      integer ndcbyt,nkpmem
      logical*4 lmastr,lkpnew
      real*8    timer(*)
      complex*WF_PRECISION cptwfp(nrplwv,nbands,nkpmem) 
      logical*4 ldonkp(nkprun)
      integer   kphost(nkprun)

!     locals
      real*R_PRECISION NORM2
      external NORM2
      integer i,j,ispin,nkp1,nb,start(5),count(5),status,ncid
      real*8  wfnorm
      real*8  wave_function_rec(2,nrplwv_global)   ! output one band at a time to save memory
      integer nkpeff,nOK
#include "ms.h"

#ifdef PARAL
#include PARAL_DECL
!     define temporay variable to read full lenght wavefunctions for one band
      complex*WF_PRECISION cptwfp_full(nrplwv_global)
#endif

      call geteff(nkp,nkpmem,nconso,nkpeff)

      lkpnew = .false.

!     open netCDF file
      if (lmastr) then
        status = nf_open(netCDF_input_filename,NF_NOWRITE, ncid )
        if (status /= nf_noerr) stop "nf_open: error getwf"                 
      endif

! get actual k-point
      nkp1  = nint(float(nkp)/float(nspin))
! get spin
      ispin = kspin(nkp)                              

!     Read wavefunctions for this k-point from the netCDF variable : 
!       WaveFunction(number_IBZ_kpoints,number_of_spin,number_of_bands,number_plane_waves,real_complex) 
!     only master read
      start(1) = 1       ! real/complex
      count(1) = 2
      start(2) = 1       ! nrplwv
      count(2) = nrplwv_global
      start(5) = nkp1
      count(5) = 1
      start(4) = ispin   ! nspin
      count(4) = 1
      do nb = 1,nbands


         start(3) = nb
         count(3) = 1

         if (lmastr) then 
           status = nfget(ncid,'WaveFunction',wave_function_rec,&
             startnf=start,countnf=count)
           if (status/=nfif_ok) then 
            write(nconso,*) &
            'WFG: could not read wave-function from netCDF set '
            write(nconso,*) &
            'WFG: assumes this is a new calculation'
            lkpnew = .true. 
           endif 
         endif !lmastr

#ifdef PARAL
         if (.not.(lmastr.and.ldonkp(nkp))) then

            if ((lmastr).or.((par_process.eq.0).and.(ldonkp(nkp)))) then
              call mspack_double_array (nconso,kphost(nkp)-1,MSG_WF,&
                 REAL8,wave_function_rec,2*nrplwv_global,nOK)
              endif
         endif

         do i = 1,nrplwv_global
           cptwfp_full(i) = cmplx(wave_function_rec(1,i),&
                                wave_function_rec(2,i))
         enddo

         ! send to all nodes if the wavefunction was found
         call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, lkpnew, 1, nOK)

         if (lkpnew) then 
            if (lmastr) then 
               status = nf_close(ncid)
            endif
            return 
         endif

!        now distribute to all nodes
         if (ldonkp(nkp)) then 
            call par_splitcols(cptwfp_full,nrplwv_global,&
                    cptwfp(1,nb,nkpeff),nrplwv,nplwkp,1,0,&
#include            PARAL_ARGS
                   ,timer,nconso  )
         endif
#else
         if (lkpnew) then 
            status = nf_close(ncid)
            return 
         endif
           
         if (ldonkp(nkp)) then
           do i = 1,nrplwv
             cptwfp(i,nb,nkpeff) = cmplx(wave_function_rec(1,i),&
                                wave_function_rec(2,i))
           enddo                    
         endif
#endif

      enddo                                              
   
!     write to disk 
      call wfswap_put(cptwfp,nkp,nrplwv,nbands,nkpmem,nkprun,ndcbyt)       

      if (lmastr) then 
         status = nf_close(ncid)
      endif

!
      return                                                    
      end

! -------------------------------------------------------------
! netcdf_write_wf
! output the reciprocal wavefunction for k-point kpoint to
! the netcdf variable wave_function_rec(nkprun,nspin,nbands,nrplwv)
!
! -------------------------------------------------------------
      subroutine netcdf_write_wf(nkprun,nspin,nbands,nrplwv,&
                                 kspin,kpoint,cptwfp)

      use netcdfinterface
      use run_context
      implicit none

      integer nkprun,nspin,nbands,nrplwv,kspin(nkprun)
      integer kpoint
      complex*WF_PRECISION cptwfp(nrplwv,*)

      real*4  wave_function_rec(2,nrplwv)   ! output one band at a time to save memory
      integer i,j,k,start(5),count(5),ispin,nb
      integer id,status,nkp1,ncid
      real*R_PRECISION NORM2
      external NORM2

      if (.not.output_wavefunction_to_netcdf) return          

      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) then 
        write(nconso,*) "nf_open: error"            
        call clexit(nconso)
      endif

! make sure we have the real_complex dimension
      status = nfputglobaldim(ncid,'real_complex',2) 
      if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize)) then 
        write(nconso,*) 'nfputglobaldim: error writing real_complex',&
        status 
        call clexit(nconso)
      endif                         

     

! create variable WaveFunction if it does not allready exists
      status = nfdefvar(ncid,'WaveFunction',NF_REAL,&
              'real_complex',&
              'number_plane_waves',&
              'number_of_bands', &
              'number_of_spin', &
              'number_IBZ_kpoints' )

      if (status == nfif_ok) then 
        write(nconso,*) 'WFG: created WaveFunction in netCDF file'

!       add attributes
        status = nfput(ncid,'WaveFunction%Decsription',&
         'Coefficients for plane-wave expansion in Reciprocal space')
        status = nfput(ncid,'WaveFunction%unit',&
         'normalized |psi|^2 = 1 (norm conserving pseudo-potential)')
      elseif (status==nfif_varexist_butOKdef) then
         continue
      else
        write(nconso,*) 'WFG: unexpected error writing WaveFunction'
        write(nconso,*) 'WFG: nf_error ',status 
        call clexit(nconso)
      endif

! get actual k-point
      nkp1  = nint(float(kpoint)/float(nspin))
! get spin
      ispin = kspin(kpoint)


      start(1) = 1   ! real/complex
      count(1) = 2
      start(2) = 1   ! nrplwv
      count(2) = nrplwv
      start(5) = nkp1
      count(5) = 1
      start(4) = ispin   ! nspin
      count(4) = 1
      do nb = 1,nbands
#ifdef DEBUG
         write(nconso,*)'netcdf writewf',nbands,nrplwv
         write(nconso,*) 'netcdf writewf norm ',nb,NORM2 (nrplwv,&
                             cptwfp(1,nb),1)
#endif
         start(3) = nb
         count(3) = 1
         do i = 1,nrplwv
           wave_function_rec(1,i) = real(cptwfp(i,nb))
           wave_function_rec(2,i) = aimag(cptwfp(i,nb))
         enddo
         status = nfput(ncid, 'WaveFunction',wave_function_rec,&
                      startnf=start,countnf=count)
         if (status/=nfif_ok) then  
            write(nconso,*)  "nf_write: error writing wavefunction"
            call clexit(nconso)
         endif
      enddo
      status = nf_close(ncid )

      return
      end


! -------------------------------------------------------------------- 
! density_put
! writes the density to the netCDF variable 
!   double ChargeDensity(number_of_spin, grid_dim3, grid_dim2, grid_dim1) ;
!                charge_density:Description = "realspace charge density" ;
!                charge_density:units = "-e/A^3" ; 
! writes the partial core density rho_core                             
!   double PartialCoreDensity(grid_dim3, grid_dim2, grid_dim1) ;
! ---------------------------------------------------------------------
      subroutine density_put(rdensr,rho_core,ngx,ngy,ngz,nspin,lmastr)
      use netcdfinterface
      use run_context
      implicit none
      integer ngx,ngy,ngz,nspin
      real*8 rdensr(ngx,ngy,ngz,nspin)
      real*8 rho_core(ngx,ngy,ngz)
      logical*4 lmastr

!     locals 
      integer status,ncid

      if (.not.output_chargedensity_to_netcdf) return    

      if (.not.lmastr) return

      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) stop "nf_open: error"

      status = nfput(ncid,'ChargeDensity',rdensr,&
                  dim_name1='hardgrid_dim1',&
                  dim_name2='hardgrid_dim2',&
                  dim_name3='hardgrid_dim3',&
                  dim_name4='number_of_spin' ) 
      if (status/=nfif_OK) then 
        write(nconso,*) 'density_put : nf_error writing density ',&  
                         status
	call clexit(nconso)
      endif

      status = nfput(ncid,'PartialCoreDensity',rho_core,&
                  dim_name1='hardgrid_dim1',&
                  dim_name2='hardgrid_dim2',&
                  dim_name3='hardgrid_dim3' ) 

      if (status/=nfif_OK) then 
        write(nconso,*) 'density_put : nf_error writing core density ',&  
                         status
	call clexit(nconso)
      endif

!     add attributes
      status = nfput(ncid,'ChargeDensity%Description', &
           'realspace charge density' )
      status = nfput(ncid,'ChargeDensity%unit','-e/A^3')

      status = nf_close(ncid) 
      if (status /= nf_noerr) stop "density_put nf_close: error"

      return 
      end
! --------------------------------------------------------------------
! density_get
! reads the density from the netcdf variable
!   double ChargeDensity(number_of_spin, grid_dim3, grid_dim2, grid_dim1) ;
! ---------------------------------------------------------------------
      subroutine density_get(rdensr,ngx,ngy,ngz,nspin,found,lmastr) 
#ifdef PARAL
      use par_functions_module
#endif
      use netcdfinterface
      use run_context
      implicit none 
      integer ngx,ngy,ngz,nspin,nOK
      real*8 rdensr(ngx,ngy,ngz,nspin)
      logical*4 found,lmastr
#include "ms.h"

!     locals 
      integer status,ncid

      if (lmastr) then 

         status = nf_open(netCDF_input_filename,NF_NOWRITE, ncid )
         if (status /= nf_noerr) stop "nf_open: error in density_get"

         status = nfget(ncid,'ChargeDensity',rdensr)

         if (status/=nfif_OK) then
            found = .false.
         else 
            found = .true.
         endif

         status = nf_close(ncid)
         if (status /= nf_noerr) stop "density_get nf_close: error"

      endif

#ifdef PARAL
      ! send to all nodes if density was found
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, found, 1, nOK)


      if (found) then 
          call mspack_double_array (nconso,ANY,MSG_SETUP,&
                   REAL8, rdensr, ngx*ngy*ngz*nspin,nOK)
      endif
#endif

      return
      end
! -----------------------------------------------------------------------
! subroutine netcdf_write_becp
! becp variable (psi|becp> is written to NetCDF file
! parallel send is done so master has defined becp for all k-points
! -----------------------------------------------------------------------
       subroutine netcdf_write_becp(ldonkp,lmastr,&
#                   include "apply_h_args.h"
                            )                                

!     define the following dimensions and variables describing 
!     the <becp|psi> overlaps. 
!       max_projectors_per_atom_dim 
!       beta_psi                      <psi|becp>
!       ltype_projector
!       mtype_projector
!       n_beta_function
!       number_of_beta_functions
!
        use run_context
        use netcdfinterface
        use van_us_data_module
        implicit none
#include "apply_h_decl.h"
        logical*4 ldonkp(nkprun),lmastr
        include 'readvan.h'

!     beta_psi_dims(6) = number_IBZ_kpoints_dim
!     beta_psi_dims(5) = number_of_spin_dim
!     beta_psi_dims(4) = number_of_atoms_dim
!     beta_psi_dims(3) = max_projectors_per_atom_dim
!     beta_psi_dims(2) = number_of_bands_dim
!     beta_psi_dims(1) = real_complex_dim                   

!     locals        
      real*8, allocatable :: beta_psi(:,:,:,:,:,:)   ! real_complex,nbands,nkbpmaxatom,nions,nspin,nkp_ibz
      integer ltype_projector(nions,nkbpmaxatom)
      integer mtype_projector(nions,nkbpmaxatom)
      integer n_beta_function(nions,nkbpmaxatom)
      integer number_of_beta_functions(nions)
      integer na,nsp,ni,nb,ncid
      integer nkp1,kpoint,ispin,i,status,max_projector_per_atom

      max_projector_per_atom = maxval(nh(:))

      if (max_projector_per_atom.eq.0) return

#ifdef PARAL
!     send becp to master
      call sm_send_becp(nconso,ldonkp,&
            becp, nkbmax,nbands,nkprun,&
#include    PARAL_ARGS
                          )
      if (.not.lmastr) return !  only master write to netcdf file
#endif


      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) call abort_calc(nconso,  &
                   "netcdf_write_becp -> nfopen") 

! make sure we have the real_complex dimension
      status = nfputglobaldim(ncid,'real_complex',2)
      if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize)) then
        write(nconso,*) 'nfputglobaldim: error writing real_complex',&
        status
        call clexit(nconso)
      endif
                                                           
      nkp1  = nint(float(nkprun)/float(nspin))
      allocate(beta_psi(2,nbands,max_projector_per_atom,&
               nions,nspin,nkp1))
      beta_psi = 0.0d0
      ltype_projector = 0
      mtype_projector = 0
      n_beta_function = 0

! make sure we have the  dimension
      status = &
       nfputglobaldim(ncid,'max_projectors_per_atom',&
                      max_projector_per_atom)
      if ((status/=nfif_ok).and.(status/=nfif_dimexist_butOKsize)) then
        write(nconso,*) &
         'netcdf_write_becp: err writing max_projectors_per_atom',&
         status
        call clexit(nconso)
      endif          

      na = 1
      do nsp = 1,nspec 
        do ni = 1,nionsp(nsp) 

          number_of_beta_functions(na) = nh(nsp)

          do i = 1,nh(nsp)

            ltype_projector(na,i) = nhtol(i,nsp)
            mtype_projector(na,i) = nhtom(i,nsp)
            n_beta_function(na,i) = indv(i,nsp)
!           write(nconso,*) 'ltype ',i,na,ltype_projector(na,i)
!           write(nconso,*) 'mtype ',i,na,mtype_projector(na,i)
!           write(nconso,*) 'nbeta ',i,na,n_beta_function(na,i)

            do nb = 1,nbands

              do kpoint = 1,nkprun
!               get actual k-point  
                nkp1  = nint(float(kpoint)/float(nspin))
!               get spin
                ispin = kspin(kpoint) 
                beta_psi(1,nb,i,na,ispin,nkp1) = &
                   dreal(becp(nkbc(na,i),nb,kpoint))
                beta_psi(2,nb,i,na,ispin,nkp1) = &
                   dimag(becp(nkbc(na,i),nb,kpoint))

              enddo
            enddo 
          enddo 
          na = na + 1

        enddo
      enddo                                                                       
 
!     beta_psi_dims(6) = number_IBZ_kpoints_dim 
!     beta_psi_dims(5) = number_of_spin_dim
!     beta_psi_dims(4) = number_of_atoms_dim
!     beta_psi_dims(3) = max_projectors_per_atom_dim
!     beta_psi_dims(2) = number_of_bands_dim
!     beta_psi_dims(1) = real_complex_dim

      status = nfput(ncid,'NLProjectorPsi',beta_psi,&
                  dim_name6='number_IBZ_kpoints',&
                  dim_name5='number_of_spin',&
                  dim_name4='number_of_dynamic_atoms',&
                  dim_name3='max_projectors_per_atom',&
                  dim_name2='number_of_bands',&
                  dim_name1='real_complex' )                
      if (status /= nf_noerr) call abort_calc(nconso,  &
                   "netcdf_write_becp -> nfput : beta_psi") 
      
      status = nfput(ncid,'TypeNLProjectorl',ltype_projector,&
                  dim_name1= 'number_of_dynamic_atoms',&
                  dim_name2= 'max_projectors_per_atom') 

      status = nfput(ncid,'TypeNLProjectorm',mtype_projector,&
                  dim_name1= 'number_of_dynamic_atoms',&
                  dim_name2= 'max_projectors_per_atom') 

!      status = nfput(ncid,'ProjectorToBeta',n_beta_function,
!     &            dim_name1= 'number_of_dynamic_atoms',
!     &            dim_name2= 'max_projectors_per_atom') 
      status = nfput(ncid,'NumberOfNLProjectors',&
                     number_of_beta_functions,&
                     dim_name1= 'number_of_dynamic_atoms' )

      status = nf_close(ncid ) 
      return 
      end

! -----------------------------------------------------------------------
! subroutine netcdf_write_ensemble_energies
! -----------------------------------------------------------------------
      subroutine netcdf_write_ensemble_energies(energies,lmastr)
      use netcdfinterface
      use run_context
      implicit none
      integer status,ncid
      real*8 energies(5)
      logical*4 lmastr

#ifdef PARAL
      if (.not.lmastr) return !  only master write to netcdf file
#endif

      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) call abort_calc(nconso,  &
                   "netcdf_write_ensemble -> nfopen")
     
      ! make sure we have the dim5 dimension 
      status = nfputglobaldim(ncid,'dim5',5)
      if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize)) then
         write(nconso,*)'nfputglobaldim:error writing dim5',status 
         call clexit(nconso)
      endif

      status = nfput(ncid,'EnsembleXCEnergies',& 
                     energies,dim_name1='dim5')

      status = nf_close(ncid ) 
      return 
      end

! -------------------------------------------------------------------- 
! potential_put
! writes the effective potential to the netCDF variable 
!   double EffectivePotential(number_of_spin, grid_dim3, grid_dim2, grid_dim1) ;
!                effective_potential:Description = "realspace effective potential" ;
!                effective_potential:units = "eV" ;                             
!   errors are fatal
! ---------------------------------------------------------------------
      subroutine potential_put(potential,ngx,ngy,ngz,nspin,lmastr)
!----------------------------------------------------------------------
      use netcdfinterface
      use run_context
      implicit none
      integer ngx,ngy,ngz,nspin
      complex*16 potential(ngx,ngy,ngz,nspin)
      logical*4 lmastr

!     locals 
      integer status,ncid
      real*8 r_potential(ngx,ngy,ngz,nspin)
      integer ispin,nx,ny,nz
!------------------------------------------------------------------------
      if (.not.lmastr) return
      if (output_effpotential_to_netcdf.eq.0) return    

      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) stop "nf_open: error in potential_put"
      
      do ispin = 1,nspin
         do nx = 1,ngx
            do ny = 1,ngy
               do nz = 1,ngz
                  r_potential(nx,ny,nz,ispin) = dble(potential(nx,ny,nz,ispin))
               enddo
            enddo
         enddo
      enddo
      status = nfput(ncid,'EffectivePotential',r_potential,&
                 dim_name1='hardgrid_dim1',&
                 dim_name2='hardgrid_dim2',&
                 dim_name3='hardgrid_dim3',&
                 dim_name4='number_of_spin') 
      if (status/=nfif_OK) then 
        write(nconso,*) 'potential_put:nf_err writing potential',status
        stop 
      endif

!     add attributes
      status = nfput(ncid,'EffectivePotential%Description',&
          'realspace local effective potential' )
      status = nfput(ncid,'EffectivePotential%unit','eV')

      status = nf_close(ncid) 
      if (status /= nf_noerr) stop "potential_put nf_close: error"

      return 
      end
! -------------------------------------------------------------------- 
! els_potential_put
! writes the electrostatic potential to the netCDF variable 
!   double ElectrostaticPotential(number_of_spin, grid_dim3, grid_dim2, grid_dim1) ;
!                electrostatic_potential:Description = "realspace electrostatic potential" ;
!                electrostatic_potential:units = "eV" ;                             
!   errors are fatal
! ---------------------------------------------------------------------
      subroutine els_potential_put(potential,ngx,ngy,ngz,nspin,lmastr)
!----------------------------------------------------------------------
      use netcdfinterface
      use run_context
      implicit none
      integer ngx,ngy,ngz,nspin
      complex*16 potential(ngx,ngy,ngz,nspin)
      logical*4 lmastr

!     locals 
      integer status,ncid
      real*8 r_potential(ngx,ngy,ngz,nspin)
      integer ispin,nx,ny,nz
!------------------------------------------------------------------------
      if (.not.lmastr) return
      if (output_elspotential_to_netcdf.eq.0) return    

      status = nf_open(netCDF_output_filename,NF_WRITE,ncid)
      if (status /= nf_noerr) stop "nf_open: error in els_potential"
      
      do ispin = 1,nspin
         do nx = 1,ngx
            do ny = 1,ngy
               do nz = 1,ngz
                  r_potential(nx,ny,nz,ispin) = dble(potential(nx,ny,nz,ispin))
               enddo
            enddo
         enddo
      enddo
      status = nfput(ncid,'ElectrostaticPotential',r_potential,&
                 dim_name1='hardgrid_dim1',&
                 dim_name2='hardgrid_dim2',&
                 dim_name3='hardgrid_dim3',&
                 dim_name4='number_of_spin') 
      if (status/=nfif_OK) then 
        write(nconso,*) 'els_potential_put:nf_err writing electrostatic potential',status
        stop 
      endif

!     add attributes
      status = nfput(ncid,'ElectrostaticPotential%Description',&
          'realspace local effective potential' )
      status = nfput(ncid,'ElectrostaticPotential%unit','eV')

      status = nf_close(ncid) 
      if (status /= nf_noerr) stop "els_potential_put nf_close: error"

      return 
      end
