!     @(#)van_us_decl.h	1.8 11/9/98
!***************************************************************************                                                          
!     Declaration of variables used for vandelbilt us potentials 
!     uses  : 
!       parameters in van_us.def 
!     + 
!       nplwv     (ngx*ngy*ngz, the number of reciprocal lattice vectors) 
!       nrplwv_global (maximum number of plane-waves below cutoff for all k-points ,
!                  (for the serial case = nrplwv)
!                  equal to nrplwv)  
!       nions   (number of ions) 
!       nspec   (number of different atoms) 
!       nbands  (number of bands) 
!       nkprun  (number of k-points)

!       ngldim  (Max number of G-shells used in the definition of qrad,            
!                is defined by x-dacapo) 
!       ngdens_max 
!               (Max number of G vectors below 4*Ecut, 
!                is defined by x-dacapo)
!****************************************************************************

!     nh   : full dimension of Q matrix
!     nhm  : maximum full dimension of Q matrix
!     indv : goes from qq (Qnm) order -> qqq order    
!     nhtol: goes from qq (Qnm) order -> l quantum number
!     nhtom: goes from qq (Qnm) order -> m quantum number 
!   qq (Qnm) order = s_1 p_x1 p_y1 p_z1 s_2 p_x2 p_z2 p_y2
!   qqq order      = s_1 s_2 p_1 p_2                       
!     nkb :     total number of projectors
!     nkbp:     number of different types of projectors
!     nkbtona: nkb -> na  (projector number->atom number)
!     nkbtonh: nkb -> nh  (projector number->index to Q matrix)
!     nkptoit: nkbp -> it                                       
!     nkbc:  (nions,nkbp) -> nkb
!     vkb  :  the projectors beta in reciprocal space
!     becp :  the scalar products <pbeta:psi>
!     qq   :  Integrated Qnm
!     dvan : D0 matrix
!     deeq : the d matrix per atom

      integer nkbp
      integer nh(nspec),indv(nhm,nspec),nhtol(nhm,nspec)
      integer nhtom(nhm,nspec), nkbtona(nkbmax), nkbtonh(nkbmax)
      integer nkptoit(nhm),nkbc(nions,nhm)

      logical*4  vkbreal(nkbpmaxatom,nspec)
      logical*4  linitvkb(nkprun),lgenpp

      complex*16 becp(nkbmax,nbands,nkprun)
      real*8 qq(nhm,nhm,nspec)
      real*8 dvan(nhm,nhm,nspec)
!     make room for two spins in deeq
      real*8 deeq(nhm,nhm,nions,2)


!     qrad :  Qnm(|r|) in reciprocal space
!     ngl  : number of G shells
!     lqx  : number of included angular components
!     ap,lpx,lpl arrays used for the clebch gordon coefficients
!     nbrx : number of different radial functions
!     lqx  : 2*lmaxx+1, l channels in qrad
        
!     aainit
      real*8  ap(25,nlx,nlx)
      integer lpx(nlx,nlx),lpl(nlx,nlx,mx)

!     qrad(ngl,nbeta1,nbeta2,lqx) = qrad(ngl,nbeta2,nbeta1,lqx) 
!     so save memory by using nbrx2dim = nbrx*(nbrx/2+1)
!     (defined in van_us_def.h)     
#ifdef QRAD_SWAP
      real*8 qrad(ngldim,nbrx2dim,lqx)
#else
      real*8 qrad(ngldim,nbrx2dim,lqx,nspec)
#endif QRAD_SWAP

!     index going from (iv,jv) into qrad (defined in us_calcqr)
      integer ivjv2index(nbrx,nbrx,nspec) 

!     max ivjvindex 
      integer maxindex(nspec)

!     index going from G-vectors array to G-shell number
      integer igtongl(nplwv)

!     actual number of G-shells 
      integer ngl

!     actual number of G vectors for the density
      integer ngdens

!     arrays to hold G-vectors
      real*8  g(ngdens_max,3), gg(ngdens_max)

!     arrray to hold G-vectors in the soft grid 
!     Init. in genbop used in us_force
      real*8 g_soft(nrplwv_global,3,nkprun)

!     index into g-array for parallel program
!     (==0 for serial program)
      integer goffs

!     padding array  for G-vectors 
      integer ipwpadG(ngdens_max,0:3) 

!     padding array for G-vectors on soft grid 
      integer ngdens_soft
      integer ipwpadG_soft(ngdens_soft,0:3) 

!     Arrays used in gk_sort. q  are work array. 
      real*8  q(nrplwv_global)
      real*8  gkabs(nrplwv_global) 

!     variable used in addusdens and us_force to hold 
!     sum of becp*becp
      complex*16 becsum(nhm,nhm,nions)

!     derivative of D matrix in force_us 
!     always make room for two spins
      real*8     ddeeq(nhm,nhm,nions,3,2)

!     ityp  (nat-> type of atom) 
      integer ityp(nions) 


