      module van_us_data_module
      use basicdata

      implicit none
!***************************************************************************                                                          
!     Declaration of variables used for vandelbilt us potentials 
!     uses  : 
!       parameters in van_us.def 
!     + 
!       nplwv     (ngx*ngy*ngz, the number of reciprocal lattice vectors) 
!       nrplwv_global (maximum number of plane-waves below cutoff for all k-points ,
!                  (for the serial case = nrplwv)
!                  equal to nrplwv)  
!       nions   (number of ions) 
!       nspec   (number of different atoms) 
!       nbands  (number of bands) 
!       nkprun  (number of k-points)

!       ngldim  (Max number of G-shells used in the definition of qrad,            
!                is defined by x-dacapo) 
!       ngdens_max 
!               (Max number of G vectors below 4*Ecut, 
!                is defined by x-dacapo)
!****************************************************************************

!     nh   : full dimension of Q matrix
!     nhm  : maximum full dimension of Q matrix
!     indv : goes from qq (Qnm) order -> qqq order    
!     nhtol: goes from qq (Qnm) order -> l quantum number
!     nhtom: goes from qq (Qnm) order -> m quantum number 
!   qq (Qnm) order = s_1 p_x1 p_y1 p_z1 s_2 p_x2 p_z2 p_y2
!   qqq order      = s_1 s_2 p_1 p_2                       
!     nkb :     total number of projectors
!     nkbp:     number of different types of projectors
!     nkbtona: nkb -> na  (projector number->atom number)
!     nkbtonh: nkb -> nh  (projector number->index to Q matrix)
!     nkptoit: nkbp -> it                                       
!     nkbc:  (nions,nkbp) -> nkb
!     vkb  :  the projectors beta in reciprocal space
!     becp :  the scalar products <pbeta:psi>
!     qq   :  Integrated Qnm
!     dvan : D0 matrix
!     deeq : the d matrix per atom

!     maximum number of projectors
      integer,save ::  nkbmax
 
      integer,save ::  ngldim,ngdens_max

      integer,save  :: nhm,nkb
      integer, save :: nkbp
      integer, allocatable,save ::  nh(:),indv(:,:),nhtol(:,:)
      integer, allocatable,save ::  nhtom(:,:), nkbtona(:), nkbtonh(:)
      integer, allocatable,save ::  nkptoit(:),nkbc(:,:)

      logical*4, allocatable,save ::   vkbreal(:,:)
      logical*4, allocatable,save ::   linitvkb(:)
      logical*4, save             ::   lgenpp

      complex*16, allocatable,save ::  becp(:,:,:)
      real*8, allocatable,save ::  qq(:,:,:)
      real*8, allocatable,save ::  dvan(:,:,:)
!     make room for two spins in deeq
      real*8, allocatable,save ::  deeq(:,:,:,:)


!     qrad :  Qnm(|r|) in reciprocal space
!     ngl  : number of G shells
!     lqx  : number of included angular components
!     ap,lpx,lpl arrays used for the clebch gordon coefficients
!     nbrx : number of different radial functions
!     lqx  : 2*lmaxx+1, l channels in qrad
        
!     aainit
      real*8, allocatable,save ::   ap(:,:,:)
      integer, allocatable,save ::  lpx(:,:),lpl(:,:,:)

!     qrad(ngl,nbeta1,nbeta2,lqx) = qrad(ngl,nbeta2,nbeta1,lqx) 
!     so save memory by using nbrx2dim = nbrx*(nbrx/2+1)
!     (defined in van_us_def.h)     

      real*8, allocatable,save ::  qrad(:,:,:)

!     index going from (iv,jv) into qrad (defined in us_calcqr)
      integer, allocatable,save ::  ivjv2index(:,:,:) 

!     max ivjvindex 
      integer, allocatable,save ::  maxindex(:)

!     index going from G-vectors array to G-shell number
      integer, pointer,save ::  igtongl(:)

!     actual number of G-shells 
      integer, save ::  ngl

!     actual number of G vectors for the density
      integer, save ::  ngdens

!     arrays to hold G-vectors
      real*8, pointer,save ::   g(:,:), gg(:)

!     arrray to hold G-vectors in the soft grid 
!     Init. in genbop used in us_force
      real*8, pointer,save ::  g_soft(:,:,:,:)

!     index into g-array for parallel program
!     (==0 for serial program)
      integer, save ::  goffs

!     padding array  for G-vectors 
      integer, pointer,save ::  ipwpadG(:,:) 

!     padding array for G-vectors on soft grid 
      integer, save ::  ngdens_soft
      integer, pointer,save ::  ipwpadG_soft(:,:) 

!     Arrays used in gk_sort. q  are work array. 
      real*8, allocatable,save ::   q(:)
      real*8, allocatable,save ::   gkabs(:) 

!     variable used in addusdens and us_force to hold 
!     sum of becp*becp
      complex*16, allocatable,save ::  becsum(:,:,:,:)

!     derivative of D matrix in force_us 
!     always make room for two spins
      real*8, allocatable,save ::      ddeeq(:,:,:,:,:)

!     ityp  (nat-> type of atom) 
      integer, allocatable,save ::  ityp(:) 



      contains 

      subroutine allocate_van_us_data(nplwv,nrplwv_global,nions, &
            nspec,nbands,nkprun) 
      implicit none


      integer nplwv,nrplwv_global,nions
      integer nspec,nbands,nkprun

      write(6,*) 'call allocate_van_us_data'

      allocate(nh(nspec),indv(nhm,nspec),nhtol(nhm,nspec))
      allocate(nhtom(nhm,nspec), nkbtona(nkbmax), nkbtonh(nkbmax))
      allocate(nkptoit(nhm),nkbc(nions,nhm))
 
      allocate(vkbreal(nkbpmaxatom,nspec))
      allocate(linitvkb(nkprun))
 
      allocate(qq(nhm,nhm,nspec))
      allocate(dvan(nhm,nhm,nspec))
      allocate(deeq(nhm,nhm,nions,2))
        
      allocate(ap(25,nlx,nlx))
      allocate(lpx(nlx,nlx),lpl(nlx,nlx,mx))

      allocate(qrad(ngldim,nbrx2dim,lqx))

      allocate(ivjv2index(nbrx,nbrx,nspec) )

      allocate(maxindex(nspec))

      allocate(q(nrplwv_global))
      allocate(gkabs(nrplwv_global) )
      allocate(becp(nkbmax,nbands,nkprun))

      allocate(becsum(nhm,nhm,nions,nkprun))
      becsum = 0.0d0

      allocate(ddeeq(nhm,nhm,nions,3,2))

      allocate(ityp(nions) )

      end subroutine allocate_van_us_data


      end module van_us_data_module
