#include "definitions.h"
    module  tmp_read_netcdf_module
!=====================================================================
!   This is a temporary module for reading, for a transition period, 
!   some variables before libtos is called.
!   reads :        nspin=1/2  - default=1
!                  nbands=    - >> no defaults implemented here<<
!                  iscxc=1..6 - default=3(PW91) (for now)
!                  nsymax     - max number of symmetries, default = 0
!                  idebug     - debug level, default=0 (silent)
!=====================================================================
    use netcdfinterface
    use run_context
    private :: abort_calc             ! local error handler
!##################################################################### 
    contains
!#####################################################################

    subroutine tmp_read(nspin, nbands, iscxc,  &
                        nsymax, idebug, lmastr)
#ifdef PARAL
    use par_functions_module
#endif
    implicit none
!=====================================================================
    integer,intent(out) :: nspin, nbands, iscxc   ! see top
    integer,intent(out) :: nsymax, idebug         ! see top
    logical*4,intent(in):: lmastr                 ! true for master process 
!--------------------------------------------------------------------- 
!   locals 

    integer          :: ncid, status,nOK
    character*100    :: ExcFunctional, PrintDebugInfo, message, iscxc_msg
    character*100    :: symm_string
#ifdef PARAL
#include "ms.h"
#endif
!=======================================================================

  if (lmastr) then

  status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)  
  if (status /= nf_noerr) call abort_calc(nconso, &
                               "tmp_read -> nf_open : error opening nc-file")  
! -------------------------------------------------------------
!   ElectronicBands:SpinPolarization => nspin = .. (cold start)
!   else nspin = number_of_spin (restart info possibly present)
!   else nspin = 1              (default)
! -------------------------------------------------------------

  status = nfget(ncid, "ElectronicBands%SpinPolarization", nspin) 
  if (status == nfif_OK) then
     if ((nspin /= 1).and.(nspin /= 2))       &
        call abort_calc(nconso,               &
            "tmp_read : ElectronicBands%SpinPolarization /= 1,2")
     
  else

     status = nfgetglobaldim(ncid, "number_of_spin", nspin) 

     if (status == nfif_OK) then
        if ((nspin /= 1).and.(nspin /= 2))    &
            call abort_calc(nconso,           &
           "tmp_read : dimension: number_of_spin /= 1,2") 
     else
         nspin = 1                                    !  set default  
     endif

  endif

  
! -------------------------------------------------------------
!   ElectronicBands:NumberOfBands = nbands .. (cold start)
!   else nbands = number_of_bands (restart info possibly present)
!   else stop                     (no default for now) 
! -------------------------------------------------------------

  
  status = nfget(ncid, "ElectronicBands%NumberOfBands", nbands) 
 
  if (status /= nfif_OK ) then

     status = nfgetglobaldim(ncid, "number_of_bands", nbands) 
     if (status /= nfif_OK ) call abort_calc(nconso, &
                             "tmp_read : unable to set nbands")
     
  else 
    
     if (nbands <= 0)  call abort_calc(nconso, &
                 "tmp_read : ElectronicBands:NumberOfBands <= 0")

  endif

! -------------------------------------------------------------
!  Set iscxc ExcFunctional 
!    iscxc = 1 : PZ   (Perdew Zunger)          LDA  
!    iscxc = 2 : VWN  (Vosko Wilk Nusair)      LDA 
!    iscxc = 3 : PW91 (Perdew Wang 91)         GGA 
!    iscxc = 4 : PBE  (Perdew Burke Ernzerhof) GGA
!    iscxc = 5 : revPBE                        GGA
!    iscxc = 6 : RPBE                          GGA
!  check, if ExcFunctional is set
!  else set iscxc = 3  (default)
! -------------------------------------------------------------
  
   ExcFunctional = ""   ! clear buffer
   status = nfget(ncid, "ExcFunctional", ExcFunctional) 
   if (status == nfif_OK) ExcFunctional = adjustl(ExcFunctional)

   if (status /= nfif_OK) then 
       iscxc = 3      ! default = PW91
   elseif (ExcFunctional(1:1) == achar(nf_fill_char)) then
       iscxc = 3      ! default = PW91
   else
       if     (index(ExcFunctional,"PZ")     == 1) then
           iscxc = 1
       elseif (index(ExcFunctional,"VWN")    == 1) then
           iscxc = 2 
       elseif (index(ExcFunctional,"PW91")   == 1) then
           iscxc = 3
       elseif (index(ExcFunctional,"PBE")    == 1) then
           iscxc = 4 
       elseif (index(ExcFunctional,"revPBE") == 1) then
           iscxc = 5 
       elseif (index(ExcFunctional,"RPBE")   == 1) then
           iscxc = 6
       else
           write(message,*)  "tmp_read : did not recognize ExcFunctional", &
                              trim(ExcFunctional)
           call abort_calc(nconso, message)
       endif 
   endif

   select case (iscxc)
     case ( 1 );  iscxc_msg = "[ XC Functional = PZ   (Perdew Zunger)          LDA]" 
     case ( 2 );  iscxc_msg = "[ XC Functional = VWN  (Vosko Wilk Nusair)      LDA]"  
     case ( 3 );  iscxc_msg = "[ XC Functional = PW91 (Perdew Wang 91)         GGA]"  
     case ( 4 );  iscxc_msg = "[ XC Functional = PBE  (Perdew Burke Ernzerhof) GGA]" 
     case ( 5 );  iscxc_msg = "[ XC Functional = revPBE                        GGA]" 
     case ( 6 );  iscxc_msg = "[ XC Functional = RPBE                          GGA]" 
   end select
   

! --  check that Perdew-Zunger LDA is not used together ---------
!     with a spin-pol. calculation (moved to here from subroutine setuop)
      if ((iscxc == 1).and.(nspin /= 1)) then
        write(nconso,*) "Perdew-Zunger LDA can not be used for a spin-&
     &polarized calculation"
        call clexit(nconso)
      endif

! ----------------------------------------------------------
! Set nsymax (maximum number of symmetries) - default = 0
! ----------------------------------------------------------

  symm_string = ""   ! clear buffer
  status = nfget(ncid, "UseSymmetry", symm_string) 
  if (status == nfif_OK ) symm_string = adjustl(symm_string)
  if (status /= nfif_OK ) then 
      nsymax = 0 
  elseif ((symm_string(1:1) == achar(nf_fill_char)) .or. & 
      (index(symm_string,"Off")            > 0)) then
      nsymax = 0                                        
  elseif (index(symm_string,"Maximum") > 0)      then
      nsymax = 6
  else
     write(nconso,*)  "tmp_read : did not recognize UseSymmetry = ", &
                              trim(symm_string)
     call clexit(nconso)
  endif


! ----------------------------------------------------------
! Set idebug (debugging level) - default = 0       
! ----------------------------------------------------------

  PrintDebugInfo = ""   ! clear buffer
  status = nfget(ncid, "PrintDebugInfo", PrintDebugInfo) 
  if (status == nfif_OK ) PrintDebugInfo = adjustl(PrintDebugInfo)
  if (status /= nfif_OK ) then 
      idebug = 0                                        
  elseif ((PrintDebugInfo(1:1) == achar(nf_fill_char)) .or. & 
      (index(PrintDebugInfo,"Off")            > 0)) then
      idebug = 0                                        
  elseif (index(PrintDebugInfo,"MediumLevel") > 0)  then
      idebug = 1
  elseif (index(PrintDebugInfo,"HighLevel")   > 0)  then
      idebug = 4
  else
     write(nconso,*)  "tmp_read : did not recognize PrintDebugInfo = ", &
                              trim(PrintDebugInfo)
     call clexit(nconso)
  endif
  status = nf_close(ncid)

! ----------------------------------------------------------
! Print short summary     
! ----------------------------------------------------------  
  
  write(nconso, 150)
  write(nconso, 160) "nspin  = ", nspin , "(spin polarized calc = 2)"
  write(nconso, 160) "nbands = ", nbands, "(bands in calculation)"
  write(nconso, 160) "iscxc  = ", iscxc ,    trim(iscxc_msg)
  write(nconso, 160) "nsymax = ", nsymax, "(maximum number of symmetries applied)"
  write(nconso, 160) "idebug = ", idebug, "(debugging level)"
  write(nconso, 170)
  write(nconso, *)
  write(nconso, *)
 
 150 format(1x, "tmp_read: ", 25("-"), " input summary ", 25("-"))
 160 format(1x, "tmp_read: ", a9, i4, 1x, a)
 170 format(1x, "tmp_read: ", 66("-"))

 
! ----------------------------------------------------------
! Output dimension number_of_spin and number_of_bands to 
! output netCDF file
! ----------------------------------------------------------
    status =  nf_open(netCDF_output_filename, NF_WRITE, ncid)      
    if (status /= nf_noerr) call abort_calc(nconso, &
                                 "tmp_read -> nf_open : error opening out nc-file")
  
    status = nfputglobaldim(ncid,'number_of_spin',nspin) 

    if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize))  & 
        call abort_calc(nconso, &
       "tmp_read : unable to write number_of_spin to out netCDF file")

    status = nfputglobaldim(ncid,'number_of_bands',nbands)
    if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize))  &
        call abort_calc(nconso, &
        "tmp_read : unable to write number_of_bands to out netCDF file")

    status =  nf_close(ncid)   
    if (status /= nf_noerr) call abort_calc(nconso, &
                      "tmp_read -> nf_close : error closingi out nc-file")


  endif ! lmastr

#ifdef PARAL
! send data to slaves
  call mspack_integer_scalar(nconso, ANY, MSG_SETUP,&
                   INTEGER4, nspin,  1, nOK)
  call mspack_integer_scalar(nconso, ANY, MSG_SETUP,&
                   INTEGER4, nbands,  1, nOK)
  call mspack_integer_scalar(nconso, ANY, MSG_SETUP,&
                   INTEGER4, iscxc,  1, nOK)
  call mspack_integer_scalar(nconso, ANY, MSG_SETUP,&
                   INTEGER4, nsymax,  1, nOK)
  call mspack_integer_scalar(nconso, ANY, MSG_SETUP,&
                   INTEGER4, idebug,  1, nOK)
#endif

  end subroutine tmp_read
!######################################################################
      subroutine abort_calc(iunit, message)
! -------------------------------------------------------
!     Local I/O abort routine that provides
!     an error message
! -------------------------------------------------------
      implicit none
      integer, intent(in)       ::  iunit
      character*(*), intent(in) ::  message
      
      write(iunit,*) "abort_calc: ", trim(message)
      call clexit(iunit)

      end subroutine abort_calc

end  module  ! tmp_read_netcdf_module








