#include "definitions.h" 
!=======================================================================
      subroutine setuid(nconso)
      write(nconso,*) '@(#)setuop.F	1.36 7/1/99'
      return
      end
!=======================================================================
!     Old reading subroutine "setuop" modified to support
!     netCDF and new input structure.
! 
!     Sticks to fixed format for the time being, so it
!     compiles as "xlf -c"; free format compilation not
!     possible yet, due to fixed format usage in van_*.h
!     (xlf allows  "!" as comment initiator in col 1 in fixed format though)
!     Asbjorn.03Aug1999
!------------------------------------------------------------------------
!        1         2         3         4         5         6         7
!23456789012345678901234567890123456789012345678901234567890123456789012|
!=======================================================================
      subroutine setuop(                                               &
! input dimensions and variables
       nrplwv,nrplwv_global,nkprun,nbands,ngx,ngy,ngz,nplwv,nions,     &
       nspin,nspec, nionsp,volc,                                       &
! atom
       nlnum,mmax,mmaxx,npspts,rlog,radius,phiatm,rho_rad,     &
       pscore, psgmax, psp,      &
! dipole
       vext, idipol, zdip,dipmix,dip0, extfie, extpot, lworkp,     &
! local density of states
       width,smethod,enemin,enemax,nener,rcutoff,&
! stm
       stmcen,stmwid,     &
! ionic dynamic
       iion,inudged,fallmax,fvarmax,fchgmax,energy_convergence, & 
       density_convergence,occupation_convergence,repeated_convergences,&
       rmass,rdamp,noffs0,rmagmo,lspsi,ieigsolver,lcharged,ireset,     &
       icharc, icharg,  nelect, deltim,ntype,uppcpu,     &
       ispati,nbspas,nkspas,langul,   &
       wangul,avebox,ibacwf,lstowf,ldelin,     &
       niter,ndiapb )
!=======================================================================
      use netcdfinterface
      use van_us_data_module, only : ityp 
      use run_context
      use basicdata
      implicit none
!=======================================================================

      integer nrplwv,nrplwv_global,nkprun,nbands,ngx,ngy,ngz,nplwv
      integer nions,nspin,nspec,nionsp(nspec)
      real*8  volc

      integer   nlnum(nspec),mmax(nspec)
      integer mmaxx,npspts
      real*8  rlog(nspec),radius(mmaxx,nspec),phiatm(mmaxx,0:2,nspec)
      real*8  rho_rad(npspts,nspec)
      real*8 pscore(nspec),psgmax(nspec)
      real*8 psp(npspts,nspec)

      real*8  vext(ngz)
      integer idipol,smethod
      real*8 zdip,dipmix,dip0,extfie,extpot
      logical*4 lworkp

      real*8 width
      real*8 enemin,enemax
      integer nener
      real*8 rcutoff

      real*8 stmcen,stmwid

      integer iion,inudged,repeated_convergences
      real*8 fallmax,fvarmax,fchgmax
      real*8 energy_convergence,density_convergence
      real*8 occupation_convergence
      real*8 rmass(nspec),rdamp(nspec)

      integer noffs0(nkprun)
      real*8  rmagmo
      logical*4 lspsi,lcharged
      integer   ieigsolver
      integer   ireset
      integer   icharc(nions),icharg(nspec)
      real*8    nelect
      real*8 deltim
      integer   ntype(nspec)
      real*8 uppcpu
      integer ispati
      integer nbspas,nkspas
      logical*4 langul
      real*8 wangul
      real*8 avebox(3,4)
      integer ibacwf
      logical*4 lstowf,ldelin
      integer niter, ndiapb

      integer ngdens_max,ngldim 
!=======================================================================
! locals
!=======================================================================
      integer       :: ncid, status
      character     :: cdummy
      character*999 :: keyword      ! char buffer for scanning input file items

      integer   nkp, imove
      integer   iznuc(nspec)
      integer   i,ntypes,nn,nch,nread,mu,nat,ni,j,newtyp
      integer   ntyp,nsp,nindx,nt,nid,nz,idelin
      real*8    f,f1,f2,f3,rrmass,rrdamp, aux2(2)
!
      character*4  str 
      character*20 dyn_method_str(0:5), dyn_type_str(0:5) ! arbi. upper limit
      character*20 print_spatial_str(0:5)
      logical      found
      real*8       extracharge,rdummy 
!=======================================================================

! ------------------------------------------------------------------
!     Open netCDF dataset
! ------------------------------------------------------------------

      status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)  
      if (status /= nf_noerr) call abort_calc(nconso, &
                 "read_structure -> nf_open : error opening nc-file")


      write(nconso,400) " "
      write(nconso,400) " ------ Task / iteration control ---------"
      write(nconso,400) " "

! =================================================================
!     Read ion dynamics details
! =================================================================

! ------------------------------------------------------------------
!     char  Dynamics  :  not def  =>  no dynamics (static calc)
!     Dynamics%Type = 
!       iion = 0 <- Dynamics%Type = Static
!       iion = 1 <- Dynamics%Type = Verlet
!       iion = 2 <- Dynamics%Type = Quickmin_Atomwise / not defined (now : not allowed together with inudged=1)
!       iion = 3 <- Dynamics%Type = Quickmin_Sum   
!       iion = 4 <- Dynamics%Type = BFGS
!       iion = 5 <- Dynamics%Type = ConjugateGradient 
! 
!     sets: inudged, iion;  imove: is a local convenience variable for printout 
!                                  (selects dyn_type_str entry)
!     reserve (iion>=50) for external controlled ion motion modes
! ------------------------------------------------------------------

      cdummy = ""         ! clear buffer
      status = nfget(ncid, "Dynamics", cdummy)  
      if (status == nfif_OK) then              ! Dynamics defined -> do dynamics
!     ----------------------------------------
         keyword = ""         ! clear buffer
         status = nfget(ncid, "Dynamics%Method", keyword)
         if (status == nfif_OK) then           ! Dynamics%Method is defined
            if     (index(keyword,"Verlet") > 0) then
               iion = 1
            elseif (index(keyword,"Quickmin_Atomwise") > 0) then
               iion = 2
            elseif (index(keyword,"Quickmin_Sum") > 0) then
               iion = 3
            elseif (index(keyword,"BFGS") > 0)  then
               iion = 4
            elseif (index(keyword,"ConjugateGradient") > 0)  then
               iion = 5
            else
               call abort_calc(nconso, "Dynamics%Method = " //&
                                        trim(keyword) // " not known")
            endif
         else                                  ! Dynamics%Method was not defined -> default
            iion = 2
         endif
!        ----------------------------------------
         keyword = ""         ! clear buffer
         status = nfget(ncid, "Dynamics%Type", keyword)
         if (status == nfif_OK) then                   ! Dynamics%Type is defined
           if     (index(keyword,"Static") > 0) then
             inudged = 0; iion    = 0                  ! may overrule Method
             imove   = 0
           elseif (index(keyword,"Relaxation") > 0)  then
             inudged = 0
             imove   = 1
           elseif (index(keyword,"ElasticBand") > 0)  then
             inudged = 1; iion    = 3                  ! (iion == 3) is tmp condition
             imove   = 2
           elseif (index(keyword,"ExternalIonMotion") > 0)  then
!
!  --- select externel ion motion (script mode)
!      character*999 :: ExternalIonMotion_script is hold in module run_context
!
             inudged = 0; iion    = 50   
             imove   = 3
             keyword = ""         ! clear buffer (OK: Dynamics%Type is parsed now)
             status = nfget(ncid, "Dynamics%ExternalIonMotion_script",&
                            keyword)
             if (status /= nfif_OK) call abort_calc(nconso,&
                            "Dynamics%ExternalIonMotion_script"&
                          //"must be provided for "//&
                            "Dynamics%Type == ExternalIonMotion")
             ExternalIonMotion_script = adjustl(keyword)

           else 

             call abort_calc(nconso, "Dynamics%Type = " // &
                             trim(keyword) // " not known")
           endif
         else                            ! Dynamics%Type is not defined -> default= relaxation
           inudged = 0; imove   = 1
         endif
!        ----------------------------------------
         status = nfget(ncid, "Dynamics%Step", deltim)
         if (status /= nfif_OK)  deltim = 1.0d0     ! default
!     ----------------------------------------
      else                                     ! Dynamics not defined -> setup static calc
         inudged = 0; iion = 0; deltim = 0.0d0
         imove   = 0
      endif


      dyn_type_str(:)   =   "                   ?"
      dyn_type_str(0:3) = (/"              Static",&
                            "          Relaxation", &
                            "         ElasticBand",&
                            "   ExternalIonMotion"/)

      dyn_method_str(:) =     "                   ?"
      dyn_method_str(0:5) = (/"              Static", &
                              "              Verlet", &
                              "   Quickmin_Atomwise",&
                              "        Quickmin_Sum", &
                              "                BFGS",&
                              "   ConjugateGradient"/)
     
  
      write(nconso,402) "Ion dynamics type  : ", &
                        trim(adjustl(dyn_type_str(imove)))


      if (iion<50) then       ! internal ion dynamics

         write(nconso,402) "Internal ion dynamics method: ", &
                            trim(adjustl(dyn_method_str(iion)))
         if (iion > 0) write(nconso,420) "dynamics time step = ", &
                                       deltim, "fs"
      
      elseif (iion==50) then   ! external ion dynamics

         write(nconso,402) "External ion motion using script: ", &
                            trim(adjustl(ExternalIonMotion_script))
      else
         call abort_calc(nconso, "setuop: unhandled dyn_type printout")
      endif

! =================================================================
!     Read iteration / electronic dynamics details
! =================================================================

! -----------------------------------------------------------------
!     ConvergenceControl:MaxNumberOfSteps -> niter (maximum outer electronic loops)
!                              for now : don't stop if (niter < 1)
!     ConvergenceControl%CPUTimeLimit     -> uppcpu (cpu time hard limit in hours)
! -----------------------------------------------------------------

      status = nfget(ncid, "ConvergenceControl%MaxNumberOfSteps", niter)
      if (status /= nfif_OK) niter = 1000000                ! niter default 
      if (niter > 0) lstowf=.true.

      write(nconso,410) 'ConvergenceControl - niter  = ', niter, &
                        '(max main loop iterations)'
     
      status = nfget(ncid, "ConvergenceControl%CPUTimeLimit",uppcpu)
      if (status /= nfif_OK) uppcpu = 1.0d8  ! no CPU time limit
 
      write(nconso,422) 'ConvergenceControl - uppcpu = ', uppcpu, &
                        'hours (cpu time hard limit)'

! -----------------------------------------------------------------
!     Critia for stopping electronic loop:
!     ConvergenceControl:AbsoluteEnergyConvergence -> energy_convergence
!       energy_convergence     : the max. absolute change in energy before stopping/moving atoms
!                                (10-6) 
!
!     ConvergenceControl:DensityConvergence -> density_convergence
!       density_convergence    : the change in density before stopping/moving atoms
!                                (0.0001)

!     ConvergenceControl:OccupationConvergence -> occupation_convergence
!       occupation_convergence : the change in density before stopping/moving atoms
!                                (0.001)
!
!     ConvergenceControl:RepeatedConvergences -> repeated_convergences
!       repeated_convergences  : the number of times that the other convergence criteria should be
!                                satisfied succesively, before stopping/moving atoms
!                                (1)
! -----------------------------------------------------------------

!     AbsoluteEnergyConvergence
      status=nfget(ncid,"ConvergenceControl%AbsoluteEnergyConvergence",&
                 energy_convergence) 
      if (status /= nfif_OK)      energy_convergence     = 1.0d-6

!     DensityConvergence
      status = nfget(ncid, "ConvergenceControl%DensityConvergence",&
                 density_convergence)
      if (status /= nfif_OK)      density_convergence    = 0.0001

!     OccupationConvergence
      status = nfget(ncid, "ConvergenceControl%OccupationConvergence",&
                 occupation_convergence)
      if (status /= nfif_OK)      occupation_convergence = 0.001

!     RepeatedConvergences
      status = nfget(ncid, "ConvergenceControl%RepeatedConvergences",&
                 repeated_convergences)
      if (status /= nfif_OK)      repeated_convergences = 1

!     write criteria for breaking electronic minimization
      write(nconso,400) "ConvergenceControl - "//&
                          "criteria for breaking electronic minimization:"
      write(nconso,423) 'ConvergenceControl - Absolute energy convergence = ',& 
                 energy_convergence
      write(nconso,423) 'ConvergenceControl - Absolute density convergence = ',& 
                 density_convergence
      write(nconso,423) 'ConvergenceControl - Absolute occupation convergence = ',& 
                 occupation_convergence
      write(nconso,421) 'ConvergenceControl - Repeated convergences = ',&
                 repeated_convergences

! -----------------------------------------------------------------
!     ConvergenceControl :   %Method = "Autopilot"  is default
!                        if %Method = "Autopilot" then get : 
!                                %Autopilot_MaxForce            / default -> fallmax
!                                %Autopilot_AbsoluteForceChange / default -> fvarmax
!                                %Autopilot_RelativeForceChange / default -> fchgmax
!                        else                       
!                           exception (no other settings are relevant currently)
!                        endif
!
!     Defaults for convergence parameters for ionic forces
!       fallmax : The max. value of the sum of alle forces                   = 0.05d0
!       fvarmax : the max. absolute change in the forces before moving ions  = 0.1d0
!       fchgmax : The max. relative change in the forces before moving ions  = 0.05d0
!       
! -----------------------------------------------------------------

      keyword = ""         ! clear buffer
      status = nfget(ncid, "ConvergenceControl%Method", keyword)
      if ((status == nfif_OK).and.&
          (index(keyword,"Autopilot") == 0)) then
         call abort_calc(nconso, "ConvergenceControl%Method = "// &
              trim(keyword) // " not known")
      else
        status = nfget(ncid, "ConvergenceControl%Autopilot_MaxForce",&
                 fallmax)     ! autopilot mode
        if (status /= nfif_OK)      fallmax = 0.05d0

        status = nfget(ncid, &
             "ConvergenceControl%Autopilot_AbsoluteForceChange",fvarmax)
        if (status /= nfif_OK)      fvarmax = 0.1d0

        status = nfget(ncid, &
             "ConvergenceControl%Autopilot_RelativeForceChange",fchgmax)
        if (status /= nfif_OK)      fchgmax = 0.05d0

        write(nconso,420) "ConvergenceControl - "//&
               "Max absolute force change   = ", fvarmax, "eV/A"
        write(nconso,420) "ConvergenceControl - "//&
               "Max relative force change   = ", fchgmax, " "

        if (iion /= 0) then                           ! write only if dynamics
          write(nconso,400) "ConvergenceControl - "//&
                          "criteria for stopping ionic motion:"
          write(nconso,420) "ConvergenceControl - "//&
               "Max force below           = ", fallmax, "eV/A"
        endif
    
      endif    
 

! ====================================================================================
!                                                                         >  default <
! set : 
!       ieigsolver     :  Which eigensolver is used  1:(resmin) 2:(eigsolve)
!                                                    3:(rmmdiss)             2
!       (occmix)       =  How much to accept of new occupation numbers       {0.2}  <inactive>
!       smethod        =  Broardening method                                 {-1}
!       width          =  fermi broardening [eV]                             {0.0}
!       ndiapb         =  diagonalizations per band                          {2}
! --------------
! * We do not check whether an alternate charge mixing scheme than "Pulay" has
!   been selected
! ====================================================================================

      keyword = ""         ! clear buffer
      status = nfget(ncid, "ElectronicMinimization%Method", keyword)
      if (status == nfif_OK) then
         if      (index(keyword,"NonSelfconsistent") > 0) then
            ieigsolver = 1             
             write(nconso,400) "Do not run self-consitent calculation:"
             write(nconso,400) "Return Hamiltonial matrix for the input"
             write(nconso,400) "wavefunctions"
             ! set the number of iteration to one 
             niter = 1
         elseif  (index(keyword,"eigsolve") > 0) then
            ieigsolver = 2
            write(nconso,400) "Using eigsolve to diag. the hamiltonian"
         elseif  (index(keyword,"rmm-diis") > 0) then
            ieigsolver=3
            write(nconso,400) "Using RMM-DIIS to diag. the hamiltonian"
         else
            call abort_calc(nconso,"Found an unrecognized option for" //&
                                   "ElectronicMinimization%Method : " //&
                                    trim(keyword) )
         endif
      else                                          !! set default
         ieigsolver = 2
         write(nconso,400) "Using eigsolve to diag. the hamiltonian"
      endif

!---------------------------------------------------------------
      keyword = ""         ! clear buffer
      status = nfget(ncid, &
         "ElectronicBands%OccupationStatistics", keyword)

      if (status /= nfif_OK) then
          smethod = -1
          write(nconso,420) "Occupation statistics type = FermiDirac"
      elseif (index(keyword, "FermiDirac") > 0) then
          smethod = -1
          write(nconso,420) "Occupation statistics type = FermiDirac"
      elseif (index(keyword, "MethfesselPaxton") > 0) then
          smethod = 1
          write(nconso,420) &
              "Occupation statistics type = MethfesselPaxton (1th order)"
      else
           call abort_calc(nconso,"Found an unrecognized option for" //&
                        "ElectronicBands%OccupationStatistics : "    //&
                         trim(keyword) )
      endif
!---------------------------------------------------------------
      status = nfget(ncid, &
         "ElectronicBands%OccupationStatistics_FermiTemperature", width)
      if (status /= nfif_OK)      width  = 0.2     ! set default 
      write(nconso,420) "FermiTemperature = ", width, " eV"

!---------------------------------------------------------------
!     see if occupation numbers should be fixed
!     (variable update_occupation_numbers held in run_context)
!--------------------------------------------------------------- 
      update_occupation_numbers = .true.           ! det default
      keyword = ""         ! clear buffer
      status = nfget(ncid, &
       "ElectronicBands%OccupationStatistics_UpdateOccupation",keyword)
      if (status == nfif_OK) then
         if (index(keyword,"No") > 0) then
            update_occupation_numbers = .false.
            write(nconso,420) &
              "Occupation numbers are not updated"
         endif
      endif

! -------------------------------------------------------------
      status = nfget(ncid, &
        "ElectronicMinimization%DiagonalizationsPerBand", ndiapb)
      if (status /= nfif_OK) ndiapb = 2                     ! ndiapb default 
      if (ndiapb < 1) call abort_calc(nconso, &
         "ElectronicMinimization%DiagonalizationsPerBand " //&
         "should be > 0 ")
      write(nconso,410) 'ndiapb = ', ndiapb, &
                        '(diagonalizations per band)'

! ------------------------------------------------------------------
!     double ExtraCharge  :  default 0.0
! ------------------------------------------------------------------

      status = nfget(ncid, "ExtraCharge", extracharge)  
      if (status /= nfif_OK) then
          extracharge = 0.0d0     
      else
        if (extracharge == nf_fill_double) extracharge = 0.0d0
      endif 

! ------------------------------------------------------------------
!     FixedMagneticMoment (rmagmo) :  default off -> rmagmo = 0.0 (ugly construct)
! ------------------------------------------------------------------  
  
      rmagmo = 0.0d0                               ! set default
      if (nspin == 2) then
         status = nfget(ncid, "ElectronicBands%FixedMagneticMoment", &
                        rmagmo) 
         if (status /= nfif_OK) rmagmo = 0.0d0     ! reset default

         if (dabs(rmagmo) > 1.d-7) then
           write(nconso,420) 'Magnetic moment constrained: rmagmo=',&
                             rmagmo, 'Bohr magnetons / unit cell'
         else
           write(nconso,400) 'Magnetic moment is unconstrained'
         endif
         
      endif

! ====================================================================
! char DipoleCorrection : if variable exist : idipol=1, else  idipol=0
! Direction is always along a3, for now
! MixingParameter, DipoleLayerPosition, InitialValue are attributes
! therefore the variable are untouched by nfget, if they are not set
!
! DipoleCorrection%InitialValue (user supplied)
! DipoleCorrection%RestartValue (dacapo output attribute; dominates InitialValue, if present)      
! DipoleCorrection%AdditiveDipoleField     :  default 0.0  V/A
!            ... additive to the compensating dipole field
! ====================================================================

      dipmix = 0.2d0      ! default mixing parameter 
      zdip   = 0.0d0      ! default initial dipole position
      dip0   = 0.0d0      ! default initial dipole value

      cdummy = ""   ! clear buffer
      status = nfget(ncid, "DipoleCorrection", cdummy)   
      if (status == nfif_OK ) then             ! dipole correction on
         idipol=1
         status = nfget(ncid, "DipoleCorrection%MixingParameter"  , &
                        dipmix)
         status = nfget(ncid, "DipoleCorrection%DipoleLayerPosition", &
                        zdip) 

         status = nfget(ncid, "DipoleCorrection%InitialValue", dip0) 
         status = nfget(ncid, "DipoleCorrection%RestartValue", dip0)

! ------ check, if an additive external filed has been requested ------     

         status = nfget(ncid, "DipoleCorrection%AdditiveDipoleField", &
                        extfie)  
         if (status /= nfif_OK) extfie = 0.0d0
           
      else                                    
         idipol=0                            ! dipole correction off 
      endif
  
  

! ------------------------------------------------------------------
!     double ExternalDipolePotential :  default 0.0  V
!         fixed, external potential jump
!         if ExternalDipolePotential set, then idipol=2
!         (overwrites DipoleCorrection)
!         ExternalDipolePotential%DipoleLayerPosition not set => 
!         optimized positioning of DipoleLayerPosition (zdip=0)
! ------------------------------------------------------------------

      status = nfget(ncid, "ExternalDipolePotential", extpot)  
      if (status /= nfif_OK) then 
          extpot = 0.0d0
      elseif (extpot == nf_fill_double) then
          extpot = 0.0d0
      else
          idipol=2                         ! freeze the dipole pot                    
          status = nfget(ncid, &
                   "ExternalDipolePotential%DipoleLayerPosition", zdip)
          if (status /= nfif_OK)  zdip = 0.0               
      endif

! --- dump dipole correction report ---

      if     (idipol == 0) then    !---------------------------------

         write(nconso,400) 'dipole correction: off'

      elseif (idipol == 1) then    !---------------------------------

         write(nconso,400) 'dipole correction: automatic'
         write(nconso,420) 'dipmix =', dipmix, &
                           '(Mixing parameter for dipole moment)'
         write(nconso,420) 'dip0   =', dip0,&
                           '[e * Angstroem] (Initial dipole moment)'
         write(nconso,420) 'External additive field:', extfie, ' V/A'
         
         if (dabs(zdip) < 1.0d-5) then
            write(nconso,400) "automatic location of dipole layer "//&
                              "position and value"
         else
            write(nconso,420) "fixed position of dipole layer =",&
                              zdip, " (in units of a3)"
         endif

      elseif (idipol == 2) then    !---------------------------------

         write(nconso,400) 'dipole correction: '//&
                           'constant external potential '
         write(nconso,420) 'External potential:', extpot, ' V'
         if (dabs(zdip) < 1.0d-5) then
            write(nconso,400) "automatic location of dipole layer "//&
                              "position and value"
         else
            write(nconso,420) "fixed position of dipole layer =",&
                              zdip, " (in units of a3)"
         endif

      endif 


! ======================================================================
!                       printout selectors
! ======================================================================

      write(nconso,400) " "
      write(nconso,400) " ------ printout setup ---------"
      write(nconso,400) " "

      wangul=0.25d0    ! set default
      enemin=-15.0d0   ! set default
      enemax=  5.0d0   ! set default
      nener = 100      ! set default (number of energy points for atomprojected dos)
      rcutoff = 2.0*bohr ! set default (cutoff for atom projected dos 2 bohr)


! ======================================================================
! set ispati : 
!  read in what spatially resolved entity to generate (only one entity 
!  controlled by ispati can be generated per calculation for now)
!  - no extra consistence checks here, likely to be upgraded later
!  0 = No
!  1 = The charge density
!  2 = State resolved charge density (band: nbspas and k-point: nkspas)
!  3 = Spatially resolved density of states                      ("s-type" in a energy window: stmcen,stmwid)
!  4 = Spatially resolved sum of wave function gradients squared ("p-type" in a energy window: stmcen,stmwid)
!  5 = x-y averaged DOS (only this option uses avebox(:,:) )     ( in a energy window by enemin,enemax,wangul!!)
!      avebox refers to scaled coordinates
! Keyword link : PrintSpatial%Quantity = "None"                 -> ispati = 0
!                PrintSpatial%Quantity = "TotalDensity"         -> ispati = 1
!                PrintSpatial%Quantity = "StateResolvedDensity" -> ispati = 2 
!                PrintSpatial%Quantity = "STM_s"                -> ispati = 3 
!                PrintSpatial%Quantity = "STM_p"                -> ispati = 4 
!                PrintSpatial%Quantity = "XYAveraged"           -> ispati = 5
! ======================================================================

      keyword = ""   ! clear buffer
      status = nfget(ncid, "PrintSpatial%Quantity", keyword)
      if (status == nfif_OK) then
         if (index(keyword, "None") > 0) then
            ispati = 0
         elseif  (index(keyword, "TotalDensity") > 0) then
            ispati = 1
         elseif  (index(keyword, "StateResolvedDensity") > 0) then
            ispati = 2
         elseif  (index(keyword, "STM_s") > 0) then
            ispati = 3
         elseif  (index(keyword, "STM_p") > 0) then
            ispati = 4
         elseif  (index(keyword, "XYAveraged") > 0) then
            ispati = 5
         else
            call abort_calc(nconso, "PrintSpatial%Quantity = "// &
                 trim(keyword) // " not known")
         endif
      else
         ispati = 0    ! default (no spatial printout)
      endif

      print_spatial_str(:) =     "                   ?"
      print_spatial_str(0:5) = (/"                None", &
                                 "        TotalDensity", &
                                 "StateResolvedDensity",&
                                 "               STM_s", &
                                 "               STM_p", &
                                 "          XYAveraged"/)

      write(nconso,402) "Print spatial quantity: ", &
                         trim(adjustl(print_spatial_str(ispati)))


      select case (ispati) 
      case (2)           ! ------ StateResolved : get band + kpoint ------
         status = nfget(ncid, &
            "PrintSpatial%StateResolvedDensity_BandNumber", nbspas)
         if (status /= nfif_OK) &
             call abort_calc(nconso, &
            "PrintSpatial%StateResolvedDensity_BandNumber not found")
         status = nfget(ncid, &
            "PrintSpatial%StateResolvedDensity_KpointNumber", nkspas)
         if (status /= nfif_OK) &
            call abort_calc(nconso, &
            "PrintSpatial%StateResolvedDensity_KpointNumber not found")
 
         write(nconso,412) 'state resolved band:   ', nbspas
         write(nconso,412) 'state resolved k-point:', nkspas
                            

      case (3:4)         ! ------ STM           : get window ------

         status = nfget(ncid, "PrintSpatial%STM_EnergyCenter", stmcen)
         if (status /= nfif_OK) &
             call abort_calc(nconso, "PrintSpatial%STM_EnergyCenter "//&
                             "not found")
         status = nfget(ncid, "PrintSpatial%STM_EnergyWidth", stmwid)
         if (status /= nfif_OK) &
             call abort_calc(nconso, "PrintSpatial%STM_EnergyWidth " //&
                             "not found")

        write(nconso,420) 'STM energy center:   ', stmcen, 'eV'
        write(nconso,412) 'STM resonance width: ', stmwid, 'eV'

      case (5)           ! ------  XYAverage     : get interval/width + avebox ------

         status = nfget(ncid, "PrintSpatial%XYAveraged_EnergyWindow", &
                        aux2)
         if (status == nfif_OK) then
           enemin = aux2(1) 
           enemax = aux2(2) 
           status = nfget(ncid, "PrintAtomProjectedDOS%EnergyWindow", &
                          aux2)
           if (status == nfif_OK) &
                call abort_calc(nconso, &
                "set only one of PrintAtomProjectedDOS%EnergyWindow " //&
                "and PrintSpatial%XYAveraged_EnergyWindow")
         endif
     
         status = nfget(ncid, "PrintSpatial%XYAveraged_EnergyWidth", f)
         if (status == nfif_OK) then
           wangul = f
           status = nfget(ncid, "PrintAtomProjectedDOS%EnergyWidth", f)
           if (status == nfif_OK) &
              call abort_calc(nconso, &
                "set only one of PrintAtomProjectedDOS%EnergyWidth "//&
                "and PrintSpatial%XYAveraged_EnergyWidth")
         endif
     
         avebox(:,:) = 0.0                    ! avebox(:,4) is inactive

         status = nfget(ncid, "PrintSpatial%XYAveraged_ZeroPoint", &
                        avebox(1:2, 1))
         if (status /= nfif_OK) avebox(1:2 ,1) = (/ 0, 0 /)
         status = nfget(ncid, "PrintSpatial%XYAveraged_Vector1", &
                        avebox(1:2, 2))
         if (status /= nfif_OK) avebox(1:2 ,2) = (/ 1, 0 /)
         status = nfget(ncid, "PrintSpatial%XYAveraged_Vector2", &
                        avebox(1:2, 3))
         if (status /= nfif_OK) avebox(1:2 ,3) = (/ 0, 1 /)

         write(nconso,420) "XYAveraged: lower energy edge =", &
                            enemin, " eV"
         write(nconso,420) "XYAveraged: upper energy edge =", &
                            enemax, " eV"
         write(nconso,420) "XYAveraged: spectral broardening =", &
                            wangul, " eV"
    
         write(nconso,424) "XYAveraged: avebox(zero)    = ", &
               avebox(1:2, 1), "(a1,a2)"
         write(nconso,424) "XYAveraged: avebox(vector1) = ", &
               avebox(1:2, 2), "(a1,a2)"
         write(nconso,424) "XYAveraged: avebox(vector2) = ", &
               avebox(1:2, 3), "(a1,a2)"

      case default
         continue
      end select
     
! -------------------------------------------------
!      Electronic Workfunction
! -------------------------------------------------

      cdummy = ""   ! clear buffer
      status = nfget(ncid, "PrintElectronicWorkfunction", cdummy)  
      if (status == nfif_OK) then
         lworkp=.true.
         write(nconso,400) "Electronic work function will be printed"
      else
         lworkp=.false.
         write(nconso,400) "Electronic work function not printed"
      endif
 
! -------------------------------------------------
!      Atomic projected DOS : get  enemin,enemax,nener,wangul (exclusive with 
!                                  PrintSpatial%XYAveraged parallels so
!                                  no (status /= OK) plug...)
! -------------------------------------------------
      cdummy = ""   ! clear buffer
      status = nfget(ncid, "PrintAtomProjectedDOS", cdummy)  

      if (status == nfif_OK) then
         langul=.true.
         write(nconso,400) "Atom projected DOS will be printed"

         status = nfget(ncid, "PrintAtomProjectedDOS%EnergyWindow", &
                        aux2)
         if (status == nfif_OK) then
           enemin = aux2(1) 
           enemax = aux2(2) 
         endif

         status = nfget(ncid, "PrintAtomProjectedDOS%EnergyWidth", f)
         if (status == nfif_OK) wangul = f

         status = nfget(ncid, "PrintAtomProjectedDOS%NumberEnergyPoints", i)
         if (status == nfif_OK) nener = i

         status = nfget(ncid, "PrintAtomProjectedDOS%CutoffRadius", f)
         if (status == nfif_OK) rcutoff = f
          
         
         write(nconso,420) "PrintAtomProjectedDOS: lower energy edge =", &
                            enemin, " eV"
         write(nconso,420) "PrintAtomProjectedDOS: upper energy edge =", &
                            enemax, " eV"
         write(nconso,420) "PrintAtomProjectedDOS: spectral broard.  =", &
                            wangul, " eV"
         write(nconso,421)   "PrintAtomProjectedDOS: number of energy points =", &
                            nener
         write(nconso,420)   "PrintAtomProjectedDOS: Cutoff radius (LDOS2) =", &
                            rcutoff," Angstrom" 

      else

         langul=.false.
         write(nconso,400) "Atom projected DOS not printed"
      endif
 

      write(nconso,400) " "
      write(nconso,400) " ------ atomic characteristics -------"
      write(nconso,400) " "

!=======================================================================
!     Read atomic characteristics  (set rdamp, rmass)
!=======================================================================
      ntypes = nspec            ! save this tmp

      rdamp(:) = 0.5d0          ! set defaults
      rmass(:) = 3.0d0          ! set defaults

! --- go through the type list and check whether (rdamp, rmass) ---
! --- has been provided for each species                        ---
    

      write(nconso, * )
      write(nconso,500)
      write(nconso,400) "species  chemical  friction  dynamic mass"  
      write(nconso,400) "number    symbol    [0..1]       [u]     "
      write(nconso,500)

      do  nn = 1, nspec
        
        keyword = "AtomProperty_" // trim( atom_symbol(ntype(nn))) // &
                  "%Dynamics_rdamp" 
        status = nfget(ncid, trim(keyword), f)
        if (status == nfif_OK) rdamp(nn) = f

        keyword = "AtomProperty_" // trim( atom_symbol(ntype(nn))) // &
                  "%Dynamics_rmass" 
        status = nfget(ncid, trim(keyword), f)
        if (status == nfif_OK) rmass(nn) = f
 
        write(nconso,8750) nn, adjustr( atom_symbol(ntype(nn)) ), &
                           rdamp(nn), rmass(nn)

      enddo 

      write(nconso,500)

!=======================================================================
!    initialize ityp  (number of atom -> type of atom - 
!    this should be moved to read_structure later) 
!=======================================================================
      nat = 1
      do nsp = 1,nspec 
        do mu = 1,nionsp(nsp)
          ityp(nat) = nsp
          nat = nat + 1
        enddo 
      enddo

!=======================================================================
! Read in the pseudopotentials and perform the Kleinman-Bylander proj. 
! (new interface - skipped support for old format)
!=======================================================================
      call nlread(ntype, &
            nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions,&
            nionsp,volc,nconso,nspec, mmaxx,npspts,&
            psp,pscore,psgmax,&
            iznuc,icharg,nlnum,mmax,rlog,radius,phiatm,rho_rad,&
            lspsi )


!=======================================================================
! calculate the total number of electrons, nelect
!=======================================================================
      nelect=0.0
      do nsp=1,nspec
        nelect=nelect+icharg(nsp)*nionsp(nsp)
      enddo
! Check if a extra charge should be added to the super cell
      lcharged = .false.
      if (dabs(extracharge).gt.0.000001) then 
!       add charge
        nelect=nelect + extracharge
!       set flag that is returned to libtos
        lcharged = .true.
        write(nconso,420) 'Extra charged added to unit cell: ',&
                           extracharge, 'electrons'
      else
        write(nconso,400) 'Unit cell is charge neutral'
      endif
      write(nconso,420) 'Unit cell contains:', nelect, 'electrons'

!=======================================================================
! form packed array containing the charges on the ions, icharc.
!=======================================================================
      nindx=1
      do nsp=1,nspec
        do ni=1,nionsp(nsp)
          icharc(nindx)=icharg(nsp)
          nindx=nindx+1
        enddo
      enddo
!=======================================================================
      if (2*nbands.lt.nelect) &
         call abort_calc(nconso,&
         ' Not enough bands (must be >= N_elect/2)')
       
      do nz=1,ngz
         vext(nz)=0.0d0
      enddo

      do nkp=1,nkprun
         noffs0(nkp)=0
      enddo

!=======================================================================
! initialize netcdf output controls 
! from netcdf variable NetCDFOutputControl.PrintWaveFunction  = 'No/Yes'
!                      NetCDFOutputControl.PrintChargeDensity = 'No/Yes'
!                      NetCDFOutputControl.PrintTotalStress   = 'No/Yes'
!                      NetCDFOutputControl.PrintEffPotential  = 'No/Yes(or Conv)/Step/Allways'
!                      NetCDFOutputControl.PrintElsPotential  = 'No/Yes(or Conv)/Step/Allways'
! output_wavefunction_to_netcdf, output_chargedensity_to_netcdf,
! output_effpotential_to_netcdf and output_elspotential_to_netcdf from 
! run_context are initialized, first 3 and ElsPot defaults true and EffPot defaults "false"=0
!=======================================================================
      cdummy = ""         ! clear buffer
      status = nfget(ncid, "NetCDFOutputControl", cdummy)
      if (status == nfif_OK) then              
!     ----------------------------------------
         keyword = ""         ! clear buffer
         status=nfget(ncid,"NetCDFOutputControl%PrintWaveFunction",keyword)
         if (status == nfif_OK) then           
            if     (index(keyword,"No") > 0) then
               output_wavefunction_to_netcdf = .false.
            endif
         endif
         keyword = ""         ! clear buffer
         status=nfget(ncid,"NetCDFOutputControl%PrintChargeDensity",keyword)
         if (status == nfif_OK) then           
            if     (index(keyword,"No") > 0) then
               output_chargedensity_to_netcdf = .false.
            endif
         endif
         keyword = ""         ! clear buffer
         status=nfget(ncid,"NetCDFOutputControl%PrintEffPotential",keyword)
         if (status == nfif_OK) then           
            if     (index(keyword,"No") > 0) then
               output_effpotential_to_netcdf = 0
            elseif     (index(keyword,"Step") > 0) then
               output_effpotential_to_netcdf = 1
            elseif     (index(keyword,"Yes") > 0.or.index(keyword,"Conv") > 0) then
               output_effpotential_to_netcdf = 2
            elseif     (index(keyword,"Allways") > 0) then
               output_effpotential_to_netcdf = 3
            endif
         endif

         ! Electrostatic potential
         keyword = ""         ! clear buffer
         status=nfget(ncid,"NetCDFOutputControl%PrintElsPotential",keyword)
         if (status == nfif_OK) then           
            if     (index(keyword,"No") > 0) then
               output_elspotential_to_netcdf = 0
            elseif     (index(keyword,"Step") > 0) then
               output_elspotential_to_netcdf = 1
            elseif     (index(keyword,"Yes") > 0.or.index(keyword,"Conv") > 0) then
               output_elspotential_to_netcdf = 2
            elseif     (index(keyword,"Allways") > 0) then
               output_elspotential_to_netcdf = 3
            endif
         endif

         ! stress
         keyword = ""         ! clear buffer
         status=nfget(ncid,"NetCDFOutputControl%PrintTotalStress", &
                        keyword)
         if (status == nfif_OK) then
            if     (index(keyword,"Yes") > 0) then
               output_totalstress_to_netcdf = .true.
            endif
            if     (index(keyword,"No") > 0) then
               output_totalstress_to_netcdf = .false.
            endif
         endif

      endif
      write(nconso,400) '  '
      write(nconso,400) 'netCDF output control'

      if (output_wavefunction_to_netcdf) then 
         write(nconso,400) 'Output WaveFunction to NetCDF file'
      else
         write(nconso,400) 'WaveFunction is not written to NetCDF file'
      endif

      if (output_chargedensity_to_netcdf) then 
         write(nconso,400) 'Output ChargeDensity to NetCDF file'
      else
         write(nconso,400) 'ChargeDensity is not writen to NetCDF file'
      endif

      if (output_effpotential_to_netcdf.eq.0) then 
         write(nconso,400) 'Eff. Potential not writen to NetCDF file'
      elseif(output_effpotential_to_netcdf.eq.1) then
         write(nconso,400) 'Eff. Potential written to NetCDF file after step'
      elseif(output_effpotential_to_netcdf.eq.2) then
         write(nconso,400) 'Eff. Potential written to NetCDF file after convergence'
      elseif(output_effpotential_to_netcdf.eq.3) then
         write(nconso,400) 'Eff. Potential written to NetCDF file after each step of electron minimization'
      endif

      if (output_elspotential_to_netcdf.eq.0) then 
         write(nconso,400) 'Electrostatic potential not writen to NetCDF file'
      elseif(output_elspotential_to_netcdf.eq.1) then
         write(nconso,400) 'Electrostatic potential written to NetCDF file after step'
      elseif(output_elspotential_to_netcdf.eq.2) then
         write(nconso,400) 'Electrostatic potential written to NetCDF file after convergence'
      elseif(output_elspotential_to_netcdf.eq.3) then
         write(nconso,400) 'Electrostatic potential written to NetCDF file after each step of electron minimization'
      endif

      if (output_totalstress_to_netcdf) then 
         write(nconso,400) 'Output stresstensor to NetCDF file'
      else
         write(nconso,400) 'Stress tensor is not written to NetCDF file'
      endif
! -----------------------------------------------------------
! grounded variables (Asbjorn.12Jul1999)
! -----------------------------------------------------------

      ibacwf = 0       ! backup frequency of the WF - this functionality is
                       ! currently not supported
      ireset = 1       ! do not know what this is
      ldelin=.false.   ! (always -> false in xdacapo - might be reactivated later)


      write(nconso,500) 

! -----------------------------------------------------------
! close NetCDF file
! -----------------------------------------------------------
      status = nf_close(ncid)

      return  
      
! --- overall format statements ---

 400  format(1x,'setuop: ',a)
 402  format(1x,'setuop: ',a,1x,a)
 410  format(1x,'setuop: ',a,1x,i12,1x,a)
 412  format(1x,'setuop: ',a,1x,i12)
 420  format(1x,'setuop: ',a,1x,f12.6,1x,a)
 421  format(1x,'setuop: ',a,1x,i4)
 422  format(1x,'setuop: ',a,1x,f12.2,1x,a)
 423  format(1x,'setuop: ',a,1x,D8.2 ,1x,a)
 424  format(1x,'setuop: ',a,f12.6,1x,f12.6,a)
 500  format(1x,'setuop: ',64("-"))
8750  format(1x,'setuop: ',i4,8x,a2,1x,2f12.6)

      end
