      module read_basic_dimensions_variables_module

#include "definitions.h"

      contains
c        subroutine read_basic_dimensions_variables

c=====================================================================
      subroutine read_basic_dimensions_variables(
     &       nions,nspec,nspin,
     &       rlatc,dirc,diri,recc,reci,
     &       ecut,gkp123,nionsp,posion,rvelo,rmove,atomic_number,
     &       iscxc, nbands, nkpmem, noldrd, idebug, 
     &       nconso)
c=====================================================================
c
c     read required dimensions and variables
c       dirc   : unitcell
c       nions  : number of ions             
c                (from the number of positions found in fort.15>
c       nspec  : number of different atoms  
c                (from the number of different atoms found in fort.15)                   
c       gkp123 : k-points         (allocated)
c       posion : atomic positions (allocated) 
c       rvelo  : atomic velocity  (allocated)
c       rmove  : dynamic factor   (allocated)
c       atomic_number  : type     (allocated)
c       iscxc  : exchange-correlation functional (1:PZ LDA  2:VWN LDA 3:PW91 GGA ... )
c       nbands : number of electronic bands
c       nkpmem : number of k-points in memory 
c       noldrd : max number of density used in Pulay mixing
c       idebug : debug level
c
c=======================================================================          
      implicit none
#include "van_us_def.h"
      integer nions,nspec,nspin
      real*8   ecut
      real*8   rlatc,dirc(3,3),diri(3,3),recc(3,3),reci(3,3) 
      real*8 , pointer :: posion(:,:,:)
      real*8 , pointer :: gkp123(:,:)
      real*8 , pointer :: rmove(:,:)
      real*8 , pointer :: rvelo(:,:)
      integer, pointer :: nionsp(:)
      integer, pointer :: atomic_number(:)
      integer  iscxc, nbands, nkpmem, noldrd, idebug 
      integer  nconso

c     locals 
      integer maxatoms,maxnspec
      parameter(maxatoms=50,maxnspec=20)

      real*8  posx,posy,posz
      integer nat,ng,ni,icoor,n,j,nsp,newtyp,ntypes,ntyp,i
      real*8  volc,voli,rlati
      real*8  rvelo1(3,maxatoms,maxnspec),rmove1(3,maxatoms,maxnspec)
c     array for reading in 
      real*8 posionr(3,maxatoms,maxnspec),gkp123r(3,maxatoms)
      real*8 rmover(3,maxatoms),rvelor(3,maxatoms)
      integer nionspr(maxatoms),ntyper(maxatoms)


c     set the number of spins
      nspin = 1
       
c     read from fort.15 
      open(15,FILE='fort.15',STATUS='OLD')
c     find the unitcell

      read(15,*) rlatc
      read(15,*) dirc(1,1), dirc(2,1), dirc(3,1)
      read(15,*) dirc(1,2), dirc(2,2), dirc(3,2)
      read(15,*) dirc(1,3), dirc(2,3), dirc(3,3)
      read(15,*) rlati
      read(15,*) diri(1,1), diri(2,1), diri(3,1)
      read(15,*) diri(1,2), diri(2,2), diri(3,2)
      read(15,*) diri(1,3), diri(2,3), diri(3,3)
      do 5700 j=1,3
        do 5710 i=1,3
          dirc(i,j)=dirc(i,j)*rlatc
          diri(i,j)=diri(i,j)*rlati
 5710   continue
 5700 continue
      call bastr(dirc,recc,volc)
      call bastr(diri,reci,voli)
      ng=1
      ntypes=0
      read(15,5720) icoor
 5720 format(1x,i1,1x)


c ===================================================================
c Write unitcell
c====================================================================
      write(nconso,*) ' Basis-set for placing atoms ',
     &                                            '( dirc(i,j) ): '
      write(nconso,100) ('Dirc',j,(dirc(i,j), i=1,3), j=1,3)
      write(nconso,100) ('Recc',j,(recc(i,j), i=1,3), j=1,3)
      write(nconso,*)
     &        ' Basis-set for cutting off plane-waves ',
     &                                            '( diri(i,j) ): '
      write(nconso,100) ('Diri',j,(diri(i,j), i=1,3), j=1,3)
 8000 format(1x,'LAT: ','lattice_constant: ',f12.8)
 8100 format(1x,'LAT: ',a4,i1,1x,3f12.8)
      write(nconso,8000) rlatc
      write(nconso,8100) ('Dirc',j,(dirc(i,j)/rlatc, i=1,3), j=1,3)
 100  format(1x,a4,i1,1x,3f12.8)

c===================================================================
                                                                                   

      nions = 0  
c     read positions of atoms, atomic number and initial velocities
      do n=1,maxatoms
        read(15,*,end=110,err=110) posx,posy,posz,
     &         (rmover(i,ng),i=1,3),ntyp,(rvelor(i,ng),i=1,3)
        write(*,*) 'read ',n,posx,posy,posz,
     &  (rmover(i,ng),i=1,3),ntyp,(rvelor(i,ng),i=1,3)
        if (ntyp.le.0) goto 110  ! temp. fix for alpha
        call uflush(18)
        nions = nions + 1
        do  i=1,ntypes
          if (ntyper(i).eq.ntyp) then
            newtyp=i
            nionspr(i)=nionspr(i)+1
            go to 7075
          endif
        enddo  
c=======================================================================
c This is the first core of a new type
c=======================================================================
        ntypes=ntypes+1

        newtyp=ntypes
        ntyper(newtyp)=ntyp
        nionspr(newtyp)=1
c=======================================================================
 7075   continue
        ni=nionspr(newtyp)
        nsp=newtyp
c       remember also to reorder rmove and rvelo
        do i = 1,3
          rmove1(i,ni,nsp) = rmover(i,ng)
          rvelo1(i,ni,nsp) = rvelor(i,ng)
        enddo
        write(*,*) 'posionr ',n,ni,nsp,posx,posy,posz
        posionr(1,ni,nsp)=posx
        posionr(2,ni,nsp)=posy
        posionr(3,ni,nsp)=posz

        ng=ng+1

      enddo   

110   continue
      
      nspec = ntypes
      write(nconso,*) 'INIT: Number of atoms (nions)           ',nions
      write(nconso,*) 'INIT: Number of different atoms (nspec) ',nspec
      call uflush(nconso)

c=======================================================================
c reorder rmove, rvelo
c and make sure that all static degree of freedom has zero velocities
       nat = 1
       do nsp = 1,nspec
         do ni = 1,nionspr(nsp)
           do i = 1,3
             rmover(i,nat) = rmove1(i,ni,nsp)
             rvelor(i,nat) = rvelo1(i,ni,nsp)
             if (rmover(i,nat).lt.0.000001)  rvelor(i,nat) = 0.0d0
           enddo
           nat = nat + 1
         enddo
       enddo                                                    

c      allocate arrays 
       allocate( posion(3,nions,nspec))
       allocate( rvelo(3,nions))
       allocate( rmove(3,nions))
       allocate( atomic_number(nspec))
       allocate( nionsp(nions))
c      now reshape 
c      posion         = reshape(source=posionr,shape=(/3,nions,nspec/))
       rmove          = reshape(source=rmover ,shape=(/3,nions/))
       rvelo          = reshape(source=rvelor ,shape=(/3,nions/))
       rmove          = reshape(source=rmover ,shape=(/3,nions/))
       atomic_number  = reshape(source=ntyper ,shape=(/nspec/))
       nionsp         = reshape(source=nionspr ,shape=(/nions/))

c=======================================================================
c write out ionic positions
c=======================================================================
c scaled space
      ng=1
      do nsp=1,nspec
       do ni=1,nionsp(nsp)
        posion(1,ni,nsp) = posionr(1,ni,nsp)
        posion(2,ni,nsp) = posionr(2,ni,nsp)
        posion(3,ni,nsp) = posionr(3,ni,nsp)
        write(nconso,7004) 'Ion123',ng,ni,nsp,posion(1,ni,nsp),
     &            posion(2,ni,nsp),posion(3,ni,nsp),
     &            (rmove(i,ng),i=1,3),atomic_number(nsp),ni,nsp,
     &            (rvelo(i,ng),i=1,3)
        ng=ng+1
       enddo
      enddo
 7004 format(1x,a6,2i4,i2,1x,3f12.8,4x,3f4.1,3i3,3f7.4)
 7006 format(1x,a6,2i4,i2,1x,3f12.6,4x,3f4.1,3i3,3f7.4)

c real space                                                                       
       ng = 1
       do nsp = 1,nspec
         do ni = 1,nionsp(nsp)
           ntyp = atomic_number(nsp)
           write(nconso,7006) 'Ionxyz',ng,ni,nsp,
     &     dirc(1,1)*posion(1,ni,nsp)+
     &     dirc(2,1)*posion(2,ni,nsp)+dirc(3,1)*posion(3,ni,nsp),
     &     dirc(1,2)*posion(1,ni,nsp)+
     &     dirc(2,2)*posion(2,ni,nsp)+dirc(3,2)*posion(3,ni,nsp),
     &     dirc(1,3)*posion(1,ni,nsp)+
     &     dirc(2,3)*posion(2,ni,nsp)+dirc(3,3)*posion(3,ni,nsp),
     &     (rmove(i,ng),i=1,3),ntyp,ni,nsp,
     &     (rvelo(i,ng),i=1,3)                      
           ng = ng + 1
         enddo 
       enddo

c======================================================================

c      jump back one step, because we have read the number of k-points
       backspace(15)
       backspace(15)
       backspace(15)
#ifdef DECALPHA
       backspace(15)
#endif

c      read parameters from param.dat
       open(17,file='param.dat',status='OLD') 
       read(17,*) iscxc  
       read(17,*) nbands
       read(17,*) nkpmem
       read(17,*) noldrd
       read(17,*) idebug
       read(17,*) nspin
       close(17) 

       write(nconso,10)  'iscxc',iscxc 
       write(nconso,10)  'nbands',nbands
       write(nconso,10)  'nkpmem',nkpmem
       write(nconso,10)  'noldrd',noldrd
       write(nconso,10)  'idebug',idebug
       write(nconso,10)  'nspin',nspin
10     format(1x,'param.dat',1x,a10,1x,i3)

       


      end subroutine read_basic_dimensions_variables 

      end module  read_basic_dimensions_variables_module

