      subroutine pvmerr (nconso, text, info)

!     @(#)pvm.F	1.2 9/24/96
!     Print out the PVM error message corresponding to "info"

      include 'fpvm3.h'
      integer nconso, info
      character*(*) text
      character*80 msg

      if (info .ge. 0) return

      if      (info .eq. PvmOk         ) then
        msg = 'OK'
      else if (info .eq. PvmBadParam   ) then
        msg = 'bad parameter'
      else if (info .eq. PvmMismatch   ) then
        msg = 'barrier count mismatch'
      else if (info .eq. PvmNoData     ) then
        msg = 'read past end of buffer'
      else if (info .eq. PvmNoHost     ) then
        msg = 'no such host'
      else if (info .eq. PvmNoFile     ) then
        msg = 'no such executable'
      else if (info .eq. PvmNoMem      ) then
        msg = 'cannot get memory'
      else if (info .eq. PvmBadMsg     ) then
        msg = 'cannot decode received msg'
      else if (info .eq. PvmSysErr     ) then
        msg = 'pvmd not responding'
      else if (info .eq. PvmNoBuf      ) then
        msg = 'no current buffer'
      else if (info .eq. PvmNoSuchBuf  ) then
        msg = 'bad message id'
      else if (info .eq. PvmNullGroup  ) then
        msg = 'null group name is illegal'
      else if (info .eq. PvmDupGroup   ) then
        msg = 'already in group'
      else if (info .eq. PvmNoGroup    ) then
        msg = 'no group with that name'
      else if (info .eq. PvmNotInGroup ) then
        msg = 'not in group'
      else if (info .eq. PvmNoInst     ) then
        msg = 'no such instance in group'
      else if (info .eq. PvmHostFail   ) then
        msg = 'host failed'
      else if (info .eq. PvmNoParent   ) then
        msg = 'no parent task'
      else if (info .eq. PvmNotImpl    ) then
        msg = 'function not implemented'
      else if (info .eq. PvmDSysErr    ) then
        msg = 'pvmd system error'
      else if (info .eq. PvmBadVersion ) then
        msg = 'pvmd-pvmd protocol mismatch'
      else if (info .eq. PvmOutOfRes   ) then
        msg = 'out of resources'
      else if (info .eq. PvmDupHost    ) then
        msg = 'host already configured'
      else if (info .eq. PvmCantStart  ) then
        msg = 'failed to exec new slave pvmd'
      else if (info .eq. PvmAlready    ) then
        msg = 'slave pvmd already running'
      else if (info .eq. PvmNoTask     ) then
        msg = 'task does not exist'
      else if (info .eq. PvmNoEntry    ) then
        msg = 'no such (group,instance)'
      else if (info .eq. PvmDupEntry   ) then
        msg = '(group,instance) already exists'
      else
        msg = '(unknown message)'
      endif

      write (nconso,100) text, msg
100   format (' PAR: PVM ', a, ': ', a)
      call uflush (nconso)

      call clexit (nconso)

      return
      end
