#include "definitions.h"
      subroutine potinit_id(nconso)
      write(nconso,*) '@(#)potinit.F	1.22 7/1/99'
      return
      end
!-----------------------------------------------------------------------
      subroutine potinit( mmaxx,mmax,rlog,radius,&
                          recc, rdensr,charge_density_initialized,& 
                          lmastr,&
#                         include "potential_args.h"
#                         include "apply_h_args.h" 
                          ,timer)
!
!     Setup the effective potential cveff for a density constructed 
!     as a superposition of atomic densities (rho_atm from readvan.h)
!-----------------------------------------------------------------------
!
      use run_context
      use netcdfinterface
      use van_us_data_module
#ifdef PARAL
      use par_functions_module 
#endif
      implicit none
#     include "apply_h_decl.h"
#     include "potential_decl.h"
      include 'readvan.h'
      integer   mmaxx,mmax(nspec)
      real*8    rlog(nspec)  
      real*8    radius(mmaxx,nspec),recc(3,3),rdensr(nplwv,nspin)
      logical*4 charge_density_initialized
      logical*4 lmastr
      real*8    timer(*)
      integer   idebug 
      parameter(idebug=0)
!**
      complex*16, allocatable :: aux(:),strfac(:)
      real*8     aux1(ndm)
      real*8     rhoc, g2, g2a, gx,jx, arg, xyz(3),fac,rinplw,dens
      integer    i, ng, ik,mu,nsp,ispin,m,status,ncid
      real*8     localmom(nions)
      real*8     eps ,ZERO
      parameter(eps=1.d-8,ZERO=0.0d0)

      logical    new_shell_found
      integer ionno,errno,n,np,icheck,nOK
      real*8 sw(nions,nspin), lden, x
!     character(len = 4)  :: as_string4
#include "ms.h"
      

!     allocate work arrays 
      allocate(aux(nplwv),STAT=icheck)
      if (icheck.gt.0) call abort_calc(nconso,&
       'potinit: error allocating aux. error = '//as_string4(icheck)) 
      allocate(strfac(ngdens_max),STAT=icheck)
      if (icheck.gt.0) call abort_calc(nconso,&
       'potinit: error allocat. strfac. error = '//as_string4(icheck)) 

      if (.not.charge_density_initialized) then 

         if (nspin.gt.1) then 

!           setup initial local magnetic moment (for Harris density)

!           default no spin polarization 
            do ionno = 1,nions
               sw(ionno,1) = .5d0
               sw(ionno,2) = .5d0
            enddo

!           look for local magnetic moment in the  netCDF variable 
!           InitialAtomicMagneticMoment

            if (lmastr) then 

               status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)
               if (status /= nf_noerr) call abort_calc(nconso, &
                 "potinit -> nf_open : error opening nc-file")

               localmom = 0.0d0  ! set default
               status = nfget(ncid,'InitialAtomicMagneticMoment',localmom) 
               if (status /= nfif_OK ) goto 573

               status = nf_close(ncid)
               if (status /= nf_noerr) call abort_calc(nconso, &
                      "potinit -> nf_close : error closing nc-outfile")

            endif ! lmastr

#ifdef PARAL
            ! send localmom to slaves 
            call mspack_double_array (nconso, ANY, MSG_SETUP,&
                   REAL8,    localmom, nions, nOK)
#endif


!           convert localmom corresponding to internal atom order 

            call Reorder_atomvector(nconso, localmom, &
                                    "netCDF_to_internal")

            write(nconso,*) 'POTINIT: local magnetic moments found'
            write(nconso,*) 'POTINIT: defined in netCDF variable: '//&
                            'InitialAtomicMagneticMoment' 
            ionno = 1
            do nsp = 1,nspec
              do np = 1,nionsp(nsp)
                x = .5d0*localmom(ionno)/dble(icharg(nsp))
                sw(ionno,1)=.5d0+x
                sw(ionno,2)=.5d0-x
                write(nconso,570) 'POTINIT: local moments on atom ',&
                      ionno  ,' = ',localmom(ionno)
 570            format(1x,a32,1x,i3,1x,a3,1x,f8.5)
                ionno = ionno + 1
              enddo
            enddo
            goto 1000

 573        write(nconso,*) 'POTINIT: Setup density not spin polarized' 
            goto 1000

    
         else    ! nspin.gt.1 
            do ionno = 1,nions
              sw(ionno,1) = 1.0d0
            enddo
         endif

!-----------------------------------------------------------------------
1000     continue

         do ispin = 1,nspin

           ionno = 1
           aux(1:nplwv) = dcmplx(0.0d0,0.0d0)
           do nsp = 1,nspec
            do mu = 1,nionsp(nsp)
!
!             setup the structure factor for this atom
              call xyzpos(posion(1,mu,nsp),dirc,xyz)
              do ik=1,ngdens_max 
                  arg = (g(ik,1)*xyz(1) + g(ik,2)*xyz(2)&
                         + g(ik,3)*xyz(3))               
                  strfac(ik) = dcmplx(cos(arg),-sin(arg))
              enddo                                           

              do ng = 1,ngdens_max
                  new_shell_found = .false.
                  if (ng.eq.1) then
                     new_shell_found = .true.
                  else 
                     if (abs(gg(ng)-gg(ng-1)).gt.EPS) then
                       new_shell_found = .true.
                     endif 
                  endif 
                  if (new_shell_found) then  
                     g2 = gg(ng)*tpiba2
                     g2a = sqrt(g2)*bohr
                     do i=1, mmax(nsp)
                        gx = g2a*radius(i,nsp)
                        dens = rho_at(i,nsp)
                        if (gx .lt. EPS) then
                           aux1(i) = dens*sw(ionno,ispin)
                        else 
                           aux1(i) = sin(gx)/gx*dens*sw(ionno,ispin)
                        endif
                     end do
                     call radlg(mmax(nsp),aux1,radius(1,nsp),&
                                rlog(nsp),rhoc)
                  end if
                  aux(ipwpadG(ng,0)) = aux(ipwpadG(ng,0))+strfac(ng)*&
                                       rhoc
100               continue
              end do        
              ionno = ionno + 1
            end do    ! mu
           end do     ! nsp

#ifdef DEBUG
           if (nspin.gt.1) then 
             write(nconso,580) &
                    'POTINIT: Number of setup electrons for spin ',&
                     ispin, ' = ', dble(aux(1))
 580         format(1x,a45,i1,a3,f12.6)
           else 
             write(nconso,*) 'POTINIT: Number of setup electrons ',&
                     aux(1)
           endif 
           call uflush(nconso)
#endif
!          convert aux to realspace
           call fft3d(aux, ngx,ngy,ngz,1)

           do i = 1,nplwv
             rdensr(i,ispin) = dble(aux(i))
           enddo

        enddo  ! ispin = 1,nspin

      endif    ! if not charge_density_initialized
      if (idebug.gt.0) then 
       write(nconso,*) 'POTINIT: rdensr ',rdensr(10,1),rdensr(100,1)
      endif


!     -----------------------------------------------------------
!     now aux contains the real space charge density 
!     get the effective potential cveff
      if (idebug.gt.0) then 
        write(nconso,*) 'POTINIT: calculate effective potential'
      endif
      call uflush(nconso)
      call tidyup(nplwv,npwxc,rdensr,rho_core,&
                 enhac,dirdat,cveff,volc,enxcc ,&
                 enxc,excdat,xcfdat,xcpdat,nxc,cvion,&
                 recc,lpctx,lpcty,lpctz,vxc,dnlg0,cwork1,&
                 iscxc,nspin,ngx,ngy,ngz,ngxs,ngys,ngzs,cveff_soft,&
                 deltav,ngdens_soft,nrplwv,ipwpadG_soft,&
                 nconso,idebug,timer)

!     ----------------------------------------------------------
!     get deeq matrix
      call newd(nions,nspec,nionsp,nplwv,nrplwv,nrplwv_global,&
         nbands,nkprun, ngx,ngy,ngz,posion,dirc,volc,cveff,&
         nspin,idebug,nconso&
#ifdef PARAL
             ,&
#include PARAL_ARGS
#endif
             ,timer)

!     deallocate workarrays 
      deallocate(aux,strfac) 


      return 
      end
!
