#include "definitions.h"
       subroutine pbeunid(nconso)
       write(nconso,*) '@(#)pbeunsp.F	4.3 3/25/98'
       return
       end
!=======================================================================
!   subroutines generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991).  they are keyed to the "programmable
!       expressions" in the notes of 1/23/91.
!=======================================================================
      subroutine pbeunsp(lgga,lcalvx,&
           nconso,dn,volc,recc,lpctx,lpcty,lpctz,&
           enxcc,enxc,ex,vxc,&
           cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc,ukfactor,timer)
!
!
! The pw() is called with two flags, lcalvx and lgga:
!
!  lgga   lcalvx  E_LDA  V_LDA  E_GGA  V_GGA
!   FALSE  TRUE    yes    yes    no     no
!   TRUE   FALSE   yes    no     yes    no
!   TRUE   TRUE    no     no     yes    yes
!
!   if ukfactor > 0 :  PBE96 or revPBE98 functionals
!   if ukfactor= 0  :  RPBE98 functional
!
      use stress_module, only : xc_gga_stress  
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      logical*4 lcalvx
      integer nconso,nplwv,nspin
      integer ngx,ngy,ngz
      real*8 volc
      dimension recc(3,3)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 enxc,enxcc,enxcc1l,enxcc1g,enxcc2
      dimension vxc(nplwv)
      dimension dn(nplwv)
      dimension cwork1(nplwv)
      dimension dnlg0(npwxc,3)
      logical*4 lgga
      real*8 exclda,excgga
      real*8 timer(*)
#include "etime.h"
! work arrays required no matter what lcalvx is
      dimension absnab(nplwv)
      dimension cab(nplwv)
! work arrays required when lcalvx is TRUE
      dimension dnabln(npwxc,3)
      dimension df2(npwxc)
      dimension densp(npwxc)
!=======================================================================
      data pi,thrd,thrd2/3.14159265d0,0.333333333333d0,0.666666666667d0/
      data hartre/27.2116d0/
!=======================================================================
      bohr = 0.529177d0
      angs = 1.0d0/bohr
      rconf = (3.0d0*pi**2)**thrd
      rconrs = (3.0d0/(4.0d0*pi))**thrd
      vol = volc / (bohr**3)
      recvol=1.0d0/vol
      rinplw=1.0d0/dble(nplwv)
!
      if (lgga) then
         do m=1,nplwv
            cab(m)=dn(m)*rinplw
         enddo
      endif

!     call uttime(time)
!     timer(TXC1)=timer(TXC1)-time(1)
!     timer(TXC2)=timer(TXC2)-time(1)
!
! find the density gradient
!
      if (lgga.and.lcalvx) then
!
! we have lots of workspace
!
!
! Truncate charge density dn(m) to a slightly positive value
! (even for negative densities)
! so that the functional makes sense.
! we only have the workarray, densp, if running selfconsistently
!
         do m=1,nplwv
            densp(m) = max(1.0d-10, dn(m)) * recvol
         enddo
         call fft3d(cab,ngx,ngy,ngz,-1)
!=======================================================================
! loop over x,y,z to get nabla n -> dnabln(1..nplwv,1..3)
! and |nabla n| -> absnab(1..nplwv)
!=======================================================================
         do 1504 i=1,3
            do 1506 m=1,nplwv
               cwork1(m)=dcmplx(0.0d0,dnlg0(m,i))*cab(m)
 1506       continue
            call fft3d(cwork1,ngx,ngy,ngz,1)
!        For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1) then
               do 1508 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=dnabln(m,i)**2
 1508          continue
            else if (i.eq. 2) then
               do 1509 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=absnab(m)+dnabln(m,i)**2
 1509          continue
            else if (i.eq. 3) then
               do 1510 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=sqrt(absnab(m)+dnabln(m,i)**2)
                  if (absnab(m) .lt. 1.0d-10) absnab(m) = 1.0d-10
 1510          continue
            endif
 1504    continue
      else if (lgga.and..not.lcalvx) then
!
! we have almost no workspaces
!
         call fft3d(cab,ngx,ngy,ngz,-1)
!=======================================================================
! loop over x,y,z to get nabla n -> dnabln(1..nplwv,1..3)
! and |nabla n| -> absnab(1..nplwv)
!=======================================================================
         do i=1,3
            n=1
            do nz=1,ngz
               g3i=recc(3,i)*lpctz(nz)
               do ny=1,ngy
                  g2i=recc(2,i)*lpcty(ny)
                  do nx=1,ngx
                     g1i=recc(1,i)*lpctx(nx)
                     cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                     n=n+1
                  enddo
               enddo
            enddo
            call fft3d(cwork1,ngx,ngy,ngz,1)
!        For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1) then
               do m=1,nplwv
                  absnab(m)=dble(cwork1(m))**2
               enddo
            else if (i.eq. 2) then
               do m=1,nplwv
                  absnab(m)=absnab(m)+dble(cwork1(m))**2
               enddo
            else if (i.eq. 3) then
               do m=1,nplwv
                  absnab(m)=sqrt(absnab(m)+dble(cwork1(m))**2)
                  if (absnab(m) .lt. 1.0d-10) absnab(m) = 1.0d-10
               enddo
            endif
         enddo
      endif
!     call uttime(time)
!     timer(TXC2)=timer(TXC2)+time(1)
!=====================================================================
!       generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991). 
!=======================================================================
      elo=0.0d0
      enxlda=0.0d0
      enxgga=0.0d0
      enclda=0.0d0
      encgga=0.0d0
      if (lcalvx) then
         enxcc1l=0.0d0
         enxcc1g=0.0d0
      endif
!=====================================================================
! loop over all real space grid points in the super cell
!=====================================================================
      do 5558 m=1,nplwv
         if (lgga.and.lcalvx) then
            d = densp(m)
         else
            d = max(1.0d-10, dn(m)) * recvol
         endif
        d13=exp(log(d)*thrd)
        fk=rconf*d13
        if (lgga) then
           drho = absnab(m)*(bohr*recvol)
        else
           drho = 0.0d0
        endif
        s=drho/(d*fk*2.d0)
        call exchpbe(d,d13,s,exlda,exgga,exdlda,exdgga,exdd,ukfactor)
        enxlda=enxlda+exlda
        enxgga=enxgga+exgga
        if(lcalvx) then
           enxcc1l=enxcc1l-exdlda*d
           enxcc1g=enxcc1g-exdgga*d
           if(lgga) then
              vxc(m)=exdgga*hartre
              df2(m)=exdd*hartre
           else
              vxc(m)=exdlda*hartre
           endif
        endif

         rs=rconrs / d13
         sk = sqrt(fk*(4.0d0/pi))
         t=drho/(d*sk*2.d0)
         call corunsppbe(rs,eclda,ecdlda,sk,&
                     t,h,ecdgga,ecdd,lgga)

! local correlation

         enclda=enclda+eclda*d
         encgga=encgga+eclda*d
         if(lcalvx) then
            enxcc1l=enxcc1l-ecdlda*d
            enxcc1g=enxcc1g-ecdlda*d
            vxc(m)=vxc(m)+ecdlda*hartre
         endif

!  nonlocal correlation:

         if (lgga) then
            encgga=encgga+h*d
            if(lcalvx) then
               enxcc1g=enxcc1g-ecdgga*d
               vxc(m)=vxc(m)+ecdgga*hartre
               df2(m)=df2(m)+ecdd*hartre
            endif
         endif

! Lieb-Oxford bound:

         if (.not.lcalvx) then
            elo=elo+exp(4.0d0/3.0d0*log(d))
         endif


 5558 continue
!
      if (lgga.and.lcalvx) then
         enxcc2=0.0d0
         do 7010 i=1,3
            do 7020 m=1,nplwv
              cwork1(m)=-rinplw*df2(m)*dnabln(m,i)/absnab(m)
 7020       continue
            call fft3d(cwork1,ngx,ngy,ngz,-1)
            if (i .eq. 1) then
              do 7030 m=1,nplwv
                cab(m)=       dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7030         continue
            else
              do 7031 m=1,nplwv
                cab(m)=cab(m)+dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7031         continue
            endif
 7010    continue
         call fft3d(cab,ngx,ngy,ngz,1)
         do m=1,nplwv
            vxc(m)=vxc(m)+dble(cab(m))*bohr
            enxcc2=enxcc2-dble(cab(m))*(densp(m)*(1.0/recvol))
         enddo
!        calculate GGA stress contribution
!        se Corso and Resta, PRB 50, 4327 (1994)
!        eg. 24 second term (fist term calculated in stress.F)
!        sum(R) dfxc/d(d_x1n) * dn/dr_x2
         call xc_gga_stress(ngx,ngy,ngz, df2,dnabln,absnab,volc)
      endif
!
      enxlda=enxlda*hartre*vol/nplwv
      enxgga=enxgga*hartre*vol/nplwv
      enclda=enclda*hartre*vol/nplwv
      encgga=encgga*hartre*vol/nplwv
      if (lcalvx) then
         enxcc1l=enxcc1l*hartre*vol/nplwv
         enxcc1g=enxcc1g*hartre*vol/nplwv
         enxcc2=enxcc2*bohr/nplwv
      else
         elo=-1.679d0*elo*hartre*vol/nplwv
      endif
!
      if (lcalvx) then
         if(lgga) then
            enxc=enxgga+encgga
            ex  =enxgga
            enxcc=enxc+enxcc1g+enxcc2
         else
            enxc=enxlda+enclda
            ex  =enxlda
            enxcc=enxc+enxcc1l
         endif
      else
         if (lgga) then
            ex=enxgga
            enxc=enxgga+encgga
         else
            ex=enxlda
            enxc=enxlda+enclda
         endif
         enxcc=0.0d0
!         write(nconso,2000)ex,enxc,elo
 2000    format(1x,'Lieb-Oxford: ',3f13.6)
      endif
!
!     call uttime(time)
!     timer(TXC1)=timer(TXC1)+time(1)
      return
      end
!=======================================================================
!----------------------------------------------------------------------
!######################################################################
!----------------------------------------------------------------------
      SUBROUTINE CORunspPBE(RS,EC,VC,sk,&
                        T,H,DVC,ecdd,lgga)
!----------------------------------------------------------------------
!  Official PBE correlation code. K. Burke, May 14, 1996.
!  INPUT: RS=SEITZ RADIUS=(3/4pi rho)^(1/3)
!       : ZET=RELATIVE SPIN POLARIZATION = (rhoup-rhodn)/rho
!       : t=ABS(GRAD rho)/(rho*2.*KS*G)  -- only needed for PBE
!       : lgga=flag to do gga (0=>LSD only)
!       : lpot=flag to do potential (0=>energy only)
!  output: ec=lsd correlation energy from [a]
!        : vcup=lsd up correlation potential
!        : vcdn=lsd dn correlation potential
!        : h=NONLOCAL PART OF CORRELATION ENERGY PER ELECTRON
!        : dvcup=nonlocal correction to vcup
!        : dvcdn=nonlocal correction to vcdn
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! References:
! [a] J.P.~Perdew, K.~Burke, and M.~Ernzerhof, 
!     {\sl Generalized gradient approximation made simple}, sub.
!     to Phys. Rev.Lett. May 1996.
! [b] J. P. Perdew, K. Burke, and Y. Wang, {\sl Real-space cutoff
!     construction of a generalized gradient approximation:  The PW91
!     density functional}, submitted to Phys. Rev. B, Feb. 1996.
! [c] J. P. Perdew and Y. Wang, Phys. Rev. B {\bf 45}, 13244 (1992).
!----------------------------------------------------------------------
!----------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
! thrd*=various multiples of 1/3
! numbers for use in LSD energy spin-interpolation formula, [c](9).
!      GAM= 2^(4/3)-2
!      FZZ=f''(0)= 8/(9*GAM)
! numbers for construction of PBE
!      gamma=(1-log(2))/pi^2
!      bet=coefficient in gradient expansion for correlation, [a](4).
!      eta=small number to stop d phi/ dzeta from blowing up at 
!          |zeta|=1.
      logical*4 lgga
      parameter(thrd=1.d0/3.d0,thrdm=-thrd,thrd2=2.d0*thrd)
      parameter(sixthm=thrdm/2.d0)
      parameter(thrd4=4.d0*thrd)
      parameter(GAM=0.5198420997897463295344212145565d0)
      parameter(fzz=8.d0/(9.d0*GAM))
      parameter(gamma=0.03109069086965489503494086371273d0)
      parameter(bet=0.06672455060314922d0,delt=bet/gamma)
      parameter(eta=1.d-12)
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! find LSD energy contributions, using [c](10) and Table I[c].
! EU=unpolarized LSD correlation energy
! EURS=dEU/drs
! EP=fully polarized LSD correlation energy
! EPRS=dEP/drs
! ALFM=-spin stiffness, [c](3).
! ALFRSM=-dalpha/drs
! F=spin-scaling factor from [c](9).
! construct ec, using [c](8)
      rtrs=dsqrt(rs)
      CALL gcor2(0.0310907D0,0.21370D0,7.5957D0,3.5876D0,1.6382D0,&
          0.49294D0,rtrs,EU,EURS)
      CALL gcor2(0.01554535D0,0.20548D0,14.1189D0,6.1977D0,3.3662D0,&
          0.62517D0,rtRS,EP,EPRS)
      CALL gcor2(0.0168869D0,0.11125D0,10.357D0,3.6231D0,0.88026D0,&
          0.49671D0,rtRS,ALFM,ALFRSM)
      ALFC = -ALFM
      EC = EU
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! LSD potential from [c](A1)
! ECRS = dEc/drs [c](A2)
! ECZET=dEc/dzeta [c](A3)
! FZ = dF/dzeta [c](A4)
      ECRS = EURS
      VC = EC -RS*ECRS/3.D0
      if (.not.lgga) return
!----------------------------------------------------------------------
! PBE correlation energy
! G=phi(zeta), given after [a](3)
! DELT=bet/gamma
! B=A of [a](8)
      PON=-EC/(gamma)
      B = DELT/(DEXP(PON)-1.D0)
      B2 = B*B
      T2 = T*T
      T4 = T2*T2
      RS2 = RS*RS
      RS3 = RS2*RS
      Q4 = 1.D0+B*T2
      Q5 = 1.D0+B*T2+B2*T4
      H = (BET/DELT)*DLOG(1.D0+DELT*Q4*T2/Q5)
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! ENERGY DONE. NOW THE POTENTIAL, using appendix E of [b].
      T6 = T4*T2
      RSTHRD = RS/3.D0
      FAC = DELT/B+1.D0
      BEC = B2*FAC/(BET)
      Q8 = Q5*Q5+DELT*Q4*Q5*T2
      Q9 = 1.D0+2.D0*B*T2
      hB = -BET*B*T6*(2.D0+B*T2)/Q8
      hRS = -RSTHRD*hB*BEC*ECRS
      hT = 2.d0*BET*Q9/Q8
      DVC = H+HRS-7.0d0*T2*HT/6.D0
      ecdd=0.5d0/sk*t*ht
      RETURN
      END
!----------------------------------------------------------------------



