#include "definitions.h"

!=======================================================================
      subroutine orspid(nconso)
      write(nconso,*) '@(#)orthop.F	1.3 10/9/96'
      return
      end
!=======================================================================
!VOCL TOTAL,VECTOR
      subroutine orsp(nbands,nrplwv,nplwkp,cptwfp,cptdum,cctdum,&
                      nplwv)
!=======================================================================
! this subroutine orthogonalises the wavefunctions obtained after
! integrating the equations of motion for the electronic states
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      complex*WF_PRECISION cptwfp(nrplwv*nbands)
!=======================================================================
!                  dimension statements
! cptdum = the wavefunction to be normalised and to which all higher
!          bands will be orthogonalised
! cctdum = the complex conjugate of the above
!=======================================================================
      dimension cptdum(nplwv),cctdum(nplwv)
!
      do 2101 nn=1,nbands
        nindw=nrplwv*(nn-1)
        do 2110 m=1,nplwkp
          cptdum(m)=cptwfp(m+nindw)
 2110   continue
!=======================================================================
! take the complex conjugate of the wavefunction
!=======================================================================
        do 2120 m=1,nplwkp
          cctdum(m)=conjg(cptdum(m))
 2120   continue
!=======================================================================
! calculate the magnitude squared of the wavefunction
!=======================================================================
        cwfmag=(0.0d0,0.0d0)
        do 2121 m=1,nplwkp
          cwfmag=cwfmag+cctdum(m)*cptdum(m)
 2121   continue
        wfmag=dble(cwfmag)
!=======================================================================
! check that it is non-zero
!=======================================================================
        if(wfmag.eq.0.0d0) then
!=======================================================================
! if it is zero print the band and k point indices and halt
! execution
!=======================================================================
          write(*,2103) nn,m, cwfmag,  nbands,nrplwv,nplwkp
2103      format(/,' in orsp: wavefunctions linearly dependent',&
           /,'          band =', i5,',   m=',i5,',  cwfmag=',2e13.6,&
           /,'         inputs are nbands,nrplwv,nplwkp =',4i5,/)

          call clexit(nconso)
        endif
        wfminv=1.0d0/sqrt(wfmag)
!=======================================================================
! normalise the wavefunction and its complex conjugate
!=======================================================================
        do 2122 m=1,nplwkp
          cptdum(m)=wfminv*cptdum(m)
          cctdum(m)=conjg(cptdum(m))
 2122   continue
!=======================================================================
! store the normalised wavefunction
!=======================================================================
        do 2116 m=1,nplwkp
          cptwfp(m+nindw)=cptdum(m)
 2116   continue
!=======================================================================
! now orthogonalise the wavefunctions of all the higher bands to the
! present wavefunction
!=======================================================================
        do 2102 mm=nn+1,nbands
          nindx=nrplwv*(mm-1)
!=======================================================================
! calculate the scalar product of the wavefunction of the higher band
! and the normalised complex conjugate of the wavefunction of the lower
! band
!=======================================================================
          cscpd=(0.0d0,0.0d0)
          do 2123 m=1,nplwkp
            cscpd=cscpd+cctdum(m)*cptwfp(m+nindx)
 2123     continue
!=======================================================================
! orthogonalise the wavefunction of the higher band to that of the lower
! band
!=======================================================================
          do 2124 m=1,nplwkp
            cptwfp(m+nindx)=cptwfp(m+nindx)-cscpd*cptdum(m)
 2124     continue
!=======================================================================
! move onto the next band to orthogonalise to the present band
!=======================================================================
 2102   continue
!=======================================================================
! move onto the next band
!=======================================================================
 2101 continue
      return
      end
