#include "definitions.h"

!=======================================================================
      subroutine nlread(atomic_number, &
            nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions,&
            nionsp,volc,nconso, nspec,mmaxx,npspts,&
            psp,pscore,psgmax,&
            iznuc,icharg,nlnum,mmax,rlog,radius,phiatm,rho_rad,&
            lspsi)

!=======================================================================
! purpose  :
!     Reads in pseudopotentials from the files given in the 
!     AtomProperty_[atom symbol]:PspotFile netCDF variable 
! parameters : 
!     atomic_number [in]  : atomic number
!     nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions,nionsp,
!     volc,nconso   [in]  : input parameters and variables
!     
!      mmaxx,npspts [in]  :  dimensions for radial grids  
! 
!   pseudo potentials output variables
!     psp      [out]      :  local pseudo-potential
!     pscore   [out]      :  G = 0 component of the local pseudo-potential
!     psgmax   [out]      :  max value of 1/G in 1/Angstroms (=100)
!     nlnum    [out]      :  max angular momentum of betafunctions
!   pseudo atom output variables
!     iznuc    [out]      :  pseudo atom nuclear charge
!     icharg   [out]      :  valence charge
!     rho_rad  [out]      :  partial core charge on radial fourier grid
!     mmax     [out]      :  max radial grid value for each element
!     rlog     [out]      :  descripes the radial log. grid
!     radius   [out]      :  r values [1..mmax]
!     phiatm   [out]      :  pseudo-atom wavefunctions
!
!     van_us_args variables also defined, see description in 
!     van_us_decl.h 
!     
!=======================================================================
      use van_us_data_module
      implicit none

      integer nconso,nspec,nionsp(nspec)
      integer atomic_number(nspec)
      integer nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions
      real*8  volc

      integer  mmaxx,npspts

!   pseudo potentials output variables
      real*8    psp(npspts,nspec),pscore(nspec)
      real*8    psgmax(nspec)
      integer   nlnum(nspec)

!   pseudo atom output variables
      integer iznuc(nspec),icharg(nspec) 
      real*8    rho_rad(npspts,nspec) 
      integer   mmax(nspec)
      real*8    rlog(nspec),radius(mmaxx,nspec)
      real*8    phiatm(mmaxx,0:2,nspec)

      logical*4  lspsi
!=======================================================================
!     locals
      character*4 nam
      character*80 filename
      integer iunit_van,nsp,m
!=======================================================================
! Put charge to zero for all species (used to see if pseudopot found for
! all)
!=======================================================================
      do nsp=1,nspec
         icharg(nsp)=0
      enddo   

! Put partial core to zero for all species 
      do nsp = 1,nspec 
        do m = 1,npspts 
           rho_rad(m,nsp) = 0.0d0 
        enddo 
      enddo

      iunit_van = 14

! -----------------------------------------------------------------------
! Read pseudopotentials for all elements
      do nsp = 1,nspec

        psgmax(nsp) = 100.0d0

! Get file name from AtomProperty_[atom symbol]:PspotFile netCDF variable 
        call get_PspotFile(atomic_number(nsp),filename)
! Open file
        write(nconso,*) 'PSP: pseudo-potential file for specie ',&
                         nsp, ':', trim(filename)
        open(iunit_van,FILE=filename,&
          STATUS = 'OLD',FORM='unformatted') 
        call getvan(iznuc(nsp),pscore(nsp),psgmax(nsp),&
          icharg(nsp),nlnum(nsp),psp(1,nsp),volc,&
          mmax(nsp),rlog(nsp),&
          radius(1,nsp),phiatm(1,0,nsp),rho_rad(1,nsp),&
          mmaxx,npspts,iunit_van,&
          nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions,&
          nsp,nspec,nionsp, lspsi, nconso)

        write(nconso,1400) 'Valence-Z ',dble(icharg(nsp))
        write(nconso,1400) 'Core-alpha',pscore(nsp)
 1400       format(1x,'PSP:                       ',a10,1x,3f16.4)

      enddo 
!-----------------------------------------------------------------------
 
!     write if generalized or normal eigenvalue problem should be solved 
!      if (lspsi) then
!         write(nconso,*)
!     &      'PSP:Generalized eigenvalue problem should be solved' 
!      else
!          write(nconso,*)
!     &      'PSP: Normal eigenvalue problem should be solved' 
!      endif
!      if (lgenpp) then 
!        write(nconso,*)
!     &      'PSP: Pseudo potential on Generalized form is used' 
!      endif
      call uflush(nconso)

      return
      end

!=======================================================================
        subroutine get_PspotFile(atomic_number,filename)
        use basicdata
        use netcdfinterface
        use run_context
!       purpose  : return a file name by reading the netCDF variable
!                  AtomProperty_[atom symbol]:PspotFile netCDF variable 
!                  If the file is not found using this name, the 
!                  content of the enviroment variable DACAPOPATH is 
!                  added
        implicit none
        integer      atomic_number       
        character*80 filename
       
!       locals 
        character*2  atomsymbol      
        character*80 netcdfvarname
        integer      status,ncid
        logical      exist 

!       open netCDF file
        status = nf_open(netCDF_input_filename,NF_NOWRITE, ncid )
        if (status /= nf_noerr) stop "nf_open:error in get_PspotFile"

        atomsymbol = atom_symbol(atomic_number)
        netcdfvarname="AtomProperty_"//trim(atomsymbol)//"%PspotFile"
!        write(nconso,*) 'PSP: reading pseudo-potential file ', 
!     &     'name from the netCDF variable ',netcdfvarname
        call uflush(nconso)

! --- filename must be empty, to avoid accidental chars in the 
!     filename buffer (nfget overwrites only nescessary spaces)

        filename = ""
        status = nfget(ncid,netcdfvarname,filename) 
        if (status/=nfif_OK) then 
           write(nconso,*) 'PSP: error reading netCDF variable ',&
                            netcdfvarname
           write(nconso,*) 'PSP: the program will stop' 
           call clexit(nconso)
        endif

!       inquire about the filename 
        inquire(file = filename,EXIST=exist) 
        if (.not.exist) then 
!         add DACAPOPATH and let nlread try to open the file
          filename = trim(dacapo_path_string)//"/"//trim(filename)
        endif
        status = nf_close(ncid)

        return 
        end

        
!=======================================================================
      real*8  function simps(n,f,h) 
!=======================================================================
!
!     simps integration for f with step length h for n points
!     n should be odd .
!
!=======================================================================
      implicit none
      integer n, nm12
      real*8  dsum, f, h
      dimension f(n)
!=======================================================================
!
      nm12=(n-1)/2
      if (nm12*2.ne.n-1) &
         call report_error('function','wrong n in simps' , 13 )
!
      simps=4.*dsum(nm12,f(2),2)+2.*dsum(nm12-1,f(3),2)+f(1)+f(n)
      simps=simps*h/3.
!
      return
      end
!=======================================================================
      DOUBLE PRECISION FUNCTION DSUM ( N, DX, INCX )
!
!     SUM OF THE ELEMENTS OF A VECTOR.
!     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO ONE.
!     JACK DONGARRA, LINPACK, 3/11/78. CJB
!
      DOUBLE PRECISION DX(*)
      INTEGER I,INCX,N,NINCX,LINCX
!
      IF(N.LE.0)RETURN
!
      NINCX = N*INCX
      LINCX = INCX + 1
      DSUM = DX(1)
      DO 10, I = LINCX,NINCX,INCX
        DSUM = DSUM + DX(I)
 10      CONTINUE
      RETURN
      END
!=======================================================================
      subroutine report_error(a,b,n)
      use run_context
      implicit none
! local variables here --->
      integer n
      character*(*) a,b
      write(6,1) a,b,n
    1 format(/'>>>!!!!!!ERROR!!!!!!',&
        /,'>>>routine ',a,': ',a,2x,i8,4x,/,'stop')
      call clexit(nconso)
      end
