module multicenter_projection_module

#include "definitions.h"

! module data

! variables for defining the multi-centers
integer,    save,private               :: numovl,maxcen
character*6,save,allocatable,private   :: namovl(:)  ! numovl
integer    ,save,allocatable,private   :: numcen(:)  ! numovl
integer    ,save,allocatable,private   :: nspcen(:,:),il_cen(:,:) ! maxcen,numovl
integer    ,save,allocatable,private   :: im_cen(:,:),ioncen(:,:) ! maxcen,numovl
integer    ,save,allocatable,private   :: muc(:,:)                ! maxcen,numovl
real*8     ,save,allocatable,private   :: wghcen(:,:)             ! maxcen,numovl
real*8     ,save,private               :: wldos=0.24,enemin=-20.0,enemax=5.0,rcutoff=1.0
real*8     ,save,allocatable,private   :: nspc(:)                 ! maxcen

integer,parameter,private              :: ncut  = 2
integer   ,save,private                :: nener=100

! calculated data
real*8    ,save,allocatable,private    :: ovlcen(:,:,:)   ! numovl,ncut,nspin
real*8    ,save,allocatable,private    :: mdos(:,:,:,:)   ! nener,numovl,ncut,nspin

! control data
logical   , save,private               :: linit = .true.

integer   , save,private               :: nspin_local,ispin_local  ! copy of nspin and ispin

contains

subroutine mulcen(nplwkp, cptwfp,mmaxx,nconso,&
                  nlnum,mmax,rlog,radius,phiatm,phir2v,&
                  occ,eigen, efermi,recc,&
                  nkpnum,nkpibz,nkpunf,lkpinv,ispin,ecut,&
#include         "apply_h_args.h" 
                 ,timer)

! Calculate the local density of states, ldos.
! The one-electron wave functions are projected onto two-center orbitals

      use van_us_data_module ,only : linitvkb
      use us_hpsi_module
     
      implicit none
 
#include         "apply_h_decl.h" 

      integer    nplwkp
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      integer    mmaxx,nconso
      integer    nlnum(nspec),mmax(nspec)
      real*8     rlog(nspec),radius(mmaxx,nspec),phiatm(mmaxx,0:2,nspec)
      real*8     phir2v(mmaxx)
      real*8     occ(nbands),eigen(nbands)
      real*8     efermi
      real*8     recc(3,3)
      integer    nkpnum,nkpibz(nkpnum),nkpunf(3,3,nkpnum),ispin
      logical*4  lkpinv(nkpnum)
      real*8     q1,nkp1
      real*8     ecut
      real*8     timer(*)
      integer,parameter ::  idebug = 1

! local variables
! work arrays; automatic declaration
      real*8     dwork1(nrplwv,3),sdnlg(nrplwv,3)
      complex*16,allocatable :: phi(:,:)               ! (nrplwv,maxcen)
      complex*16,allocatable :: Sphi(:,:)              ! (nrplwv,maxcen)
      real*8,allocatable     :: shbas(:,:,:)           ! (3,3,maxcen)
      real*8     radialwfct(nrplwv)
      complex*16 cwor11(nrplwv),cwor12(nplwv)
      
! dshcos: contains the direction cosines in the basis in which
!         the spherical harmonics are set up
      real*8,allocatable     :: dshcos(:,:,:)          ! (nrplwv,3,maxcen)

      integer ns1,ns2
      integer nkpused,mu1,mu2
      logical*4 lproj
      integer   nb,ig,i,nene,nion,novl,icut,mu,nsp,ncen,nkpall,nn
      real*8    s1(3,3),ove,wfac,wful,x,y,z,rxyz
      complex*16 cover
      logical*4 lheader,found
      integer   nextcenter,currentcenter
      save lheader
      data lheader/.true./

      if (linit) call init(nspin,nspec,nions,nionsp)

      if (numovl.eq.0) return 

      allocate(phi(nrplwv,maxcen),Sphi(nrplwv,maxcen))
      allocate(shbas(3,3,maxcen),dshcos(nrplwv,3,maxcen))

      nkpused = nkpnum

! loop over cuts (1=no cut, 2=cut at 2 bohr) to the radial functions

      ispin_local = ispin

      do 5000 icut=1,ncut

! loop over the groups of multicenter orbitals

         do 4500 novl=1,numovl

! find out what kind of species the two centers are

            nion=0
            do nsp=1,nspec
               do mu=1,nionsp(nsp)
                  nion=nion+1
                  do ncen=1,numcen(novl)
                     if (nion.eq.ioncen(ncen,novl)) then
                        nspc(ncen)=nsp
                        muc(ncen,novl)=mu
                     endif
                  enddo
               enddo
            enddo

! determine the direction cosines in the basis where the spherical
! harmonics are set up.

            do ncen=1,numcen(novl)

            mu1 = muc(ncen,novl)
            ns1 = nspc(ncen)

! find the 'next' atom as direction pointer :
            found = .false.
            ! search for the next center
            currentcenter = ncen
            do i = 1,numcen(novl)-1
               nextcenter = get_next_center(currentcenter,numcen(novl))
               if (ioncen(nextcenter,novl).ne.ioncen(ncen,novl)) then
                  mu2 = muc(nextcenter,novl)
                  ns2 = nspc(nextcenter)
                  found = .true.
                  exit
               endif
               currentcenter = nextcenter
            enddo
            write(*,*) 'i = ',i

            if (.not.found) then 
               mu2 =mu1
               ns2 = ns1
            endif

            x=(posion(1,mu2,ns2)-&
               posion(1,mu1,ns1))*dirc(1,1)&
             +(posion(2,mu2,ns2)-&
               posion(2,mu1,ns1))*dirc(2,1)&
             +(posion(3,mu2,ns2)-&
               posion(3,mu1,ns1))*dirc(3,1)
            y=(posion(1,mu2,ns2)-&
               posion(1,mu1,ns1))*dirc(1,2)&
             +(posion(2,mu2,ns2)-&
               posion(2,mu1,ns1))*dirc(2,2)&
             +(posion(3,mu2,ns2)-&
               posion(3,mu1,ns1))*dirc(3,2)
            z=(posion(1,mu2,ns2)-&
               posion(1,mu1,ns1))*dirc(1,3)&
             +(posion(2,mu2,ns2)-&
               posion(2,mu1,ns1))*dirc(2,3)&
             +(posion(3,mu2,ns2)-&
               posion(3,mu1,ns1))*dirc(3,3)
            rxyz=sqrt(x**2+y**2+z**2)
            if (rxyz.le.1d-5) then 
              if (lheader) write(nconso,*) &
                    'MUL: ',novl,': Using old basis'
              shbas(1,3,ncen) = 0.0d0
              shbas(2,3,ncen) = 0.0d0
              shbas(3,3,ncen) = 1.0d0
            else
              shbas(1,3,ncen)=x/rxyz
              shbas(2,3,ncen)=y/rxyz
              shbas(3,3,ncen)=z/rxyz
            endif

! if this new z-direction is parallel to the old z-direction, use
! the old coordination system fully.

            rxyz=sqrt(shbas(1,3,ncen)**2+shbas(2,3,ncen)**2)
            if (rxyz.le.1d-5) then
               shbas(1,1,ncen)=1.0d0
               shbas(2,1,ncen)=0.0d0
               shbas(3,1,ncen)=0.0d0
               shbas(1,2,ncen)=0.0d0
               shbas(2,2,ncen)=1.0d0
               shbas(3,2,ncen)=0.0d0
            else

! else, use an x-axis which is the cross product between the new z
! and the old z direction

               shbas(1,1,ncen)= shbas(2,3,ncen)/rxyz
               shbas(2,1,ncen)=-shbas(1,3,ncen)/rxyz
               shbas(3,1,ncen)=0.0d0

! and use z cross-product x for the y-direction

               x=-shbas(2,1,ncen)*shbas(3,3,ncen)
               y= shbas(1,1,ncen)*shbas(3,3,ncen)
               z= shbas(1,3,ncen)*shbas(2,1,ncen)&
                    -shbas(1,1,ncen)*shbas(2,3,ncen)
               rxyz=sqrt(x**2+y**2+z**2)
               shbas(1,2,ncen)=x/rxyz
               shbas(2,2,ncen)=y/rxyz
               shbas(3,2,ncen)=z/rxyz

            endif
            if (lheader) then
               write(nconso,1818) novl,ncen,shbas(1,1,ncen),&
                    shbas(1,2,ncen),shbas(1,3,ncen)
               write(nconso,1818) novl,ncen,shbas(2,1,ncen),&
                    shbas(2,2,ncen),shbas(2,3,ncen)
               write(nconso,1818) novl,ncen,shbas(3,1,ncen),&
                    shbas(3,2,ncen),shbas(3,3,ncen)
 1818          format(1x,'MUL: Rmatrix',2i3,3f12.6)
               if (novl.eq.numovl.and.ncen.eq.numcen(novl))&
                    lheader=.false.
            endif
         enddo
! Loop over the symmetry operations that brings this k-point through
! all corresponding k-points outside the IBZ

!        get actual k-point in case of a spin-pol calculation
         nkp1 = nkp
         if (nspin_local.eq.2) nkp1 = nint(float(nkp)/2.0)

         do 3125 nkpall=1,nkpnum
            if (nkpibz(nkpall).eq.nkp1) then

! Change the cosine's (G+k)_i/|G+k|, to be applicable for this k-point.
! Note that the G's will now be in an unknown order (no ipwpad array
! can put then in the FFT grid). This however doesn't disturb for
! the present purpose, where only dot-products are to be calculated

! nkpibz(x=1..nkpnum):     The index of which IBZ k-point corresponds
!                          to the x'th k-point in the 1st Brillouin zone
! nkpunf(3,3,x=1..nkpnum): The matrix bringing the nkpibz(x)'th k-point
!                          from the IBZ to the x'th k-point in the
!                          1st Brillouin zone
! lkpinv: True if the nkpunf has been added the inversion without this
!         being present in the space group

! Generate the S^-1 matrix in Cartesian coordinates
 
               call cartsG(dirc,recc,nkpunf(1,1,nkpall),s1)
               do 6000 ig=1,nplwkp

! rotate the direction cosines for the spherical harmonics: dshcos
! (note that shbas transpose= shbas^(-1) as shbas is unitary)

                  x=s1(1,1)*dnlkg(ig,1,nkp)&
                   +s1(1,2)*dnlkg(ig,2,nkp)&
                   +s1(1,3)*dnlkg(ig,3,nkp)
                  y=s1(2,1)*dnlkg(ig,1,nkp)&
                   +s1(2,2)*dnlkg(ig,2,nkp)&
                   +s1(2,3)*dnlkg(ig,3,nkp)
                  z=s1(3,1)*dnlkg(ig,1,nkp)&
                   +s1(3,2)*dnlkg(ig,2,nkp)&
                   +s1(3,3)*dnlkg(ig,3,nkp)
                  do ncen=1,numcen(novl)
                  do i = 1,3
                     dshcos(ig,i,ncen)=shbas(1,i,ncen)*x&
                                 +shbas(2,i,ncen)*y&
                                 +shbas(3,i,ncen)*z
                  enddo
                  enddo

! rotate the dnlkg and dnlg arrays 

                  do i = 1,3
                     dwork1(ig,i)=s1(i,1)*dnlkg(ig,1,nkp)&
                                 +s1(i,2)*dnlkg(ig,2,nkp)&
                                 +s1(i,3)*dnlkg(ig,3,nkp)
                     sdnlg(ig,i)= s1(i,1)*dnlg(ig,1,nkp)&
                                 +s1(i,2)*dnlg(ig,2,nkp)&
                                 +s1(i,3)*dnlg(ig,3,nkp)
                  enddo
 6000          continue

! -------------------------------------------------------------------------
!  recalculate vkb so that S|atmpsi> will be calculated correct,
!  using sdnlg instead of dnlg

                linitvkb(nkp) = .true.
                nn = 1
                call cal_vkb(nplwv,nrplwv,nrplwv_global,nplwkp,nkp, &
     &               nions,nspec,nionsp,nkpmem, &
     &               nbands,nkprun,sdnlg,posion,dirc,volc, &
     &               ngxs,ngys,ngzs,ecut,idebug,recc &
#ifdef PARAL
     &               , &
#include             PARAL_ARGS
#endif
                      )


! -------------------------------------------------------------------------
!   ion              : nspc
!   l quantum number : il_cen
!   m quantum number : im_cen


!                 loop over the numcen centers for this novl
                  do ncen = 1,numcen(novl)
                    call make_phi(novl,ncen,il_cen(ncen,novl),&
                         im_cen(ncen,novl),phi(1,ncen),&
                          Sphi(1,ncen),&
                         nlnum,mmax,rlog,radius,&
                         phiatm,phir2v,lproj,mmaxx,nplwkp,&
                         icut,dshcos(1,1,ncen),dwork1,radialwfct,&
#                        include  "apply_h_args.h"
                         ,timer)

                  enddo
!                 make the multicenter orbital in Sphi(:,1)
                  call make_bond_antibond(novl,&
                                   nplwkp,phi,Sphi,&
#                        include  "apply_h_args.h"
                       ,timer)

                
! Loop over the bands

                  do 3110 nb=1,nbands

                     wfac=occ(nb)/dble(nkpused)
                     wful=2.0d0  /dble(nkpused)/dble(nspin_local)


! If   S belongs to the space group:  no problem
! else the inversion has been added - and the wavefunction coefficients
!      must be complex conjugated

                     if (.not.lkpinv(nkpall)) then
                        do ig=1,nplwkp
                           cwor11(ig)=cptwfp(ig,nb)
                        enddo    
                     else
                        do ig=1,nplwkp
                           cwor11(ig)=conjg(cptwfp(ig,nb))
                        enddo    
                     endif 

! Calculate the overlap

                     cover=dcmplx(0.0d0,0.0d0)
                     do 3020 ig=1,nplwkp
                        cover=cover+conjg(Sphi(ig,1))*cwor11(ig)
 3020                continue
                     ove=dble(conjg(cover)*cover)
                     write(nconso,*) 'ove wfac ',novl,icut,nb,ove,wfac,cover
                     write(nconso,*) 'eigen ',novl,nb,icut,eigen(nb),efermi

                     call ldosad(ove*wful,&
                          mdos(1,novl,icut,ispin_local),&
                          eigen(nb)-efermi,wldos,nener,&
                          enemin,enemax)
                     ovlcen(novl,icut,ispin_local)=&
                          ovlcen(novl,icut,ispin_local)+ove*wfac

 3110             continue   ! nbands
            endif
 3125    continue            ! nkpnum
 4500    continue            ! novl
 5000 continue               ! icut
      return
      end subroutine mulcen

!     -------------------------------------------------------------------
      integer function get_next_center(current,maxcenter) 
!     -------------------------------------------------------------------
!     find cyclic the next center from the current
      integer current,maxcenter

      if ((current+1).gt.maxcenter) then 
        get_next_center = 1
      else 
        get_next_center = current+1
      endif 
      end function get_next_center


!     -------------------------------------------------------------------
      subroutine mulcwr(lmastr) 
!     -------------------------------------------------------------------
      use run_context
      use netcdfinterface
      implicit none

      logical*4  :: lmastr

      integer     icut,novl,i,ispin,status,ncid
      character*2 spintxt(2)
      real*8      work(ncut*numovl*nener*nspin_local)
      real*8      energygrid(nener)
      real*8      factor

      if (numovl.eq.0) return 

#ifdef PARAL
!       Slaves send partial values back to master.
!       Master receives and sums up contributions.
!       Here, we use smdens() for a different array.
!       Barrier synchronization (send flags: a dummy action) is
!       done in between the calls of smdens to avoid mixing
!       of the various packages sent from the slaves
        call smdens (nconso,mdos,work, ncut*numovl*nener*nspin_local)
#endif PARAL

      spintxt(1) = 'UP'
      spintxt(2) = 'DN'
      if (nspin_local.eq.1) spintxt(1) = ' '

! locals

      do 5100 ispin = 1,nspin_local
       do 5000 icut=1,ncut
          if (icut.eq.1) then 
              write(nconso,*) 'MO_OVL  No cutoff'
          else
              write(nconso,*) 'MO_OVL  cutoff at 2 bohr'
          endif
          do novl=1,numovl
             write(nconso,4010) icut,spintxt(ispin),&
                 novl,namovl(novl),ovlcen(novl,icut,ispin) 
 4010        format(1x,'MO_OVL',i1,a2,2x,i3,2x,a6,1x,f8.4)
          enddo
 5000  continue
 5100 continue

!     now write energy resolved projected density of state
      do ispin = 1,nspin_local
        do icut = 1,ncut
          write(nconso,6000) 'MO_LDOS    energy(eV)   ',&
               (namovl(novl),novl=1,numovl)
          call ldoswi(icut,ispin)
        enddo
      enddo
6000  format(1x,a22,1x,8(a7,1x))

 
      if (.not.lmastr) return 

!     -------------------------------------------------------------------
!     output data to netcdf file: 
!       dimensions : 
!                      multicenter_energygrid_size 
!                      number_of_multicenters  (allready defined)
!       variables  : 
!                      MultiCenterProjectedDOS_EnergyResolvedDOS(
!                            number_of_multicenters
!                            dim2                         (icut)
!                            number_of_spin
!                            multicenter_energygrid_size)
!
!                      MultiCenterProjectedDOS_EnergyGrid(
!                            multicenter_energygrid_size)
!                    
!     -------------------------------------------------------------------
      status = nf_open(netCDF_output_filename,NF_WRITE, ncid)
      if (status /= nf_noerr) stop "nf_open: error in mulcen"


!     dimensions 
      status = nfputglobaldim(ncid, "multicenter_energygrid_size", nener)

      if ((status /= nfif_ok).and.(status/=nfif_dimexist_butOKsize))&
          stop "nfputglobaldim: multicenter_energygrid_size"

!     variables 
      status = nfdefvar(ncid, "MultiCenterProjectedDOS_EnergyResolvedDOS", &
                        NF_DOUBLE,&
                        dim_name1="multicenter_energygrid_size", &
                        dim_name2="number_of_spin", &
                        dim_name3="dim2", &
                        dim_name4="number_of_multicenters")

      status = nfdefvar(ncid, "MultiCenterProjectedDOS_IntegratedDOS", &
                        NF_DOUBLE,&
                        dim_name1="number_of_spin", &
                        dim_name2="dim2", &
                        dim_name3="number_of_multicenters")


      factor = dble(nener-1)/(enemax-enemin)/2.0d0
      do icut = 1, ncut
        do ispin = 1, nspin_local
         do novl = 1,numovl
           ! EnergyResolvedDOS
           status = nfput(ncid,&
                   "MultiCenterProjectedDOS_EnergyResolvedDOS",&
                    mdos(:,novl,icut,ispin)*factor,&
                    startnf=(/1,ispin,icut,novl/),&
                    countnf=(/nener,1,1,1/) )
           if (status /= nfif_ok) &
               stop "nfput: MultiCenterProjectedDOS_EnergyResolvedDOS"

           ! IntegratedDOS
           status = nfput(ncid,&
                   "MultiCenterProjectedDOS_IntegratedDOS",&
                    ovlcen(novl,icut,ispin),&
                    startnf=(/ispin,icut,novl/),&
                    countnf=(/1,1,1/) )

           if (status /= nfif_ok) &
               stop "nfput: MultiCenterProjectedDOS_IntegratedDOS"
         enddo
        enddo
      enddo

!     set energy grid 
      call set_dos_grid(energygrid,nener,enemin,enemax)
      status = nfput(ncid,"MultiCenterProjectedDOS_EnergyGrid",energygrid, & 
                     dim_name1 = "multicenter_energygrid_size")
      if (status /= nfif_ok) &
               stop "nfput: MultiCenterProjectedDOS_EnergyGrid"

      status = nf_close(ncid)
      if (status /= nf_noerr) stop "nf_close: error"


      return
      end subroutine mulcwr

!     -------------------------------------------------------------------
      subroutine ldoswi(icut,ispin)
!     -------------------------------------------------------------------
      use run_context
      implicit none
      integer icut,ispin

!     locals 
      character*2 spintxt(2)
      real*8  xdel,rdel,e
      integer nene,novl
 
      spintxt(1) = 'UP'
      spintxt(2) = 'DN'
      if (nspin_local.eq.1) spintxt(1) = '  '

      xdel=(enemax-enemin)/dble(nener-1)
      rdel=1.0d0/(2.0d0*xdel)
      do 1010 nene=1,nener
         e=xdel*dble(nene-1)+enemin
         write(nconso,1030) icut,spintxt(ispin),e,&
           (mdos(nene,novl,icut,ispin)*rdel,novl=1,numovl)
 1010 continue
 1030 format(1x,'MO_LDOS',i1,a2,f12.6,8(f7.4,1x))
      return
      end subroutine ldoswi

!     -------------------------------------------------------------------
      subroutine radfou(nlnum,mmax,rlog,radius,phiatm,phir2v,&
                        lproj,nspec,mmaxx,nplwkp,dnlkg,bohr,nrplwv,&
                        nsp,il,radialwfct,icut)
!     -------------------------------------------------------------------
      implicit none

      integer   nrplwv,mmaxx,nspec
      integer   nlnum(nspec)
      integer   mmax(nspec)
      real*8    rlog(nspec)
      real*8    radius(mmaxx,nspec)
      real*8    phiatm(mmaxx,0:2,nspec)
      real*8    phir2v(mmaxx)
      real*8    dnlkg(nrplwv,0:3)
      real*8    radialwfct(nrplwv)
      real*8    bohr
      logical*4 lproj
      real*8   simps
      external simps
      logical*4 ldoit
      integer   nsp,icut,nplwkp,il

!     locals
      real*8    worint(mmaxx)
      real*8 eps
      parameter(eps=1.0d-7)
      integer ir,ig
      real*8  fac,fct,arg,gkdotr,bessel,rcut,q1


! calculate the integral of j_l(|kr|)*phi_l(r)r^2
! Remember that the phiatm-array contains sqrt(4pi)*phi_l(r)
! The factor sqrt(4pi) will be cancelled by similar terms in the denominator
! of the spherical harmonics and in the expansion of a plane-wave in such.

      lproj=.false.
      if (il.ge.nlnum(nsp)) return
      lproj=.true.

! Cut off the radial function at rcut [bohr]
      rcut=100.0d0
	if (icut.eq.2) rcut=rcutoff/bohr
do 2004 ir=1,mmax(nsp)
         fac = (radius(ir,nsp)-rcut)/0.10d0
         if (fac.gt.60.0d0) then
            fct = 0.0d0   
         elseif (fac.lt.-60.0d0) then
            fct = 1.0d0 
         else 
            fct = 1.0d0/(1.0d0+exp(fac))  
         endif
         phir2v(ir)=phiatm(ir,il,nsp)*fct

 2004 continue

! Now Fourier transform: Loop over arg=|G+k| in units of 1/bohr

      do 2040 ig=1,nplwkp
         arg=dnlkg(ig,0)*bohr
         do 2000 ir=1,mmax(nsp)
            worint(ir)=phir2v(ir)*radius(ir,nsp)**2
 2000    continue
         ldoit=.true.

! Treat the |(G+k) r|=0 analytically (Bessel=1 for s, =0 for p and d)

         if (arg.lt.1.d-4) then
            if (il.ne.0) then
               ldoit=.false.
            endif
         else

! Treat the general |(G+k) r|<>0 case numerically

            do 2030 ir=1,mmax(nsp)

! Set up the spherical Bessel functions: j_0, j_1 or j_2
! j_l+1(kr)=(2*l+1)/kr j_l(kr) - j_l-1(kr), l>0

             gkdotr=arg*radius(ir,nsp)
             if (il.eq.0) then
                if (gkdotr.lt.eps) then
                        bessel = 1.0d0
                      else
                        bessel=sin(gkdotr)/gkdotr
                      endif
                   else
                     if (gkdotr.lt.eps) then
                       bessel = 0.0d0
                     else
                       bessel=(sin(gkdotr)/gkdotr-cos(gkdotr))/gkdotr
                       if (il.eq.2) then
                         bessel=(3.*bessel-sin(gkdotr))/gkdotr
                       endif
                     endif
                   endif
                   worint(ir)=bessel*worint(ir)
2030            continue
             endif

! Perform the integration (if not analytically zero)
             if (ldoit) then
                if (radius(1,nsp).lt.eps) then 
                  call radlg(mmax(nsp),worint,radius(1,nsp),&
                             rlog(nsp), q1)
                else
                  q1 = simps(mmax(nsp),worint,rlog(nsp) )
                endif
                radialwfct(ig)=q1*(bohr**3)
             else
                radialwfct(ig)=0.0d0
             endif
 2040        continue


      return 
      end subroutine radfou


!     -------------------------------------------------------------------
      subroutine atmnor(il,im,nplwkp,radialwfct,dwork1,cwor12,&
                        nrplwv,lproj)
!     -------------------------------------------------------------------
      implicit none

      integer     il,im,nplwkp,nrplwv
      real*8      radialwfct(nrplwv)
      real*8      dwork1(nrplwv,3)
      complex*16  cwor12(nrplwv)
      logical*4   lproj
   
!     locals
      integer m,ig
      real*8  fnorm,anorm
     

      if (.not.lproj) return

! Copy the s-radial function

      if (il.eq.0) then
         do 2050 ig=1,nplwkp
            cwor12(ig)=radialwfct(ig)
 2050    continue
      endif

! Multiply the p-radial function with the spherical harmonic

      if (il.eq.1) then
         do 2070 ig=1,nplwkp
            cwor12(ig)=dcmplx(0.0d0,-radialwfct(ig)*dwork1(ig,im))
 2070    continue
      endif

! Multiply the d-radial function with the spherical harmonic + normalize
! The latter are the normalized versions of:
! 1: Y_20   2: Y_22+Y_2-2   3: Y_22-Y_2-2   4: Y_21-Y_2-1   5: Y_21+Y_2-1

      if (il.eq.2) then
         do 3070 m=1,nplwkp
            if (im.eq.1)&
            cwor12(m)=-radialwfct(m)*(3.d0*dwork1(m,3)**2-1.0d0)
            if (im.eq.2)     &
            cwor12(m)=-radialwfct(m)*(dwork1(m,1)**2-dwork1(m,2)**2)
            if (im.eq.3)     &
            cwor12(m)=-radialwfct(m)*dwork1(m,1)*   dwork1(m,2)
            if (im.eq.4)     &
            cwor12(m)=-radialwfct(m)*dwork1(m,1)*   dwork1(m,3)
            if (im.eq.5)     &
            cwor12(m)=-radialwfct(m)*dwork1(m,2)*   dwork1(m,3)
 3070    continue
      endif

      return
      end subroutine atmnor


!     ------------------------------------------------------------------------
      subroutine init(nspin,nspec,nions,nionsp)
!     ------------------------------------------------------------------------
      use run_context
      use netcdfinterface
      use van_us_data_module ,only : bohr
      implicit none
      integer   nspin,nspec,nions,nionsp(nspec)

!     locals    
      integer   ncen,novl,status,ncid,i,natom,nsp,ni
      real*8, allocatable :: datamatrix(:,:,:)
      real*8              :: aux2(2),f
      character           :: cdummy

      linit = .false.
      numovl = 0

      ! parallel send should be implemented

      status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)
 !     if (status /= nf_noerr) call abort_calc(nconso, &
 !            "mulcenter init -> nf_open : error opening nc-file")
      if (status /= nf_noerr) then 
         write(nconso,*) &
         "mulcenter init -> nf_open : error opening nc-file"
         return 
      endif


!     get dimensions
      status = nfgetglobaldim(ncid,'number_of_multicenters',numovl)
      if (status /= nfif_OK) return

      status = nfgetglobaldim(ncid,'max_orbitals',maxcen)
      if (status /= nfif_OK) then 
          write(nconso,*) 'mulcen: Error could not find dimension max_orbitals in netcdf file'
          call uflush(nconso)
          numovl = 0
          return
      endif

!     now allocate data matrix
      allocate(datamatrix(4,maxcen,numovl))


!     get data from netcdf variable MultiCenterProjectedDOS
      cdummy = ""   ! clear buffer
      status = nfget(ncid, "MultiCenterProjectedDOS", datamatrix)

      write(nconso,*) 'datamatrix ',datamatrix
      write(nconso,*) 'numovl,maxcen ',numovl,maxcen
      call uflush(nconso)

      if (status == nfif_OK) then
         write(nconso,400) "Multi Center Atomic Projections will be calculated"

         status = nfget(ncid, "MultiCenterProjectedDOS%EnergyWindow", &
                        aux2)
         if (status == nfif_OK) then
           enemin = aux2(1)
           enemax = aux2(2)
         endif

         status = nfget(ncid, "MultiCenterProjectedDOS%EnergyWidth", f)
         if (status == nfif_OK) wldos = f

         status = nfget(ncid, "MultiCenterProjectedDOS%NumberEnergyPoints", i)
         if (status == nfif_OK) nener = i

         rcutoff = 2.0*bohr
         status = nfget(ncid, "MultiCenterProjectedDOS%CutoffRadius", f)
         if (status == nfif_OK) rcutoff = f


         write(nconso,420) "MultiCenterProjectedDOS: lower energy edge =", &
                            enemin, " eV"
         write(nconso,420) "MultiCenterProjectedDOS: upper energy edge =", &
                            enemax, " eV"
         write(nconso,420) "MultiCenterProjectedDOS: spectral broard.  =", &
                            wldos, " eV"
         write(nconso,421)   "MultiCenterProjectedDOS: number of energy points =", &
                            nener
         write(nconso,420)   "MultiCenterProjectedDOS: Cutoff radius (LDOS2) =", &
                            rcutoff," Angstrom"
         call uflush(nconso)
      else 
         return 
         numovl = 0
     
      endif

!     allocate input data 
      allocate(namovl(numovl)) 
      allocate(numcen(numovl))  ! numovl
      allocate(nspcen(maxcen,numovl),il_cen(maxcen,numovl))
      allocate(im_cen(maxcen,numovl),ioncen(maxcen,numovl))
      allocate(wghcen(maxcen,numovl))
      allocate(muc(maxcen,numovl))
      allocate(nspc(maxcen))

!     copy data
      do novl = 1,numovl 

         write(nconso,*) 'novl = ',novl
         namovl(novl) = '  '
!        get number of orbitals for this multicenter 
         numcen(novl) = maxcen
         do ncen = 1,maxcen
           write(nconso,*) 'ncen datamatrix ',ncen,datamatrix(1,ncen,novl)
           if (datamatrix(1,ncen,novl).lt.0) then
              numcen(novl) = ncen-1 
              exit
           endif 
         enddo
         write(nconso,*) 'numcen(novl) = ',novl,numcen(novl)
         call uflush(nconso)
 
         do ncen = 1,numcen(novl) 
           ioncen(ncen,novl) = nint(datamatrix(1,ncen,novl))+1
           il_cen(ncen,novl) = nint(datamatrix(2,ncen,novl))
           im_cen(ncen,novl) = nint(datamatrix(3,ncen,novl))
           wghcen(ncen,novl) = datamatrix(4,ncen,novl)
         enddo
      enddo

!     get nspcen 
      natom = 1
      do nsp = 1,nspec 
        do ni = 1,nionsp(nsp) 
          do novl = 1,numovl
            do ncen = 1,numcen(novl) 
              if (natom.eq.ioncen(ncen,novl)) nspcen(ncen,novl) = nsp
            enddo
          enddo 
          natom = natom + 1
        enddo 
      enddo

!     check nspcen and ioncen
      do novl = 1,numovl
        do ncen=1,numcen(novl)
          if (nspcen(ncen,novl).lt.0) then 
             nspcen(ncen,novl) = 1
             write(nconso,*) 'MUL:  nspcen < 0 ',ncen,novl
          endif
          if (nspcen(ncen,novl).gt.nspec) then 
             nspcen(ncen,novl) = nspec
             write(nconso,*) 'MUL: nspcen > nspec ',ncen,novl
          endif
          if (ioncen(ncen,novl).lt.0) then 
             ioncen(ncen,novl) = 1
             write(nconso,*) 'MUL: ioncen < 0 ',ncen,novl
          endif
          if (ioncen(ncen,novl).gt.nions) then 
             ioncen(ncen,novl) = nions
             write(nconso,*) 'MUL: ioncen > nions ',ncen,novl
          endif
        enddo
      enddo
        

!     write to outfile 
!       MUL: label  <nmulticenter> <description>
!       MUL: center <nmulticenter> <ncenter> <nsp> <ion> <l> <m> <weight>  


      do novl = 1,numovl
         write(nconso,2000) novl,namovl(novl)
2000     format('MUL: label ',i1,1x,a6)
         do ncen = 1,numcen(novl)
            write(nconso,2100) novl,ncen, nspcen(ncen,novl),&
                      ioncen(ncen,novl),&
                      il_cen(ncen,novl),&
                      im_cen(ncen,novl),&
                      wghcen(ncen,novl)
2100        format('MUL: center ',6(i2,1x),f13.8) 
         enddo
      enddo
      call uflush(nconso)

!     allocate output data
      allocate(ovlcen(numovl,ncut,nspin))
      allocate(mdos(nener,numovl,ncut,nspin))
      ovlcen = 0.0
      mdos   = 0.0
      nspin_local = nspin


420   format(1x,'mulcen: ',a,1x,f12.6,1x,a)
421   format(1x,'mulcen: ',a,1x,i4)
400   format(1x,'mulcen: ',a50 )

      return
      end subroutine init

! -----------------------------------------------------------------------


      subroutine make_phi(novl,ncen,il,im,phi,Sphi,&
           nlnum,mmax,rlog,radius,&
           phiatm,phir2v,lproj,mmaxx,nplwkp,&
           icut,dshcos,dwork1,radialwfct,&
#include  "apply_h_args.h" 
           ,timer)

      use van_us_data_module, only : lgenpp, bohr
      use run_context
      implicit none

#     include "apply_h_decl.h"
      integer novl,ncen,il,im
      complex*16 phi(nrplwv)
      complex*16 Sphi(nrplwv)
      integer mmaxx,nplwkp
      integer nlnum(nspec)
      integer mmax(nspec)
      real*8 rlog(nspec)
      real*8 radius(mmaxx,nspec)
      real*8 phiatm(mmaxx,0:2,nspec)
      real*8 phir2v(mmaxx)
      logical*4 lproj
      integer icut
      real*8 dshcos(nrplwv,3)
      real*8 dwork1(nrplwv,3)
!     array to hold radial wave functions
      real*8  radialwfct(nrplwv),timer(*)

! locals
      integer ig,mu,nsp
      real*8 x,y,z,gdotr,anorm
      complex*16 cwor12(nplwv)
!      logical,save  :: linit1=.true.

!      integer,save :: nspold(maxcen),ilold(maxcen),icutold,nkpold

!      if (linit1) then  
!        nspold = -1
!        ilold  = -1
!        icutold = -1
!        nkpold = -1
!        linit1 = .false.
!      endif


      nsp=nspcen(ncen,novl)
      mu=muc(ncen,novl)
!     if (nsp.ne.nspold(ncen).or.il.ne.ilold(ncen)&
!          .or.icut.ne.icutold.or.nkp.ne.nkpold.or.1.eq.1) then
!        nspold(ncen)=nsp
!        ilold(ncen)=il
!        icutold=icut
!        nkpold=nkp
!
! Set up the normalized s-,p- or d-wave radial wave functions
! (at R=(0,0,0) ) for this center

         call radfou(nlnum,mmax,rlog,radius,phiatm,&
              phir2v,&
              lproj,nspec,mmaxx,nplwkp,dnlkg(1,0,nkp),bohr,nrplwv,&
              nsp,il,radialwfct,icut)
         
         anorm = 0.0d0
         do ig = 1,nplwkp
             anorm = anorm + radialwfct(ig)**2
         enddo 
         write(nconso,*) 'efter radfou anorm ',anorm

!     else

!     endif

! Multiply with the spherical harmonics
 
      call atmnor(il,im,nplwkp,radialwfct,dshcos,&
           cwor12,nrplwv,lproj)

! move atomic orbital to right position 

      x=posion(1,mu,nsp)*dirc(1,1)&
       +posion(2,mu,nsp)*dirc(2,1)&
       +posion(3,mu,nsp)*dirc(3,1)
      y=posion(1,mu,nsp)*dirc(1,2)&
       +posion(2,mu,nsp)*dirc(2,2)&
       +posion(3,mu,nsp)*dirc(3,2)
      z=posion(1,mu,nsp)*dirc(1,3)&
       +posion(2,mu,nsp)*dirc(2,3)&
       +posion(3,mu,nsp)*dirc(3,3)
      do 3000 ig=1,nplwkp
         gdotr=dwork1(ig,1)*x+dwork1(ig,2)*y+dwork1(ig,3)*z
         gdotr=gdotr*dnlkg(ig,0,nkp)
         phi(ig) = dcmplx(cos(gdotr),-sin(gdotr))*cwor12(ig) 
 3000 continue

! normalize
      call normalize_phi(nplwkp,phi,Sphi,&
#include  "apply_h_args.h" 
           ,timer)

      return
      end subroutine make_phi

! --------------------------------------------------------------------------

      subroutine make_bond_antibond(novl,nplwkp,phi,Sphi,&
#include  "apply_h_args.h" 
           ,timer)

      implicit none

#     include "apply_h_decl.h"
      integer novl,nplwkp
      complex*16 phi(nrplwv,maxcen)
      complex*16 Sphi(nrplwv,maxcen)
      real*8 timer(*)

! locals
      integer ig,ncen
      complex*16 cwork(nrplwv)

! Make molecular states: w1*phi1 + w2*phi2 + .. + wn*phin
!   Numcen orbitals is given in phi
!   Weight of each arbitals is given in wghcen
!   Return result in Sphi(:,1)

      do ig=1,nplwkp
         cwork(ig) = 0.0d0
      enddo
         
! loop over centers
      do ncen = 1,numcen(novl)
         do ig=1,nplwkp
            cwork(ig) = cwork(ig) + wghcen(ncen,novl)*phi(ig,ncen)
         enddo
      enddo

! normalize
      call normalize_phi(nplwkp,cwork,Sphi,&
#include  "apply_h_args.h" 
           ,timer)

      return
      end subroutine make_bond_antibond

      subroutine normalize_phi(nplwkp,wavefunc,Swavefunc,&
#include  "apply_h_args.h" 
          ,timer)

      use van_us_data_module, only : lgenpp
      use us_hpsi_module
      implicit none

#     include "apply_h_decl.h"
      integer nplwkp
      real*8  timer(*)
      complex*16 wavefunc(nrplwv)
      complex*16 Swavefunc(nrplwv)

! locals
      integer ig
      real*8  anorm
      complex*16 dummy(1),cnorm
      complex*WF_PRECISION atmpsi(nrplwv)
      complex*WF_PRECISION stmpsi(nrplwv)
      logical*4 lhpsi,lspsi,lcalbec

! Normalize the wave-function
! If ultra-soft pp is used <atom_psi|S|atm_psi> should be normalized

      do ig = 1,nplwkp
         atmpsi(ig) = wavefunc(ig) 
      enddo
      lhpsi = .false.
      lspsi = .true.
      lcalbec = .true.
      call S_TIMES_B(stmpsi,nplwkp,lhpsi,lspsi,lcalbec,1,&
#include            H_TIMES_B_ARGS
                   ,timer,reci_psi=atmpsi)

      cnorm=dcmplx(0.0d0,0.0d0)
      do ig = 1,nplwkp
        cnorm=cnorm+conjg(atmpsi(ig))*stmpsi(ig)
      enddo 

      anorm=1.0d0/sqrt(dble(cnorm))
      do ig=1,nplwkp
         wavefunc(ig) =wavefunc(ig)*anorm
         Swavefunc(ig)=stmpsi(ig)  *anorm
      enddo
      write(6,*) 'MU2: ',sqrt(dble(cnorm))

      return
      end subroutine normalize_phi


end module multicenter_projection_module
