
! Global definitions for the message-passing parallel code
! Version @(#)msgpass.h	1.3 8/26/98

#if PVM || PVME || PARMACS || MPI

#define PARAL
#define PARAL_ARGS "parallel_args.h"
#define PARAL_DECL "parallel_decl.h"

! The send/receive wildcard (any node)
#ifdef MPI
#define ANY MPI_ANY_SOURCE
! For use in the MPI error handler
#define NCONSO 6
#else
#define ANY (-1)
#endif

! Define the message-passing chunk-size = 1 MB (of 8-byte array elements)
#define CHUNKSIZE (1*1024*1024 / 8)

#ifdef PVME
! Fix for obsolete PVMe parameters:
#define PVM
#define	PVMDATADEFAULT	PVMDEFAULT
#define	PVMDATARAW	PVMRAW
#define	PVMDATAINPLACE	PVMINPLACE
#define	PVMTASKHOST	PVMHOST
#endif PVME

#ifdef PARMACS
#define STRING		PMBYTE
#define INTEGER4	PMINT4
#define LOGICAL4	PMLOG4
#define REAL8		PMRE8
#define COMPLEX8	PMCX8
#define COMPLEX16	PMCX16
#endif PARMACS

#ifdef MPI
#define STRING          MPI_CHARACTER
#define INTEGER4        MPI_INTEGER
#define LOGICAL4        MPI_LOGICAL
#define REAL8           MPI_DOUBLE_PRECISION
#define COMPLEX8        MPI_COMPLEX
#define COMPLEX16       MPI_DOUBLE_COMPLEX
#endif MPI

! Define the message-passing library's error message subroutine

#ifdef PVM
#define MESS_PASS_ERR pvmerr
#endif PVM
#ifdef PARMACS
#define MESS_PASS_ERR chkerr
#endif PARMACS
#ifdef MPI
#define MESS_PASS_ERR mpierr
#endif

! Define the message-passing subroutines:

#ifdef PVM
#define INIT pvmfinitsend
#define SEND pvmfsend
#define RECEIVE pvmfrecv
#define MULTICAST pvmfmcast
#endif PVM

#ifdef PARMACS
#define INIT 
! #define SEND pmsndr
! #define RECEIVE pmrcvr
#define SEND mypmsnd
#define RECEIVE mypmrcv
#define MULTICAST pmcast
#endif PARMACS

! Define the data-packing/unpacking subroutines:

#ifdef PVM
#define PACK pvmfpack
#define UNPACK pvmfunpack
#endif PVM

! Probably obsolete
#ifdef MASTER

! Master->slave packer

#define MSPACK PACK

! Slave->master unpacker

#define SMPACK UNPACK
#endif MASTER

#ifdef SLAVE
! Master->slave unpacker
#define MSPACK UNPACK
! Slave->master packer
#define SMPACK PACK
#endif SLAVE

#else

#define SERIAL

#endif
