#include "definitions.h"

! Subroutines for both the message-passing master and slave tasks

      subroutine msinit (lmastr,&
                         idebug,&
#include                 PARAL_ARGS
                         )
      use run_context
      use par_functions_module

!     Initialize message passing for the master and slave tasks,
!     and distribute k-points to the slave tasks.

!     This routine should be programmed for any message passing
!     library (such as PVM version 3.3), but should isolate
!     the caller from the details of message passing.  Any global
!     message-passing variables should accordingly be passed through
!     common-blocks of static size (for inclusion in a library).
!     Ole H. Nielsen, 27-Apr-1995

!     MPI support added / Lennart september 1996

!     Arguments:
!     Input:
!     nconso ... output unit
!     slvexe ... name of the slave executable file                  (paral_args)
!     idebug ... Set the internal debugging-flag to this value
!     Output:
!     myid ..... identifier of this parallel process (integer)      (paral_args)
!     lmastr .... TRUE if this task is the master task              (paral_args)
!     par_process parallel process number                           (paral_args)
!     par_group   Communicator identifying group of par. processes  (paral_args)
!     par_np      total number of processes in this group           (paral_args)

      implicit none
      integer idebug,myid
      logical*4 lmastr

#include "ms.h"
#include PARAL_DECL

!     Local variables
      character*32 arch, name, libnam
      character*999 outfil
      integer madtid, narch, dtid, numt, imast, mtu, speed, info, ihost
      integer nproc, dummy, n, sender, bufid, idummy(1)
      external mpierrf
      integer errhandler
      character*(MPI_MAX_PROCESSOR_NAME) procname
      integer resultlen
      integer status(MPI_STATUS_SIZE)

      call uttime(time)
      msdebug = idebug
      ms_time = - time(1)

!     start up the parallel enviroment
!     return total number of processes for this group : par_np
      call par_start(&
#include PARAL_ARGS
        )

!      if (idebug.gt.0) then 
!        write(*,*) 'PAR: Number of proc in this group ',par_np
!        write(*,*) 'PAR: Group id ',par_process
!      endif

!     below use nhost      : the number of host in this group
!               mytid/myid : process number for this process
!               matid      : process number for master node 
      mytid  = par_process
      myid  = mytid
      nhosts = par_np


      matid = 0
      madtid = matid
      libnam = 'MPI'

!     Errors are fatal so far. Register a custom error handler routine
      call MPI_Errhandler_create(mpierrf, errhandler, info)
      call MPI_Errhandler_set(comm, errhandler, info)

!     init run_context for all
      if (mytid.eq.matid) call init_run_context(.true.)
! ----------------------------------------------------------------------

!     Receive "I'm running" messages from all slaves before proceeding.
!     This ensures that all slaves are ready to receive messages,
!     and is likely vital for large numbers of slave tasks.

      if (mytid.eq.madtid) then 
         lmaster = .true.
         lslave  = .false.
         do ihost = 1, par_np - 1
           call smstart (nconso, ANY, MSG_ARRAY, &
              'msinit: I am running')
           idummy(1) = mytid
           sender = ANY
           call smpack(sender,MSG_ARRAY,INTEGER4,idummy,1,info)
           call MESS_PASS_ERR (nconso, 'msinit: UNPACK', info)
           if (idebug.gt.0) then
             write(nconso,*) 'PAR: msinit: slave running, TID = ', idummy(1)
           endif
         enddo
         if (idebug.gt.0) then 
           call msmess (nconso, 'msinit:', 'all slaves are now running')
           call uflush(nconso)
         endif
      else
        lmaster = .false.
        lslave  = .true.
!       Send "I'm running" message to the master
        call smstart (nconso, ANY, MSG_ARRAY, &
           'msinit: I am running')
        idummy(1) = mytid
        call smpack(sender,MSG_ARRAY,INTEGER4,idummy,1,info)
        call MESS_PASS_ERR (nconso, 'msinit: smpack', info)

        call MESS_PASS_ERR (nconso, 'msinit: SEND', info)
      endif

!     Send command-line arguments from master to all slaves
!     run_context holds all command line arguments in str_args
!     We do this because mpich have a problem with
!     commandline arguments for slave nodes.
      call ms_send_cmdline_args()

!     Now we can init run_context for slave nodes
      if (lslave) call init_run_context(.false.)


!     check the netcdf variable MPIControl if word group should split up 
      call sub_divide_worldgroup(comm,par_np,par_process)
      nhosts = par_np
      mytid  = par_process
      myid  = mytid

      if (par_process .eq. matid) then
!       I am the master !
        lmaster = .TRUE.
        lslave  = .FALSE.
      else
!       I am but a poor slave !
        lmaster = .FALSE.
        lslave  = .TRUE.
      endif
      lmastr = lmaster 


      if (lslave) goto 300

!     Now the master starts up the slave tasks

!     The master process writes to the filename: ASCII_output_filename, if
!     ASCII_output_filename_provided  == true, otherwise no file association
 
      if (ASCII_output_filename_provided)&
        open (nconso, FILE=ASCII_output_filename , FORM='FORMATTED')                 

      write(nconso,*) 'PAR: Hosts in this parallel machine:'
      call uflush(nconso)

      imast = -1
      do 200 ihost = 1, MXHOST
        if (ihost .gt. par_np) goto 210

! The master node receives host names from the slaves
      if (ihost.eq.1) then
         call MPI_Get_processor_name(procname, resultlen, info)
      else
         call MPI_Recv(procname, MPI_MAX_PROCESSOR_NAME, MPI_CHARACTER,&
             ihost - 1, MSG_MESSAGE, comm, status, info)
      endif
      dtid = ihost - 1
      slvtid(ihost) = dtid
      write(nconso,120) ihost, dtid, procname(1:20)
120   format (' PAR: host no. ', i4, ' (hostid=', i4,&
        ') hostname=', a30)

      call uflush (nconso)
      if (par_np .le. 1) then
        write(nconso,*) 'PAR: ERROR: number of hosts = ', par_np,&
          ' should be > 1'
        call clexit (nconso)
      endif

      if (dtid .eq. madtid) then
!       Master process
        imast = ihost
        lmaster = .true.
        write(nconso,*) 'PAR: The above is the master task, ',&
          '         TID = ', matid

      endif

200   continue

210   write(nconso,220) par_np
220   format (' PAR: This run contains ', i4, ' machines')
      if (imast .le. 0 .or. imast .gt. par_np) then
        write(nconso,225) 
225     format (' PAR: Error: the master task was not identified')
        call clexit (nconso)
      endif

!     Now that the slave tasks are started, we can open the output files

300   continue

      if (lslave) then 
        call MPI_Get_processor_name(procname, resultlen, info)
        call MPI_Send(procname, MPI_MAX_PROCESSOR_NAME, MPI_CHARACTER,&
          0, MSG_MESSAGE, comm, info)
      endif

!     Now we can open ascii outfile for slaves
      if (lslave) then 
         
!       The slave processes write to the fileroot.slave<identifier>
!       Only if idebug>0
        if ((ASCII_output_filename_provided).and.(idebug>0)) then
          write (outfil, '(2a,i6.6)') trim(ASCII_output_filename),&
                                      ".slave", myid
          open (nconso, FILE=outfil, FORM='FORMATTED')
        else
          open (nconso, FILE=ASCII_slaveoutput_dump, FORM='FORMATTED')
        endif                                               

      endif

      write(nconso,400) libnam
400   format (1x/' PAR: Initialized libtos using ', a20)
#ifndef VPP500
!     Fujitsu VPP-500 requires a single image which is replicated from
!     master onto slaves, and thus the VPP-500 has no slave executable.
      write(nconso,410) slvexe
410   format (' PAR: Slave executable = ', a20)
#endif VPP500
      call uflush (nconso)

!     Print out start-message and module versions
      call libprt (nconso)

      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

#ifndef MPI
      subroutine slstat (nconso, id, info)

!     Master check if slave task ID="id" is responding
!     If id <= 0 all slaves are checked

      implicit none
      integer nconso, id, info
#include "ms.h"

      integer i

      call uttime(time)
      ms_time = ms_time - time(1)

#ifdef PVM
      do 200 i = 1, nhosts
        if (slvtid(i) .eq. matid) then
          goto 200
        else if (id .eq. slvtid(i) .or. id .le. 0) then
          call pvmfpstat (slvtid(i), info)
          if (info .ne. PvmOk) then
            write (nconso,*) 'PAR: slstat: Host ID=', slvtid(i), &
              ' is not responding'
            call pvmerr (nconso, 'slstat', info)
          endif
        endif
200   continue
#endif PVM
#ifdef PARMACS
      info = pmstat ()
      if (info .ne. PMGOOD) then
        write (nconso,*) 'PAR: slstat: PARMACS status is not GOOD'
      endif
#endif PARMACS

      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end
#endif

      subroutine kpdist (nconso, id, nhosts, kphost, nkprun, imast)

!     Calculate nkprun k-points' distribution among nhosts tasks

      implicit none
      integer nkprun,nconso,imast,nhosts
      integer kphost(nkprun)
      integer id(nhosts)

!     Local variables
      integer nkp1, nrem, ihost, nkp, nk, k

!     Calculate number of k-points for one host, and remainder
      nkp1 = nkprun / nhosts
      nrem = nkprun - nkp1*nhosts
      nkp = 0

      do 200 ihost = 1, nhosts
        nk = nkp1
        if (nrem .gt. 0 .and. ihost .ne. imast) then
!         Add one remainder k-point to slave task (none on master)
          nk = nk + 1
          nrem = nrem - 1
        endif
        do 100 k = 1, nk
          kphost(nkp+k) = id(ihost)
100     continue
        if (nk .gt. 1) then
          write (nconso,*) 'PAR: kpdist: TID=', id(ihost),&
          ' is assigned k-points no. ', nkp+1, ' until ', nkp+nk
        else if (nk .eq. 1) then
          write (nconso,*) 'PAR: kpdist: TID=', id(ihost),&
          ' is assigned k-point no. ', nkp+1
        endif
        nkp = nkp + nk
200   continue

      if (nkp .ne. nkprun) then
        write(nconso,300) nkp, nkprun
300     format (' PAR: Bad k-point distribution: ', 2i8)
        call clexit (nconso)
      endif
      return
      end

      subroutine smpack (sender, msgtag, type, array, n, info)

!     Slave-to-master data packing (PARMACS: send/receive)
!     MPI: send/receive. Master receives from 'sender'. If
!     'sender' is 'ANY' (alias MPI_ANY_SOURCE), the actual sender
!     rank is returned in 'sender'.
      use par_functions_module, only: comm_world
      implicit none
 
#include "ms.h"

      integer sender, msgtag, type, n, info, array(*)

!     Local vars
      integer nbytes, actag, aclen, acsen

      integer status(MPI_STATUS_SIZE) 
      if (lslave) then
        call MPI_Send(array, n, type, matid, msgtag, comm_world,info)
      else if (lmaster) then
        call MPI_Recv(array, n, type, sender, msgtag, comm_world,status,info)
        sender = status(MPI_SOURCE)
      endif

      return
      end

      subroutine msmess (nconso, text1, text2)

!     Write out an informative message

      integer nconso
      character*(*) text1, text2

      write (nconso,*) 'PAR: ', text1, ' ', text2
      call uflush(nconso)
      return
      end

      subroutine msdebg (nconso, idebug)

!     Set internal debugging parameter

      integer nconso, idebug

#include "ms.h"

!     idebug ... Debugging value (0,1,2)

      if (idebug .lt. 0 .or. idebug .gt. 10) then
        write (nconso,*) 'PAR: msdebg: unreasonable debug value=',&
          idebug, ', ignored'
        return
      endif

      msdebug = idebug
      write (nconso,*) 'PAR: msdebg: debug value=', idebug
      call uflush(nconso)
      return
      end

      subroutine msstart (nconso, msgtag, text)

!     Start up master -> slave communication

#include "ms.h"

!     msgtag ........ Message tag
!     text .......... Informative text
      integer nconso, msgtag
      character*(*) text

!     Local variables
      integer bufid
      character*80 txtbuf

      if (lmaster) then
        if (msdebug .gt. 1) call msmess (nconso, 'sending:', text)
!       Check that slaves are responding:
!       Maybe this should always be done, if the overhead isn't too large.
!       if (msdebug .gt. 0) call slstat (nconso, 0, info)

#ifdef PVM
        call INIT (PVMDATARAW, bufid)
        if (bufid .lt. 0) then
          write (txtbuf,500) 'INIT', text
          call MESS_PASS_ERR (nconso, txtbuf, bufid)
        endif
#endif PVM

      else

        if (msdebug .gt. 1) call msmess (nconso, 'receiving:', text)
#ifdef PVM
        call RECEIVE (matid, msgtag, bufid)
        if (bufid .lt. 0) then
          write (txtbuf,500) 'RECEIVE', text
          call MESS_PASS_ERR (nconso, txtbuf, bufid)
        endif
#endif PVM
      endif
500   format (' PAR: ', a, 1x, a)

      return
      end

      subroutine msfinish (nconso, tid, msgtag, nOK, text1, text2)

!     Finish up the master -> slave communication (send or multicast)

#include "ms.h"

!     tid ........... Task-id to send to.  A -1 means multicast to all.
!     msgtag ........ message tag
!     nOK ........... Status value from message-passing call
!     text1,2 ....... informative text
      integer nconso, tid, msgtag, nOK
      character*(*) text1, text2

#ifdef PVM
!     Local variables
      integer bufid, info
      character*80 txtbuf

      if (lmaster) then
        if (tid .eq. matid) then
          call msmess (nconso, text1,&
            'cannot let master send to itself') 
          call clexit (nconso)
        else if (tid .ge. 0) then
          call SEND (tid, msgtag, info)
        else
!         Multicast the data to all slaves
#ifdef PVME
          call MULTICAST (nhosts-1, slvtid(2), msgtag, info)
#else  PVME
          call MULTICAST (nhosts, slvtid, msgtag, info)
#endif PVME
          if (info .lt. 0) call MESS_PASS_ERR (nconso, text1, info)
        endif

      else

        if (nOK .lt. 0) then
          write (txtbuf,500) text1
500       format (' PAR: msfinish called from ', a)
          call MESS_PASS_ERR (nconso, txtbuf, bufid)
        endif
        if (msdebug .gt. 1) call msmess (nconso, text1, text2)
      endif
#endif PVM

      return
      end

      subroutine smstart (nconso, tid, msgtag, text)

!     Start up slave -> master communication

#include "ms.h"

!     tid ........... Task-id (used by master when receiving)
!     msgtag ........ message tag (used by master)
!     text .......... informative text
      integer nconso, tid, msgtag
      character*(*) text

!     Local variables
      integer bufid
      character*80 txtbuf

      if (lslave) then
!       Slave
        if (mytid .eq. matid) then
          call msmess (nconso, 'smstart:',&
            'cannot let master send to itself')
          call msmess (nconso, 'ERROR:', text)
          call clexit (nconso)
        endif
        if (msdebug .gt. 1) call msmess (nconso, 'sending:', text)
#ifdef PVM
        call INIT (PVMDATARAW, bufid)
        if (bufid .lt. 0) then
          write (txtbuf,500) 'INIT', text
          call MESS_PASS_ERR (nconso, txtbuf, bufid)
        endif
#endif PVM
      else

!       Master
        if (msdebug .gt. 1) call msmess (nconso, 'receiving:', text)
#ifdef PVM
!       Blocking receive
        call RECEIVE (tid, msgtag, bufid)
        if (bufid .lt. 0) then
          write (txtbuf,500) 'RECEIVE', text
          call MESS_PASS_ERR (nconso, txtbuf, bufid)
        endif
#endif PVM
      endif
500   format (' PAR: ', a, 1x, a)

      return
      end

      subroutine magchk (nconso, magval, text)

!     Check that magval equals the MAGIC value

#include "ms.h"

      integer nconso, magval
      character*(*) text

      if (magval .ne. MAGIC) then
        write (nconso,500) MAGIC, magval
500     format (' PAR: expected magic value=', i10, ' got=', i10)
        call MESS_PASS_ERR (nconso, text, PvmOk)
      endif

      return
      end

      subroutine mstuop (nconso, kphost, nkprun,&
            nlnum,mmax,rlog,radius,phiatm,vion,phir2v,&
            mmaxx,&
            dirc, diri, vext,ffield,&
            enmax,  newpts,&
            idipol, icharc, icharg, &
            lpctx,lpcty, lpctz, nelect,nionch,nichsq,&
            ngx,ngy,ngz,nionsp,nions,&
            nmsfft, nplwv, npspts, nspec,nsymax, numsym,nmstyp,&
            posion, pscale, pscore,psgmax, psp, rho_rad, &
            recc, reci, &
            vkpt, volc, width, wtkpt, &
            occmix,&
            gkp123,smethod,nkpibz,nkpunf,lkpinv,nkpnum,&
            zdip,stmcen,stmwid,&
            ispati,dip0,extfie,dipmix,nbspas,nkspas,lworkp,langul,&
            wangul,extpot,enemin,enemax,nener,rcutoff,avebox,kspin,niter,ndiapb,&
            ireset, lspsi, ieigsolver,&
            nrplwv,nrplwv_global,nbands,&
            output_wavefunction_to_netcdf,&
            output_chargedensity_to_netcdf,&
            output_totalstress_to_netcdf,&
            output_effpotential_to_netcdf,&
            output_elspotential_to_netcdf)

!     Broadcast all the data from setuop() from master to slaves

      use van_us_data_module
      use par_functions_module
      implicit none

      integer  nrplwv,nbands,nrplwv_global

#include "ms.h"

      integer nconso
!     Array of task-ID's for each k-point
      integer nkprun,nkpnum
      integer kphost(nkprun)

      integer nspec, nions, mmaxx, ngx, ngy, ngz
      integer nionch,nichsq
      integer   nlnum(nspec)
      integer   mmax(nspec)
      real*8    rlog(nspec)
      real*8    radius(mmaxx,nspec)
      real*8    phiatm(mmaxx,0:2,nspec)
      real*8    vion(mmaxx,0:2)
      real*8    phir2v(mmaxx)
      real*8    dirc(3,3)
      real*8    diri(3,3)
      real*8    vext(ngz)
      real*8    ffield(3,nions,nspec)
      real*8 enmax
      integer idipol, newpts
      integer   icharc(nions)
      integer   icharg(nspec)
      integer   lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8     nelect
      integer   nionsp(nspec)
      integer nplwv,npspts,nsymax,numsym
      integer nmsfft(nplwv,max(nsymax,1))
      integer nmstyp(max(nsymax,1))
      real*8  posion(3,nions,nspec)
      real*8    pscale(0:2,nspec)
      real*8    pscore(nspec)
      real*8    psgmax(nspec)
      real*8    psp(npspts,nspec)
      real*8    rho_rad(npspts,nspec)
      real*8    recc(3,3),reci(3,3)
      real*8    vkpt(3,nkprun)
      real*8 volc,width
      real*8 wtkpt(nkprun)
      real*8 occmix
      real*8 gkp123(3,nkpnum)
      integer smethod
      integer nkpibz(nkpnum)
      integer nkpunf(3,3,nkpnum)
      logical*4   lkpinv(nkpnum)
      real*8 zdip
      real*8 stmcen,stmwid
      integer ispati
      real*8 dip0, extfie
      real*8 dipmix
      integer nbspas,nkspas
      logical*4 lworkp,langul
      real*8 wangul
      real*8 extpot
      real*8 enemin
      real*8 enemax
      integer nener
      real*8  rcutoff
      real*8 avebox(3,4)
      integer kspin(nkprun)
      integer niter
      integer ndiapb
      integer     ireset
      logical*4   lspsi
      integer     ieigsolver
      logical*4   output_wavefunction_to_netcdf
      logical*4   output_chargedensity_to_netcdf
      logical*4   output_totalstress_to_netcdf
      integer     output_effpotential_to_netcdf
      integer     output_elspotential_to_netcdf
!
!     include Ultra-Soft variables

#     include "readvan.h"

!     Local variables
      integer bufid, nOK, m
      real*8 tsetup

      if (nkprun .le. 0 .or. nspec .le. 0 .or. mmaxx .le. 0 .or.&
        nions .le. 0 .or. ngx .le. 0 .or. ngy .le. 0 .or.&
        ngz .le. 0 .or. npspts .le. 0 .or.newpts .le. 0) then
        write (nconso,100) nkprun, nspec, mmaxx, nions, ngx, ngy, ngz,&
          npspts, newpts
100     format (' PAR: mstuop: some dimension is not > 0:'/&
          1x,6i10/1x,3i10)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)
      tsetup = - time(1)

      call msstart (nconso, MSG_SETUP, 'mstuop: setup data')

!     Administrative data
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, kphost,  nkprun, nOK)

!     Message-passing hosts data
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nhosts,  1, nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, slvtid,  MXHOST, nOK)

!     Data that are k-point independent
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nlnum,   nspec, nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, mmax,    nspec, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    rlog,    nspec, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    radius,  nspec*mmaxx, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    phiatm, nspec*mmaxx*3,nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    vion,    mmaxx*3, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    phir2v,  mmaxx, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    dirc,    9, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    diri,    9, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    vext,    ngz, nOK)
      call mspack_double_array (nconso,ANY,MSG_SETUP,&
        REAL8,    ffield,nspec*nions*3,nOK)
      call mspack_double_scalar (nconso,ANY,MSG_SETUP,&
        REAL8,    enmax,   1, nOK)
      call mspack_integer_scalar (nconso,ANY,MSG_SETUP,&
        INTEGER4, idipol,  1, nOK)
      call mspack_integer_array (nconso,ANY,MSG_SETUP,&
        INTEGER4, icharc,nions, nOK)
      call mspack_integer_array (nconso,ANY,MSG_SETUP,&
        INTEGER4, icharg,  nspec, nOK)

      call mspack_integer_array (nconso,ANY,MSG_SETUP,&
        INTEGER4, lpctx,   ngx, nOK)
      call mspack_integer_array (nconso,ANY,MSG_SETUP,&
        INTEGER4, lpcty,   ngy, nOK)
      call mspack_integer_array (nconso, ANY,MSG_SETUP,&
        INTEGER4, lpctz,   ngz, nOK)
      call mspack_double_scalar (nconso,ANY,MSG_SETUP,&
        REAL8,  nelect,  1, nOK)
      call mspack_integer_array (nconso, ANY,MSG_SETUP,&
                   INTEGER4, nionsp,  nspec, nOK)
      call mspack_integer_scalar (nconso,ANY, MSG_SETUP,&
                   INTEGER4, nionch,  1, nOK)
      call mspack_integer_scalar (nconso,ANY, MSG_SETUP,&
                   INTEGER4, nichsq,  1, nOK)
      call mspack_integer_scalar (nconso,ANY, MSG_SETUP,&
                   INTEGER4, numsym,  1, nOK)
      call mspack_integer_array (nconso,ANY, MSG_SETUP,&
                   INTEGER4, nmstyp,  nsymax, nOK)
      do 200 m = 1, nsymax
        call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nmsfft(1,m), nplwv,nOK)
200   continue

      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkpnum,  1, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
           REAL8,    posion,nspec*nions*3,nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
           REAL8,    pscale,  nspec*3, nOK)

      call mspack_double_array (nconso, ANY, MSG_SETUP,&
           REAL8,    pscore,  nspec, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
           REAL8,    psgmax,  nspec, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    psp,npspts*nspec, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    rho_rad,npspts*nspec, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    recc,    9, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    reci,    9, nOK)


      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    vkpt,    nkprun*3, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    volc,    1, nOK)

      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    width,   1, nOK)

      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    wtkpt,   nkprun, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    occmix,  1, nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    gkp123,  nkpnum*3, nOK)

      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, smethod,  1, nOK)

      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkpibz,  nkpnum, nOK)

      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkpunf,  nkpnum*3*3, nOK)
      call mspack_logical_array (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, lkpinv,  nkpnum, nOK)

      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    zdip,    1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    stmcen,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    stmwid,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ispati,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    dip0,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    extfie,  1, nOK)


      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    dipmix,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nbspas,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkspas,  1, nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, lworkp,  1, nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, langul,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    wangul,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    extpot,  1, nOK)
      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    enemin,  1, nOK)

      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          REAL8,    enemax,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
          INTEGER4,    nener,  1, nOK)

      call mspack_double_scalar (nconso, ANY, MSG_SETUP,&
          INTEGER4,    rcutoff,  1, nOK)

      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    avebox,  3*4, nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, kspin,   nkprun, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, niter,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ndiapb,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ireset,  1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ieigsolver,  1, nOK)

!     variables from van_us_decl.h
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkb,  1,              nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ityp,  nions,       nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    qq,  nhm*nhm*nspec,   nOK)
      call mspack_logical_array (nconso, ANY, MSG_SETUP,&
          LOGICAL4,vkbreal,  nkbpmaxatom*nspec,   nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    dvan,  nhm*nhm*nspec, nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nh,  nspec,           nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4,    nhtol, nhm*nspec,  nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nhtom, nhm*nspec,     nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkbtona,  nkbmax,     nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkbtonh,  nkbmax,     nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkbc,  nions*nhm,     nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nkbp, 1 ,             nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, indv, nhm*nspec,      nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    ap,  25*nlx*nlx,      nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, lpx,  nlx*nlx,        nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, lpl,  nlx*nlx*mx,     nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, lspsi,  1,        nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, lgenpp,  1,       nOK)

      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
        LOGICAL4,output_wavefunction_to_netcdf,1,nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
        LOGICAL4,output_totalstress_to_netcdf,1,nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_SETUP,&
        LOGICAL4,output_chargedensity_to_netcdf,1,nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
        INTEGER4,output_effpotential_to_netcdf,1,nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_SETUP,&
        INTEGER4,output_elspotential_to_netcdf,1,nOK)

!     readvan variables  (common dion)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,    dion,  &
                   nbrx*nbrx*npsx,           nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8,   betar, &
                   (ndm+1)*nbrx*npsx  ,      nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, qqq,     &
                   nbrx*nbrx*npsx,           nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, qfunc,   &
                   (ndm+1)*nbrx*nbrx*npsx  , nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nbeta,  npsx,   nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, kkbeta,npsx,    nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nvales,npsx,    nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, lll,   &
                   nbrx*npsx,                nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, iver,  3*npsx,  nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nqf,   npsx,    nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, ifqopt,  npsx,  nOK)
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
                   INTEGER4, nqlc,  npsx,    nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, qfcoef, &
                   nqfm*lqx*nbrx*nbrx*npsx , nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, rinner, lqx*npsx , nOK)

!     readvan variables  (common atom, not all)
      call mspack_logical_array (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, tvanp, npsx,    nOK)
      call mspack_logical_array (nconso, ANY, MSG_SETUP,&
                   LOGICAL4, tlog,   npsx,   nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, r,     &
                   (ndm+1)*npsx ,            nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, rab,   &
                   (ndm+1)*npsx ,            nOK)
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, rho_at,&
                   (ndm+1)*npsx ,            nOK)      
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, rho_atc,&
                   (ndm+1)*npsx ,            nOK)      
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, vnl,&
                   (ndm+1)*(lmaxx+2)*npsx ,  nOK)      
      call mspack_double_array (nconso, ANY, MSG_SETUP,&
          REAL8, zp,&
                    npsx ,            nOK)      
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
          INTEGER4, lloc,&
                    npsx ,            nOK)      
      call mspack_integer_array (nconso, ANY, MSG_SETUP,&
          INTEGER4, mesh,&
                    npsx ,            nOK)      
      
!     A "magic" value at the end for sanity checking
      m = MAGIC
      call mspack_integer_scalar (nconso, ANY, &
        MSG_SETUP, INTEGER4,&
        m,  1, nOK)

      call msfinish (nconso, ANY, MSG_SETUP, nOK, 'mstuop', &
        'data from setuop()')
      call magchk (nconso, m, 'mstuop')
 
      call uttime(time)
      ms_time = ms_time + time(1)
      tsetup  = tsetup  + time(1)
      write (nconso,500) tsetup
500   format (' PAR: mstuop: done multicasting setup data ',&
        f10.3, ' CPU seconds')
      call uflush (nconso)

      return
      end

      subroutine donkp (ldonkp, kphost, nkprun, myid, nkploc)

!     Assign ldonkp=TRUE where kphost==myid.
!     Return the number of TRUE values in nkploc.
 
      implicit none
      integer nkprun, myid, nkploc
      logical*4 ldonkp(nkprun)
      integer kphost(nkprun)
      integer nkp

      nkploc = 0

      do 100 nkp = 1, nkprun
        if (kphost(nkp) .eq. myid) then
          ldonkp(nkp) = .TRUE.
          nkploc = nkploc + 1
        else
          ldonkp(nkp) = .FALSE.
        endif
100   continue
      return
      end

      subroutine msflag (nconso, lstop, lupdch, lupdio, lupdki, lupdnl,&
        lionmv)
      use par_functions_module		

!     Send flags from master to slaves
      implicit none

#include "ms.h"

      integer nconso
      logical*4 lstop, lupdch, lupdio, lupdki, lupdnl, lionmv

!     Local variables
      integer bufid, nOK
 
      call uttime(time)
      ms_time = ms_time - time(1)

      call msstart (nconso, MSG_FLAGS, 'msflag: flags')

      call mspack_logical_scalar (nconso, ANY, &
         MSG_FLAGS, LOGICAL4,&
         lstop,   1, nOK)
      call mspack_logical_scalar (nconso, ANY, &
         MSG_FLAGS, LOGICAL4,&
         lupdch,  1, nOK)
      call mspack_logical_scalar (nconso, ANY, &
         MSG_FLAGS, LOGICAL4,&
         lupdio,  1, nOK)
      call mspack_logical_scalar (nconso, ANY, &
         MSG_FLAGS, LOGICAL4,&
         lupdki,  1, nOK)
      call mspack_logical_scalar (nconso, ANY,  &
         MSG_FLAGS, LOGICAL4,&
         lupdnl,  1, nOK)
      call mspack_logical_scalar (nconso, ANY, &
         MSG_FLAGS, LOGICAL4,&
         lionmv,  1, nOK)

      call msfinish (nconso, ANY, MSG_FLAGS, nOK,&
         'msflag', 'flags')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end
! ----------------------------------------------------------------------------
      subroutine ms_send_cmdline_args() 
      use run_context
      use par_functions_module
 
!     Send 'number_of_args' command line arguments to slaves
!     str_args are allocated for slave nodes
      implicit none

#include "ms.h"

!     Local variables
      integer, parameter  :: str_len = 999
      integer nOK,iarg
      character(str_len)  :: str

      call msstart (nconso,MSG_CLINE,'ms_send_cmdline_args')

!     send number_of_args to slaves
      call mspack_integer_scalar (nconso, ANY, MSG_CLINE, MPI_INTEGER,&
         number_of_args, 1, nOK)                             

!     allocate str_args, if not allready allocated (master node) 
      if (.not.allocated(str_args)) then 
         allocate(str_args(0:number_of_args))
      endif 

      do iarg = 0,number_of_args 
         call mspack_character_string(nconso,ANY,MSG_CLINE,MPI_CHARACTER,&
                   str_args(iarg),  str_len , nOK)

      enddo
 
      call msfinish (nconso, ANY, MSG_CLINE, nOK,&
         'ms_send_cmdline', 'args')
 
      return
      end                                 

!
! ------------------------------------------------------------------------
!
      subroutine sm_send_becp(nconso,ldonkp,&
            becp, nkbmax,nbands,nkprun,&
#include    PARAL_ARGS   
                               )


!     Slaves send becp  for this slave's k-points back to master.
!     Master receives contributions.
!     Only first process in each pw-group send to master-process

      use par_functions_module
      implicit none
#include "ms.h"
      integer nconso,nkbmax,nbands,nkprun
      logical*4 ldonkp(nkprun)
      complex*16 becp(nkbmax,nbands,nkprun)

#include PARAL_DECL

!     Local variables
      integer bufid, info, nOK, nnkp, nkp, sender,irank
      logical*4 lflag
      integer idummy(1)

      if (nbands .le. 0 .or. nkprun .le. 0) then
        write (nconso,100) nbands, nkprun
100     format (' PAR: smkinl: Bad dimensions nbands=', i7,&
          ' nkprun=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

!     get rank in the pw group for this process
      call par_rank_pw(irank,&
#include PARAL_ARGS
       ,nconso)
!     only irank = 1 in each group send/receive
      if (irank.gt.1) return 

      do 200 nkp = 1, nkprun
        if (lslave  .and. (.not. ldonkp(nkp))) goto 200
        if (lmaster .and. ldonkp(nkp)) goto 200
        call smstart (nconso, ANY, MSG_BECP, &
          'becp')
        nnkp = nkp
        sender = ANY
        idummy(1)= nnkp
        call smpack (sender, MSG_BECP, INTEGER4, idummy, 1, nOK)
!       PARMACS: smpack returns in sender the TID, which we must use below.
!       The same is true for MPI
        call MESS_PASS_ERR (nconso, 'smbecp: smpack', nOK)
!       Identify k-point treated by slave
        if (nnkp .le. 0 .or. nnkp .gt. nkprun) then
          write (nconso,*) 'PAR: ms_send_becp: Bad nnkp=', nnkp
          call clexit (nconso)
        endif

        call smpack (sender, MSG_BECP, COMPLEX16,&
           becp(1,1,nnkp), nbands*nkbmax, nOK)

        if (lslave) then
!         Slave
#ifdef PVM
          call SEND (matid, MSG_BECP, info)
#endif PVM
          call MESS_PASS_ERR (nconso, 'sm_send_becp: SEND',  nOK )
        else
!         Master
          call MESS_PASS_ERR (nconso, 'sm_send_becp: smpack', nOK)
        endif
200   continue

      if (lmaster .and. msdebug .gt. 1)&
        call msmess (nconso, 'sm_send_becp:',&
          'Received becp from all slaves')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end
!-------------------------------------------------------------------------------

      subroutine msddin(nconso, g2max, nplwk2, ientry, ichsto,&
           cdelr, cdelp, cresid, n2plwv, nspin, noldrd, ldenrd)

      use par_functions_module
!     Send flags from master to slaves

      implicit none
#include "ms.h"

      integer nconso
      real*8 g2max
      integer nplwk2,ientry,ichsto
      integer n2plwv,nspin,noldrd
      real*8  cdelr(2,n2plwv,nspin,noldrd)
      real*8 cdelp(2,n2plwv,nspin,noldrd)
      real*8 cresid(2,n2plwv,2)
      logical*4 luns2s
      logical*4 ldenrd


!     Local variables
      integer bufid, nOK
 
      call uttime(time)
      ms_time = ms_time - time(1)

      call msstart (nconso, MSG_FLAGS, 'msddin: ddin')

      call mspack_double_scalar (nconso, ANY, MSG_FLAGS,&
         REAL8,    g2max,    1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_FLAGS,&
         INTEGER4, nplwk2,   1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_FLAGS,&
         INTEGER4, ientry,   1, nOK)
      call mspack_integer_scalar (nconso, ANY, MSG_FLAGS,&
         INTEGER4, ichsto,   1, nOK)
      call mspack_double_array (nconso, ANY, MSG_FLAGS,&
         REAL8,    cdelr,   &
           2*n2plwv*nspin*noldrd, nOK)
      call mspack_double_array (nconso, ANY, MSG_FLAGS,&
         REAL8,    cdelp,   &
           2*n2plwv*nspin*noldrd, nOK)
      call mspack_double_array (nconso, ANY, MSG_FLAGS,&
         REAL8,    cresid,&
           2*n2plwv*2, nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_FLAGS,&
         LOGICAL4, luns2s,   1, nOK)
      call mspack_logical_scalar (nconso, ANY, MSG_FLAGS,&
         LOGICAL4, ldenrd,   1, nOK)

      call msfinish (nconso, ANY, MSG_FLAGS, nOK,&
         'msddin', 'ddin')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine mswf (nconso, idslav, nkp, &
        cptwfp, occ, eigen,&
        ipwpad,nplwkp,pwkine,dnlg,dnlkg, &
        nrplwv, nbands, efermi)

!     Send one wavefunction (all bands of 1 k-point) from master to slave
!     denoted by idslav.
!     The arrays have the last dimension (nkprun) removed

      implicit none
#include "ms.h"

      integer nconso, idslav, nkp
      integer nrplwv, nbands, nplwkp
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      real*8 occ(nbands)
      real*8 eigen(nbands)
      integer ipwpad(nrplwv)
      real*8 pwkine(nrplwv)
      real*8 dnlg(nrplwv,3)
      real*8 dnlkg(nrplwv,0:3)
      real*8 efermi

!     Local variables
      integer nn, nns, sender, iwf

      if (msdebug .gt. 1) then
        write(nconso,*)&
          'PAR: mswf: Sending wavefunction for k-point ',&
          nkp, ' to slave ID ', idslav
        call uflush(nconso)
      endif
 
!     Loop over bands and initial data since a complete wavefunction
!     may exceed the available buffer space (32 MB/msg and 128 MB
!     total in PVMe 1.3)

      call ms_int4  (nconso, idslav, nkp,    1, 'mswf: nkp', 0)
      call ms_int4  (nconso, idslav, nplwkp, 1, 'mswf: nplwkp', 0)
      call ms_real8 (nconso, idslav, efermi, 1, 'mswf: efermi', 0)
      call ms_real8 (nconso, idslav, eigen,  nbands, 'mswf: eigen', 0)
      call ms_real8 (nconso, idslav, occ,    nbands, 'mswf: occ', 0)
      call ms_int4  (nconso, idslav, ipwpad, nrplwv, 'mswf: ipwpad', 0)
      call ms_real8 (nconso, idslav, pwkine, nrplwv, 'mswf: pwkine', 0)
      call ms_real8 (nconso, idslav, dnlg,  nrplwv*3, 'mswf: dnlg', 0)
      call ms_real8 (nconso, idslav, dnlkg, nrplwv*4, 'mswf: dnlkg', 0)

!     The wavefunction cptwfp:
!     Here we use the fact that a complex*8 takes as many bytes (8)
!     as a real*8, hence we can use ms_real8() also for complex*8 arrays.
!     If WF_PRECISION is 16 we set iwf=2, otherwise iwf=1
      iwf = WF_PRECISION / 8

      if (nrplwv*nbands .gt. 250000) then
!       For more than 250000 elements, break up in a loop over bands
        do 200 nn = 1, nbands
#ifdef VPP500
!         Handshake: slave sends "ready to receive", in order not to 
!         overflow slave's buffer space (on VPP-500, 12-Dec-1995)
          call smstart (nconso, idslav, MSG_ARRAY, 'mswf: ready')
          nns = nn
          sender = idslav
          call smpack (sender, MSG_ARRAY, INTEGER4, nns, 1, info)
          call MESS_PASS_ERR (nconso, 'mswf: UNPACK', info)
#endif VPP500

!         Send the wavefunction band
          call ms_real8 (nconso, idslav, cptwfp(1,nn), iwf*nrplwv,&
            'mswf: cptwfp', 0)
200     continue
      else
        call ms_real8 (nconso, idslav, cptwfp, iwf*nrplwv*nbands,&
          'mswf: cptwfp', 0)
      endif

      if (msdebug .gt. 1) write (nconso,*)&
          'PAR: mswf: received wavefunction for nkp=', nkp
      call uflush (nconso)

      return
      end

      subroutine smdens (nconso, rdensr, work, nplwv)

!     Slaves send partial charge densities rdensr back to master.
!     Master receives and sums up contributions 

      implicit none
#include "ms.h"

      integer nconso, nplwv
      real*8 rdensr(nplwv), work(nplwv)

!     Local variables
      integer bufid, info, sender, ihost

      if (nplwv .le. 0) then
        write (nconso,100) nplwv
100     format (' PAR: smdens: Bad dimensions nplwv=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

      if (lslave) then
!       Slave
        call smstart (nconso, ANY, MSG_RDENSR,&
           'charge density')
        call smpack (sender, MSG_RDENSR, REAL8,&
           rdensr, nplwv, info)
        call MESS_PASS_ERR (nconso, 'smdens: smpack', info)
#ifdef PVM
!       Could use pvmfpsend/pvmfprecv here (not in PVMe :-( )
        call SEND (matid, MSG_RDENSR, info)
#endif PVM
        call MESS_PASS_ERR (nconso, 'smdens: SEND', info)
      else

!       Master receives data from all slaves (in work)
        do 200 ihost = 1, nhosts - 1
          call smstart (nconso, ANY, MSG_RDENSR,&
             'charge density')
          sender = ANY
          call smpack (sender, MSG_RDENSR, &
             REAL8,&
             work, nplwv, info)
          call MESS_PASS_ERR (nconso, 'smdens: UNPACK', info)
!         Accumulate charge density
          call add (rdensr, work, nplwv)
200     continue
        if (msdebug .gt. 1) call msmess (nconso, 'smdens:',&
          'received charge density from all slaves')
      endif
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine smkinl (nconso, ldonkp, wfkine,&
            vnl, eigen, eigold, occ, sizham, deriv, &
            nbands, nkprun,&
#include PARAL_ARGS 
            )

!     Slaves send kinetic and non-local energies 
!     for this slave's k-points back to master.
!     Master receives contributions.
!     Only first process in each pw-group send to master-process

      use par_functions_module
      implicit none
#include "ms.h"

      integer nconso, nbands, nkprun
      logical*4 ldonkp(nkprun)
      real*8 wfkine(nbands,nkprun),   vnl(nbands,nkprun)
      real*8 eigen(nbands,nkprun), eigold(nbands,nkprun)
      real*8 occ(nbands,nkprun)
      real*8 sizham(nkprun), deriv(nkprun)

#include PARAL_DECL

!     Local variables
      integer bufid, info, nOK, nnkp, nkp, sender,irank
      logical*4 lflag

      if (nbands .le. 0 .or. nkprun .le. 0) then
        write (nconso,100) nbands, nkprun
100     format (' PAR: smkinl: Bad dimensions nbands=', i7,&
          ' nkprun=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

!     get rank in the pw group for this process
      call par_rank_pw(irank,&
#include PARAL_ARGS
       ,nconso)
!     only irank = 1 in each group send/receive
      if (irank.gt.1) return 

      do 200 nkp = 1, nkprun
        if (lslave  .and. (.not. ldonkp(nkp))) goto 200
        if (lmaster .and. ldonkp(nkp)) goto 200
        call smstart (nconso, ANY, MSG_KINL, &
          'kin+n.l.+eigen+occ')
        nnkp = nkp
        sender = ANY
        call smpack (sender, MSG_KINL, INTEGER4, nnkp, 1, nOK)
!       PARMACS: smpack returns in sender the TID, which we must use below.
!       The same is true for MPI
        call MESS_PASS_ERR (nconso, 'smkinl: smpack', nOK)
!       Identify k-point treated by slave
        if (nnkp .le. 0 .or. nnkp .gt. nkprun) then
          write (nconso,*) 'PAR: smkinl: Bad nnkp=', nnkp
          call clexit (nconso)
        endif

        call smpack (sender, MSG_KINL, REAL8,&
                  wfkine(1,nnkp), nbands, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  vnl(1,nnkp),    nbands, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  eigen(1,nnkp),  nbands, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  eigold(1,nnkp), nbands, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  occ(1,nnkp),    nbands, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  sizham(nnkp),   1, nOK)
        call smpack (sender, MSG_KINL, REAL8,&
                  deriv(nnkp),    1, nOK)

        if (lslave) then
!         Slave
#ifdef PVM
          call SEND (matid, MSG_KINL, info)
#endif PVM
          call MESS_PASS_ERR (nconso, 'smkinl: SEND',  nOK )
        else
!         Master
          call MESS_PASS_ERR (nconso, 'smkinl: smpack', nOK)
        endif
200   continue

      if (lmaster .and. msdebug .gt. 1)&
        call msmess (nconso, 'smkinl:',&
          'Received kin+n.l.+eigen+occ from all slaves')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine msposi (nconso, posion, nions, nspec)

! Include ms.h, otherwise ANY will not be defined if MPI is used.
      implicit none
#include "ms.h"

!     Master sends updated ionic positions to all slaves
    
      integer nconso, nions, nspec
      real*8 posion(3,nions,nspec)

      call ms_real8 (nconso, ANY, posion, 3*nions*nspec,&
        'msposi: ionic positions', 0)

      return
      end



      subroutine ms_send_real8 (nconso, rdata)
 
! Include ms.h, otherwise ANY will not be defined if MPI is used.
      implicit none
#include "ms.h"
 
!     Master sends updated ionic positions to all slaves
 
      integer nconso
      real*8 rdata
      real*8 dataarray(1)

      dataarray(1) = rdata  
      call ms_real8 (nconso, ANY, dataarray, 1,&
        'ms_send_real8: send real', 0)
 
      return
      end

      subroutine mseigo (nconso, efermi, eigen, eigold, occ,&
        nbands, nkprun)

      implicit none
#include "ms.h"

!     Master sends eigenvalues and occupancy to all slaves

      integer nconso, nbands, nkprun
      real*8 efermi
      real*8 eigen(nbands,nkprun), eigold(nbands,nkprun)
      real*8 occ  (nbands,nkprun)

      call ms_real8 (nconso, ANY, efermi, 1,&
         'mseigo: efermi', 0)
      call ms_real8 (nconso, ANY, eigen,  nbands*nkprun,&
        'mseigo: eigen', 0)
      call ms_real8 (nconso, ANY, eigold, nbands*nkprun,&
        'mseigo: eigold', 0)
      call ms_real8 (nconso, ANY, occ,    nbands*nkprun,&
        'mseigo: occ', 0)

      return
      end

      subroutine smfnl (nconso, fnleif, work, nionsp, nions, nspec)

!     Slaves send partial non-local forces back to master.
!     Master receives and sums up contributions 

      implicit none
#include "ms.h"

      integer nconso, nions, nspec
      real*8 fnleif(3,nions,nspec), work(3,nions,nspec)
      integer nionsp(nspec)

!     Local variables
      integer bufid, info, m, mu, nsp, sender,ihost

      if (nions .le. 0 .or. nspec .le. 0) then
        write (nconso,100) nions, nspec
100     format (' PAR: smfnl: Bad dimensions nions=', i7,&
          ' nspec=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

      if (lslave) then
!       Slave
        call smstart (nconso, ANY, MSG_FNL, 'n-l forces')
        call smpack (sender, MSG_FNL,&
          REAL8, fnleif, 3*nions*nspec, info)
        call MESS_PASS_ERR (nconso, 'smfnl: smpack', info)
#ifdef PVM
        call SEND (matid, MSG_FNL, info)
        call MESS_PASS_ERR (nconso, 'smfnl: SEND', info)
#endif PVM
      else

!       Master receives rdensr from all slaves
        do 200 ihost = 1, nhosts - 1
          call smstart (nconso, ANY, MSG_FNL, 'n-l forces')
          sender = ANY
          call smpack (sender, MSG_FNL,&
            REAL8, work, 3*nions*nspec, info)
          call MESS_PASS_ERR (nconso, 'smfnl: smpack', info)
!         Accumulate n-l forces
          do 150 nsp = 1, nspec
            do 150 mu = 1, nionsp(nsp)
              do 150 m = 1, 3
                fnleif(m,mu,nsp) = fnleif(m,mu,nsp) +&
                  work(m,mu,nsp)
150           continue
200     continue
        if (msdebug .gt. 1) call msmess (nconso, 'smfnl:',&
          'received n-l forces from all slaves')
      endif
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine ms_real8 (nconso, tid, array, narray, text, inplace)
      use par_functions_module

!     Utility: Master sends an array (real*8) to slave "tid",
!     or to all slaves if tid is -1.
!     The text string identifies the caller for debugging output.
!     If inplace is 1, the array is sent in-place (not copied to buffer).

!     tid ........... Task-id to send to.  A -1 means multicast to all.
!     array ......... array of type real*8
!     narray ........ size of array
!     text .......... informative text
!     Used only for PVM:
!     inplace ....... 0 for "raw" transfer via PVM buffer,
!                     1 for in-place transfer

      implicit none
#include "ms.h"

      integer nconso, tid, narray, inplace
      real*8 array(narray)
      character*(*) text

!     Local variables
      integer bufid, nOK, encoding

      if (narray .le. 0) then
        write (nconso,100) narray
100     format (' PAR: ms_real8: Bad dimension narray=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

#ifdef PVM
!     At the moment, we don't specify encoding to msstart
      encoding = PVMDATARAW
      if (inplace .eq. 1) encoding = PVMDATAINPLACE
#endif PVM

      call msstart (nconso, MSG_ARRAY, text)
      call mspack_double_array (nconso, tid,MSG_ARRAY,REAL8,array,narray,nOK)
      call MESS_PASS_ERR (nconso, text, nOK)
      call msfinish (nconso, tid, MSG_ARRAY, nOK, text, ' ')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine ms_int4 (nconso, tid, array, narray, text, inplace)
      use par_functions_module

!     Utility: Master sends an array (integer*4) to slave "tid",
!     or to all slaves if tid is -1.
!     The text string identifies the caller for debugging output.
!     If inplace is 1, the array is sent in-place (not copied to buffer).

!     tid ........... Task-id to send to.  A -1 means multicast to all.
!     array ......... array of type integer*4
!     narray ........ size of array
!     text .......... informative text
!     Used only for PVM:
!     inplace ....... 0 for "raw" transfer via PVM buffer,
!                     1 for in-place transfer

      implicit none
#include "ms.h"

      integer nconso, tid, narray, inplace
      integer*4 array(narray)
      character*(*) text

!     Local variables
      integer bufid, nOK, encoding

      if (narray .le. 0) then
        write (nconso,100) narray
100     format (' PAR: ms_int4: Bad dimension narray=', i7)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

#ifdef PVM
!     At the moment, we don't specify encoding to msstart
      encoding = PVMDATARAW
      if (inplace .eq. 1) encoding = PVMDATAINPLACE
#endif PVM

      call msstart (nconso, MSG_ARRAY, text)
      call mspack_integer_array (nconso,tid,MSG_ARRAY,INTEGER4,array,narray,nOK)
      call MESS_PASS_ERR (nconso, text, nOK)
      call msfinish (nconso, tid, MSG_ARRAY, nOK, text, ' ')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine mssendok (nconso, idslav)
      use par_functions_module

!     Master-slave handshaking: slave sends only data
!     when requested by master.  Master talks with slave TID=idslav.

      implicit none
#include "ms.h"

      integer nconso, idslav

!     Local variables
      integer info, nOK, sendOK, OK
      parameter (OK = 1)

      if (msdebug .gt. 1) call msmess (nconso, 'mssendok',&
        'Master-slave handshaking')
      if (lmaster .and. idslav .eq. matid) then
        call msmess (nconso, 'mssendok', &
          'cannot let master send to itself')
        call clexit (nconso)
      endif

      call uttime(time)
      ms_time = ms_time - time(1)

!     Master sends to only one slave.
      call msstart (nconso, MSG_SEND_OK, 'mssendok')
 
      sendOK = OK
      call mspack_integer_scalar(nconso,idslav,MSG_SEND_OK,INTEGER4,&
        sendOK, 1, info)

      if (lmaster) then
!       Master
#ifdef PVM
        call SEND (idslav, MSG_SEND_OK, info)
#endif PVM
        call MESS_PASS_ERR (nconso, 'mssendok: SEND', info)
      else

!       Slave
        if (msdebug .gt. 1) then
          call msmess (nconso, 'mssendok', 'received OK to send')
          call uflush(nconso)
        endif
        call MESS_PASS_ERR (nconso, 'mssendok: mspack', info)
        if (sendOK .ne. OK) then
          call msmess (nconso, 'mssendok', 'received value .ne. OK') 
          call clexit (nconso) 
        endif 
      endif 

      call uttime(time)
      ms_time = ms_time + time(1)

 
      return
      end

      subroutine msexit (nconso)

      implicit none
      integer nconso

#include "ms.h"
!     Local variables
      real*8 tmess
      integer info

      call mstime (tmess)
      write(nconso,300) tmess
300   format (' PAR: msexit: Message-passing time=', f15.3,&
        ' CPU seconds')
      call uflush (nconso)

      if (lmaster) then
!       Master
        call msmess (nconso, 'msexit', 'halting Master')
#ifdef PVM
        call pvmfhalt(info)
#endif PVM
#ifdef PARMACS
!       wait for the node processes to finish
        call pmwend (info)
!       call MESS_PASS_ERR (nconso, 'pmwend', info)
        call pmend (info)
!       call MESS_PASS_ERR (nconso, 'pmend', info)
#endif PARMACS
      else

!       Slave
        call msmess (nconso, 'msexit', 'exiting Slave')
#ifdef PVM
        call pvmfexit(info)
#endif PVM
#ifdef PARMACS
        call pmend (info)
#endif PARMACS
      endif

#ifdef MPI
      call MPI_Finalize(info)
#endif MPI
      return
      end
    
      subroutine mstime (timer)

!     Return the time from master-slave communication

      implicit none
#include "ms.h"
      real*8 timer

      timer = ms_time

      return
      end

      subroutine mssum1 (nconso, s1, work, s0, na)
!
!     Global sum of array "s1" from all nodes.
!     The result is available in "s1" on all nodes.
!
!     The communication pattern has been optimized to require
!     only order log(nhosts) steps using the algorithm of
!     J. Bruck and C.T. Ho,
!     ``Efficient Global Combine Operations in Multi-Port Message-Passing
!     Systems'', Parallel Processing Letters, Vol. 3, No. 4,
!     pp. 335-346, December 1993.
!     We use their Algorithm 1 for n=nhosts processors, m=1 data items
!     and k=1 communication ports.  The code for general values of "k"
!     is easily implemented (see file mssum.F).
!
!     A similar subroutine in MPI is mpi_allreduce().
!     A similar subroutine in BLACS is dgsum2d().
!     Written by Ole H. Nielsen, Sep 1 1995.
!
!     nconso ....... Fortran output unit
!     s1 ........... Array to be summed (dimension na)
!     work, s0 ..... Workspaces (dimension na)

      implicit none
      integer nconso, na
      real*8 s1(na), work(na), s0(na)

!     Local variables
      integer n, dest, index
      integer c, r, LMAX, l, n1, n2
      parameter (LMAX = 10)
      integer a(0:LMAX),nhosts

!     Destination host = (index + n) modulo nhosts (offset = 1):
      dest(n) = mod (index + 2*nhosts + n - 1, nhosts) + 1

!     Get number of hosts, and index of this host:
      call mshost (nconso, nhosts, index)
!     Deduce base-2 representation of (nhosts-1)
      n1 = nhosts - 1
!     On VPP-500 this loop MUST be scalarized, or the optimizer 
!     generates incorrect code /OHN, 5-Oct-1995.
!VOCL LOOP,SCALAR
      do 130 r = 0, LMAX
#ifndef VPP500
        a(r) = mod (n1, 2)
        n1 = n1 / 2
#else
!       The VPP-500 compiler frtpx has a bug which gets the above
!       code wrong.  A workaround is the following:
        n2 = n1 / 2
        a(r) = n1 - n2 * 2
!       write(nconso,*) 'PAR: mssum: r,n1,a(r) = ', r,n1,a(r)
        n1 = n2
#endif VPP500
        if (n1 .eq. 0) goto 200
130   continue
      write(nconso,*) 'mssum: binary representation of ', nhosts-1,&
        ' is longer than ', LMAX
      call clexit (nconso)

!     The number of rounds = l
200   l = r + 1
!      write(nconso,*) 'PAR: mssum: number of rounds = ', l
!      write(nconso,240) nhosts-1, (a(r),r=l-1,0,-1)
240   format (' PAR: mssum: ', i5, ' binary = ', 20i3)

      c = 0

      do 400 r = 1, l
!       In the paper, alpha = a(l-r)
        if (a(l-r) .eq. 1) then
!         Send s1 and receive data in work
!         write(nconso,*) 'PAR: mssum: sending to -(c+1)=',
!    &      dest(-(c+1))
!         call uflush (nconso)
          call nsendr (nconso, r, dest(-(c+1)), s1, &
            dest(c+1), work, na)
        else
!         Send s0 and receive data in work
!         write(nconso,*) 'PAR: mssum: sending to -c=', dest(-c)
!         call uflush (nconso)
          call nsendr (nconso, r, dest(-c), s0, dest(c), work, na)
        endif

!       Update s0 and s1
        if (r .eq. l) then
!         Last round (no need to update s0)
          do 300 n = 1, na
            s1(n) = s1(n) + work(n)
300       continue
        else if (r .eq. 1) then
!         First round (initialize s0)
          do 310 n = 1, na
            s0(n) = work(n)
            s1(n) = s1(n) + work(n)
310       continue
        else
          do 320 n = 1, na
            s0(n) = s0(n) + work(n)
            s1(n) = s1(n) + work(n)
320       continue
        endif
!       Update c
        c = c * 2 + a(l-r)
400   continue

      return
      end

      subroutine mshost (nconso, n, index)

!     Return the number of hosts "n" and the "index" of this host

      implicit none
#include "ms.h"

      integer nconso, n, index
      integer i

      if (nhosts .lt. 2) then
        write (nconso,*) 'mshost: Bad number of hosts: ', nhosts
        call clexit (nconso)
      endif

      n = nhosts
      index = -1
      do 100 i = 1, nhosts
        if (slvtid(i) .eq. mytid) then
          index = i
          return
        endif
100   continue

      write (nconso,*) 'mshost: Bad hostlist configuration:', n, index
      call clexit (nconso)

      return
      end

      subroutine nsendr (nconso, round, dest, array, src, work, na)

!     This node sends "array" to the host number "dest"
!     and receives data from host "src" in the array "work".
!     The proper "round" of communication is required for correctness.

!     Also, the send and receive must be asynchronous, because we
!     expect the send to return immediately without waiting for
!     the corresponding receive to finish up.  This implies that
!     we can't use the PARMACS synchronous send/receive subroutines.

      use par_functions_module, only : comm_world
      implicit none
#include "ms.h"

      integer nconso, round, dest, src, na
      real*8 array(na), work(na)

!     Local variables
      integer bufid, info, msgtag
      integer nbytes, sender, actag, aclen
      integer ichunk, nchunks, nn, offset
      character*80 txtbuf
#ifdef MPI
      integer status(MPI_STATUS_SIZE)
#endif MPI
      if (na .le. 0) then
        write (nconso,100) na
100     format (' PAR: nsendr: Bad dimensions na=', i7)
        call clexit (nconso)
      endif

!     Check receiving host
      if (dest .le. 0 .or. dest .gt. nhosts .or.&
        slvtid(dest) .eq. mytid) then
        write (nconso,110) dest, slvtid(dest), mytid
110     format (' PAR: nsendr: Bad host dest=', i7, 2i12)
        call clexit (nconso)
      endif
 
      call uttime(time)
      ms_time = ms_time - time(1)

!     Send the array in chunks of (at most) CHUNKSIZE elements,
!     in order not to overflow the system buffers

      nchunks = (na - 1) / CHUNKSIZE + 1
      offset = 0
      do 200 ichunk = 1, nchunks
        nn = min (CHUNKSIZE, na - offset)

!     Start up communication

      if (msdebug .gt. 1) write (nconso,*) 'PAR: nsendr sending:',&
        ' array to node =', dest, ' TID = ', slvtid(dest)
#ifdef PVME
!     Could perhaps use PVMDATAINPLACE in stead of PVMDATARAW
!     call INIT (PVMDATARAW, bufid)
      call INIT (PVMDATAINPLACE, bufid)
      if (bufid .lt. 0) then
        write (txtbuf,500) 'INIT', 'array'
500     format (' PAR: ', a, 1x, a)
        call MESS_PASS_ERR (nconso, txtbuf, bufid)
      endif
#endif PVME

!     Select message tag to distinguish the different rounds
      msgtag = MSG_MSSUM + round

!     Send array   (MPI: send/receive)

#ifdef PVM
#ifdef PVME
      call PACK (REAL8, array(1+offset), nn, 1, info)
      call SEND (slvtid(dest), msgtag, info)
#else
!     PVM 3.3 has the pack-send feature:
      call pvmfpsend (slvtid(dest), msgtag, array(1+offset), nn,REAL8, info)
#endif PVME
#endif PVM
#ifdef PARMACS
!     The send/receive MUST be asynchronous in this algorithm
      nbytes = pmform (1, REAL8, nn, info)
      call MESS_PASS_ERR (nconso, 'nsendr: pmform', info)
      call mypmsnd (slvtid(dest), msgtag, nbytes, array(1+offset),info)
#endif PARMACS
#ifdef MPI
      call MPI_Sendrecv(array(1+offset),nn,REAL8,slvtid(dest), msgtag, work(1+offset),&
	 nn,REAL8, slvtid(src), msgtag,comm_world, status, info)
#endif MPI
      call MESS_PASS_ERR (nconso, 'nsendr: SEND', info)

!     Receive array

      if (msdebug .gt. 1) call msmess (nconso,'nsendr receiving:', 'array')
!     Blocking receive from any host:
#ifdef PVM
#ifdef PVME
      call RECEIVE (slvtid(src), msgtag, bufid)
      if (bufid .lt. 0) then
        write (txtbuf,500) 'RECEIVE', 'array'
        call MESS_PASS_ERR (nconso, txtbuf, bufid)
      endif
      call UNPACK (REAL8, work(1+offset), nn, 1, info)
#else
!     PVM 3.3 has the receive-unpack feature:
      call pvmfprecv (slvtid(src), msgtag, work(1+offset), nn,&
        REAL8, sender, actag, alen, info)
#endif PVME
#endif PVM
#ifdef PARMACS
!     The send/receive MUST be asynchronous in this algorithm
      nbytes = pmform (1, REAL8, nn, info)
      call MESS_PASS_ERR (nconso, 'nsendr: pmform', info)
      call mypmrcv (slvtid(src), msgtag, nbytes, work(1+offset), &
        sender, actag, aclen, info)
      if (msdebug .gt. 1) write (nconso,*) 'PAR: nsendr received ',&
        aclen, ' bytes from TID =', sender
#endif PARMACS
      call MESS_PASS_ERR (nconso, 'nsendr: UNPACK', info)

        offset = offset + nn
200   continue

      if (msdebug .gt. 1) call msmess (nconso, 'nsendr:',&
        'received array')
 
      call uttime(time)
      ms_time = ms_time + time(1)

      return
      end

      subroutine denstest (nconso, text, array, n)
      implicit none
      integer nconso, n
      character*(*) text
      real*8 array(n), sum
      integer i 
      sum = 0.0d0
      do i = 1, n
        sum = sum + array(i)
      end do
      write (nconso,200) text, n, sum
200   format(' PAR: ', a, ': array size=', i10, ' sum=', g20.12)
      write (nconso,220) (array(i),i=1,5), (array(i),i=n-4,n)
220   format(' PAR: array elements='/5g15.8/5g15.8)
      call uflush (nconso)
      return
      end

! ------------------------------------------------------------------------------

      subroutine change_input_output_filenames(int) 
!     change run_context input/output names names by appending _<int>
      use run_context
      implicit none 
      integer int

      write(netCDF_output_filename,'(1a,i1)') trim(netCDF_output_filename),int 
      write(netCDF_input_filename, '(1a,i1)') trim(netCDF_input_filename),int 
      write(ASCII_output_filename, '(1a,i1)') trim(ASCII_output_filename),int 
    
      return 
      end


