!=======================================================================
      subroutine inidid(nconso)
      write(nconso,*) '@(#)inidir.F	1.2 9/24/96'
      return
      end
!=======================================================================
      subroutine inidir(ngx,ngy,ngz,nplwv,recc,volc,&
           lpctx,lpcty,lpctz,dirdat)
!=======================================================================
! Initialize the dirdat array
!
! output: dirdat(g)=const. * 1/G**2
!=======================================================================
      use van_us_data_module, only : edeps
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension recc(3,3)
      dimension dirdat(nplwv)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
!=======================================================================
! get edeps = electron charge divided by the permittivity of free space
! from van_us_data_module
!=======================================================================
!=======================================================================
! scale the hartree potential by edeps divided by the volume of the unit
! cell
!=======================================================================
      scale=edeps/volc
!=======================================================================
! calculate the hartree potential on the grid of reciprocal lattice
! vectors, the correction to the total energy and the force on the unit
! cell
!=======================================================================
      ni=1
      do 8630 n=1,ngz
        gzx=recc(3,1)*lpctz(n)
        gzy=recc(3,2)*lpctz(n)
        gzz=recc(3,3)*lpctz(n)
        do 8631 nn=1,ngy
          gyx=recc(2,1)*lpcty(nn)
          gyy=recc(2,2)*lpcty(nn)
          gyz=recc(2,3)*lpcty(nn)
          do 8632 nnn=1,ngx
            gxx=recc(1,1)*lpctx(nnn)
            gxy=recc(1,2)*lpctx(nnn)
            gxz=recc(1,3)*lpctx(nnn)
            gisq=(gxx+gyx+gzx)**2+(gxy+gyy+gzy)**2+(gxz+gyz+gzz)**2
!=======================================================================
! since the g=0 coulomb contributions to the hartree, ewald and
! electron-ion energies are individually divergent but together sum to
! zero, set the hartree potential at g=0 to zero.
!=======================================================================
            if (gisq.lt.0.001d0) then
              dirdat(ni)=0.0d0
            else
              gisq=1.0d0/gisq
              dirdat(ni)=scale*gisq
            endif
            ni=ni+1
 8632     continue
 8631   continue
 8630 continue
      return
      end
