      subroutine gk_sort_id(nconso)
      write(nconso,*) '@(#)gk_sort.F	1.3 10/21/97'
      return
      end
!-----------------------------------------------------------------------
      subroutine gk_sort (kplusg, ngm, ecut, ngk, gk, gk2, q )
!-----------------------------------------------------------------------
!
!     Sorts k+g in order of increasing magnitude, up to ecut
!
!-----------------------------------------------------------------------

      implicit none

      integer  ngm, ngk, ng, proc, iacc
      real*8   kplusg(3,ngm), gk(3,ngk), gk2(ngk), ecut, q(ngm)
      external v_sort
      integer  i(ngm)

      ngk = 0
      do ng = 1, ngm
         q(ng) = (kplusg(1,ng)) **2 +&
                 (kplusg(2,ng)) **2 +&
                 (kplusg(3,ng)) **2
         if (q(ng).le.ecut) ngk = ngk + 1
      end do

! order vector q (containing ng elements) keeping initial position in i
      call v_sort(ngm, q, i)

      do ng = 1, ngk
         gk(1,ng) = kplusg(1,i(ng))
         gk(2,ng) = kplusg(2,i(ng))
         gk(3,ng) = kplusg(3,i(ng))
         gk2 (ng) = q(ng)
      end do

      return
      end

!------------------------------------------------------------------------
      subroutine v_sort(n,vect,index)
!------------------------------------------------------------------------
! sort a vector and yields an index table- vector is ordered
! version for ESSL ibm library
      implicit none
      integer n, index(n)
      real*8 vect(n)
#ifdef ESSL 
      external dsortx
      call dsortx(vect,1,n,index)
#else
      external sort
      call sort(vect,n,index) 
#endif 
 
      return
      end


#ifndef ESSL
      subroutine sort(vect,n,index) 

      implicit none 
      integer n,index(n)
      real*8  vect(n)

!     locals 
      integer i 
      real*8  vect1(n)     

!     copy vect 
      do i = 1,n 
        vect1(i) = vect(i) 
      enddo

!     Use Numerical Recipes(indexx) to sort VECT and generate a index-table INDEX

      call indexx(n,vect1,index) 

      do i = 1,n 
        vect(i) = vect1(index(i))
      enddo
      
      return 
      end


      SUBROUTINE indexx(n,arr,indx)

!     From Numerical recipes (LH changed REAL -> REAL*8)
      INTEGER n,indx(n),M,NSTACK
      REAL*8 arr(n)
      PARAMETER (M=7,NSTACK=200)
      INTEGER i,indxt,ir,itemp,j,jstack,k,l,istack(NSTACK)
      REAL*8 a
      do 11 j=1,n
        indx(j)=j
11    continue
      jstack=0
      l=1
      ir=n
1     if(ir-l.lt.M)then
        do 13 j=l+1,ir
          indxt=indx(j)
          a=arr(indxt)
          do 12 i=j-1,l,-1
            if(arr(indx(i)).le.a)goto 2
            indx(i+1)=indx(i)
12        continue
          i=l-1
2         indx(i+1)=indxt
13      continue
        if(jstack.eq.0)return
        ir=istack(jstack)
        l=istack(jstack-1)
        jstack=jstack-2
      else
        k=(l+ir)/2
        itemp=indx(k)
        indx(k)=indx(l+1)
        indx(l+1)=itemp
        if(arr(indx(l)).gt.arr(indx(ir)))then
          itemp=indx(l)
          indx(l)=indx(ir)
          indx(ir)=itemp
        endif
        if(arr(indx(l+1)).gt.arr(indx(ir)))then
          itemp=indx(l+1)
          indx(l+1)=indx(ir)
          indx(ir)=itemp
        endif
        if(arr(indx(l)).gt.arr(indx(l+1)))then
          itemp=indx(l)
          indx(l)=indx(l+1)
          indx(l+1)=itemp
        endif
        i=l+1
        j=ir
        indxt=indx(l+1)
        a=arr(indxt)
3       continue
          i=i+1
        if(arr(indx(i)).lt.a)goto 3
4       continue
          j=j-1
        if(arr(indx(j)).gt.a)goto 4
        if(j.lt.i)goto 5
        itemp=indx(i)
        indx(i)=indx(j)
        indx(j)=itemp
        goto 3
5       indx(l+1)=indx(j)
        indx(j)=indxt
        jstack=jstack+2
        if(jstack.gt.NSTACK)pause 'NSTACK too small in indexx'
        if(ir-i+1.ge.j-l)then
          istack(jstack)=ir
          istack(jstack-1)=i
          ir=j-1
        else
          istack(jstack)=j-1
          istack(jstack-1)=l
          l=i
        endif
      endif
      goto 1
      END

#endif
