      module g_vectors

      contains 

!        genbop 
!           Setup the indexing system for padding the spheres of plane 
!           waves at this k point into the box used for the fast 
!           fourier transforms
!        gvectors
!           Define g and gg arrays in van_us_decl.h
!           also igtongl; the index  G-array -> G-shell           


!=======================================================================
      subroutine g_vectors_module(nconso)
      write(nconso,*) '@(#)genbop.F	1.16 7/1/99'
      end subroutine g_vectors_module

!=======================================================================
      subroutine genbop(nrplwv,ngx,ngy,ngz,nplwkp,enmax, &
          vkpt,recc,reci,wtkpt,nkprun,nspin, &
          ngdens,ngdens_soft,g,gg,g_soft,ipwpad, &
          ipwpadG, pwkine, dnlg,dnlkg, &
          lmastr )               
!=======================================================================
! Setup the indexing system
! for padding the spheres of plane waves at this k point into the box
! used for the fast fourier transforms and
! kinetic energies of the plane wave basis states at each k point and
! the x,y and z components of the kinetic energy. The indexing system
! is based on the reci() reciprocal basis
!=======================================================================
      use basicdata,only : hsqdtm,pi,ev,angst
      use netcdfinterface
      use run_context
      implicit none
      integer  nrplwv,ngx,ngy,ngz
      real*8   enmax,recc(3,3),reci(3,3)
      integer  nkprun,nspin,ngdens,ngdens_soft
      real*8 , pointer :: vkpt(:,:,:),wtkpt(:,:)
      integer, pointer :: nplwkp(:,:)
      real*8, pointer  ::  g(:,:),gg(:),g_soft(:,:,:,:) 
      integer, pointer ::  ipwpad(:,:,:),ipwpadG(:,:)
      real*8 , pointer ::  dnlg(:,:,:,:),dnlkg(:,:,:,:),pwkine(:,:,:)
      logical*4 lmastr

!     locals 
      integer, pointer ::  index3dfft(:,:,:)      ! netcdf variable WaveFunctionFFTindex
      integer          ::  number_plw_kpt(nkprun) ! netcdf variable NumberPlaneWavesKpoint

      real*8    kptx,kpty,kptz,energ,enerix,testmx
      real*8    eneriy,energx,energy,energz,eneriz,rvoli,rnomi,eneff
      real*8    energi,dum,rnumpl,accmxc,accmxi,gx,gy,gz
      integer   nmax,i,j,nsboxi,ng,k,m,status,ncid,ispin,nkp,iloop


!=======================================================================
!                       the data statements
!=======================================================================
      data accmxc,accmxi/0.0d0,0.0d0/
      save nmax
      save accmxc,accmxi
!=======================================================================
      testmx=0.0d0
!=======================================================================
!
! The index in the reciprocal lattice grid of each plane wave basis 
! states at each k point is given in ipwpad (generated by gvectors). 
! The G vectors up to the energy cutoff for the density (4*Eplw)
! is given in g(3,1-ngdens) and gg(1-ngdens)
! 
! The kinetic energies of the basis states and the x,y and z
! components of the kinetic energy are calculated. if the cut-off energy
! enmax is too large so that there are more than nrplwv plane wave basis
! states of energy less than enmax at any k point, enmax is
! automatically reduced
! NB. reci and recc are for now assumed to be equal.
!
!=======================================================================
!     initialize  
!     allocate too large arrays for 
                         
!=======================================================================
!     loop over k-points and spin
!     make two loops, first loop to determine nmax=nrplwv 
!=======================================================================
      do iloop = 1,2

      rnumpl = 1.0d0

!=======================================================================
!     allocate with size nmax=nrplwv
      if (iloop==2) then 
        allocate(pwkine(nrplwv,nspin,nkprun))
        allocate(ipwpad(nrplwv,nspin,nkprun))
        allocate(dnlg(nrplwv,3,nspin,nkprun))
        allocate(dnlkg(nrplwv,0:3,nspin,nkprun))
        allocate(g_soft(nrplwv,3,nspin,nkprun))
        allocate(index3dfft(nrplwv,3,nkprun))
        ! render all elements defined (netCDF write references all elements)
        pwkine     = 0.0
        ipwpad     = 0
        dnlg       = 0.0
        dnlkg      = 0.0
        g_soft     = 0.0
        index3dfft = 0.0
      endif 
                                                              
      do nkp = 1,nkprun
       do ispin = 1,nspin

        nsboxi=1
        do ng = 1,ngdens_soft
          kptx=recc(1,1)*vkpt(1,ispin,nkp)+recc(2,1)*vkpt(2,ispin,nkp)+&
               recc(3,1)*vkpt(3,ispin,nkp)
          kpty=recc(1,2)*vkpt(1,ispin,nkp)+recc(2,2)*vkpt(2,ispin,nkp)+&
               recc(3,2)*vkpt(3,ispin,nkp) 
          kptz=recc(1,3)*vkpt(1,ispin,nkp)+recc(2,3)*vkpt(2,ispin,nkp)+&
               recc(3,3)*vkpt(3,ispin,nkp) 

          gx=kptx + g(ng,1)
          gy=kpty + g(ng,2)
          gz=kptz + g(ng,3)

          energx=hsqdtm*(gx**2)
          energy=hsqdtm*(gy**2)
          energz=hsqdtm*(gz**2)
          energ=energx+energy+energz
          enerix=hsqdtm*(gx**2)
          eneriy=hsqdtm*(gy**2)
          eneriz=hsqdtm*(gz**2)
          energi=enerix+eneriy+eneriz
          if(energi.gt.testmx) testmx=energi
!=======================================================================
!
! check to see if the kinetic energy of the plane wave is less than
! enmax in which case the plane wave is included in the set of basis
! states for the k point
!
!=======================================================================
              if(energi.lt.enmax) then
                if(energ.gt.accmxc) accmxc=energ
                if(energi.gt.accmxi) accmxi=energi

                if (iloop>1) then
                   pwkine(nsboxi,ispin,nkp)=energ
!=======================================================================
! For the use of non-local pseudopotential elements:
! dnlg(*,1-3,nkp) = (Gx+kx,Gy+ky,Gz+kz) in cartesian co-ordination
!=======================================================================
                   dnlg(nsboxi,1,ispin,nkp)=gx
                   dnlg(nsboxi,2,ispin,nkp)=gy
                   dnlg(nsboxi,3,ispin,nkp)=gz

!                  store g-vector number ng corresponding to nsboxi
                   g_soft(nsboxi,1,ispin,nkp) = g(ng,1)
                   g_soft(nsboxi,2,ispin,nkp) = g(ng,2)
                   g_soft(nsboxi,3,ispin,nkp) = g(ng,3)                          
!=======================================================================
!                     (Gx+kx,Gy+ky,Gz+kz)
! dnlkg(*,1-3,nkp) = ---------------------  [Cartesian coordinates]
!                    |(Gx+kx,Gy+ky,Gz+kz)|
!=======================================================================
                   dum=sqrt(gx**2+gy**2+gz**2)
                   dnlkg(nsboxi,0,ispin,nkp)=dum
                   if(dum.le.0.000001d0) then
                      do 2015 i=1,3
                          dnlkg(nsboxi,i,ispin,nkp)=0.57735027d0
 2015                 continue
                   else
                      dnlkg(nsboxi,1,ispin,nkp)=gx/dum
                      dnlkg(nsboxi,2,ispin,nkp)=gy/dum
                      dnlkg(nsboxi,3,ispin,nkp)=gz/dum
                   end if
                   ipwpad(nsboxi,ispin,nkp)      = ipwpadG(ng,0)
                   index3dfft(nsboxi,1,nkp)=ipwpadG(ng,1)
                   index3dfft(nsboxi,2,nkp)=ipwpadG(ng,2)
                   index3dfft(nsboxi,3,nkp)=ipwpadG(ng,3)
                endif ! iloop>1
!=======================================================================
                nsboxi=nsboxi+1
              endif
        enddo  ! ng = 1,ngdens_soft
      
!=======================================================================
! Bump out if too few states
!=======================================================================
        nsboxi=nsboxi-1

        nplwkp(ispin,nkp)=nsboxi
        rnumpl=rnumpl*dble(nplwkp(ispin,nkp))**(wtkpt(ispin,nkp)/nspin)
        if (nplwkp(ispin,nkp).gt.nmax) nmax=nplwkp(ispin,nkp)
       enddo ! ispin
      enddo  ! nkprun

!     the dimension nrplwv is set to the maximum number of planewaves
!     for any k-point
      nrplwv = nmax

      enddo  ! iloop 

!=======================================================================
! After loop over k-point and spin write result
!=======================================================================
! Calculate/print the nominal and average number of plane waves
! - these are needed for the Francis-Payne correction
! [J.Phys.Cond.Matter 2, 4395 (1990)]
!=======================================================================
      write(nconso,*)'PAD:'
      write(nconso,*) 'PAD: Nominal # of PW  Average # of PW   Max #',&
                        ' of PW'
      write(nconso,*) 'PAD: for this cutoff  in k-point set    in ',&
                        ' k-point set'
      rvoli=      reci(1,1)*(reci(2,2)*reci(3,3)-reci(2,3)*reci(3,2))
      rvoli=rvoli-reci(2,1)*(reci(1,2)*reci(3,3)-reci(1,3)*reci(3,2))
      rvoli=rvoli+reci(3,1)*(reci(1,2)*reci(2,3)-reci(1,3)*reci(2,2))
      rvoli=rvoli*angst**3
      rnomi=4.0d0/3.0d0*pi*(enmax/eV*2.0d0)**1.5d0/abs(rvoli)
      write(nconso,2054) rnomi,rnumpl,nmax
 2054 format(1x,'PAD:      ',f10.4,'       ',f10.4,'      ',i8)
      write(nconso,*)'PAD:'
!=======================================================================
!     use the average number of planes waves to calculate the effective
!     energy cutoff for the planewaves.                                 
      eneff=eV/2.0d0*                   &
          (((rnumpl*3.0d0*abs(rvoli))/(4.0d0*pi))**(0.6666667d0))
!=======================================================================
      write(nconso,2030) enmax/eV*2.0d0,enmax                          
      write(nconso,2031) eneff/eV*2.0d0,eneff 
 2030 format(1x,'PAD: Plane waves of E_kin below      ',f8.2,' Ryd =',&
                  f8.2,' eV accepted')                                   
 2031 format(1x,'PAD: Effective E_kin for plane waves ',f8.2,' Ryd =',&
                  f8.2,' eV')                                            


!     write this dimension 
      if (lmastr) then 

!       open netCDF file
        status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
        if (status /= nf_noerr) then 
          write(nconso,*) 'PAD: nf_open: error'
          call clexit(nconso) 
        endif
  
        status = nfputglobaldim(ncid,'number_plane_waves',nrplwv) 
        if ((status/=nfif_ok) .and. &
            (status/=nfif_dimexist_butOKsize)) then 
          write(nconso,*) &
           'PAD: nf_error writing number_plane_waves dimension',&
                 status
           call clexit(nconso)
        endif

      endif ! lmastr
 

      if (lmastr) then 
!       write index3dfft to netcdf variable WaveFunctionFFTindex
        status = nfput(ncid,'WaveFunctionFFTindex',index3dfft,&
                                  dim_name1='number_plane_waves', &
                                  dim_name2='dim3', &
                                  dim_name3='number_IBZ_kpoints') 
        if (status/=nfif_ok) then
          write(nconso,*) 'PAD: nf_error writing index3dfft', status
           call clexit(nconso)
        endif 
        status = nfput(ncid,'WaveFunctionFFTindex%Description', &
             'index array mapping compact wavefunction array' // &
             ' to 3-dim FFT grid' )

!       write the number of plane waves for each k-point : NumberPlaneWavesKpoint
        do i = 1,nkprun
          number_plw_kpt(i) = nplwkp(1,i)
        enddo
        status = nfput(ncid,'NumberPlaneWavesKpoint',number_plw_kpt,&
                                  dim_name1='number_IBZ_kpoints') 
        status = nfput(ncid,'NumberPlaneWavesKpoint%Description', &
             'Number of G-vectors for which |G+k|^2 < PlaneWaveCutoff' )

        status = nf_close(ncid)
        if (status /= nf_noerr) then
           write(nconso,*) 'PAD: nf_close: error'
           call clexit(nconso)
        endif                                         

      endif

      end subroutine genbop


#include "definitions.h"
!=======================================================================
      subroutine gvectors(&
          recc,reci,ngx,ngy,ngz,&
          nplwv,nkprun,ecut,&
          lpctx,lpcty,lpctz,ngdens,ngdens_max,ngldim,&
          g,gg,ipwpadG,igtongl,goffs&
#ifdef PARAL
          ,&
#include PARAL_ARGS
#endif                                        
          ,nconso )

!
!    Define g and gg arrays in van_us_decl.h 
!    also igtongl; the index  G-array -> G-shell 
!    Define ipwpadG; index for padding the spheres of the planes waves 
!    into the box used for the fast fourier transform. 
!    The padding array ipwpad for G+k for eack k-point is defined in genbop
!
!    For parallel program : 
!       g(1..ngdens_max) is defined on all nodes.
!       ngdens is the local number of G-vectors
!       ngl    is the local number of G-shells. 
!       (grad is later defined on each node (qrad(1..ngl)). 

      use basicdata, only : hsqdtm
      implicit  none 

      integer   nplwv,nkprun 
      integer   ngx,ngy,ngz
      integer, pointer ::   lpctx(:),lpcty(:),lpctz(:)
      integer  ngdens,ngdens_max,ngldim
      real*8   recc(3,3),reci(3,3),ecut
      real*8, pointer :: g(:,:),gg(:)
      integer,pointer :: ipwpadG(:,:)
      integer, pointer :: igtongl(:)
      integer   goffs
#ifdef PARAL
#include      PARAL_DECL
      integer offset(par_pw_np)
      integer nlocal(par_pw_np)
#endif
      integer   nconso


!     locals
      real*8    gzx,gzy,gzz,gyx,gyy,gyz,gxx,gxy,gxz
      real*8    eneriz,energi,energ,enerix,eneriy,energz
      real*8    gizy,gizz,giyx,giyz,gixx,gixy,gizx 
      real*8    giyy,gixz,energx,energy 

      real*8    gx,gy,gz,swap
      integer   iswap,indsw,ir,ng,ngl
      real*8    eps
      parameter (eps = 1.0d-9) 
      integer   nr,nx,ny,nz,i,nbox,ngdens1
      integer   index(nplwv),ipwpad1(nplwv,0:3)
      real*8    g1(nplwv,3),gg1(nplwv)

!=======================================================================
!
! initialize the loop counters lpctx,lpcty,lpctz and lpctfx,etc that
! label the number of the reciprocal lattice vectors in the x,y,z
! directions, respectively. for the x direction the reciprocal lattice
! vectors corresponding to the first,second,...,ngxth elements in all
! of the reciprocal lattice arrays are 0,1,..,(ngx/2),-((ngx/2-1),..,-1
! times the x reciprocal lattice vector 2*pi/sizex
!=======================================================================
      allocate (lpctx(ngx))
      allocate (lpcty(ngy))
      allocate (lpctz(ngz))
      do nx=1,(ngx/2)+1
        lpctx(nx)=nx-1
!       lpctfx(nx)=nx-1
      enddo   
      do nx=(ngx/2)+2,ngx
        lpctx(nx)=nx-1-ngx
!       lpctfx(nx)=nx-1-ngx
      enddo    
      do ny=1,(ngy/2)+1
        lpcty(ny)=ny-1
!       lpctfy(ny)=ny-1
      enddo    
      do ny=(ngy/2)+2,ngy
        lpcty(ny)=ny-1-ngy
!       lpctfy(ny)=ny-1-ngy
      enddo   
      do nz=1,(ngz/2)+1
        lpctz(nz)=nz-1
!       lpctfz(nz)=nz-1
      enddo   
      do nz=(ngz/2)+2,ngz
        lpctz(nz)=nz-1-ngz
!       lpctfz(nz)=nz-1-ngz
      enddo                                           

!=======================================================================
!       Initialize g (Gx,Gy,Gz) and gg |G| arrays up to ecut
!=======================================================================
        ngdens1 = 0
        nbox = 1
        do 2010 nz=1,ngz
          gzx=recc(3,1)*lpctz(nz)
          gzy=recc(3,2)*lpctz(nz)
          gzz=recc(3,3)*lpctz(nz)
          gizx=reci(3,1)*lpctz(nz)
          gizy=reci(3,2)*lpctz(nz)
          gizz=reci(3,3)*lpctz(nz)
          do 2011 ny=1,ngy
            gyx=recc(2,1)*lpcty(ny)
            gyy=recc(2,2)*lpcty(ny)
            gyz=recc(2,3)*lpcty(ny)
            giyx=reci(2,1)*lpcty(ny)
            giyy=reci(2,2)*lpcty(ny)
            giyz=reci(2,3)*lpcty(ny)
            do 2012 nx=1,ngx
              gxx=recc(1,1)*lpctx(nx)
              gxy=recc(1,2)*lpctx(nx)
              gxz=recc(1,3)*lpctx(nx)
              gx=gxx+gyx+gzx
              gy=gxy+gyy+gzy
              gz=gxz+gyz+gzz
              gixx=reci(1,1)*lpctx(nx)
              gixy=reci(1,2)*lpctx(nx)
              gixz=reci(1,3)*lpctx(nx)
              energx=hsqdtm*(gx**2)
              energy=hsqdtm*(gy**2)
              energz=hsqdtm*(gz**2)
              energ=energx+energy+energz
              enerix=hsqdtm*((gixx+giyx+gizx)**2)
              eneriy=hsqdtm*((gixy+giyy+gizy)**2)
              eneriz=hsqdtm*((gixz+giyz+gizz)**2)
              energi=enerix+eneriy+eneriz         

              if (energi.lt.ecut) then 
                 ngdens1 = ngdens1 + 1
                 g1(ngdens1,1)= gx
                 g1(ngdens1,2)= gy
                 g1(ngdens1,3)= gz
                 gg1(ngdens1) = gx**2 + gy**2 + gz**2
                 ipwpad1(ngdens1,0) = nbox
                 ipwpad1(ngdens1,1) = nx
                 ipwpad1(ngdens1,2) = ny
                 ipwpad1(ngdens1,3) = nz
              endif
              nbox = nbox + 1
 2012       continue
 2011     continue
 2010   continue

        ngdens     = ngdens1
        ngdens_max = ngdens1
!        write(nconso,*) 'gvectors ngdens ',ngdens
        call uflush(nconso)

        allocate(g(ngdens_max,3)) 
        allocate(gg(ngdens_max))
        allocate(ipwpadG(ngdens_max,0:3))
!        write(nconso,*) 'gvectors ngdens1 ',ngdens
        call uflush(nconso)
         
        do ng = 1,ngdens1
          gg(ng) = gg1(ng)
        enddo

!        write(nconso,*) 'gvectors sort ',ngdens
        call uflush(nconso)
!       sort G-vectors 
        call v_sort(ngdens1,gg,index) 

        do ng = 1,ngdens1 

           do i=0,3
            ipwpadG(ng,i) = ipwpad1(index(ng),i)
           enddo 
           do ir = 1,3 
             g(ng,ir) = g1(index(ng),ir)
           enddo
 
        enddo
!        write(nconso,*) 'gvectors par_defwfk ',ngdens
        call uflush(nconso)

#ifdef PARAL
!     find ngdens for all nodes.
      call par_defwfk(ngdens_max,ngdens_max,ngdens_max,nlocal,&
                      offset,ngdens,&
#include PARAL_ARGS
       )
      goffs  = offset(par_process+1)
#else
      ngdens = ngdens1
      goffs  = 0
#endif

!========================================================================
!     define igtongl index and ngl
!========================================================================
!      write(nconso,*) 'gvectors define igtongl'
!      call uflush(nconso)

      allocate(igtongl(nplwv))
      ngl = 1
      igtongl(1) = 1
      do nr = 2,ngdens
        if (gg(nr+goffs).gt.(gg(nr-1+goffs)+eps)) ngl=ngl+1
        igtongl(nr) = ngl
      enddo
!      write(nconso,*) 'GVectors density: ',ngdens,' tot:',nplwv,
!     &                'G shells ',ngl
      call uflush(nconso)
 
      ngldim = ngl
 
      end subroutine gvectors

      end module g_vectors
