#include "definitions.h"
      subroutine gen_orthop_id(nconso)
      write(nconso,*) '@(#)gen_orthop.F	1.6 7/1/99'
      return
      end
!-----------------------------------------------------------------------
      subroutine gen_orthop(firstband,lastband,&
                         psi,spsi,cptwfp,nbands,&
                         nrplwv,nplwkp,overlap,normalize)
!-----------------------------------------------------------------------
!   
!     Orthogonalize psi to band firstband->lastband (in cptwfp) 

!                           lastband
!         |psi> = (1 - sum   |cptwfp_j><cptwfp_j|S|psi> 
!                          j=firstband
!
!     Normalize |psi> if normalize is true
!
!-----------------------------------------------------------------------
      implicit none

      integer    nbands,nrplwv,nplwkp
      complex*16 cptwfp(nrplwv,nbands)
      complex*16 Spsi(nrplwv),psi(nrplwv) 
      complex*16 overlap(nbands) 
      integer    firstband,lastband
      logical*4  normalize

      real*8     eps
      complex*16 anorm
      parameter (eps =1.0d-16)
      integer    i,j

      if (lastband.ge.firstband) then 

!       find overlap <psi_j|Spsi> in overlap(j)
        do j = firstband,lastband
          overlap(j) = (0.0d0,0.0d0)  
          do i = 1,nplwkp
            overlap(j) = overlap(j) + conjg(cptwfp(i,j))*Spsi(i)
          enddo
        enddo

        do j = firstband,lastband
          do i = 1,nplwkp
            psi(i) = psi(i) - overlap(j)*cptwfp(i,j) 
          enddo 
        enddo

      endif

      if (normalize) then 

!       <psi|S|psi> = 1, so normalize |psi> and S|psi>
        anorm = (0.0d0,0.0d0) 
        do i = 1,nplwkp 
          anorm = anorm + conjg(psi(i))*Spsi(i)
        enddo
        if (abs(anorm).gt.eps) then 
          anorm = 1.0d0/sqrt(anorm)
          do i = 1,nplwkp
            psi(i)  = conjg(anorm)*psi(i) 
            spsi(i) = anorm*spsi(i) 
          enddo 
        else 
          write(*,*) 'gen_orthop anorm<eps ',anorm
        endif
  
      endif
      
      return
      end

!-----------------------------------------------------------------------
       subroutine get_residual(nrplwv,nplwkp,hpsi,spsi,&
                               cptwfp,eapp,lspsi)

!-----------------------------------------------------------------------
!   
!     get eapp 
!       eapp = <psi|H|psi>/<psi|S|psi> 
!     and form 
!       Rpsi = (H|psi> - eapp*S|psi>)
!       -(steepest descent direction)
!       return : eapp  
!                hpsi
!
!-----------------------------------------------------------------------
      implicit none

      integer    nrplwv,nplwkp
      complex*WF_PRECISION cptwfp(nrplwv)
      complex*WF_PRECISION spsi(nrplwv),hpsi(nrplwv),h
      logical*4  lspsi
      real*8     eapp,eps
      parameter (eps =1.0d-16)

      integer    m
      real*8     temp    

      temp = 0.0d0 
      eapp = 0.0d0 
      if (lspsi) then 
        do m = 1,nplwkp
          eapp = eapp + dble(conjg(cptwfp(m))*hpsi(m)) 
          temp = temp + dble(conjg(cptwfp(m))*spsi(m)) 
        enddo
      else
        do m = 1,nplwkp
          eapp = eapp + dble(conjg(cptwfp(m))*hpsi(m)) 
          temp = temp + dble(conjg(cptwfp(m))*cptwfp(m))
        enddo
      endif
      if (temp.gt.eps) then 
          eapp = eapp/temp
      else 
          write(*,*) 'get_eapp temp<eps ',temp
      endif
          
      if (lspsi) then 
        do m = 1,nplwkp
          h  = (hpsi(m) - eapp*spsi(m))
          hpsi(m) = h
        enddo 
      else
        do m = 1,nplwkp
          h  = hpsi(m) - eapp*cptwfp(m)
          hpsi(m) = h
        enddo 
      endif

      if (.not.lspsi) then 
        do m = 1,nplwkp
            spsi(m) =  cptwfp(m)
        enddo 
      endif  

      return 
      end 

!=======================================================================
      
      real*8 function size_psi(nplwkp,psi) 
!     get size of psi
      implicit none 
      integer     nplwkp
      complex*16  psi(nplwkp)
      integer     m
      real*8      temp 

      temp = 0.0d0
      do m = 1,nplwkp
        temp = temp + dble(conjg(psi(m))*psi(m))
      enddo
      size_psi = temp 

      return 
      end

!-----------------------------------------------------------------------
      subroutine cdiaghg (n,h,s,ldh,e,v)
!     =================
!
!   calculates all the eigenvalues and eigenvectors of a complex
!   hermitean matrix
!
!   LAPACK version
!
!-----------------------------------------------------------------------
      use run_context
      implicit none
 
!  on INPUT
       integer    n               ! dimension of the matrix to be diagonalized
       integer    ldh             ! leading dimension of h, as declared
                                  ! in the calling pgm unit
       complex*16 h(ldh,n)        ! matrix to be diagonalized
       complex*16 s(ldh,n)        ! overlap matrix
 
!  on OUTPUT
       real*8     e(n)            ! eigenvalues
       complex*16 v(ldh,n)        ! eigenvectors (column-wise)

!  Automatic variables
       complex*16 dum(n,n)       
       real*8     rwork(3*n-2)
       complex*16 work(2*n-1)

!  LOCAL variables
       integer lwork, info,i
       external ZCOPY, ZHEEV
 
       lwork = 2*n-1
 
       call ZCOPY(n*ldh,h,1,v,1)
       do i=1,n
          call ZCOPY(n,s(1,i),1,dum(1,i),1)
       enddo
       call ZHEGV(1,'V','U',n,v,ldh,dum,n,e,work,lwork,rwork,info)
       if(abs(info) .ne. 0) then
          write(nconso,*) 'cdiag info =/= 0',info,n
          call report_error('cdiagh','info =/= 0',info)
       endif
       info=nint(dble(work(1)))
       if ((info.ne.lwork).and.(n.gt.1)) then
          write(nconso,*) 'lwork could be improved',info,lwork
!         call report_error('cdiagh','lwork could be improved',-info)
       endif
 
       return
       end

