! Calculate the hamiltonian matrix, for the currect set of wavefunction. 
! Used for localized wannnier orbitals generated outside dacapo. 
! 
#include "definitions.h" 
#define PARAL_ARGS "parallel_args.h"
#define PARAL_DECL "parallel_decl.h"  

       subroutine gen_hamiltonian_matrix(cptwfp, nplwkp,&
#include "apply_h_args.h"
                          , timer)         

      use netcdfinterface
      use run_context
      use us_hpsi_module 
      use module_rmm_diss
#ifdef PARAL
      use par_functions_module
#endif PARAL
      implicit none    

#include "apply_h_decl.h"
      complex*WF_PRECISION :: cptwfp(nrplwv,nbands)
      integer nplwkp 
      real*8  eigen(nbands) 
      real*8 timer(*)

      ! locals 
      complex*16 hmat(nbands,nbands),smat(nbands,nbands)
      integer    block_size,n,m,status,n_local,ncid
      ! matrices for writing to netcdf
      real*8     hmat_netcdf(2,nbands,nbands) 
      real*8     smat_netcdf(2,nbands,nbands)
#ifdef PARAL
      integer offset(par_pw_np),nlocal(par_pw_np),irank
#endif                

#ifdef PARAL 
      ! find lenght of wavefunction array for this process
      call  par_defwfk (nrplwv,nrplwv_global,nplwkp,nlocal,&
                        offset,n_local,&
#include PARAL_ARGS
        , nconso)
      n_global= nplwkp   ! parallel_args
      ! get the rank of this processor
      call par_rank_pw(irank,&
#include PARAL_ARGS
        ,nconso   )
      block_size = par_pw_np
#else 
      n_local = nplwkp 
      block_size = min(nbands,12)
#endif

      ! setup <b|H|b> (hmat) and <b|S|b> (smat)
      call setup_bhb_bsb(cptwfp,nplwkp,nbands,hmat,smat,&
#include "apply_h_args.h"
             ,timer,nconso)

     ! copy complex variables to real variables 
     do n = 1,nbands 
      do m = 1,nbands 
         hmat_netcdf(1,n,m) = dreal(hmat(n,m)) 
         hmat_netcdf(2,n,m) = dimag(hmat(n,m)) 
         smat_netcdf(1,n,m) = dreal(smat(n,m)) 
         smat_netcdf(2,n,m) = dimag(smat(n,m)) 
      enddo 
     enddo

     ! open netCDF out file
     status =  nf_open(netCDF_output_filename, NF_WRITE, ncid )
     if (status /= nf_noerr) call abort_calc(nconso,  &
         "gen_hamiltonian_matrix  -> nf_open : error opening nc-outfile")


     status = nfput(ncid,'HMatrix',hmat_netcdf, &
                     dim_name1='real_complex',            &
                     dim_name2='number_of_bands',         &
                     dim_name3='number_of_bands'  ) 
     if (status /= nf_noerr) call abort_calc(nconso,  &
         "gen_hamiltonian_matrix  -> nfput : error writing hmat")

     status = nfput(ncid,'SMatrix',smat_netcdf, &
                     dim_name1='real_complex',            &
                     dim_name2='number_of_bands',         &
                     dim_name3='number_of_bands'  ) 
     if (status /= nf_noerr) call abort_calc(nconso,  &
         "gen_hamiltonian_matrix  -> nfput : error writing smat")

     status = nf_close(ncid) 


     end subroutine gen_hamiltonian_matrix
