!=====================================================================
      subroutine gencoord(&
                    posion,posq,                        &
                    force,forq,&
                    rvelo ,velq,&
#                   include "ions_args.h"
                    nconso)    
     
!=====================================================================
!    subroutine gencoord handles dynamic in spherical coordinates for 
!    two atoms given in sphericalcnstr. 
!    cforce is returned as the generalized forces
!=====================================================================
      implicit none
!=====================================================================
#     include "ions_decl.h"                 
      real*8   posion(3,nions,nspec),posq(3*nions)
      real*8   force(3,nions,nspec), forq(3*nions)
      real*8   rvelo(3,nions),       velq(3*nions)
      integer  nconso
      
!     locals 
      integer ncoor,natom1,natom2
      integer ni,nq,nr,nis,nsp,mr
      real*8 posr(3,nions),forr(3*nions)
      real*8 posrnew(3,nions),dltposr(3,nions)
      real*8 jcb(3*nions,3*nions),jcbi(3*nions,3*nions)
      real*8 forwrk(3,nions)
      real*8 dltsum,forqsum
      real*8 center
      real*8 eps
      parameter(eps = 1.0d-7)


      ncoor=2
      natom1=sphericalcnstr(1)
      natom2=sphericalcnstr(2)
      center=0.5d0
      ni = 1
      nq=1
      do nsp = 1 , nspec
         do nis = 1 , nionsp(nsp)
            do mr = 1 , 3
               posr(mr,ni)=posion(mr,nis,nsp)
               forr(nq)=force(mr,nis,nsp)
               velq(nq)=rvelo(mr,ni)
               write(*,*) 'forr velq  ',nq,&
                           forr(nq),velq(nq)
               nq=nq+1
            enddo
            write(*,*) 'posr ',ni,(posr(mr,ni),mr=1,3)
            ni = ni + 1
         enddo
      enddo
      call posa_to_r(posr,dirc,nions)
      call posr_to_q(ncoor,posr,posq,natom1,natom2,center,forr,nions)
      call jacobian(ncoor,posq,jcb,jcbi,natom1,natom2,center,nions,&
           nconso)
      do nq=1,3*nions
         forq(nq)=0.0d0
         do nr=1,3*nions
            forq(nq)=forq(nq)+jcb(nq,nr)*forr(nr)
         enddo
         write(*,3500)'FORQ',nq,forr(nq),forq(nq),velq(nq)
 3500 format(1x,a4,i4,1x,3f12.8)
      enddo


      return 
      end

      subroutine qumin_gen(forq,posq,dt,velq,nions,natom1,natom2,dposq)
!
      implicit  none
      integer   nions,natom1,natom2
      real*8    dt
      real*8    posq(3*nions),velq(3*nions)
      real*8    forq(3*nions),dltvelq(3*nions)
      real*8    dposq(3*nions)
      integer nq,nr,n,nat,j
      real*8    eps,sum 
      parameter(eps = 1.0d-12)
      real*8    size,dot_product,jjtdvq(3*nions)

      do nq=1,3*nions
         dltvelq(nq)= forq(nq)*dt
         velq(nq)   = velq(nq) + dltvelq(nq)
      enddo

!     loop over atoms

      do nat=1,nions
        size=0.0d0
        dot_product=0.0d0
        if (nat.lt.natom2) then 
          do j = 1,3
            nq = (nat-1)*3 + j
            size=size+forq(nq)**2
            dot_product=dot_product+velq(nq)*forq(nq)
          enddo
          do j=1,3
            nq = (nat-1)*3 + j
            if (size.gt.eps.and.dot_product.gt.eps) then
              velq(nq)=forq(nq)*dot_product/size
            else
              velq(nq)=dltvelq(nq)
            endif
          enddo
        else
!         take each component separately
          do j = 1,3 
            nq = (nat-1)*3 + j
            size=forq(nq)**2
            dot_product=velq(nq)*forq(nq)
            write(*,*) 'size dot_product ',nat,j,nq,size,dot_product,&
                        forq(nq),velq(nq)
            if (size.gt.eps.and.dot_product.gt.eps) then
              velq(nq)=forq(nq)*dot_product/size
            else                                           
              velq(nq)=dltvelq(nq)
            endif                 
          enddo
        endif

      enddo ! nat=1,nions

!     find the change in the generalized positions
      do nq=1,3*nions
         dposq(nq)=velq(nq)*dt*0.00957904d0/3.0d0
         write(*,*) 'dposq ',nq,dposq(nq),posq(nq)
      enddo

      end

#ifdef NUDGEDGEN
!=======================================================================
      subroutine bndcnst(nconso,velq,jcb,jcbi,forr,posr,dirc,nions)
!
! Hyperplane adaptive constraint method (HAC) 
! (=Nudged Elastic Band Method with force constant = 0)
!
!   substract the component of the force parallel to the constraint
!   direction from the total force.  
!   The resulting force is retuned in grion. 
!
! 
      implicit none
!
      real*8    jcb(3*nions,3*nions),velq(3*nions)
      real*8    jcbi(3*nions,3*nions),dirc(3,3)
      real*8    forr(3*nions),posr(3*nions)
      integer nions,nconso
! locals
      real*8 dirnorm,cnst(3*nions),a(3),cq(3*nions),sum
      integer ni,nq,nr,mr,mq
      real*8 dot,deds,fnorm,constant,resnorm
      logical*4 linit
      data linit /.true./
      save linit

      dirnorm=0.0d0
      open(22,FILE='constraint',STATUS='OLD')
      rewind 22
      nq=1
      do ni=1,nions
         read(22,*)(a(mq),mq=1,3)
         do mr=1,3
            cnst(nq)=0.0d0
            do mq=1,3
               cnst(nq)=cnst(nq)+dirc(mq,mr)*a(mq)
            enddo
            dirnorm=dirnorm+cnst(nq)**2
            nq=nq+1
         enddo
      enddo
      close(unit=22)
      do nq=1,3*nions
         cnst(nq)=cnst(nq)/dsqrt(dirnorm)
      enddo
      dot=0.0d0
      do nq=1,3*nions
         sum=0.0d0
         do nr=1,3*nions
            sum=sum+jcb(nq,nr)*cnst(nr)
         enddo
         dot=dot+sum*velq(nq)
      enddo
!
! calculate the dot product between the constraint direction and 
! the force, displacement, and calculate the dot-product between the 
! current positions and the constrain direction
! (should be constant) 
! 
      deds=0.d0
      constant=0.0d0
      fnorm=0.d0
      do nq=1,3*nions
         deds=deds-cnst(nq)*forr(nq)
         fnorm=fnorm+forr(nq)**2
         constant=constant+posr(nq)*cnst(nq)
         do nr=1,3*nions
            velq(nq)=velq(nq)-cnst(nr)*jcbi(nr,nq)*dot
         enddo
      enddo
!
! substract the component of the displacement parallel to the constraint
! direction from the total displacement.
!
      resnorm=0.0d0
      do nr=1,3*nions
         resnorm=resnorm+(forr(nr)+deds*cnst(nr))**2
      enddo
      if (linit) then
         write(nconso,*) &
      'HAC       |F|        |F_path|  |F_constrained|    POS*CDIR'
         linit=.false.
      endif
      write(nconso,4600)sqrt(fnorm),-deds,sqrt(resnorm),constant
 4600 format(1x,'HAC:',3f12.6,1x,f15.8)
      return 
      end

#endif NUDGEDGEN


!=========================================================================
      subroutine posa_to_r(a,dirc,nions)
!
!     convert coordinates in a from a1,a2,a3 coordinates to
!     x,y,z coordinates in a.
!
!=========================================================================
      implicit none
      integer     nions,ni,mr,mq
      real*8      a(3,nions),dirc(3,3),tmp(3)

      do ni=1,nions
         do mr=1,3
            tmp(mr)=0.0d0
            do mq=1,3
               tmp(mr)=tmp(mr)+a(mq,ni)*dirc(mq,mr)
            enddo	
         enddo	
         do mr=1,3
            a(mr,ni)=tmp(mr)
         enddo
      enddo
      return
      end

!=========================================================================
      subroutine posr_to_a(a,b,recc,tpi,nions)
!
!     convert coordinates in a from x,y,z coordinates to
!     a1,a2,a3 coordinates in b.
!
!=========================================================================
      implicit none
      integer     nions,ni,mq,mr
      real*8      a(3,nions),b(3,nions),recc(3,3),tmp(3),tpi

      do ni=1,nions
         do mq=1,3
            tmp(mq)=0.0d0
            do mr=1,3
               tmp(mq)=tmp(mq)+a(mr,ni)*recc(mq,mr)/tpi
            enddo	
         enddo	
         do mq=1,3
            b(mq,ni)=tmp(mq)
         enddo
      enddo
      return
      end


!=========================================================================
      subroutine posr_to_q(ncoor,r,q,natom1,natom2,center,forr,nions)
!
!     convert coordinates in r from x,y,z coordinates to
!     generalized coordinates of type ncoor in q.
!
!     ncoor = 1 : x_1,y_1,z_1,...z_nions
!             2 : center of mass for natom1 and natom2: x,y,z,r,phi,theta
!
!=========================================================================
      implicit none
      integer     ncoor,natom1,natom2,mr,mq,nions,ni
      real*8      r(3,nions),q(3,nions),center
      real*8      sum,dist,theta,phi,forr(3,nions)

      do ni=1,nions
         do mq=1,3
            q(mq,ni)=r(mq,ni)
         enddo
      enddo
      if(ncoor.eq.2) then
         sum=0.0d0
         do mr=1,3
            q(mr,natom1)=center*r(mr,natom1)+&
                 (1.0d0-center)*r(mr,natom2)
            sum=sum+(r(mr,natom2)-r(mr,natom1))**2
         enddo
         dist=dsqrt(sum)
         theta=dacos((r(3,natom2)-r(3,natom1))/dist)
         if(dsin(theta).lt.1.0d-3) then
            phi = 0.0d0
!           phi=datan2(center*forr(2,natom2)-
!    &           (1.0d0-center)*forr(2,natom1),
!    &           center*forr(1,natom2)-
!    &           (1.0d0-center)*forr(1,natom1))
         else
            phi=datan2(r(2,natom2)-r(2,natom1),&
                 r(1,natom2)-r(1,natom1))
         endif
         q(1,natom2)=dist
         q(2,natom2)=theta
         q(3,natom2)=phi
      endif

      do ni = 1,nions
        write(*,*) 'q ',ni,(q(mq,ni),mq=1,3)
      enddo
      return 
      end

!=========================================================================
      subroutine posq_to_r(q,r,natom1,natom2,nions)
!
!     convert coordinates in q from generalized coordinates of type 
!     ncoor to x,y,z coordinates in r
!     q,r can be the same array
!
!=========================================================================
      implicit none
      integer     natom1,natom2,nions
      real*8      q(3,nions),r(3,nions)
!     locals
      real*8      center
      integer     ncoor,mr,ni
      parameter(center=0.5d0,ncoor=2)
      real*8      x,y,z,q1(3,nions)

!     copy q to q1
      do ni = 1,nions 
       do mr = 1,3
         q1(mr,ni) = q(mr,ni)
       enddo
      enddo 

      if(ncoor.eq.2) then
         x=q1(1,natom2)*dsin(q1(2,natom2))*dcos(q1(3,natom2))
         y=q1(1,natom2)*dsin(q1(2,natom2))*dsin(q1(3,natom2))
         z=q1(1,natom2)*dcos(q1(2,natom2))
         r(1,natom1)=q1(1,natom1)-(1.0d0-center)*x
         r(2,natom1)=q1(2,natom1)-(1.0d0-center)*y
         r(3,natom1)=q1(3,natom1)-(1.0d0-center)*z
         r(1,natom2)=q1(1,natom1)+center*x
         r(2,natom2)=q1(2,natom1)+center*y
         r(3,natom2)=q1(3,natom1)+center*z
      endif
      do ni=1,nions
         if(ni.ne.natom1.and.ni.ne.natom2) then
            do mr=1,3
               r(mr,ni)=q1(mr,ni)
            enddo
         endif	
      enddo
      return 
      end

!=========================================================================
      subroutine jacobian(ncoor,q,jcb,jcbi,natom1,natom2,&
           center,nions,nconso)
!
!     convert forces in fr from x,y,z coordinates to
!     generalized forces of type ncoor in fq.
!
!=========================================================================
      implicit none
      integer     ncoor,natom1,natom2,mr,mq,nions,nr,nq,nconso
      real*8      center,jcb(3,nions,3,nions),q(3,nions),diag(3)
      real*8      r,theta,phi,j(3,3),jcbi(3,nions,3,nions)

      do nq=1,nions
         do mq=1,3
            do nr=1,nions
               do mr=1,3
                  jcb(mq,nq,mr,nr)=0.0d0
                  jcbi(mq,nq,mr,nr)=0.0d0
               enddo
            enddo
            jcb(mq,nq,mq,nq)=1.0d0
            jcbi(mq,nq,mq,nq)=1.0d0
         enddo
      enddo
      if(ncoor.eq.2) then
         r=q(1,natom2)
         theta=q(2,natom2)
         phi=q(3,natom2)
         if(theta.lt.1.0d-3) theta=1.0d-3
         if(theta.gt.3.141592654d0-1.0d-3) &
              theta=3.141592654d0-1.0d-3
         j(1,1)=dsin(theta)*dcos(phi)
         j(1,2)=dsin(theta)*dsin(phi)
         j(1,3)=dcos(theta)
         j(2,1)=r*dcos(theta)*dcos(phi)
         j(2,2)=r*dcos(theta)*dsin(phi)
         j(2,3)=-r*dsin(theta)
         j(3,1)=-r*dsin(theta)*dsin(phi)
         j(3,2)=r*dsin(theta)*dcos(phi)
         j(3,3)=0.0d0
         diag(1)=1.0d0
         diag(2)=r**2
         diag(3)=(r*dsin(theta))**2
         do mq=1,3
            do mr=1,3
               if(mq.eq.mr) then
                  jcb(mq,natom1,mr,natom1)=1.0d0
                  jcb(mq,natom1,mr,natom2)=1.0d0
                  jcbi(mq,natom1,mr,natom1)=center
                  jcbi(mq,natom2,mr,natom1)=1.0d0-center
               else 
                  jcb(mq,natom1,mr,natom1)=0.0d0
                  jcb(mq,natom1,mr,natom2)=0.0d0
                  jcbi(mq,natom1,mr,natom1)=0.0d0
                  jcbi(mq,natom2,mr,natom1)=0.0d0
               endif
               jcb(mq,natom2,mr,natom1)=(center-1.0d0)*&
                    j(mq,mr)
               jcb(mq,natom2,mr,natom2)=center*&
                    j(mq,mr)
               jcbi(mq,natom1,mr,natom2)=-j(mr,mq)/diag(mr)
               jcbi(mq,natom2,mr,natom2)=j(mr,mq)/diag(mr)
            enddo
         enddo
         write(nconso,10) r,theta,phi
 10      format(1x,'RTHETAPHI',3(f12.6,1x))
      endif
      return 
      end


