#include "definitions.h"
!=======================================================================
      subroutine forlid(nconso)
      write(nconso,*) '@(#)forloc.F	1.10 7/1/99'
      return
      end
!=======================================================================
      subroutine forloc(ngx,ngy,ngz,nions,nplwv,posion,rdensr,rdnsum,&
          recc,eifor,lpctx,lpcty,lpctz,lpctfx,lpctfy,lpctfz,&
          nspec,nionsp,psp,rho_rad,vxc,&
          psgmax,icharg,npspts,&
          volc,nspin)
!=======================================================================
! this subroutine calculates 
! 
! (1) The hellmann-feynman forces exerted on the
!     ions by the local pseudo potential : 
!     which equals the sum over reciprocal lattice
!     vectors of ig*exp(-ig.r)* charge density at wavevector g * the value
!     of the pseudopotential at wavevector -g
!
! (2) The force from the partial-core charge rho_rad
!
!     F_partialcore = -i sum(G)( G * exp(i g r) * Vxc(G) * rho_rad(G) ) 
!                                                (Vxc+(G) + Vxc-(G))*1/2*rho_rad(G)
!                                                for spin-polarization
!

! input: rdensr(r): realspace charge density (input charge density for 
!                   Harris functional)
!        rdnsum(r): realspace charge density (output charge density for
!                   Harris functional)
!                   (Not used now)
!        psp      : real space local pseudo potential 
!        vxc      : real space exchange-correlation potential 
!        rho_rad  : partial core charge on radial fourier grid 
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension posion(3,nions,nspec)
      dimension rdensr(nplwv,nspin),rdnsum(nplwv,nspin)
      dimension vxc(nplwv,nspin) 
      dimension rho_rad(npspts,nspec)
      dimension recc(3,3)
      dimension eifor(3,nions,nspec)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      dimension lpctfx(ngx),lpctfy(ngy),lpctfz(ngz)
      dimension nionsp(nspec)
      dimension psp(npspts,nspec)
      dimension psgmax(nspec)
      dimension icharg(nspec)
      integer nspin

!     Local arrays 
      dimension cwork1(nplwv)
      dimension cwor12(nplwv) 
!=======================================================================
      citpi=(0.0d0,6.283185307179d0)
!=======================================================================
! Note: The dot-product of R.G will be calculated as R1*G1+R2*G2+R3*G3
!       - just as though R and G were in cartesian coordinates!
!       This is NOT an error, but is true in this special case
!       were G is defined in the reciprocal space of R.
!
! [ |  |  | ] [ ]   2pi[  |     |     |  ] [ ]
! [ a1 a2 a3] [R] . ---[a2xa3 a3xa1 a1xa2] [G] = 2 pi{R1*G1+R2*G2+R3*G3}
! [ |  |  | ] [ ]   vol[  |     |     |  ] [ ]
!=======================================================================
! initialise the force on the ions to zero
!=======================================================================
      do 8020 nsp=1,nspec
         do 8010 nion=1,nionsp(nsp)
            do 8000 m=1,3
               eifor(m,nion,nsp)=0.0d0
 8000       continue
 8010    continue
 8020 continue
!=======================================================================
! transform the charge density (rdensr) into recicprocal space (cwork1) 
!=======================================================================
      rinplw=1.0d0/nplwv
      do m=1,nplwv
        cwork1(m)=(rdensr(m,1)+dble(nspin-1)*rdensr(m,nspin))*rinplw
      enddo   
      call fft3d(cwork1,ngx,ngy,ngz,-1)

!=======================================================================
! transform the charge density (rdnsum) into recicprocal space (cwork2) 
!=======================================================================
!     rinplw=1.0d0/nplwv
!     do  m=1,nplwv
!       cwork2(m)=(rdnsum(m,1)+dble(nspin-1)*rdnsum(m,nspin))*rinplw
!     enddo    
!     call fft3d(cwork2,ngx,ngy,ngz,-1)
!=======================================================================
! transform the exchange-corrlation potential into reciprocal space (cwor12)
!=======================================================================
      do 8026 m=1,nplwv 
        cwor12(m)=(vxc(m,1)+dble(nspin-1)*vxc(m,nspin))*&
                   rinplw/dble(nspin)
 8026 continue                                           
      call fft3d(cwor12,ngx,ngy,ngz,-1)

!=======================================================================
! ng = an index used to label the reciprocal lattice vectors
!=======================================================================
      ng=1
!=======================================================================
! calculate the total force on the ions by summing over reciprocal
! lattice vectors
!=======================================================================
      do 8070 n=1,ngz
         g3x=recc(3,1)*lpctz(n)
         g3y=recc(3,2)*lpctz(n)
         g3z=recc(3,3)*lpctz(n)
         do 8060 nn=1,ngy
            g2x=recc(2,1)*lpcty(nn)
            g2y=recc(2,2)*lpcty(nn)
            g2z=recc(2,3)*lpcty(nn)
            do 8050 nnn=1,ngx
               gx=recc(1,1)*lpctx(nnn)+g2x+g3x
               gy=recc(1,2)*lpctx(nnn)+g2y+g3y
               gz=recc(1,3)*lpctx(nnn)+g2z+g3z
               g=sqrt(gx**2+gy**2+gz**2)
               do 8040 nsp=1,nspec
!=======================================================================
! calculate the formfactor for this g with species nsp
!=======================================================================
                  call calvps(g,vps,volc,psp(1,nsp),psgmax(nsp),&
                                                     icharg(nsp),npspts)

!=======================================================================
! calculate the value rhoc for the partial core for this g 
!=======================================================================
                  call interpolate(g,rho_rad(1,nsp),nspec,&
                                   psgmax(nsp),npspts,rhoc)
!=======================================================================
! calculate the value rhov for the atomic valence density for this g 
!=======================================================================
!                 call interpolate(g,atom_val(1,nsp),nspec,
!    1                             psgmax(nsp),npspts,rhov)
!=======================================================================
! loop over atoms of this species
!=======================================================================
                  do 8030 ni=1,nionsp(nsp)
!=======================================================================
! calculate the complex exponential of the phase factor
!=======================================================================
                     cexpf=exp( citpi*(posion(1,ni,nsp)*lpctx(nnn)+&
                                       posion(2,ni,nsp)*lpcty(nn)+&
                                       posion(3,ni,nsp)*lpctz(n)))
!=======================================================================
! add the contribution to the force from the present reciprocal lattice
! vector
!=======================================================================
!                    (1) local pseudo potential 
!                    cprod1=0.5d0*(cwork1(ng)+cwork2(ng))*vps*cexpf
                     cprod1= cwork1(ng)*vps*cexpf

!                    (2) partial core 
                     cprod2=cwor12(ng)*rhoc*cexpf

                     cprod = cprod1 + cprod2
                     eifor(1,ni,nsp)=eifor(1,ni,nsp)+dimag(gx*cprod)
                     eifor(2,ni,nsp)=eifor(2,ni,nsp)+dimag(gy*cprod)
                     eifor(3,ni,nsp)=eifor(3,ni,nsp)+dimag(gz*cprod)
!=======================================================================
! move onto the next ion
!=======================================================================
 8030             continue
 8040          continue
!=======================================================================
! increase the reciprocal lattice vector index by one
!=======================================================================
               ng=ng+1
 8050       continue
 8060    continue
 8070 continue
      return
      end
!=======================================================================
      subroutine iforce(fortot,eifor,ewifor,fnleif,nions,nionsp,nspec,&
                        nconso,iprint,idebug,ffield,rmove,forvar,forsha,&
                        forall)
!=======================================================================
      implicit  none
!=======================================================================
      integer   nions,nconso,iprint,idebug,nspec
      real*8    fortot(3,nions,nspec)
      real*8    eifor(3,nions,nspec)
      real*8    ewifor(3,nions,nspec)
      real*8    fnleif(3,nions,nspec)
      real*8    ffield(3,nions,nspec)
      integer   nionsp(nspec)
      real*8    rmove(3,nions)
      real*8    forvar,forsha,forall
!=======================================================================
      integer   ii,nsp,ni,m
      real*8    ftot
      ii=1
      forvar=0.0d0
      forall=0.0d0
      do 111 nsp=1,nspec
         do 112 ni=1,nionsp(nsp)
            if (idebug.ge.10) then
               write(nconso,214) ii,(eifor(m,ni,nsp),m=1,3)
               call uflush(nconso)
               write(nconso,314) ii,(ewifor(m,ni,nsp),m=1,3)
               call uflush(nconso)
               write(nconso,414) ii,(fnleif(m,ni,nsp),m=1,3)
               call uflush(nconso)
               write(nconso,514) ii,(ffield(m,ni,nsp),m=1,3)
               call uflush(nconso)
            endif
            do 113 m=1,3
               ftot=eifor(m,ni,nsp)+ewifor(m,ni,nsp)+&
                   fnleif(m,ni,nsp)+ffield(m,ni,nsp)
               forvar=forvar+(rmove(m,ii)*(fortot(m,ni,nsp)-ftot))**2
               forall=forall+(rmove(m,ii)*ftot)**2
               fortot(m,ni,nsp)=ftot
 113        continue
          if (iprint.eq.0) then
            write(nconso,114) ii,(fortot(m,ni,nsp),m=1,3)
          endif
          ii=ii+1
 112   continue
 111  continue
      forvar=sqrt(forvar)
      forall=sqrt(forall)
      forsha= 0.0d0
      if (forall.gt.1.0d-7) forsha=forvar/forall
!114  format(1x,'FOR: ',i3,3f9.4)
 114  format(1x,'FOR: ',i3,3f12.7)
 214  format(1x,'eifor ',i2,3f13.7)
 314  format(1x,'ewifo ',i2,3f13.7)
 414  format(1x,'fnlei ',i2,3f13.7)
 514  format(1x,'ffiel ',i2,3f13.7)
      return
      end
