      subroutine fft3id(nconso)
      write(nconso,*) '@(#)fft3d2.F	1.14 7/1/99'
      return
      end
!======================== FFTW ========================================
#ifdef FFTW 
! FFTW version 2.1.3
!=======================================================================
      subroutine fft3d(inp,n1,n2,n3,isign)
      use run_context
!======================================================================= 
      implicit none
      integer n1,n2,n3,niter,isign
      complex*16 inp(n1*n2*n3)
      complex*16 dummy
      integer i,istatus

#include "fftw_f77.i"
!     make room for two plans
      integer*8 planfwd(2),planinv(2)
      logical init(2),same_grid,setup_grid
      integer grid1(3),grid_number
      data init/.true.,.true./ 
      save planfwd,planinv,init,grid1

      setup_grid = .false.
      if (init(1)) then
       write(nconso,*) 'FFTW : Setup grid 1',n1,n2,n3
       grid1(1) = n1
       grid1(2) = n2
       grid1(3) = n3
       grid_number = 1
       setup_grid = .true. 
       init(1) = .false.
      elseif (init(2)) then 
       if (.not.(same_grid(n1,n2,n3,grid1))) then 
         write(nconso,*) 'FFTW : Setup grid 2',n1,n2,n3
         grid_number = 2
         setup_grid = .true. 
         init(2) = .false.
       endif
      endif
      if (setup_grid) then 
       call fftw3d_f77_create_plan(planfwd(grid_number),n1,n2,n3,&
          FFTW_FORWARD, FFTW_MEASURE + FFTW_IN_PLACE)
       call fftw3d_f77_create_plan(planinv(grid_number),n1,n2,n3,&
          FFTW_BACKWARD, FFTW_MEASURE + FFTW_IN_PLACE)
!    +    FFTW_ESTIMATE + FFTW_IN_PLACE)
      endif

      if (same_grid(n1,n2,n3,grid1)) then 
         grid_number = 1
      else
         grid_number = 2
      endif

      if (isign.gt.0) then 
        call fftwnd_f77_one(planinv(grid_number), inp, dummy)
      else
        call fftwnd_f77_one(planfwd(grid_number), inp, dummy)
      endif

      return
      end               

!======================================================================
      logical function same_grid(n1,n2,n3,grid) 
      integer n1,n2,n3,grid(3) 

        same_grid = .true. 
        if (n1.ne.grid(1)) same_grid = .false. 
        if (n2.ne.grid(2)) same_grid = .false. 
        if (n3.ne.grid(3)) same_grid = .false. 

      return 
      end

!======================== ESSL ========================================
#elif ESSL
!=======================================================================
      subroutine fft3d(inp,n1,n2,n3,isign)
!=======================================================================
      implicit none
      complex*16 inp(*)
      integer n1,n2,n3
      integer isign
!=======================================================================
! Locals
!=======================================================================
      integer inc2x,inc3x
      real*8 scale
      integer i1    
      parameter(i1 = 60000)
      complex*16 c1(i1)
!=======================================================================
      inc2x=n1
      inc3x=inc2x*n2
      scale=1.0d0
!=======================================================================
      call DCFT3(inp,inc2x,inc3x,inp,inc2x,inc3x,n1,n2,n3,&
                 -isign,scale,c1,i1)
!=======================================================================
      return
      end



!======================= SUM ULTRA/SS10 ================================
!
! ULTRA_ZFFT : zfft.o Lennart Bengtsson 1998    (only this option is active now)
! ULTRA      : ultrafft.o Lennart Bengtsson 1996
! SS10       : hyperfft.o Lennart Bengtsson 1995


#elif ULTRA

#ifdef ULTRA_ZFFT

!=======================================================================
      subroutine fft3d(inp,n1,n2,n3,isign)
!
!     new interface, provided by Sergei Dudiy Feb 1, 2000
!=======================================================================
      implicit none
      complex*16 inp(n1*n2*n3)
      integer n1,n2,n3
      integer isign
!=======================================================================
! Locals
!=======================================================================
      double precision c1fft(n1*n2*n3)
!=======================================================================
      call zfft3di(n1,n2,n3,c1fft)
      call zfft3d(isign,n1,n2,n3,inp,&
                         n1,n2,c1fft)
      return
      end
!=======================================================================   

#else


!  Use home-made FFT routines for SUN / Lennart Bengtsson CTH 1995-96

      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)
      use run_context
      implicit none
      double precision inp(*), r1fft, r2fft, r3fft, c1fft(*)
      complex*16 c2fft
      integer ngptar(3), i1fft, isign
      integer ntot, i, align
!  The 'effective' cache size on an ultra-1 is 60 pages due to
!  oddities in physical memory allocation order. / Lennart
#define CACHESIZE 491520

!  Use ultrasparc-optimized FFT-routine
!  Make sure the fft work area is located on a 16 byte boundary 
      external ckalign !$pragma C(ckalign)
      ntot = ngptar(1)*ngptar(2)*ngptar(3)
      if (i1fft.eq.0) i1fft=ntot
      call ckalign(c1fft, align)
      if (align.eq.16) then
         call fft(inp, c1fft(1), 3, ngptar, -isign, .true., .false.,&
            i1fft, CACHESIZE, NCONSO)
      else
         if (i1fft.gt.ntot) then
            call fft(inp, c1fft(2), 3, ngptar, -isign, .true., .false.,&
               i1fft-1, CACHESIZE, nconso)
         else
            call fft(inp, c1fft(2), 3, ngptar, -isign, .true., .false.,&
               i1fft, CACHESIZE, nconso)
         endif
      endif
      return
      end

#endif ULTRA_ZFFT

#elif SS10

!  Use home-made FFT routines for SUN / Lennart Bengtsson CTH 1995-96
 
      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)
      implicit none
      double precision inp(*), r1fft, r2fft, r3fft, c1fft(*)
      complex*16 c2fft
      integer ngptar(3), i1fft, isign
      integer ntot, i, align

!  Use super/hypersparc version
      call fftold(inp, c1fft, 3, ngptar, -isign, 16000)
      ntot = ngptar(1)*ngptar(2)*ngptar(3)
      do 10 i = 1, 2*ntot
         inp(i) = c1fft(i)
 10   continue
      return
      end


!======================= DEC ALPHA (using the DXML library ==========

#elif DXML

      subroutine fft3d(inp,ngx,ngy,ngz,isign)
      use run_context
      implicit none
      complex*16 inp(*)
      integer ngx,ngy,ngz
      integer isign       

! locals
      integer status,ndim,i
                            
      INCLUDE '/usr/include/DXMLDEF.FOR'
                                         
      if (isign.eq.-1) then
        status = ZFFT_3D ('C','C','F',inp,inp,&
                        ngx,ngy,ngz,  &
                        ngx,ngy, 1, 1, 1)   
      else                                            
        status = ZFFT_3D ('C','C','B',inp,inp,&
                        ngx,ngy,ngz,  &
                        ngx,ngy, 1, 1, 1)   
      endif                                           
            
      if (isign.eq.1) then
        ndim= ngx*ngy*ngz
        do i=1,ndim                        
          inp(i)=inp(i)*ndim
        enddo                
      endif   
            
      if ( status.ne. DXML_SUCCESS() ) then
        write(nconso,*) 'Fatal error in Digital DXML Fourier call'
        call clexit(nconso)                                        
      endif             
            
      return
      end

!========================= Silicon Graphics ============================
!     (SGI interface by Sergei Dudiy) 

#elif SGI

!=======================================================================
      subroutine fft3d(inp,n1,n2,n3,isign)
!=======================================================================
      implicit none
      complex*16 inp(n1*n2*n3)
      integer n1,n2,n3
      integer isign
!=======================================================================
! Locals
!=======================================================================
      complex*16  c1fft(n1+15 + n2+15 + n3+15)
!=======================================================================
      call zfft3di(n1,n2,n3,c1fft)
      call zfft3d(isign,n1,n2,n3,inp,&
                        n1,n2,c1fft)
      return
      end


!========================= CRAY UNICOS =================================
#elif CRAY

!=======================================================================
      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)
!=======================================================================
      implicit none
      complex*16 inp(*)
      integer ngptar(3), i1fft, isign
      real*8 r1fft, r2fft, r3fft
      complex*16 c1fft(*), c2fft
!=======================================================================
! Locals
!=======================================================================
      integer isys
      real*8 scale
      real*8 table(100+2*(ngptar(1)+ngptar(2)+ngptar(3)))
      real*8 work(512*max(ngptar(1),ngptar(2),ngptar(3)))
!=======================================================================
      scale=1.0d0
!     Parallel performance:
!     The isys=1 option would require a larger work array
      isys=0
!=======================================================================
!     Set up tables
      call CCFFT3D(0,    ngptar(1),ngptar(2),ngptar(3),scale,&
        inp,ngptar(1),ngptar(2), inp,ngptar(1),ngptar(2),&
        table,work,isys)
!     Do the FFT
      call CCFFT3D(-isign,ngptar(1),ngptar(2),ngptar(3),scale,&
        inp,ngptar(1),ngptar(2), inp,ngptar(1),ngptar(2),&
        table,work,isys)
!=======================================================================
      return
      end

#elif VPP500
!========================= Fujitsu VPP vector processors ===============

      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)

!     Using the Fujitsu SSL II Extended Capabilities library
!     for single-node vector-processor.
!     For multi-node FFT the parallel library must be used.
!     /Ole H. Nielsen, Feb. 1998.

      use run_context
      implicit none
      complex*16 inp(*)
      integer ngptar(3), i1fft, isign
      real*8 r1fft(*), r2fft(*), r3fft(*)
      complex*16 c1fft(*), c2fft(*)

!     Local variables
      integer i, nconso, iw, icon, isize, isn(3)
      logical initialized
      data initialized /.FALSE./
      save iw, initialized

!     Convention used for "isign":
!     isign = -1 ... Normal (forward) transform (real->reciprocal space)
!     isign = +1 ... Inverse transform (reciprocal->real space)
      do i = 1, 3
        isn(i) = - isign
      end do

!     Determine workspace size "iw"
      if (.not. initialized) then
        iw = 0
        call dvmcft (r1fft, r2fft, ngptar, 3, isn, r3fft, iw, icon)
        if (icon .ne. 0 .and. icon .ne. 30001) then
          write (nconso,*) 'dvmcft initialization returned error code ', &
            icon, ' iw=', iw
          call clexit (nconso)
        endif
!       The value "iw" returned is saved and used for all subsequent calls
        initialized = .TRUE.
      endif

!     Do the Fourier transform

      isize = ngptar(1) * ngptar(2) * ngptar(3)
      call dvmcft_wrapper (inp, ngptar, isize, iw, isn,nconso)

      return
      end

!VOCL TOTAL,VECTOR
      subroutine dvmcft_wrapper (inp, ngptar, isize, iw, isn,nconso)

!     Calling the dvmcft, allocates temporary workspaces

      implicit none
      complex*16 inp(isize)
      integer ngptar(3), isize, iw, isn(3)

!     Local variables
      real*8 xr(isize), xi(isize), w(iw), xnorm
      integer icon, i, nconso

!     Copy the complex*16 array into separate real and imaginary arrays
      do i = 1, isize
        xr(i) = dreal (inp(i))
        xi(i) = dimag (inp(i))
      end do

      call dvmcft (xr, xi, ngptar, 3, isn, w, iw, icon)

      if (icon .ne. 0) then
        write (nconso,*) 'dvmcft returned error code ', icon
        call clexit (nconso)
      endif

!     Copy result back into the complex*16 array

!     if (isn(1) .eq. 1) then
!       Forward transform
        do i = 1, isize
          inp(i) = dcmplx (xr(i), xi(i))
        end do
!     else
!       Inverse transform: must normalize
!       xnorm = dble(isize)
!       do i = 1, isize
!         inp(i) = xnorm * dcmplx (xr(i), xi(i))
!       end do
!     endif

      return
      end

#else

!========================== Default FFT ================================

!VOCL TOTAL,VECTOR
      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)
!=======================================================================
      implicit none
      complex*16 inp(*)
      integer ngptar(3)
      integer i1fft
      real*8 r1fft(*)
      real*8 r2fft(*)
      real*8 r3fft(*)
      complex*16 c1fft(i1fft)
      complex*16 c2fft(i1fft)
      integer isign
!=======================================================================
! this subroutine was written by professor david h. vanderbilt (now at
! harvard). the subroutine basically performs a series of permutations
! of a three dimensional data array to make optimum use of the multi-
! one dimensional array capability of the vectorised fast fourier
! transform routine cfft99. this subroutine puts the data into a larger
! array than the ngx*ngy*ngz grid used in the basic programs for some
! esoteric reason related to the way that the cray works. basically, if
! you have a better, clearer three dimensional fast fourier transform
! subroutine you may be better off using it.
!=======================================================================
! as mentioned above the array for the fourier transforms is bigger than
! the grid used in the programs so the parameters mnbx,mnby and mnbz
! must be chosen so that mnbx*mnby*mnbz is greater than ngx*ngy*ngz+
! max(ngx,ngy,ngz). also with the present routine mnbx must equal ngx
! and mnby must equal ngy for the permutations to work
!=======================================================================
      integer ifacx(13),ifacy(13),ifacz(13)
      integer key
      data key/0/
      save key
      save ifacx,ifacy,ifacz
      integer nx,ny,nz,mnbx,mnby,mnbz
      integer nzx,nyz,nxy
      integer nzx1,nyz1,nxy1
      integer nnn,ndim
!
!     3-d fast fourier transform
!
!     isign = +1 : forward : real --> recip : exp(-iqr)
!     isign = -1 : backward: recip --> real : exp(+iqr)
!
!     ngptar should be same for all calls
!
!     mnbx,y,z should be chosen so that the product exceeds
!       nx*ny*nz by at least max(nx,ny,nz)
!     usually can be done by incrementing mnbx by 1
!
      if (key.eq.1) go to 60
!
      nx=ngptar(1)
      ny=ngptar(2)
      nz=ngptar(3)
      mnbx=nx
      mnby=ny
      mnbz=nz+1
      nxy=nx*ny
      nyz=ny*nz
      nzx=nz*nx
      nxy1=nx*ny+1
      nyz1=ny*nz+1
      nzx1=nz*nx+1
      if (nx.gt.mnbx) go to 900
      if (ny.gt.mnby) go to 900
      if (nz.gt.mnbz) go to 900
      ndim=nx*ny*nz+max0(nx,ny,nz)*4
      if (ndim.gt.mnbx*mnby*mnbz) go to 900
      call cftfax(nx,ifacx,r1fft)
      call cftfax(ny,ifacy,r2fft)
      call cftfax(nz,ifacz,r3fft)
      if (ifacx(1).le.0) stop 44
      if (ifacy(1).le.0) stop 44
      if (ifacz(1).le.0) stop 44
!     LH key=1 -> key=0
   60 key=0
      do 8020 nnn=1,nx*ny*nz
         c1fft(nnn)=inp(nnn)
 8020 continue
!
      if (isign.lt.0) go to 100
  100 continue
!
!     cfft99 has different convention : isign=-1 --> forward
!
      call fpack(c1fft,c2fft,nx,ny,nz,ndim)
      call cfft99(c2fft,c1fft,r3fft,ifacz,nxy1,1,nz,nxy,isign)
      call fperm(c2fft,c1fft,nx,ny,nz,ndim)
      call cfft99(c1fft,c2fft,r1fft,ifacx,nyz1,1,nx,nyz,isign)
      call fperm(c1fft,c2fft,ny,nz,nx,ndim)
      call cfft99(c2fft,c1fft,r2fft,ifacy,nzx1,1,ny,nzx,isign)
      call funpk(c2fft,c1fft,nx,ny,nz,ndim)
 751  format(1x,e12.6)
!
      do 8060 nnn=1,nx*ny*nz
         inp(nnn)=c1fft(nnn)
 8060 continue
      return
!
  900 write (6,5) nx,ny,nz,mnbx,mnby,mnbz
    5 format (' === mnbx,y,z too small ==='&
          /' nx,y,z   =',3i5/&
          /' mnbx,y,z =',3i5)
      stop 43
      end

!     ****************************************************************
!VOCL TOTAL,VECTOR
      subroutine fpack(a,b,nx,ny,nz,ndim)
!     ****************************************************************
      implicit double precision (a-h,o-z)
      complex*16 a(ndim),b(ndim)
      mnbx=nx
      mnby=ny
      mnbz=nz
      mxy=mnbx*mnby
      nxy1=nx*ny+1
      do 100 iz=1,nz
      ia2=mxy*iz-mxy-mnbx
      ib2=nxy1*iz-nxy1-nx
      do 100 iy=1,ny
      ia=mnbx*iy+ia2
      ib=nx*iy+ib2
      do 90 ix=1,nx
   90 b(ib+ix)=a(ia+ix)
  100 continue
      return
      end

!     ****************************************************************
!VOCL TOTAL,VECTOR
      subroutine funpk(a,b,nx,ny,nz,ndim)
!     ****************************************************************
      implicit double precision (a-h,o-z)
      complex*16 a(ndim),b(ndim)
      mnbx=nx
      mnby=ny
      mnbz=nz
      mxy=mnbx*mnby
      nzx1=nz*nx+1
      do 100 iz=1,nz
      ia2=iz-nzx1-nz
      ib2=mxy*iz-mxy-mnbx
      do 100 iy=1,ny
      ia=nzx1*iy+ia2
      ib=mnbx*iy+ib2
      do 90 ix=1,nx
   90 b(ib+ix)=a(ia+ix*nz)
  100 continue
      return
      end

!     ****************************************************************
!VOCL TOTAL,VECTOR
      subroutine fperm(a,b,nx,ny,nz,ndim)
!     ****************************************************************
      implicit double precision (a-h,o-z)
      complex*16 a(ndim),b(ndim)
      nxy1=nx*ny+1
      nyz1=ny*nz+1
      do 100 iz=1,nz
      ia2=nxy1*iz-nxy1-nx
      ib2=ny*iz-nyz1-ny
      do 100 iy=1,ny
      ia=nx*iy+ia2
      ib=iy+ib2
      do 90 ix=1,nx
   90 b(ib+ix*nyz1)=a(ia+ix)
  100 continue
      return
      end

!***********************************************************************
!***********************************************************************
!!sec cfft99
! cfft99     from xlib                                     05/13/82
!VOCL TOTAL,VECTOR
      subroutine cfft99(a,work,trigs,ifax,inc,jump,n,lot,isign)
!
! purpose      performs multiple fast fourier transforms.  this package
!              will perform a number of simultaneous complex periodic
!              fourier transforms or corresponding inverse transforms.
!              that is, given a set of complex gridpoint vectors, the
!              package returns a set of complex fourier
!              coefficient vectors, or vice versa.  the length of the
!              transforms must be a number greater than 1 that has
!              no prime factors other than 2, 3, and 5.
!
!              the package cfft99 contains several user-level routines:
!
!            subroutine cftfax
!                an initialization routine that must be called once
!                before a sequence of calls to cfft99
!                (provided that n is not changed).
!
!            subroutine cfft99
!                the actual transform routine routine, cabable of
!                performing both the transform and its inverse.
!                however, as the transforms are not normalized,
!                the application of a transform followed by its
!                inverse will yield the original values multiplied
!                by n.
!
!
! access       *fortran,p=xlib,sn=cfft99
!
!
! usage        let n be of the form 2**p * 3**q * 5**r, where p .ge. 0,
!              q .ge. 0, and r .ge. 0.  then a typical sequence of
!              calls to transform a given set of complex vectors of
!              length n to a set of (unscaled) complex fourier
!              coefficient vectors of length n is
!
!                   dimension ifax(13),trigs(2*n)
!                   complex a(...), work(...)
!
!                   call cftfax (n, ifax, trigs)
!                   call cfft99 (a,work,trigs,ifax,inc,jump,n,lot,isign)
!
!              the output vectors overwrite the input vectors, and
!              these are stored in a.  with appropriate choices for
!              the other arguments, these vectors may be considered
!              either the rows or the columns of the array a.
!              see the individual write-ups for cftfax and
!              cfft99 below, for a detailed description of the
!              arguments.
!
! history      the package was written by clive temperton at ecmwf in
!              november, 1978.  it was modified, documented, and tested
!              for ncar by russ rew in september, 1980.  it was
!              further modified for the fully complex case by dave
!              fulker in november, 1980.
!
!-----------------------------------------------------------------------
!
! subroutine cftfax (n,ifax,trigs)
!
! purpose      a set-up routine for cfft99.  it need only be
!              called once before a sequence of calls to cfft99,
!              provided that n is not changed.
!
! argument     ifax(13),trigs(2*n)
! dimensions
!
! arguments
!
! on input     n
!               an even number greater than 1 that has no prime factor
!               greater than 5.  n is the length of the transforms (see
!               the documentation for cfft99 for the definition of
!               the transforms).
!
!              ifax
!               an integer array.  the number of elements actually used
!               will depend on the factorization of n.  dimensioning
!               ifax for 13 suffices for all n less than 1 million.
!
!              trigs
!               a real array of dimension 2*n
!
! on output    ifax
!               contains the factorization of n.  ifax(1) is the
!               number of factors, and the factors themselves are stored
!               in ifax(2),ifax(3),...  if n has any prime factors
!               greater than 5, ifax(1) is set to -99.
!
!              trigs
!               an array of trigonometric function values subsequently
!               used by the cft routines.
!
!-----------------------------------------------------------------------
!
! subroutine cfft99 (a,work,trigs,ifax,inc,jump,n,lot,isign)
!
! purpose      perform a number of simultaneous (unnormalized) complex
!              periodic fourier transforms or corresponding inverse
!              transforms.  given a set of complex gridpoint
!              vectors, the package returns a set of
!              complex fourier coefficient vectors, or vice
!              versa.  the length of the transforms must be a
!              number having no prime factors other than
!              2, 3, and 5.  this routine is
!              optimized for use on the cray-1.
!
! argument     complex a(n*inc+(lot-1)*jump), work(n*lot)
! dimensions   real trigs(2*n), integer ifax(13)
!
! arguments
!
! on input     a
!               a complex array of length n*inc+(lot-1)*jump containing
!               the input gridpoint or coefficient vectors.  this array
!               overwritten by the results.
!
!               n.b. although the array a is usually considered to be of
!               type complex in the calling program, it is treated as
!               real within the transform package.  this requires that
!               such type conflicts are permitted in the user's
!               environment, and that the storage of complex numbers
!               matches the assumptions of this routine.  this routine
!               assumes that the real and imaginary portions of a
!               complex number occupy adjacent elements of memory.  if
!               these conditions are not met, the user must treat the
!               array a as real (and of twice the above length), and
!               write the calling program to treat the real and
!               imaginary portions explicitly.
!
!              work
!               a complex work array of length n*lot or a real array
!               of length 2*n*lot.  see n.b. above.
!
!              trigs
!               an array set up by cftfax, which must be called first.
!
!              ifax
!               an array set up by cftfax, which must be called first.
!
!
!               n.b. in the following arguments, increments are measured
!               in word pairs, because each complex element is assumed
!               to occupy an adjacent pair of words in memory.
!
!              inc
!               the increment (in word pairs) between successive element
!               of each (complex) gridpoint or coefficient vector
!               (e.g.  inc=1 for consecutively stored data).
!
!              jump
!               the increment (in word pairs) between the first elements
!               of successive data or coefficient vectors.  on the cray-
!               try to arrange data so that jump is not a multiple of 8
!               (to avoid memory bank conflicts).  for clarification of
!               inc and jump, see the examples below.
!
!              n
!               the length of each transform (see definition of
!               transforms, below).
!
!              lot
!               the number of transforms to be done simultaneously.
!
!              isign
!               = -1 for a transform from gridpoint values to fourier
!                    coefficients.
!               = +1 for a transform from fourier coefficients to
!                    gridpoint values.
!
! on output    a
!               if isign = -1, and lot gridpoint vectors are supplied,
!               each containing the complex sequence:
!
!               g(0),g(1), ... ,g(n-1)  (n complex values)
!
!               then the result consists of lot complex vectors each
!               containing the corresponding n coefficient values:
!
!               c(0),c(1), ... ,c(n-1)  (n complex values)
!
!               defined by:
!                 c(k) = sum(j=0,...,n-1)( g(j)*exp(-2*i*j*k*pi/n) )
!                 where i = sqrt(-1)
!
!
!               if isign = +1, and lot coefficient vectors are supplied,
!               each containing the complex sequence:
!
!               c(0),c(1), ... ,c(n-1)  (n complex values)
!
!               then the result consists of lot complex vectors each
!               containing the corresponding n gridpoint values:
!
!               g(0),g(1), ... ,g(n-1)  (n complex values)
!
!               defined by:
!                 g(j) = sum(k=0,...,n-1)( g(k)*exp(+2*i*j*k*pi/n) )
!                 where i = sqrt(-1)
!
!
!               a call with isign=-1 followed by a call with isign=+1
!               (or vice versa) returns the original data, multiplied
!               by the factor n.
!
!
! example       given a 64 by 9 grid of complex values, stored in
!               a 66 by 9 complex array, a, compute the two dimensional
!               fourier transform of the grid.  from transform theory,
!               it is known that a two dimensional transform can be
!               obtained by first transforming the grid along one
!               direction, then transforming these results along the
!               orthogonal direction.
!
!               complex a(66,9), work(64,9)
!               real trigs1(128), trigs2(18)
!               integer ifax1(13), ifax2(13)
!
!               set up the ifax and trigs arrays for each direction:
!
!               call cftfax(64, ifax1, trigs1)
!               call cftfax( 9, ifax2, trigs2)
!
!               in this case, the complex values of the grid are
!               stored in memory as follows (using u and v to
!               denote the real and imaginary components, and
!               assuming conventional fortran storage):
!
!   u(1,1), v(1,1), u(2,1), v(2,1),  ...  u(64,1), v(64,1), 4 nulls,
!
!   u(1,2), v(1,2), u(2,2), v(2,2),  ...  u(64,2), v(64,2), 4 nulls,
!
!   .       .       .       .         .   .        .        .
!   .       .       .       .         .   .        .        .
!   .       .       .       .         .   .        .        .
!
!   u(1,9), v(1,9), u(2,9), v(2,9),  ...  u(64,9), v(64,9), 4 nulls.
!
!               we choose (arbitrarily) to transorm first along the
!               direction of the first subscript.  thus we define
!               the length of the transforms, n, to be 64, the
!               number of transforms, lot, to be 9, the increment
!               between elements of each transform, inc, to be 1,
!               and the increment between the starting points
!               for each transform, jump, to be 66 (the first
!               dimension of a).
!
!               call cfft99( a, work, trigs1, ifax1, 1, 66, 64, 9, -1)
!
!               to transform along the direction of the second subscript
!               the roles of the increments are reversed.  thus we defin
!               the length of the transforms, n, to be 9, the
!               number of transforms, lot, to be 64, the increment
!               between elements of each transform, inc, to be 66,
!               and the increment between the starting points
!               for each transform, jump, to be 1
!
!               call cfft99( a, work, trigs2, ifax2, 66, 1, 9, 64, -1)
!
!               these two sequential steps results in the two-dimensiona
!               fourier coefficient array overwriting the input
!               gridpoint array, a.  the same two steps applied again
!               with isign = +1 would result in the reconstruction of
!               the gridpoint array (multiplied by a factor of 64*9).
!
!
!-----------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      double precision a,work,trigs
      dimension a(*),work(*),trigs(*),ifax(*)
!
!     subroutine 'cfft99' - multiple fast complex fourier transform
!
!     a is the array containing input and output data
!     work is an area of size n*lot
!     trigs is a previously prepared list of trig function values
!     ifax is a previously prepared list of factors of n
!     inc is the increment within each data "vector"
!         (e.g. inc=1 for consecutively stored data)
!     jump is the increment between the start of each data vector
!     n is the length of the data vectors
!     lot is the number of data vectors
!     isign = +1 for transform from spectral to gridpoint
!           = -1 for transform from gridpoint to spectral
!
!
!     vectorization is achieved on cray by doing the transforms in
!     parallel.
!
!
! the following call is for monitoring library use at ncar
!     call q8qst4 ( 4hxlib, 6hcfft99, 6hcfft99, 10hversion 01)
!
      nn = n+n
      ink=inc+inc
      jum = jump+jump
      nfax=ifax(1)
      jnk = 2
      jst = 2
      if (isign.ge.0) go to 30
!
!     the innermost temperton routines have no facility for the
!     forward (isign = -1) transform.  therefore, the input must be
!     rearranged as follows:
!
!     the order of each input vector,
!
!     g(0), g(1), g(2), ... , g(n-2), g(n-1)
!
!     is reversed (excluding g(0)) to yield
!
!     g(0), g(n-1), g(n-2), ... , g(2), g(1).
!
!     within the transform, the corresponding exponential multiplier
!     is then precisely the conjugate of that for the normal
!     ordering.  thus the forward (isign = -1) transform is
!     accomplished
!
!     for nfax odd, the input must be transferred to the work array,
!     and the rearrangement can be done during the move.
!
      jnk = -2
      jst = nn-2
      if (mod(nfax,2).eq.1) goto 40
!
!     for nfax even, the rearrangement must be applied directly to
!     the input array.  this can be done by swapping elements.
!
      ibase = 1
      ilast = (n-1)*ink
      nh = n/2
      do 20 l=1,lot
      i1 = ibase+ink
      i2 = ibase+ilast
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 10 m=1,nh
!     swap real and imaginary portions
      hreal = a(i1)
      himag = a(i1+1)
      a(i1) = a(i2)
      a(i1+1) = a(i2+1)
      a(i2) = hreal
      a(i2+1) = himag
      i1 = i1+ink
      i2 = i2-ink
   10 continue
      ibase = ibase+jum
   20 continue
      goto 100
!
   30 continue
      if (mod(nfax,2).eq.0) goto 100
!
   40 continue
!
!     during the transform process, nfax steps are taken, and the
!     results are stored alternately in work and in a.  if nfax is
!     odd, the input data are first moved to work so that the final
!     result (after nfax steps) is stored in array a.
!
      ibase=1
      jbase=1
      do 60 l=1,lot
!     move real and imaginary portions of element zero
      work(jbase) = a(ibase)
      work(jbase+1) = a(ibase+1)
      i=ibase+ink
      j=jbase+jst
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 50 m=2,n
!     move real and imaginary portions of other elements (possibly in
!     reverse order, depending on jst and jnk)
      work(j) = a(i)
      work(j+1) = a(i+1)
      i=i+ink
      j=j+jnk
   50 continue
      ibase=ibase+jum
      jbase=jbase+nn
   60 continue
!
  100 continue
!
!     perform the transform passes, one pass for each factor.  during
!     each pass the data are moved from a to work or from work to a.
!
!     for nfax even, the first pass moves from a to work
      igo = 110
!     for nfax odd, the first pass moves from work to a
      if (mod(nfax,2).eq.1) igo = 120
      la=1
      do 140 k=1,nfax
      if (igo.eq.120) go to 120
  110 continue
      call vpassm(a(1),a(2),work(1),work(2),trigs,&
         ink,2,jum,nn,lot,n,ifax(k+1),la)
      igo=120
      go to 130
  120 continue
      call vpassm(work(1),work(2),a(1),a(2),trigs,&
          2,ink,nn,jum,lot,n,ifax(k+1),la)
      igo=110
  130 continue
      la=la*ifax(k+1)
  140 continue
!
!     at this point the final transform result is stored in a.
!
      return
      end

!VOCL TOTAL,VECTOR
      subroutine cftfax(n,ifax,trigs)
      implicit double precision (a-h,o-z)
      double precision trigs
      dimension ifax(13),trigs(1)
!
!     this routine was modified from temperton's original
!     by dave fulker.  it no longer produces factors in ascending
!     order, and there are none of the original "mode" options.
!
! on input     n
!               the length of each complex transform to be performed
!
!               n must be greater than 1 and contain no prime
!               factors greater than 5.
!
! on output    ifax
!               ifax(1)
!                 the number of factors chosen or -99 in case of error
!               ifax(2) thru ifax( ifax(1)+1 )
!                 the factors of n in the followin order:  appearing
!                 first are as many factors of 4 as can be obtained.
!                 subsequent factors are primes, and appear in
!                 ascending order, except for multiple factors.
!
!              trigs
!               2n sin and cos values for use by the transform routine
!
      call fact(n,ifax)
      k = ifax(1)
      if (k .lt. 1 .or. ifax(k+1) .gt. 5) ifax(1) = -99
      if (ifax(1) .le. 0 ) write (6,991) ifax(1)
      if (ifax(1) .le. 0 ) call clexit(nconso)
  991 format (' fftfax -- invalid n',i5)
      call cftrig (n, trigs)
      return
      end

!VOCL TOTAL,VECTOR
      subroutine fact(n,ifax)
!     factorization routine that first extracts all factors of 4
      implicit double precision (a-h,o-z)
      dimension ifax(13)
      if (n.gt.1) go to 10
      ifax(1) = 0
      if (n.lt.1) ifax(1) = -99
      return
   10 nn=n
      k=1
!     test for factors of 4
   20 if (mod(nn,4).ne.0) go to 30
      k=k+1
      ifax(k)=4
      nn=nn/4
      if (nn.eq.1) go to 80
      go to 20
!     test for extra factor of 2
   30 if (mod(nn,2).ne.0) go to 40
      k=k+1
      ifax(k)=2
      nn=nn/2
      if (nn.eq.1) go to 80
!     test for factors of 3
   40 if (mod(nn,3).ne.0) go to 50
      k=k+1
      ifax(k)=3
      nn=nn/3
      if (nn.eq.1) go to 80
      go to 40
!     now find remaining factors
   50 l=5
      max = sqrt(dble(nn))
      inc=2
!     inc alternately takes on values 2 and 4
   60 if (mod(nn,l).ne.0) go to 70
      k=k+1
      ifax(k)=l
      nn=nn/l
      if (nn.eq.1) go to 80
      go to 60
   70 if (l.gt.max) go to 75
      l=l+inc
      inc=6-inc
      go to 60
   75 k = k+1
      ifax(k) = nn
   80 ifax(1)=k-1
!     ifax(1) now contains number of factors
      return
      end

!VOCL TOTAL,VECTOR
      subroutine cftrig(n,trigs)
      implicit double precision (a-h,o-z)
      double precision trigs
      dimension trigs(1)
      pi=2.0d0*asin(1.0d0)
      del=(pi+pi)/dble(n)
      l=n+n
      do 10 i=1,l,2
      angle=0.5d0*dble(i-1)*del
      trigs(i)=cos(angle)
      trigs(i+1)=sin(angle)
   10 continue
      return
      end

!VOCL TOTAL,VECTOR
      subroutine vpassm(a,b,c,d,trigs,inc1,inc2,inc3,inc4,lot,n,ifac,la)
      implicit double precision (a-h,o-z)
      double precision a,b,c,d,trigs
      dimension a(n),b(n),c(n),d(n),trigs(n)
!
!     subroutine 'vpassm' - multiple version of 'vpassa'
!     performs one pass through data
!     as part of multiple complex (inverse) fft routine
!     a is first real input vector
!     b is first imaginary input vector
!     c is first real output vector
!     d is first imaginary output vector
!     trigs is precalculated table of sines & cosines
!     inc1 is addressing increment for a and b
!     inc2 is addressing increment for c and d
!     inc3 is addressing increment between a's & b's
!     inc4 is addressing increment between c's & d's
!     lot is the number of vectors
!     n is length of vectors
!     ifac is current factor of n
!     la is product of previous factors
!
      data sin36/0.587785252292473d0/,cos36/0.809016994374947d0/,&
           sin72/0.951056516295154d0/,cos72/0.309016994374947d0/,&
           sin60/0.866025403784437d0/
!
      m=n/ifac
      iink=m*inc1
      jink=la*inc2
      jump=(ifac-1)*jink
      ibase=0
      jbase=0
      igo=ifac-1
      if (igo.gt.4) return
      go to (10,50,90,130),igo
!
!     coding for factor 2
!
   10 ia=1
      ja=1
      ib=ia+iink
      jb=ja+jink
      do 20 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 15 ijk=1,lot
      c(ja+j)=a(ia+i)+a(ib+i)
      d(ja+j)=b(ia+i)+b(ib+i)
      c(jb+j)=a(ia+i)-a(ib+i)
      d(jb+j)=b(ia+i)-b(ib+i)
      i=i+inc3
      j=j+inc4
   15 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
   20 continue
      if (la.eq.m) return
      la1=la+1
      jbase=jbase+jump
      do 40 k=la1,m,la
      kb=k+k-2
      c1=trigs(kb+1)
      s1=trigs(kb+2)
      do 30 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 25 ijk=1,lot
      c(ja+j)=a(ia+i)+a(ib+i)
      d(ja+j)=b(ia+i)+b(ib+i)
      c(jb+j)=c1*(a(ia+i)-a(ib+i))-s1*(b(ia+i)-b(ib+i))
      d(jb+j)=s1*(a(ia+i)-a(ib+i))+c1*(b(ia+i)-b(ib+i))
      i=i+inc3
      j=j+inc4
   25 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
   30 continue
      jbase=jbase+jump
   40 continue
      return
!
!     coding for factor 3
!
   50 ia=1
      ja=1
      ib=ia+iink
      jb=ja+jink
      ic=ib+iink
      jc=jb+jink
      do 60 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 55 ijk=1,lot
      c(ja+j)=a(ia+i)+(a(ib+i)+a(ic+i))
      d(ja+j)=b(ia+i)+(b(ib+i)+b(ic+i))
      c(jb+j)=(a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     -(sin60*(b(ib+i)-b(ic+i)))
      c(jc+j)=(a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     +(sin60*(b(ib+i)-b(ic+i)))
      d(jb+j)=(b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     +(sin60*(a(ib+i)-a(ic+i)))
      d(jc+j)=(b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     -(sin60*(a(ib+i)-a(ic+i)))
      i=i+inc3
      j=j+inc4
   55 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
   60 continue
      if (la.eq.m) return
      la1=la+1
      jbase=jbase+jump
      do 80 k=la1,m,la
      kb=k+k-2
      kc=kb+kb
      c1=trigs(kb+1)
      s1=trigs(kb+2)
      c2=trigs(kc+1)
      s2=trigs(kc+2)
      do 70 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 65 ijk=1,lot
      c(ja+j)=a(ia+i)+(a(ib+i)+a(ic+i))
      d(ja+j)=b(ia+i)+(b(ib+i)+b(ic+i))
      c(jb+j)=&
          c1*((a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     -(sin60*(b(ib+i)-b(ic+i))))&
         -s1*((b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     +(sin60*(a(ib+i)-a(ic+i))))
      d(jb+j)=&
          s1*((a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     -(sin60*(b(ib+i)-b(ic+i))))&
         +c1*((b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     +(sin60*(a(ib+i)-a(ic+i))))
      c(jc+j)=&
          c2*((a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     +(sin60*(b(ib+i)-b(ic+i))))&
         -s2*((b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     -(sin60*(a(ib+i)-a(ic+i))))
      d(jc+j)=&
          s2*((a(ia+i)-0.5d0*(a(ib+i)+a(ic+i)))&
                     +(sin60*(b(ib+i)-b(ic+i))))&
         +c2*((b(ia+i)-0.5d0*(b(ib+i)+b(ic+i)))&
                     -(sin60*(a(ib+i)-a(ic+i))))
      i=i+inc3
      j=j+inc4
   65 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
   70 continue
      jbase=jbase+jump
   80 continue
      return
!
!     coding for factor 4
!
   90 ia=1
      ja=1
      ib=ia+iink
      jb=ja+jink
      ic=ib+iink
      jc=jb+jink
      id=ic+iink
      jd=jc+jink
      do 100 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 95 ijk=1,lot
      c(ja+j)=(a(ia+i)+a(ic+i))+(a(ib+i)+a(id+i))
      c(jc+j)=(a(ia+i)+a(ic+i))-(a(ib+i)+a(id+i))
      d(ja+j)=(b(ia+i)+b(ic+i))+(b(ib+i)+b(id+i))
      d(jc+j)=(b(ia+i)+b(ic+i))-(b(ib+i)+b(id+i))
      c(jb+j)=(a(ia+i)-a(ic+i))-(b(ib+i)-b(id+i))
      c(jd+j)=(a(ia+i)-a(ic+i))+(b(ib+i)-b(id+i))
      d(jb+j)=(b(ia+i)-b(ic+i))+(a(ib+i)-a(id+i))
      d(jd+j)=(b(ia+i)-b(ic+i))-(a(ib+i)-a(id+i))
      i=i+inc3
      j=j+inc4
   95 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
  100 continue
      if (la.eq.m) return
      la1=la+1
      jbase=jbase+jump
      do 120 k=la1,m,la
      kb=k+k-2
      kc=kb+kb
      kd=kc+kb
      c1=trigs(kb+1)
      s1=trigs(kb+2)
      c2=trigs(kc+1)
      s2=trigs(kc+2)
      c3=trigs(kd+1)
      s3=trigs(kd+2)
      do 110 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 105 ijk=1,lot
      c(ja+j)=(a(ia+i)+a(ic+i))+(a(ib+i)+a(id+i))
      d(ja+j)=(b(ia+i)+b(ic+i))+(b(ib+i)+b(id+i))
      c(jc+j)=&
          c2*((a(ia+i)+a(ic+i))-(a(ib+i)+a(id+i)))&
         -s2*((b(ia+i)+b(ic+i))-(b(ib+i)+b(id+i)))
      d(jc+j)=&
          s2*((a(ia+i)+a(ic+i))-(a(ib+i)+a(id+i)))&
         +c2*((b(ia+i)+b(ic+i))-(b(ib+i)+b(id+i)))
      c(jb+j)=&
          c1*((a(ia+i)-a(ic+i))-(b(ib+i)-b(id+i)))&
         -s1*((b(ia+i)-b(ic+i))+(a(ib+i)-a(id+i)))
      d(jb+j)=&
          s1*((a(ia+i)-a(ic+i))-(b(ib+i)-b(id+i)))&
         +c1*((b(ia+i)-b(ic+i))+(a(ib+i)-a(id+i)))
      c(jd+j)=&
          c3*((a(ia+i)-a(ic+i))+(b(ib+i)-b(id+i)))&
         -s3*((b(ia+i)-b(ic+i))-(a(ib+i)-a(id+i)))
      d(jd+j)=&
          s3*((a(ia+i)-a(ic+i))+(b(ib+i)-b(id+i)))&
         +c3*((b(ia+i)-b(ic+i))-(a(ib+i)-a(id+i)))
      i=i+inc3
      j=j+inc4
  105 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
  110 continue
      jbase=jbase+jump
  120 continue
      return
!
!     coding for factor 5
!
  130 ia=1
      ja=1
      ib=ia+iink
      jb=ja+jink
      ic=ib+iink
      jc=jb+jink
      id=ic+iink
      jd=jc+jink
      ie=id+iink
      je=jd+jink
      do 140 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 135 ijk=1,lot
      c(ja+j)=a(ia+i)+(a(ib+i)+a(ie+i))+(a(ic+i)+a(id+i))
      d(ja+j)=b(ia+i)+(b(ib+i)+b(ie+i))+(b(ic+i)+b(id+i))
      c(jb+j)=(a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
        -(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i)))
      c(je+j)=(a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
        +(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i)))
      d(jb+j)=(b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
        +(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i)))
      d(je+j)=(b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
        -(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i)))
      c(jc+j)=(a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
        -(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i)))
      c(jd+j)=(a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
        +(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i)))
      d(jc+j)=(b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
        +(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i)))
      d(jd+j)=(b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
        -(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i)))
      i=i+inc3
      j=j+inc4
  135 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
  140 continue
      if (la.eq.m) return
      la1=la+1
      jbase=jbase+jump
      do 160 k=la1,m,la
      kb=k+k-2
      kc=kb+kb
      kd=kc+kb
      ke=kd+kb
      c1=trigs(kb+1)
      s1=trigs(kb+2)
      c2=trigs(kc+1)
      s2=trigs(kc+2)
      c3=trigs(kd+1)
      s3=trigs(kd+2)
      c4=trigs(ke+1)
      s4=trigs(ke+2)
      do 150 l=1,la
      i=ibase
      j=jbase
!VOCL LOOP,NOVREC
!dir$ ivdep
      do 145 ijk=1,lot
      c(ja+j)=a(ia+i)+(a(ib+i)+a(ie+i))+(a(ic+i)+a(id+i))
      d(ja+j)=b(ia+i)+(b(ib+i)+b(ie+i))+(b(ic+i)+b(id+i))
      c(jb+j)=&
          c1*((a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
            -(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i))))&
         -s1*((b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
            +(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i))))
      d(jb+j)=&
          s1*((a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
            -(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i))))&
         +c1*((b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
            +(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i))))
      c(je+j)=&
          c4*((a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
            +(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i))))&
         -s4*((b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
            -(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i))))
      d(je+j)=&
          s4*((a(ia+i)+cos72*(a(ib+i)+a(ie+i))-cos36*(a(ic+i)+a(id+i)))&
            +(sin72*(b(ib+i)-b(ie+i))+sin36*(b(ic+i)-b(id+i))))&
         +c4*((b(ia+i)+cos72*(b(ib+i)+b(ie+i))-cos36*(b(ic+i)+b(id+i)))&
            -(sin72*(a(ib+i)-a(ie+i))+sin36*(a(ic+i)-a(id+i))))
      c(jc+j)=&
          c2*((a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
            -(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i))))&
         -s2*((b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
            +(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i))))
      d(jc+j)=&
          s2*((a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
            -(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i))))&
         +c2*((b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
            +(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i))))
      c(jd+j)=&
          c3*((a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
            +(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i))))&
         -s3*((b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
            -(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i))))
      d(jd+j)=&
          s3*((a(ia+i)-cos36*(a(ib+i)+a(ie+i))+cos72*(a(ic+i)+a(id+i)))&
            +(sin36*(b(ib+i)-b(ie+i))-sin72*(b(ic+i)-b(id+i))))&
         +c3*((b(ia+i)-cos36*(b(ib+i)+b(ie+i))+cos72*(b(ic+i)+b(id+i)))&
            -(sin36*(a(ib+i)-a(ie+i))-sin72*(a(ic+i)-a(id+i))))
      i=i+inc3
      j=j+inc4
  145 continue
      ibase=ibase+inc1
      jbase=jbase+inc2
  150 continue
      jbase=jbase+jump
  160 continue
      return
      end
#endif
