!=======================================================================
      subroutine fexcid(nconso)
      write(nconso,*) '@(#)fexcop.F	1.4 10/24/96'
      return
      end
!=======================================================================
      subroutine fexcop(nplwv,cwork1,volc,enxcc,enxc,&
                        excdat,xcfdat,xcpdat,nxc,nconso)
!=======================================================================
!
!
! this subroutine calculates the exchange correlation potential from the
! charge density.  the correction to the
! total energy due to overcounting the exchange correlation energy on
! summing the electronic eigenvalues and the forces on the unit cell
! due to the exchange correlation energy are also calculated.
! the exchange correlation energy is taken from perdew and zunger's
! parameterization of ceperley and alder's values for the correlation
! energy of an electron gas at low density and the gell-mann brueckner
! expression for the correlation energy of a high density electron gas
!
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension cwork1(nplwv)
      dimension excdat(nxc),xcfdat(nxc),xcpdat(nxc)
      data pi,third /3.14159265d0,-0.33333333d0/
      data half,sixth /0.5d0,0.166666666666667d0/
      c0=(0.0d0,0.0d0)
!=======================================================================
! rscale is a scaling factor used when obtaining the wigner-seitz radius
! from the electronic charge density
!=======================================================================
      rscale=(4.0d0*pi)/(3.0d0*volc)
!=======================================================================
! initialise the correction to the exchange correlation energy to zero
!=======================================================================
      rwsmin = 1.0d20
      xcf=0.0d0
      exc=0.0d0
      do 8100 n=1,nplwv
!=======================================================================
! calculate the wigner-seitz radius for the point on the real space grid
!=======================================================================
! The use of cbrt works on the cray, but is incredible slow!
!      rwsrad=cbrt(rscale*dble(cwork1(n)))
!=======================================================================
      rwsrad = rscale * dble(cwork1(n))
!     Note the minimum value
      rwsmin = min (rwsmin, rwsrad)
!     Make sure that we never use a negative value
      rwsrad = max (1.0d-10, rwsrad)
      rwsrad = exp (third * log (rwsrad))
      arg = 100.0d0*rwsrad
!     if (arg .gt. nxc-3) arg=nxc-3
!     if (arg .lt. 1.0d0) arg=1.0d0
      arg = min (arg, dble (nxc-3))
      arg = max (arg, 1.0d0)
      narg=int(arg)
      rem=arg-narg
!=======================================================================
! calc the exchange correlation energy
!=======================================================================
!       v1=excdat(narg-1)
!       v2=excdat(narg)
!       v3=excdat(narg+1)
!       v4=excdat(narg+2)
!       t0=v2
!       t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
!       t2=(v1+v3-(2*v2))*half
!       t3=(v4-v1+(3*(v2-v3)))*sixth
!       exc=exc+((t0+rem*(t1+rem*(t2+rem*t3)))
!    &       *dble(cwork1(n)))
!=======================================================================
! calc the exchange correlation energy correction
!=======================================================================
        v1=xcfdat(narg-1)
        v2=xcfdat(narg)
        v3=xcfdat(narg+1)
        v4=xcfdat(narg+2)
        t0=v2
        t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
        t2=(v1+v3-(2*v2))*half
        t3=(v4-v1+(3*(v2-v3)))*sixth
        xcf=xcf+((t0+rem*(t1+rem*(t2+rem*t3)))&
            *dble(cwork1(n)))
!=======================================================================
! calc the exchange correlation potential
!=======================================================================
        v1=xcpdat(narg-1)
        v2=xcpdat(narg)
        v3=xcpdat(narg+1)
        v4=xcpdat(narg+2)
        t0=v2
        t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
        t2=(v1+v3-(2*v2))*half
        t3=(v4-v1+(3*(v2-v3)))*sixth
!= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
        cwork1(n)=dcmplx((t0+rem*(t1+rem*(t2+rem*t3))),0.0d0)
!= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
! Alternative: Call the Xerox code
!= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
!       rho=dble(cwork1(n))
!       call excorr(rho,3,1,volc,1.0d0,exfact,xce,xcmu,18)
!       cwork1(n)=(1.0d0,0.0d0)*xcmu*13.6058d0
!       exc=exc+xce*13.6058d0*rho
!       xcf=xcf-3.0d0*(xce-xcmu)*13.6058d0*rho
!= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 8100 continue
      if (rwsmin .lt. 0.0d0) then
        write (nconso,100) rwsmin
100     format (' fexcop: WARNING: non-positive density,',&
             ' minimum value=',&
          g15.6)
        if (rwsmin .le. -1.d0) then
!           call clexit (nconso)
        endif
      endif
!=======================================================================
! scale the correction to the total energy
!=======================================================================
      enxcc=-xcf/(3.0d0*nplwv)
      enxc=exc/nplwv
      return
      end

      subroutine excold(nplwv,rdensr,volc,enxclo,excdat,nxc)
!=======================================================================
! this subroutine calculates the exchange correlation energy from the
! charge density. It is used to subtract from the total energy so that
! the gradient corrected exchange correlation energy can be added.
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension rdensr(nplwv)
      dimension excdat(nxc)
      data pi,third /3.14159265d0,0.33333333d0/
      data half,sixth /0.5d0,0.166666666666667d0/
!=======================================================================
! rscale is a scaling factor used when obtaining the wigner-seitz radius
! from the electronic charge density
!=======================================================================
      rscale=3.0d0*volc/(4.0d0*pi)
!=======================================================================
! initialise the exchange correlation energy to zero
!=======================================================================
      exc=0.0d0
      do 8100 n=1,nplwv
!=======================================================================
! calculate the wigner-seitz radius for the point on the real space grid
!=======================================================================
      rwsrad=exp(third*log(rscale/max(1.0d-10,rdensr(n))))
      arg=100*rwsrad
      if(arg.gt.nxc-3) arg=nxc-3
      narg=int(arg)
      rem=arg-narg
!=======================================================================
! calc the exchange correlation energy
!=======================================================================
        v1=excdat(narg-1)
        v2=excdat(narg)
        v3=excdat(narg+1)
        v4=excdat(narg+2)
        t0=v2
        t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
        t2=(v1+v3-(2*v2))*half
        t3=(v4-v1+(3*(v2-v3)))*sixth
        exc=exc+((t0+rem*(t1+rem*(t2+rem*t3)))&
             *rdensr(n))
 8100 continue
!=======================================================================
! scale the exchange correlation energy
!=======================================================================
      enxclo=exc/dble(nplwv)
      return
      end


!=======================================================================
! history: 18/5/90 taken from file xcdat.for
!                  expressions for xc-energy when summing kinetic
!                    energies now in excdat()
!          22/8/90 formula corrected according mcp by weng
!=======================================================================
      subroutine xcdat(excdat,xcfdat,xcpdat, nxc)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension excdat(nxc)
      dimension xcfdat(nxc)
      dimension xcpdat(nxc)
!=======================================================================
! rscfxv is a parameter from the perdew zunger expression for the
! correlation energy
!=======================================================================
      data rscfxv /6.59747d0/
!=======================================================================
! rscale is a scaling factor used when obtaining the wigner-seitz radius
! from the electronic charge density
!=======================================================================
! initialise the correction to the exchange correlation energy to zero
!=======================================================================
      do 8200 n=1,nxc
!=======================================================================
! calculate the wigner-seitz radius for the point on the real space grid
!=======================================================================
        rwsrad=0.01d0*n
!=======================================================================
! the formula for the exchange correlation energy is different for the
! wigner-seitz radius greater or less than the bohr radius the following
! if statement selects the correct formulae for the exchange correlation
! potential and the correction to the total energy
!=======================================================================
        if(rwsrad.gt.0.529177d0) then
          f1wsr=1.0d0+(1.447394d0*sqrt(rwsrad))+(0.630035d0*rwsrad)
          f2wsr=(0.723697d0*sqrt(rwsrad))+(0.630035d0*rwsrad)
          excdat(n)=-3.872211d0/f1wsr - rscfxv/rwsrad
          xcfdat(n)=-(rscfxv/rwsrad+(3.872211d0*f2wsr/(f1wsr**2)))
          xcpdat(n)=-(4d0*rscfxv/(3d0*rwsrad)+(3.872211d0/f1wsr)+&
             (3.872211d0*f2wsr)/(3d0*(f1wsr**2)))
        else
          wsrlog=log(rwsrad/0.529177d0)
          excdat(n)=-1.306157d0+0.84628d0*wsrlog-0.5965d0*rwsrad+&
                    0.10284d0*rwsrad*wsrlog - rscfxv/rwsrad
          xcfdat(n)=-(rscfxv/rwsrad+0.84628+(-0.493653*rwsrad)+&
            (0.102819d0*rwsrad*wsrlog))
          xcpdat(n)=-(4d0*rscfxv/(3d0*rwsrad)-(0.84628d0*wsrlog)+&
            1.58825d0-(0.068567d0*rwsrad*wsrlog)+(0.431949d0*rwsrad))
        endif
 8200 continue
      return
      end
!=======================================================================
      subroutine excorr (rho,iexcor,nspin,volum,ula,exfact,xce,xcmu,&
                         nconso)
!=======================================================================
!
!     exchange-correlation functional used in routine "exch4"
!
!     input:
!     rho ...... charge density
!     iexcor is passed from k207:
!     0 means no xc at all
!     1 means slater x-alpha
!     2 means wigner interpolation
!     3 means ceperley-alder
!     nspin .... 1 for non-polarized, 2 for spin-polarized
!                (1=spin-up, 2=spin-down)
!     exfact ... the alpha-factor in slater x-alpha (1 for wigner etc.)
!
      double precision rho(nspin), xce(nspin), xcmu(nspin)
      double precision volum,ula,exfact
!
      double precision beta,eta,xil,pi43,atrd,ftrd,tftm
      logical*4 initlz, spnpol
      real ex, mux, ec, muc, exp, muxp, ecp, mucp
!
!.....physical and mathematical constants
      double precision abohr,pi
!
      save volau,atrd,ftrd,pi43,tftm,ttrd,xfac,spnpol,initlz
      save a,b,c,d,g,b1,b2
      save ap,bp,cp,dp,gp,b1p,b2p
      data initlz /.false./
      data pi,abohr/3.14159265d0,0.529177d0/
!
!-----------------------------------------------------------------------
!
      if (.not. initlz) then
!
!       first time around - tell which functional
!
        volau = volum * ( ula / abohr )**3
        atrd  = 1.0d0 / 3.0d0
        ftrd  = 4.0d0 / 3.0d0
        pi43  = pi * ftrd
        tftm  = 2.0d0 ** ftrd - 2.0d0
        ttrd  = 2.0d0 ** atrd
        xfac  = (2.0d0/pi) * ( 9.0d0*pi/4.0d0 )**atrd
!
        if (iexcor .eq. 0) then
!         no xc
!
        else if (iexcor .eq. 1) then
!         x-alpha
!         scale the exchange term by alpha and 3/2:
          xfac = exfact * xfac * 3.0d0 / 2.0d0
!
        else if (iexcor .eq. 2) then
!         wigner correlation
          if (nspin .ne. 1) then
            write (nconso,105)
105         format ('0excorr *** warning ***'/&
              ' wigner correlation is nonpolarized')
            goto 400
            endif
!
        else if (iexcor .eq. 3) then
!         parameters for unpolarized gas
          a =  0.0311
          b = -0.0480
          c =  0.0020
          d = -0.0116
          g = -0.1423
          b1 = 1.0529
          b2 = 0.3334
!         parameters for fully polarized gas
          ap =  0.01555
          bp = -0.0269
          cp =  0.0007
          dp = -0.0048
          gp = -0.0843
          b1p = 1.3981
          b2p = 0.2611
!
        else
          write (nconso,*) 'excorr: illegal iexcor=',iexcor
          call clexit(nconso)
          endif
!
        if (nspin .eq. 1) then
          spnpol = .false.
        else
          spnpol = .true.
          endif
        initlz = .true.
!
        endif
!
!-----------------------------------------------------------------------
!
      if (iexcor .le. 0) then
        do 170 ispin = 1, nspin
          xce (ispin) = 0.0
          xcmu(ispin) = 0.0
170       continue
        return
        endif
!
      if (spnpol) then
        rhoav = rho(1) + rho(2)
      else
        rhoav = rho(1)
        endif
!
!     guard against slightly negative densities
      if (rhoav .lt. -0.01) then
        write (nconso,*) 'excorr *** error *** rhoav =',rhoav
        call clexit(nconso)
      else if (rhoav .le. 1.0e-9) then
        rhoav = 1.0e-9
        endif
!
      if (spnpol) then
        z     = (rho(1) - rho(2)) / rhoav
        fz    = ( (1.0+z)**ftrd + (1.0-z)**ftrd - 2.0 ) / tftm
        fzp   = ( (1.0+z)**atrd - (1.0-z)**atrd ) / tftm * ftrd
        endif
!
!-----------------------------------------------------------------------
!
!     the exchange potential
!
      rs   = ( volau / (rhoav * pi43) )**atrd
!     exchange-correlation potential:
      mux  = - xfac / rs
!     exchange-correlation energy:
      ex   = 0.75 * mux
!     relativistic correction factor (macdonald and vosko)
      beta = 0.0140 / rs
      eta  = dsqrt( 1.0d0 + beta*beta )
      xil  = dlog( beta + eta )
      mux  = mux * ( - 0.5d0 + 1.5d0 * xil / (beta*eta) )
      ex   = ex  * (   1.0d0 - 1.5d0 * ( eta/beta - xil/beta**2 )**2 )
      if (spnpol) then
        exp  = ttrd * ex
        muxp = ttrd * mux
        endif
!
!-----------------------------------------------------------------------
!
!     slater x-alpha density functional
!
      if (iexcor .eq. 1) then
!
      ec  = 0.0
      muc = 0.0
!
!-----------------------------------------------------------------------
!
!     wigner interpolation formula
!
      else if (iexcor .eq. 2) then
!
        ec  = - 0.88 / (rs + 7.8 )
        muc = ec * (1.0 + rs/3.0/(rs + 7.8) )
!
!-----------------------------------------------------------------------
!
!     ceperley-alder (see bachelet et al., phys. rev. b 26, 4199 (1982).
!
      else if (iexcor .eq. 3) then
!
      if (rs .ge. 1.0) then
        sqrtrs = sqrt(rs)
        denom = 1.0 + b1*sqrtrs + b2*rs
        ec  = g / denom
        muc = ec * (1.0 + 7.0/6.0*b1*sqrtrs + 4.0/3.0*b2*rs) / denom
      else
        rslog = alog(rs)
        ec  = b + a*rslog + d*rs + c*rs*rslog
        muc = (b - a/3.0) + a*rslog + (d+d-c)/3.0*rs +&
              2.0/3.0*c*rs*rslog
        endif
!     conversion to rydbergs:
      ec  = 2.0 * ec
      muc = 2.0 * muc
!
      if (spnpol) then
!       the fully polarized data
        if (rs .ge. 1.0) then
          denom = 1.0 + b1p*sqrtrs + b2p*rs
          ecp  = gp / denom
          mucp = ecp * (1.0 + 7.0/6.0*b1p*sqrtrs + 4.0/3.0*b2p*rs) /&
                 denom
        else
          ecp  = bp + ap*rslog + dp*rs + cp*rs*rslog
          mucp = (bp - ap/3.0) + ap*rslog + (dp+dp-cp)/3.0*rs +&
                2.0/3.0*cp*rs*rslog
          endif
!       conversion to rydbergs:
        ecp  = 2.0 * ecp
        mucp = 2.0 * mucp
        endif
!
!-----------------------------------------------------------------------
!
      else
!
        write (nconso,140) iexcor
140     format('0subroutine excorr *** fatal error ***'/&
          ' iexcor = ',i4,' is illegal')
        call clexit(nconso)
        endif
!
      if (spnpol) then
        dxc = fz * (exp - ex) + fz * (ecp - ec)
        ex  = ex  + fz * (exp - ex)
        ec  = ec  + fz * (ecp - ec)
        mux = mux + fz * (muxp - mux)
        muc = muc + fz * (mucp - muc)
        do 200 ispin = 1, nspin
!         ispin=1 is up, ispin=2 is down
          sign = float(3 - 2*ispin)
          xce(ispin)  = ex  + ec
          xcmu(ispin) = mux + muc + dxc * fzp * (sign - z)
200       continue
      else
!       non-polarized
        xce(1)  = ex  + ec
        xcmu(1) = mux + muc
        endif
!
      return
!
!-----------------------------------------------------------------------
!
!     error messages
!
400   write (nconso,410)
410   format ('0excorr *** fatal error ***')
      write (nconso,420) nspin,iexcor
420   format ('0spin-polarized (nspin=',i2,') not allowed for iexcor =',&
        i3)
      call clexit(nconso)
      return
      end
