!     @(#)erfc.F	1.3 4/29/97 

      double precision function erfc(xx)
      implicit double precision (a-h,o-z)
!
!     complementary error function
!     from the sandia mathematical program library

!     xmax is the value beyond which erfc(x) = 0 .
!     it is computed as sqrt(log(rmin)), where rmin is the
!     smallest real number representable on the machine.
!     ibm value: (the intrinsic erfc could also be used)
      parameter ( xmax = 13.4 )
!     vax value:
!     parameter ( xmax = 9.3 )

      dimension p1(4),q1(4),p2(6),q2(6),p3(4),q3(4)
!
      data p1 /242.6679552305318d0 , 21.97926161829415d0 , 6.996383488619136d0 , -3.560984370181539d-2/ 
      data q1 /215.0588758698612d0 , 91.16490540451490d0, 15.08279763040779d0 , 1.0d0/
      data p2 /22.898992851659d0,26.094746956075d0,14.571898596926d0,4.2677201070898d0,0.56437160686381d0,-6.0858151959688d-6/
      data q2 /22.898985749891d0 , 51.933570687552d0 ,50.273202863803d0 , 26.288795758761d0 ,7.5688482293618d0 , 1.0d0/ 
      data p3 /-1.21308276389978d-2 , -0.1199039552681460d0 ,-0.243911029488626d0 , -3.24319519277746d-2/
      data q3 /4.30026643452770d-2 , 0.489552441961437d0 ,1.43771227937118d0 , 1.0d0/ 
!     1/sqrt(pi)
      data sqpi /0.564189583547756d0/
!----------------------------------------------------------------------
      if (xx .gt.  xmax)    goto 330
      if (xx .lt. -xmax)    goto 320
      x = abs(xx)
      x2 = x*x
      if (x .gt. 4.0d0)     goto 300
      if (x .gt. 0.46875d0) goto 200
!
!     -46875 < x < 0.46875
      erfc = x*(p1(1) + x2*(p1(2) + x2*(p1(3) + x2*p1(4))))
      erfc = erfc/(q1(1) + x2*(q1(2) + x2*(q1(3) + x2*q1(4))))
      if (xx .lt. 0.0d0) erfc = - erfc
      erfc = 1.0d0 - erfc
      return
!
200   erfc = exp( -x2)*(p2(1) + x*(p2(2) + x*(p2(3) + x*(p2(4) +&
       x*(p2(5) + x*p2(6))))))
      erfc = erfc/(q2(1) + x*(q2(2) + x*(q2(3) + x*(q2(4) + x*(q2(5) +&
       x*q2(6))))))
      if (xx .le. 0.0d0) erfc = 2.0d0 - erfc
      return
!
300   xi2 = 1.0d0/x2
      erfc = xi2*(p3(1) + xi2*(p3(2) + xi2*(p3(3) + xi2*p3(4))))/&
       (q3(1) + xi2*(q3(2) + xi2*(q3(3) + xi2*q3(4))))
      erfc = exp( -x2)*(sqpi + erfc)/x
      if (xx .lt. 0.0d0) erfc = 2.0d0 - erfc
      return
!
320   erfc = 2.0d0
      return
330   erfc = 0.0d0
      return
      end
