#include "definitions.h"

!=======================================================================
      subroutine eferod(nconso)
      write(nconso,*) '@(#)eferop.F	1.12 6/15/99'
      return
      end
!=======================================================================
      subroutine eferop(nbands,nkprun,occ,wtkpt,eigen,efermi,&
           width,occmix,enfrec,entrpy,smethod,nconso,        &
           nelect,ocvar,nspin)
!-----------------------------------------------------------------------
!     Update occupation numbers and find the Fermi energy
!     ----------------------
!     occ    -  occupation numbers to be updated              [in/out]
!     occmix -  acceptance factor for new occupation numbers  [in]
!               occmix = 0.0 results in no change in occ
!     ocvar  -  virtual RMS change in occ, as if full         [out]
!               acceptance (corresponding occmix = 1.0)
!     efermi -  found fermi energy; input value used as       [in/out]
!               initial guess
!     enfrec -  Total energy correction from entropy < 0      [out]
!     entrpy -  = -TS < 0, S=Electronic entropy, T= width     [out]
!     width  -  Electronic temperature in broardening         [in] 
!     smethod-  method used for Fermi surface broardening     [in]
!               -1: Fermi-Dirac statistics
!                n: Methfessel-Paxton step function, order 0<=n<=??
!                   currently, only 1 is accepted
!                   see PRB 40 (1989), 3616. for details
!     nelect -  Number of electrons
!     nbands -  Number of bands 
!     nkprun -  Number of kpoints (spin index merged
!               with kpoint index)
!     wtkpt  -  weigth
!     eigen  -  eigen spectruum
!     nspin  -  spins present
!     nconso -  I/O unit for error reporting
!---------------------------------------------------------------------
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
!=======================================================================
      real*8    nelect
      dimension occ(nbands,nkprun)
      dimension wtkpt(nkprun)
      dimension eigen(nbands,nkprun)
      integer nspin,smethod
!=======================================================================
      parameter(epsn=1d-9)
      external fsum
!     locals 
      dimension work1(nbands,nkprun), work2(nbands,nkprun) 

! --- make sure smethod choice is valid (-1 or 1)

      if ((smethod.ne.-1).and.(smethod.ne.1)) then
         write(nconso,*) 'eferop.f: illegal smethod = ', smethod
         call clexit(nconso)
      endif

!=======================================================================
! find higher and lower limit for fermi energy
! for bisection
!=======================================================================
      efmax= efermi + 0.2d0
      do 705 ii=1,10000
        if (fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efmax,width,&
                 nspin,1,1,smethod) .lt.nelect) then
          efmax = efermi + 2.0d0 * (efmax - efermi)
        else
          goto 1001
        endif
 705  continue
      write(nconso,*) 'eferop.f: efmax not found',efermi
      call clexit(nconso)
 1001 continue
      efmin= efermi - 0.2d0
      do 715 ii=1,10000
        if (fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efmin,width,&
                 nspin,1,1,smethod).gt.nelect) then
          efmin = efermi + 2.0d0 * (efmin - efermi)
        else
          goto 1002
        endif
 715  continue
      write(nconso,*) 'eferop.f: efmin not found',efermi
      call clexit(nconso)
 1002 continue
!=======================================================================
! iterate until fermi energy found
!=======================================================================
      ic=0
      icmax=100
 1000 continue
      del=fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efermi,width,&
               nspin,1,1,smethod)-nelect
!=======================================================================
! test if fermi-energy already converged
! else make another bisection step
!=======================================================================
      if (abs(del).ge.epsn) then
        ic=ic+1
        if (ic.gt.icmax) then
          write(nconso,*) 'Fermi energy not found. Max. number of iterations:',icmax 
          write(nconso,'(''efermi, efmin, efmax'', 3f12.5)') &
            efermi,efmin,efmax
          write(nconso,20) ic,efermi,del
 20       format('fermi failed'/' ic =',i4,' efermi =',e15.6,' del =',e15.6/)
          call clexit(nconso)
        else
          if (del.gt.0.0d0) then
            efmax=efermi
          else 
            efmin=efermi
          endif
          efermi=(efmax+efmin)/2.0d0
          goto 1000
        endif
      endif

! Now calculate the various entropy terms of the electronic system
! and update occupation numbers
! update_occ_nembers_MP* should be collected into a single function with
! argument smethod, once a hermite function library is established
      select case (smethod)
      case (-1)
         call update_occ_numbers_FD(nbands, nkprun, nspin,         &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1)
      case ( 1)
         call update_occ_numbers_MP1(nbands, nkprun, nspin,        &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1, work2) 
      end select

      return
      end

! ============================================================================0
      subroutine efcmom(nbands,nkprun,occ,wtkpt,eigen,efermi,&
           width,occmix,rmagmo,enfrec,entrpy,smethod,nconso,nelect,ocvar,nspin)
!
! efcmom() calculates the occupation numbers under the constraint that
! the magnetic moment has a certain value (rmagmo)
!
      implicit none
!
      integer nbands
      integer nkprun
      real*8 occ(nbands,nkprun)
      real*8 wtkpt(nkprun)
      real*8 eigen(nbands,nkprun)
      real*8 efermi
      real*8 width,occmix
      real*8 enfrec, entrpy
      integer nconso
      real*8  nelect
      integer smethod
      real*8 ocvar
      integer nspin
      real*8 rmagmo
!
      integer ispin
      real*8 efmin,efmax
      integer ii
      integer ic,icmax
      parameter(icmax=100)
      real*8 del
      real*8 eps,epsn
      real*8 work1(nbands,nkprun), work2(nbands,nkprun) 
      parameter(eps=1.e-10, epsn=1e-9)
      integer nkp,nb
      real*8 ef1
      real*8 pp,q
      real*8 statpe
!
      real*8 fsum
      external fsum
!
! return if there are no empty states.
!
      if (nbands*2<=nelect) return
      if (nspin.ne.2) then
         write(nconso,*) 'efcmom() in eferop.F: No sense in calling',&
              ' this routine with nspin=',nspin
         call clexit(nconso)
      endif
!
! lower rmagmo if not enough empty states
!
      if (int(nelect+rmagmo).gt.nbands*2) then
         write(nconso,*) 'MOM: the desired magnetic moment cannot',&
              ' be accomodated with nbands=',nbands
         rmagmo=dble(2*nbands-nelect)
         write(nconso,*) 'MOM: rmagmo will be reduced to ',rmagmo
      endif

! --- make sure smethod choice is valid (-1 or 1)

      if ((smethod.ne.-1).and.(smethod.ne.1)) then
         write(nconso,*) 'eferop.f: illegal smethod = ', smethod
         call clexit(nconso)
      endif

!
! loop over the two spins
!
      do ispin=1,nspin
!
! find higher and lower limit for fermi energy
!
         efmax= efermi + 0.2d0
         do ii=1,10000
            if (fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efmax,&
                 width,nspin,ispin,nspin,smethod)&
                 .lt.(nelect+dble(3-2*ispin)*rmagmo)/2.0d0) then
               efmax = efermi + 2.0d0 * (efmax - efermi)
            else
               goto 1001
            endif
         enddo
         write(nconso,*) 'efcmom: ERROR, an upper limit for E_fermi',&
              ' could not be found.',efermi
         call clexit(nconso)
 1001    continue
         efmin= efermi - 0.2d0
         do ii=1,10000
            if (fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efmin,&
                 width,nspin,ispin,nspin,smethod)&
                 .gt.(nelect+dble(3-2*ispin)*rmagmo)/2.0d0) then
               efmin = efermi + 2.0d0 * (efmin - efermi)
            else
               goto 1002
            endif
         enddo
         write(nconso,*) 'efcmom: ERROR, a lower limit for E_fermi',&
              ' could not be found.',efermi
         call clexit(nconso)
 1002    continue
!
! iterate until fermi energy found
!
         ic=0
 1000    continue

         del=fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efermi,&
              width,nspin,ispin,nspin,smethod)&
              -(nelect+dble(3-2*ispin)*rmagmo)/2.0d0
!
! test if fermi-energy already converged
!
         if (abs(del).ge.epsn) then
            ic=ic+1
            if (ic.gt.icmax) then
               write(nconso,*) 'Fermi energy not found. Max. number of iterations:',icmax
               write(nconso,'(''efermi, efmin, efmax'', 3f12.5)') &
                    efermi,efmin, efmax
               write(nconso,20) ic,efermi,del,rmagmo
 20            format('fermi failed'/' ic =',i4,' efermi =',e15.6,' del =',e15.6,' rmagmo =',f12.5/)
               call clexit(nconso)
            else
               if (del.gt.0.0d0) then
                  efmax=efermi
               else 
                  efmin=efermi
               endif
               efermi=(efmax+efmin)/2.0d0
               goto 1000
            endif
         endif
!
! average the efermi (for print-out purposes only). 
!
         if (ispin.eq.1) then
            ef1=efermi
         else
            efermi=(ef1+efermi)/2.0d0
         endif
      enddo             ! spin loop

! Now calculate the various entropy terms of the electronic system
! and update occupation numbers
! update_occ_nembers_MP* should be collected into a single function with
! argument smethod, once a hermite function library is established

      select case (smethod)
      case (-1)
         call update_occ_numbers_FD(nbands, nkprun, nspin,         &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1)
      case ( 1)
         call update_occ_numbers_MP1(nbands, nkprun, nspin,        &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1, work2) 
      end select

      return
      end




      double precision &
           function fsum(nbands,nkprun,work1,work2,wtkpt,eigen,efermi,width,&
           nspin,ispin,istride,smethod)
!=======================================================================
! function to sum up electrons with given efermi and width,
! using Fermi statistics. Return occupation numbers in work1 
!   work1: values in   [0..2] for nspin = 1
!   work1: values in   [0..1] for nspin = 2  
! smethod is the broardening method  
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
!=======================================================================
      dimension work1(nbands,nkprun),work2(nbands,nkprun)
      dimension wtkpt(nkprun)
      dimension eigen(nbands,nkprun)
      integer nspin,ispin,istride,smethod
!=======================================================================
      fspin=2.0d0
      if (nspin.eq.2) fspin=1.0d0
      fsum = 0.0d0
      do 2000 nkp=ispin,nkprun,istride
        do 1000 nb=1,nbands
           x = (eigen(nb,nkp)-efermi)/width
           work1(nb,nkp) = fspin*smear(x,smethod)
           work2(nb,nkp) = x
!=======================================================================
!...how many electrons?
!=======================================================================
           fsum=fsum+work1(nb,nkp)*wtkpt(nkp)
 1000   continue
 2000 continue
      return
      contains
      ! -----------------------------------------------
      real*8 function smear(x, s)
      ! --- raw occupation factor in +[0, 1]+
      ! --- assume s is valid
      real*8  x
      integer s
      select case (s)
         case (-1)  
           smear = FD(x)
         case ( 1) 
           smear = MP1(x)
      end select
      end function smear
      ! -----------------------------------------------
      real*8 function FD(x)
      real*8 x
      if (x.le.-30.0d0) then
         FD = 1.0d0
      else if (x.lt.30.0d0) then
         FD = 1.0/(1.0d0+exp(x))
      else
         FD = 0.0d0
      endif
      end function FD
      ! -----------------------------------------------
      real*8 function MP0(x)
      real*8 x, erfc
      external  erfc
      MP0 = 0.5*erfc(x)
      end function MP0
      ! -----------------------------------------------
      real*8 function MP1(x)
      real*8 x
      real*8,parameter :: sqrtpi=1.772453850905515881919427556567825d0
      MP1 = MP0(x)
      if (abs(x).lt.10.0d0) then
         MP1 = MP1 - x*exp(-x**2)/2.0/sqrtpi
      endif
      end function MP1
      ! ----------------------------------------------
      end function fsum


!========================================================================= 
	subroutine setoccupation(nbands,nkprun,occ,wtkpt,eigen,efermi,&
                                 width,enfrec,entrpy,smethod, &
                                 nelect,ocvar,nspin,rmagmo)

        use run_context
        use netcdfinterface
        implicit none
        real*8  nelect
        integer nbands,nkprun,nspin,smethod
        real*8  occ(nbands,nkprun),wtkpt(nkprun),eigen(nbands,nkprun) 
        real*8  efermi,width,enfrec,ocvar,rmagmo,entrpy 

!       locals 
        logical*4, save ::  lmagmo,init=.true.
        real*8,    save ::  occmix=1.0d0
        integer ncid,status

!=========================================================================
!       For use in damden; 
!        occupation numbers occ is defined from the eigenvalues in 
!        eigen and rmagmo (for spin constrained calculation).
!=========================================================================

        if (init) then 
          if (.not.update_occupation_numbers) then 
            occmix = 0.0d0

            ! get occupation numbers from netcdf file
            status =  nf_open(netCDF_input_filename, NF_NOWRITE, ncid)
            if (status /= nf_noerr) call abort_calc(nconso, &
                 "setoccupation -> nf_open : error opening nc-file")

            status = nfget(ncid,"OccupationNumbers",occ) 
            if (status /= nf_noerr) call abort_calc(nconso, &
                 "setoccupation -> OccupationNumbers must be given")
          endif
          init = .false.
        endif
          
!
! test to see if the magnetic moment is to be constrained
! (this has to be done in every iteration as efcmom may change rmagmo)
!
        if (abs(rmagmo).le.1.d-10) then
            lmagmo=.false.
        else
            lmagmo=.true.
        endif
        if (.not.lmagmo) then
            call eferop(nbands,nkprun,occ,wtkpt,eigen,efermi,&
                width,occmix,enfrec,entrpy,smethod,nconso,    &
                nelect,ocvar,nspin)
        else
! constrain the spin moment
            call efcmom(nbands,nkprun,occ,wtkpt,eigen,efermi,&
                 width,occmix,rmagmo,enfrec,entrpy,smethod,nconso,  &
                 nelect,ocvar,nspin)
        endif

        return 
        end

!========================================================================= 
    subroutine update_occ_numbers_FD(nbands, nkprun, nspin,        &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1)
!   ----------------------------------------------------------------
!   Update occupdation numbers (occ) and entropy terms (enfrec,entrpy),
!   using Fermi Dirac Statistics
!   work1 contains the occupations numbers
!   ----------------------------------------------------------------
    implicit none
    integer  nbands, nkprun, nspin
    real*8   occmix, ocvar, width, enfrec, entrpy
    real*8   occ(nbands,nkprun), wtkpt(nkprun), work1(nbands,nkprun)
    real*8, parameter :: eps=1.d-10        ! truncation for log calls
    integer  nkp, nb
    real*8   pp, q, octmp, statpe
!   ----------------------------------------------------------------
    enfrec=0.0d0
    ocvar=0.0d0
    statpe=dble(nspin)/2.0d0
    do 750 nkp=1,nkprun
       do 751 nb=1,nbands
          octmp=(occ(nb,nkp)-work1(nb,nkp))**2
          ocvar=ocvar+octmp*wtkpt(nkp)
          occ(nb,nkp)=occ(nb,nkp)*(1.0d0-occmix)+work1(nb,nkp)*occmix
          pp=statpe*occ(nb,nkp)
          q=1.0d0-pp
          if (q.lt.eps) q=1.0d0
          if (pp.lt.eps) pp=1.0d0
          enfrec=enfrec-wtkpt(nkp)*(pp*log(pp)+q*log(q))
751     continue
750  continue
     enfrec=enfrec/statpe
! ----------------------------------------------------------------
! Total energy correction:                     enfrec = -TS/2
! Negative Electronic entropy for free energy: entrpy = -TS
! ----------------------------------------------------------------
     entrpy = -enfrec*width
     enfrec = -enfrec*width/2.0d0
     ocvar=sqrt(ocvar)                  ! conventional RMS normalization

     end subroutine update_occ_numbers_FD

!=======================================================================
     subroutine update_occ_numbers_MP1(nbands, nkprun, nspin,      &
                             occmix, ocvar, width, enfrec, entrpy, &
                             occ, wtkpt, work1, work2) 

!   ----------------------------------------------------------------
!   Update occupdation numbers (occ) and entropy terms (enfrec,entrpy),
!   using Methfessel-Paxton approximant 1 for the step function
!   work1 contains the occupations numbers
!   work2 contains the scaled energies (e-efermi/width)
!   ----------------------------------------------------------------
    implicit none
    integer  nbands, nkprun, nspin
    real*8   occmix, ocvar, width, enfrec, entrpy
    real*8   occ(nbands,nkprun), wtkpt(nkprun)
    real*8   work1(nbands,nkprun), work2(nbands,nkprun)
    real*8,parameter :: eps=1.d-10        ! truncation for log calls
    integer  nkp, nb
    real*8   octmp, x, e
    real*8,parameter :: sqrtpi=1.772453850905515881919427556567825d0
!   ----------------------------------------------------------------
    enfrec=0.0d0
    ocvar=0.0d0
    do 750 nkp=1,nkprun
       do 751 nb=1,nbands
          octmp=(occ(nb,nkp)-work1(nb,nkp))**2
          ocvar=ocvar+octmp*wtkpt(nkp)
          occ(nb,nkp)=occ(nb,nkp)*(1.0d0-occmix)+work1(nb,nkp)*occmix
          x = work2(nb,nkp)
          e = (1.0d0-2.0d0*(x**2))*exp(-x**2)/4.0d0/sqrtpi
          enfrec = enfrec + wtkpt(nkp)*e
751     continue
750  continue
     enfrec=2.0d0*enfrec/nspin
! ----------------------------------------------------------------
! Total energy correction (MP level 1):        enfrec = -2TS/3
! Negative Electronic entropy for free energy: entrpy = -TS
! ----------------------------------------------------------------
     entrpy = -enfrec*width
     enfrec = -enfrec*width*2.0d0/3.0d0
     ocvar=sqrt(ocvar)                  ! conventional RMS normalization

     end subroutine update_occ_numbers_MP1
