! ======================================================================
! This file contains subroutine handling double grid copy operations : 
!    copy_real_soft_to_dens_grid
!    copy_real_dens_to_soft_grid
!    copy_reciprocal_dens_to_soft
!    copy_reciprocal_soft_to_dens
! =======================================================================

      subroutine  copy_real_soft_to_dens_grid(ngx,ngy,ngz,&
               ngxs,ngys,ngzs,grid_soft, grid_dens ) 
      implicit none
      integer ngx,ngy,ngz,ngxs,ngys,ngzs
      complex*16 grid_soft(ngxs*ngys*ngzs),grid_dens(ngx*ngy*ngz)

! copy real space grid_soft to real space dense grid in grid_dens: 
! Fourier transform grid_soft to reciprocal space and then copy to 
! dense grid by setting the high G components to zero, finally back
! transforming

      complex*16 fac

!     transform grid_soft to reciprocal space 
      call fft3d(grid_soft,ngxs,ngys,ngzs,-1) 
      fac = 1.0d0/dble(ngxs*ngys*ngzs)
      call ZSCAL(ngxs*ngys*ngzs,fac,grid_soft,1) 

      call copy_reciprocal_soft_to_dens(ngx,ngy,ngz,ngxs,ngys,ngzs,&
                    grid_soft,grid_dens )

!     transform dense grid to real space  
      call fft3d(grid_dens,ngx,ngy,ngz,1) 

      return      
      end 

! =======================================================================

      subroutine  copy_real_dens_to_soft_grid(ngx,ngy,ngz,&
            ngxs,ngys,ngzs,ngdens_soft,nrplwv,ipwpadG_soft,grid_dens,&
                    grid_soft )                     
      implicit none
      integer ngx,ngy,ngz,ngxs,ngys,ngzs
      integer ngdens_soft,nrplwv,ipwpadG_soft(ngdens_soft,0:3)
      complex*16 grid_soft(ngxs*ngys*ngzs),grid_dens(ngx*ngy*ngz)
 
!     copy real space grid_dens to real space grid_soft:
!     Fourier transform grid_dens to reciprocal space and then copy to
!     soft grid by truncating high Fourier components, finally 
!     transform grid_soft to real space

      complex*16 fac,work(ngx*ngy*ngz)


!     copy dense grid so it is returned unchanged
      call ZCOPY(ngx*ngy*ngz,grid_dens,1,work,1) 

!     transform grid_dens to reciprocal space
      call fft3d(work,ngx,ngy,ngz,-1)
      fac = 1.0d0/dble(ngx*ngy*ngz)
      call ZSCAL(ngx*ngy*ngz,fac,work,1) 
 
      call copy_reciprocal_dens_to_soft(ngx,ngy,ngz,ngxs,ngys,ngzs,&
         ngdens_soft,nrplwv,ipwpadG_soft,work,grid_soft )
 
!     transform dense grid to real space
      call fft3d(grid_soft,ngxs,ngys,ngzs,1)                        

!      call xydens(ngxs,ngys,ngzs,grid_soft)
!      call xydens(ngx,ngy,ngz,grid_dens)
!      stop 'test'

      return
      end                            

! ======================================================================    

      subroutine copy_reciprocal_soft_to_dens(ngx,ngy,ngz,&
           ngxs,ngys,ngzs,grid_soft,grid_dens )
      implicit none
      integer ngx,ngy,ngz,ngxs,ngys,ngzs 
      complex*16 grid_soft(ngxs,ngys,ngzs),grid_dens(ngx,ngy,ngz)

!     copy reciprocal grid_soft to grid_dens by setting the high 
!     G components to zero 

      integer nx,ny,nz,nxd,nyd,nzd
      integer sg2dg
      integer n1,n2,n3
      n1 = ngxs/2 + 1
      n2 = ngys/2 + 1
      n3 = ngzs/2 + 1

!     zero all Fourier components of grid_dens
      grid_dens = dcmplx(0.0d0,0.0d0)

      do nx = 1,ngxs
       nxd = sg2dg(nx,ngxs,ngx) 
       do ny = 1,ngys
        nyd = sg2dg(ny,ngys,ngy) 
        do nz = 1,ngzs
          nzd = sg2dg(nz,ngzs,ngz) 
          grid_dens(nxd,nyd,nzd) = grid_soft(nx,ny,nz)
        enddo 
       enddo 
      enddo
      grid_dens(n1,:,:) = (0.0d0,0.0d0)
      grid_dens(:,n2,:) = (0.0d0,0.0d0)
      grid_dens(:,:,n3) = (0.0d0,0.0d0)
      

      return 
      end 

! ======================================================================
 
      subroutine copy_reciprocal_dens_to_soft(ngx,ngy,ngz,&
         ngxs,ngys,ngzs,ngdens_soft,nrplwv,ipwpadG_soft,&
                     grid_dens,grid_soft)
      implicit none
      integer ngx,ngy,ngz,ngxs,ngys,ngzs
      integer ngdens_soft,nrplwv,ipwpadG_soft(ngdens_soft,0:3)
      complex*16 grid_soft(ngxs,ngys,ngzs),grid_dens(ngx,ngy,ngz)
!     copy reciprocal grid_soft to grid_dens by setting the high
!     G components to zero

      integer nx,ny,nz,nxd,nyd,nzd
      integer sg2dg 
      integer ng    

!     zero all Fourier components of soft grid
      grid_soft = dcmplx(0.0d0,0.0d0)

!     do ng = 1,ngdens_soft
!       nx = ipwpadG_soft(ng,1)
!       ny = ipwpadG_soft(ng,2)
!       nz = ipwpadG_soft(ng,3)
!       nxd = sg2dg(nx,ngxs,ngx)
!       nyd = sg2dg(ny,ngys,ngy)
!       nzd = sg2dg(nz,ngzs,ngz)
!       grid_soft(nx,ny,nz) = grid_dens(nxd,nyd,nzd)
!     enddo

       do nx = 1,ngxs
        nxd = sg2dg(nx,ngxs,ngx)
        do ny = 1,ngys
         nyd = sg2dg(ny,ngys,ngy)
         do nz = 1,ngzs
           nzd = sg2dg(nz,ngzs,ngz)
           grid_soft(nx,ny,nz) = grid_dens(nxd,nyd,nzd)
         enddo
        enddo
       enddo          
 
      return
      end                                   

! ======================================================================

      integer function sg2dg(n,ngs,ng) 
      implicit none
      integer n,ng,ngs

!     given a grid number in the reciprocal soft grid return 
!     the index into the dense grid 
!     input :     
!              n   : index in soft grid 
!              ng  : dense grid size
!              ngs : soft grid size
      
      if (n.le.(ngs/2 +1)) then 
        sg2dg = n 
      else 
        sg2dg = ng - (ngs-n) 
      endif

      return 
      end
