#include "definitions.h"

      subroutine chdid(nconso)
      write(nconso,*) '%W& 7/1/99'
      return
      end

!=======================================================================

      subroutine chdtr(nbands,nplwv,nrplwv,nrplwv_global,nkprun,wtkpt,&
#ifdef PARAL
#include PARAL_ARGS
          ,&
#endif
          cptwfp,rdensr,ngx,ngy,ngz,ngxs,ngys,ngzs,cwork1,ipwpad,&
          nplwkp,occ,nspin,kspin,timer,nconso)

! subroutine chdtr constructs the electronic charge density (rdensr) 
! are returned on the dense grid, but calculated on the course grid
#ifdef PARAL 
      use par_functions_module
#endif PARAL
      implicit none
      integer nbands,nplwv,nrplwv,nrplwv_global,nkprun
      real*8  wtkpt
      integer nplwkp
      integer  nspin,kspin, nconso
      complex*WF_PRECISION cptwfp(*)  ! nrplwv*nbands
      complex*16 cwork1(nplwv)
      real*8   rdensr(nplwv,nspin)
      real*8   occ(nbands)
      integer  ngx,ngy,ngz,ngxs,ngys,ngzs
      real*8   timer(*)
#ifdef SERIAL
      integer  ipwpad(nrplwv)
#endif

#ifdef PARAL
#include PARAL_DECL
!     Make a full length work array
      complex*WF_PRECISION cwork(nrplwv_global)
      integer ipwpad(nrplwv_global)
      logical exists
#endif

!     locals
      complex*16 work_soft(ngxs*ngys*ngzs)
      real*8  rwork_dens(nplwv),wght
      integer m,nn,nindw,nplwv_soft
      integer n,nx,ny,nz,i

! soft grid size
      nplwv_soft = ngxs*ngys*ngzs

! initialise the charge density at this k point to zero
      work_soft = dcmplx(0.0d0,0.0d0)

      do 200 nn=1,nbands

!       init fourier transform array to zero
        cwork1 = dcmplx(0.0d0,0.0d0) 

        nindw=nrplwv*(nn-1)

#ifdef PARAL
!       Get the entire wavefunction from the other processors
        if (par_pw_np.gt.1) then
          call par_getwf (cptwfp, nrplwv,  nn, nbands, 0,&
#include PARAL_ARGS
          , cwork, exists, timer, nconso)
          if (.not. exists) goto 200
!         Entire wavefunction is now in the array cwork
          do m = 1,nplwkp
            cwork1(ipwpad(m)) = cwork(m)
          end do
        else
          do m = 1,nplwkp
            cwork1(ipwpad(m)) = cptwfp(m+nindw)
          end do
        endif
#else
        do m = 1,nplwkp
          cwork1(ipwpad(m)) = cptwfp(m+nindw)
        end do
#endif

! transform the wavefunction into real space

        call fft3d(cwork1,ngxs,ngys,ngzs,1)

! multiplying occupancy by the weighting factor for the k point
        wght = occ(nn) * wtkpt
        do m = 1,nplwv_soft
          work_soft(m) = work_soft(m)+&
                         wght*dble((cwork1(m))*conjg(cwork1(m)))
        end do

 200  continue

#ifdef PARAL
!     Make global sum of partial densities
      call par_sum_complex ('A',work_soft,work_soft,nplwv_soft,&
                             nplwv_soft,1,&
#include PARAL_ARGS
        ,timer)
#endif

! copy rwork to dense grid; Fourier transform rwork to 
! reciprocal space and then copy to dense grid by 
! setting the high G components to zero, finally back 
! transforming
      call copy_real_soft_to_dens_grid(ngx,ngy,ngz,&
                ngxs,ngys,ngzs,work_soft,cwork1)

!     copy to real space dense grid 
      do i = 1,nplwv
        rwork_dens(i) = dble(cwork1(i))
      enddo

! add charge density at the present k point to the total charge density

      call add (rdensr(1,kspin), rwork_dens, nplwv)


      return
      end

!=======================================================================

      subroutine spacha(volc,&
                        nbands,nplwv,nrplwv,wtkpt,&
                        cptwfp,ngx,ngy,ngz,ipwpad,&
                        nplwkp,rdensr,occ,eigen,&
                        nmsfft,numsym,nmstyp,nconso,efermi)

! subroutine chdtr constructs the electronic charge density and computes
! the real space wavefunctions which are used again in the electron
! dynamics subroutine

      implicit none
      real*8 volc
      integer nbands,nplwv,nrplwv
      real*8 wtkpt
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)
      integer nplwkp
      real*8  rdensr(nplwv)
      real*8 occ(nbands)
      real*8 eigen(nbands)
      integer nmsfft(nplwv,*)
      integer numsym
      integer nmstyp(*)
      integer nconso
      real*8 efermi

! locals

      real*8 wght
      integer m,nn
      complex*16 cwork1(nplwv)

! initialise the charge density at this k point to zero

      do 1400 nn=1,nbands
         wght=occ(nn)*wtkpt/volc

! initialise the arrays used in the fourier transform to zero. this step
! must be performed to ensure that the coefficients of the plane waves
! beyond the cut-off energy are zero.

         do m=1,nplwv
            cwork1(m)=(0.0d0,0.0d0)
         end do
         do m=1,nplwkp
            cwork1(ipwpad(m))=cptwfp(m,nn)
         end do

! transform the wavefunction into real space
         call fft3d(cwork1,ngx,ngy,ngz,1)

! calculate the charge density in real space and store the real space
! wavefunction for use in the electron dynamics subroutine

! add charge density at the present k point to the total charge density
! multiplying by the weighting factor for the k point

         do 2000 m=1,nplwv
            rdensr(m)=rdensr(m)+&
                      dble((cwork1(m))*conjg(cwork1(m)))*wght
 2000    continue
 1400 continue

      return
      end

!=======================================================================

      subroutine spawr (nconso, rdensr, nplwv, text)

!     Printout of density

      integer nconso, nplwv
      double precision rdensr(nplwv)
      character*6 text

      do m=1,int(nplwv/6)*6,6
         write(nconso,3000) text,(rdensr(m+i),i=0,5)
      end do
      if (int(nplwv/6)*6.lt.nplwv)&
            write(nconso,3000) text,(rdensr(m),m=int(nplwv/6)*6+1,nplwv)
 3000 format(1x,a6,6f12.6)
      return
      end

!=======================================================================

      subroutine spasta(nbspas,volc,&
                        nbands,nplwv,nrplwv,wtkpt,&
                        cptwfp,rdensr,ngx,ngy,ngz,ipwpad,&
                        nplwkp,occ,eigen,&
                        nmsfft,numsym,nmstyp,nconso,efermi)

! subroutine chdtr constructs the electronic charge density and computes
! the real space wavefunctions which are used again in the electron
! dynamics subroutine

      implicit none
      integer nbspas
      real*8 volc
      integer nbands,nplwv,nrplwv
      real*8 wtkpt
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      real*8 rdensr(nplwv)
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)
      integer nplwkp
      real*8 occ(nbands)
      real*8 eigen(nbands)
      integer nmsfft(nplwv,*)
      integer numsym
      integer nmstyp(*)
      integer nconso
      real*8 efermi

! locals

      real*8 wght
      integer m
      real*8 rhomax
      integer nmax
      complex*WF_PRECISION cphas
      complex*16 cwork1(nplwv)

      wght=2.0d0/volc

! initialise the arrays used in the fourier transform to zero. this step
! must be performed to ensure that the coefficients of the plane waves
! beyond the cut-off energy are zero.

      do m=1,nplwv
         cwork1(m)=(0.0d0,0.0d0)
      end do
      do m=1,nplwkp
         cwork1(ipwpad(m))=cptwfp(m,nbspas)
      end do

! transform the wavefunction into real space

      call fft3d(cwork1,ngx,ngy,ngz,1)

! calculate the charge density in real space and store the real space
! wavefunction for use in the electron dynamics subroutine
      nmax=1
      rhomax=-1.0d0
      do m=1,nplwv
         if (dble(cwork1(m)*conjg(cwork1(m))).gt.rhomax) nmax=m
      end do
      cphas=sqrt(dble(cwork1(nmax)*conjg(cwork1(nmax))))/cwork1(nmax)
      do m=1,nplwv
         rdensr(m)=cwork1(m)*cphas*sqrt(wght)
      end do

      return
      end

!=======================================================================

      subroutine spados(stmcen,stmwid,volc,&
                        nbands,nplwv,nrplwv,wtkpt,&
                        cptwfp,ngx,ngy,ngz,ipwpad,&
                        nplwkp,rdensr,occ,eigen,&
                        nmsfft,numsym,nmstyp,nconso,efermi)

! subroutine chdtr constructs the electronic charge density and computes
! the real space wavefunctions which are used again in the electron
! dynamics subroutine

      implicit none
      real*8 stmcen,stmwid
      real*8 volc
      integer nbands,nplwv,nrplwv
      real*8 wtkpt
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)
      integer nplwkp
      real*8  rdensr(nplwv)
      real*8 occ(nbands)
      real*8 eigen(nbands)
      integer nmsfft(nplwv,*)
      integer numsym
      integer nmstyp(*)
      integer nconso
      real*8 efermi

! locals

      real*8 wght
      integer m,nn
      complex*16 cwork1(nplwv)
      real*8 sqrtpi
      data sqrtpi /1.772453851d0/

! initialise the charge density at this k point to zero

      do 1200 m=1,nplwv
        rdensr(m)=0.0d0
 1200 continue
      do 1400 nn=1,nbands
         wght=exp(-((eigen(nn)-efermi)-stmcen)**2/stmwid)&
              *2.0d0/sqrtpi/sqrt(stmwid)/volc*wtkpt

! initialise the arrays used in the fourier transform to zero. this step
! must be performed to ensure that the coefficients of the plane waves
! beyond the cut-off energy are zero.

         do m=1,nplwv
            cwork1(m)=(0.0d0,0.0d0)
         end do
         do m=1,nplwkp
            cwork1(ipwpad(m))=cptwfp(m,nn)
         end do

! transform the wavefunction into real space

         call fft3d(cwork1,ngx,ngy,ngz,1)


! calculate the charge density in real space and store the real space
! wavefunction for use in the electron dynamics subroutine

! add charge density at the present k point to the total charge density
! multiplying by the weighting factor for the k point

         do 2000 m=1,nplwv
            rdensr(m)=rdensr(m)+&
                      dble((cwork1(m))*conjg(cwork1(m)))*wght
 2000    continue
 1400 continue

      return
      end

!=======================================================================

      subroutine spdpsi(stmcen,stmwid,volc,dnlkg,&
                        nbands,nplwv,nrplwv,wtkpt,&
                        cptwfp,ngx,ngy,ngz,ipwpad,&
                        nplwkp,rdensr,occ,eigen,&
                        nmsfft,numsym,nmstyp,nconso,efermi)

! subroutine chdtr constructs the electronic charge density and computes
! the real space wavefunctions which are used again in the electron
! dynamics subroutine

      implicit none
      real*8 stmcen,stmwid
      real*8 volc
      integer nbands,nplwv,nrplwv
      real*8 dnlkg(nrplwv,0:3)
      real*8 wtkpt
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)
      integer nplwkp
      real*8  rdensr(nplwv)
      real*8 occ(nbands)
      real*8 eigen(nbands)
      integer nmsfft(nplwv,*)
      integer numsym
      integer nmstyp(*)
      integer nconso
      real*8 efermi

! locals

      complex*16 cwork1(nplwv)
      real*8 wght
      integer m,nn
      real*8 sqrtpi
      data sqrtpi /1.772453851d0/

! initialise the charge density at this k point to zero

      do 1400 nn=1,nbands
         wght=exp(-((eigen(nn)-efermi)-stmcen)**2/stmwid)&
              *2.0d0/sqrtpi/sqrt(stmwid)/volc*wtkpt

! initialise the arrays used in the fourier transform to zero. this step
! must be performed to ensure that the coefficients of the plane waves
! beyond the cut-off energy are zero.

         do m=1,nplwv
            cwork1(m)=(0.0d0,0.0d0)
         end do

! Now find the z-derivative of the wave function

!=======================================================================
!                     (Gx+kx,Gy+ky,Gz+kz)
! dnlkg(*,1-3,nkp) = ---------------------  [Cartesian coordinates]
!                    |(Gx+kx,Gy+ky,Gz+kz)|
!
! naevneren staar i 0'te element i dnlkg: Husk at gange den vaek !!!          
!                  dnlkg(nsboxi,0)=sqrt(gx**2+gy**2+gz**2)
!=======================================================================
         do m=1,nplwkp
            cwork1(ipwpad(m))=(0.0d0,1.0d0)*dnlkg(m,3)*dnlkg(m,0)*&
                                                            cptwfp(m,nn)
         end do

! transform the wavefunction into real space

         call fft3d(cwork1,ngx,ngy,ngz,1)

! calculate the charge density in real space and store the real space
! wavefunction for use in the electron dynamics subroutine

! add charge density at the present k point to the total charge density
! multiplying by the weighting factor for the k point

         do 2000 m=1,nplwv
            rdensr(m)=rdensr(m)+&
                      dble((cwork1(m))*conjg(cwork1(m)))*wght
 2000    continue
 1400 continue

      return
      end

!=======================================================================

      subroutine doszwr (nconso,rdensr,dirc,ngx,ngy,ngz,nener,&
                         enemin,enemax,nxytot)

!     Printout states per eV per Angstrom in the x-y area 

      implicit none
      integer nconso, ngx, ngy, ngz, nener, nxytot
      double precision rdensr(ngz,nener)
      double precision dirc(3,3)
      double precision enemin,enemax

!     Locals
      double precision rdel,edel,ener
      integer ne, nz

      write(nconso,1120) 100*nxytot/dble(ngx*ngy)
 1120 format(1x,'RDOS: The x-y cell covers ',f5.1,&
             ' % of the entire surface area')

      edel=(enemax-enemin)/dble(nener-1)
      rdel=1.0d0/(2.0d0*edel)/dirc(3,3)/dble(ngx*ngy)
      do ne=1,nener
         ener=edel*dble(ne-1)+enemin
         do nz=1,ngz
            write(nconso,3000) ener,(nz-1)/dble(ngz)*dirc(3,3),&
                              rdensr(nz,ne)*rdel
 3000       format(1x,'ZDOS: ',3f12.6)
         end do
      end do
      return
      end

 
! -------------------------------------------------------------------------

      subroutine symadd (nconso, rdensr, rdnsum, nplwv,&
        work1, work2, nmsfft, numsym, nmstyp, ldummy, addsub,nspin,&
#ifdef PARAL
#include PARAL_ARGS
         ,&
#endif PARAL
        timer)

#ifdef PARAL       
      use par_functions_module
#endif PARAL
!     Symmetrize change in charge density, and add to rdensr(r).
 
!     For the master-slave code, first perform a global sum using mssum().
!     When ldummy is true, we first set "rdnsum" to zero.
!     The "work1","work2" are workspaces.
!     The "addsub" flag means the following:
!       addsub > 0:  Add rdnsum to rdensr
!       addsub = 0:  Don't add anything to rdensr
!       addsub < 0:  Subtract rdnsum from rdensr

      implicit none
#ifdef PARAL
#include PARAL_DECL
#endif PARAL
 
      integer    nconso, nplwv, numsym, addsub,nspin
      real*8     rdensr(nplwv,nspin), rdnsum(nplwv,nspin)
      real*8     work1(nplwv), work2(nplwv)
      integer    nmsfft(nplwv,*), nmstyp(*)
      logical*4  ldummy
      real*8     timer(*)
!     locals
      integer    i

      if (ldummy) rdnsum = 0.0d0
 
#ifdef PARAL
!     Global sum over parallel nodes of charge-density-changes (rdnsum)
!     (the result is available on all nodes).
      do  i=1,nspin
        call mssum (rdnsum(1,i), rdnsum(1,i),nplwv,nplwv,1,&
#include PARAL_ARGS
         ,nconso,timer )
      enddo   
#endif PARAL
 
! symmetrize change in charge density and calc. new rdensr(r)
      do 200 i=1,nspin
        call symchd (nconso, nplwv, rdnsum(1,i),&
          work2, nmsfft, numsym, nmstyp)
 200  continue                           
               
!     Add, subtract or do nothing as determined by "addsub":
      if (addsub .gt. 0) then                                
        call add (rdensr, rdnsum, nplwv*nspin)
      else if (addsub .lt. 0) then             
        call sub (rdensr, rdnsum, nplwv*nspin)
      endif                                    
            
      return
      end    

