
      subroutine auxmid(nconso)
      write(nconso,*) '@(#)auxmod.F	1.25 7/1/99'
      return
      end



      subroutine sumpot(enpot,nplwv,rdensr,cveff,nspin)

! Calculate energy from  / V_eff_local(r)n(r) dr

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension rdensr(nplwv)
      dimension cveff(nplwv)
      integer nspin

      rinplw=dble(nspin)/dble(nplwv)
      enpot=0.0d0
      do 9200 m=1,nplwv
         enpot=enpot+rdensr(m)*dble(cveff(m))
 9200 continue
      enpot=enpot*rinplw
      return
      end


      subroutine sumvnl(envnl,nkprun,nbands,vnl,wtkpt,occ)

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension occ(nbands,nkprun)
      dimension wtkpt(nkprun)
      dimension vnl(nbands,nkprun)

!  calculate the total non-local energy

      envnl=0.0d0
      do 2000 nkp=1,nkprun
         do 1000 nb=1,nbands
            envnl=envnl+vnl(nb,nkp)*wtkpt(nkp)*occ(nb,nkp)
 1000    continue
 2000 continue
      return
      end



      subroutine sumkin(enkin,nkprun,nbands,wfkine,wtkpt,occ)

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension occ(nbands,nkprun)
      dimension wtkpt(nkprun)
      real*8 wfkine(nbands,nkprun)

!  calculate the total kinetic energy

      enkin=0.0d0
      do 2000 nkp=1,nkprun
        do 1000 nb=1,nbands
          enkin=enkin+wfkine(nb,nkp)*wtkpt(nkp)*occ(nb,nkp)
 1000   continue
 2000 continue
      return
      end

!-----------------------------------------------------------------------
 
      subroutine elspot(nplwv,cwork1,rdensr,ngx,ngy,ngz,&
                 dirdat,cveff,cvion,nspin)

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      integer nplwv
      dimension cwork1(nplwv)
      dimension rdensr(nplwv,nspin)
      integer ngx,ngy,ngz
      dimension dirdat(nplwv)
      dimension cveff(nplwv,nspin)
      dimension cvion(nplwv)
      integer nspin
!
! locals
!
      real*8 rinplw


!  transform charge density to reciprocal space and calculate hartree
!  and exchange-correlation energy and tidy up potentials

      rinplw=1.0d0/nplwv
      if (nspin.eq.2) then
         do 6000 m=1,nplwv
            cwork1(m)=(rdensr(m,1)+rdensr(m,2))*rinplw
 6000    continue
      else
         do 6100 m=1,nplwv
            cwork1(m)=rdensr(m,1)*rinplw
 6100    continue
      endif
      
      call fft3d(cwork1,ngx,ngy,ngz,-1)
      do 6200 m = 1 , nplwv
        cveff(m,1) = cwork1(m) * dirdat(m)
 6200 continue

! cveff(g) = contains the reciprocal space hartree potential

      call fft3d(cveff,ngx,ngy,ngz,1)

! (now working in real space, where rdensr(r) is charge-density)

      do 3025 m=1,nplwv
         cveff(m,1)=cveff(m,1)+cvion(m)
 3025 continue

      if (nspin.eq.2) then
         do 3030 m=1,nplwv
            cveff(m,nspin)=cveff(m,1)
 3030    continue
      endif

      return
      end

!---------------------------------------------------------------------

      subroutine tidyup(nplwv, npwxc, rdensr,rho_core,&
                 enhac,dirdat,cveff,volc,enxcc,&
                 enxc,excdat,xcfdat,xcpdat,nxc,cvion, &
                 recc,lpctx,lpcty,lpctz,vxc,dnlg0,cwork1, &
                 iscxc,nspin,ngx,ngy,ngz,ngxs,ngys,ngzs,cveff_soft, &
                 deltav,ngdens_soft,nrplwv,ipwpadG_soft,&
                 nconso,idebug,timer)

!
!    From the realspace density in rdensr the effective potential 
!    and exchange correlation potential is calculated. 
!    The partial-core density in rho_core is added before calculating 
!    the exchange-correlation potential.

!    input : 
!             rdensr    : reals space density 
!             rho_core  : partial core density.
!             iscxc     : parameter selecting the exchange-correlation 
!                         potential.
!    output : 
!             cveff     : Effective potential
!             vxc       : Exchange-correlation potential
!             enxc,enxcc: Exchange-correlation energy and energy correction.

      implicit none
      integer    nplwv,npwxc,iscxc,nspin,ngx,ngy,ngz,ngxs,ngys,ngzs
      real*8     rdensr(nplwv,nspin),rho_core(nplwv) 
      real*8     enhac
      real*8     dirdat(nplwv)
      complex*16 cveff(nplwv,nspin),cveff_soft(ngxs*ngys*ngzs,nspin)
      complex*16 deltav(nplwv)
      integer ngdens_soft,nrplwv,ipwpadG_soft(ngdens_soft,0:3) 
      real*8     volc
      real*8     enxcc,enxc,ex(2)
      integer    nxc
      real*8     excdat(nxc),xcfdat(nxc),xcpdat(nxc)
      complex*16 cvion(nplwv)
      real*8     recc(3,3)
      integer    lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8     vxc(nplwv,nspin)
      real*8     dnlg0(npwxc,3)
      complex*16 cwork1(nplwv)
      integer    nconso,idebug
      real*8 timer(*)

!     locals 
      real*8     encore,rinplw,spinfac
      integer    m,i
      logical*4  lxcpot


      rinplw=1.0d0/dble(nplwv)
!
! 1) determine the xc potential and energy terms
!    (cveff can be used as a work array)
!
!     calculate the exchange-correlation energy (enxc and enxcc) and 
!     the potential (vxc)
      lxcpot = .true. 
      call uflush(nconso)
      call calcxc(iscxc,lxcpot,nspin,nconso,rdensr,rho_core,&
       volc,recc,lpctx,lpcty,lpctz,enxcc,enxc,ex,vxc,nxc,excdat,xcfdat,&
       xcpdat,cwork1,ngx,ngy,ngz,nplwv,dnlg0,npwxc,timer)

!     add the rho_core*Vxc term, which are present in enxcc
!     but not in enpot                                       
      rinplw=1.0d0/dble(nplwv)
      spinfac=1.0d0/dble(nspin) 
      encore = 0.0d0
      do i = 1,nspin
        do m=1,nplwv
          encore=encore+rho_core(m)*vxc(m,i)*spinfac
9200    enddo   
      enddo
      encore=encore*rinplw
      enxcc = enxcc + encore                           

999   continue

!
! 2) determine the Hartree potential and energy terms
!

!  transform charge density to reciprocal space and calculate hartree
!  and exchange-correlation energy and tidy up potentials

      if (nspin.eq.2) then
         do 6000 m=1,nplwv
            cwork1(m)=(rdensr(m,1)+rdensr(m,2))*rinplw
 6000    continue
      else
         do 6100 m=1,nplwv
            cwork1(m)=rdensr(m,1)*rinplw
 6100    continue
      endif
      
      call fft3d(cwork1,ngx,ngy,ngz,-1)

      if (idebug.gt.0) then 
         write(nconso,*) 'NELEC (TIDYUP) ',cwork1(1)
         call uflush(nconso)
      endif

      enhac = 0.0d0
      do 6200 m = 1 , nplwv
        cveff(m,1) = cwork1(m) * dirdat(m)
        enhac = enhac + dble ( cveff(m,1) * conjg ( cwork1(m) ) )
 6200 continue
      enhac = - enhac / 2.0d0

! cveff(g) = contains the reciprocal space hartree potential

      call fft3d(cveff,ngx,ngy,ngz,1)

! (now working in real space, where rdensr(r) is charge-density)

!
! 3) sum up the Hartree (now: cveff) , exchange-correlation (vxc)
!    and local ionic + external electrostatic (cvion) potentials
!    to the effective Kohn-Sham potential (cveff).
!

      do 5030 i=nspin,1,-1
        do 5020 m = 1 , nplwv
           cveff(m,i)=cveff(m,1)+vxc(m,i)+cvion(m)+deltav(m)
 5020   continue
 5030 continue

!     copy to soft grid copy of cveff
      do i = 1,nspin
        call copy_real_dens_to_soft_grid(ngx,ngy,ngz,&
          ngxs,ngys,ngzs,ngdens_soft,nrplwv,ipwpadG_soft,&
          cveff(1,i),cveff_soft(1,i))  
      enddo

      return
      end


!-----------------------------------------------------------------------


      subroutine calcxc(iscxc,lxcpot,nspin,nconso,rdensr,rho_core,&
         volc,recc,lpctx,lpcty,lpctz,enxcc,enxc,ex,vxc,nxc,excdat,&
         xcfdat,xcpdat,cwork1,ngx,ngy,ngz,nplwv,dnlg0,npwxc,timer) 



!     Calculate the exchange-correlation potential and energy. If 
!     lscpot=false only energy is calculated. 
!     The partial-core in rho_core is added before exchange-corr. 
!     is calculated.
!     input : iscxc  
!                   1   Perdew-Zunger  LDA
!                   2   Perdew Wang 91 GGA
!                   3   VoskoWilkNus   LDA
!                   4   Original PBE   
!                   5   Revised  PBE
!                   5   RPBE98
!
!     on return: 
!        enxcc : exchange-correlation energy correction
!        enxc  : exchange-correlation energy 
!        ex    : exchange only energy
!        vxc   : exchange-correlation potential

      implicit none
      integer    iscxc
      logical*4  lxcpot
      integer    nspin,nconso
      integer    ngx,ngy,ngz,nplwv
      real*8     rdensr(nplwv,nspin),rho_core(nplwv)
      real*8     volc,recc(3,3)
      integer    lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8     enxcc,enxc,ex(*)
      real*8     vxc(nplwv,nspin)
      complex*16 cwork1(nplwv)
      integer    nxc
      real*8     excdat(nxc),xcfdat(nxc),xcpdat(nxc)
      integer    npwxc
      real*8     dnlg0(npwxc,3)
      real*8     timer(*)

!     locals
      logical*4  lscgga
      integer    m
      real*8     ukfactor
      integer    iinit
      data iinit /0/
      save iinit             

!     initialization of the dnlg0 array (only for iscxc>1 and lxcpot=true)
      if ((iinit.eq.0).and.(iscxc.gt.1).and.(lxcpot)) then 
         call idnlg0(ngx,ngy,ngz,npwxc,recc,lpctx,lpcty,lpctz,dnlg0)
         iinit = 1
      endif

!     Add partialcore charge to rdensr
      if (nspin.eq.1) then
        do m = 1,nplwv
          rdensr(m,1) = rdensr(m,1) + rho_core(m)
        enddo
      endif
      if (nspin.eq.2) then
        do m = 1,nplwv
          rdensr(m,1) = rdensr(m,1) + 0.5d0*rho_core(m)
          rdensr(m,2) = rdensr(m,2) + 0.5d0*rho_core(m)
        enddo
      endif

      if (iscxc.eq.1) then
         if (lxcpot) then 
           do  m = 1 , nplwv
              cwork1(m) = rdensr(m,1)
           enddo
           call fexcop(nplwv,cwork1,volc,enxcc,enxc,&
                excdat,xcfdat,xcpdat,nxc,nconso)
         
!          cwork1(r) is now the real-space xc-potential 
!          store in vxc 
           do m = 1,nplwv 
             vxc(m,1) = dble(cwork1(m))
           enddo
         else
           if (nspin.eq.1) then
             call excold(nplwv,rdensr,volc,enxc,excdat,nxc)
           else
             enxc=0.0d0
           endif
         endif
         ex(1) = 0.0d0

      elseif ((iscxc.eq.2).or.(iscxc.eq.3)) then   ! PW91 or VWN
         if (iscxc.eq.3) lscgga = .true. 
         if (iscxc.eq.2) then 
              lscgga = .false.
!             if lxcpot = false we get both GGA and VWN energies from one call
!             excc is VWN energy
              if (.not.(lxcpot)) lscgga = .true. 
         endif

         if (nspin.eq.1) then
           call pwunsp(lscgga,lxcpot,&
            nconso,rdensr,volc,recc,lpctx,lpcty,lpctz,enxcc,enxc,ex,vxc,&
            cwork1,nspin,ngx,ngy,ngz,nplwv, dnlg0,  npwxc )
         else
            call pw(lscgga,lxcpot,&
              nconso,rdensr,volc,recc,lpctx,lpcty,lpctz,&
              enxcc,enxc,ex,vxc,&
              cwork1,nspin,ngx,ngy,ngz,nplwv, dnlg0, npwxc )
         endif

      elseif ((iscxc.ge.4).or.(iscxc.le.11)) then 
!        PBE 
         if (iscxc.eq.4) then 
!           Original PBE with kappa = 0.804 
            ukfactor = 1.0d0
         endif 
         if (iscxc.eq.5) then 
!           Revised PBE with kappa = 1.245
            ukfactor = 1.245d0/0.804d0 
         endif
         if (iscxc.eq.6) then 
!           RPBE98
            ukfactor = 0.0d0 
         endif 
         if (iscxc.gt.6) then 
!           exchange ensemble
            ukfactor = -iscxc
         endif 
         lscgga = .true.
         if (nspin.eq.1) then 
           call pbeunsp(lscgga,lxcpot,&
             nconso,rdensr,volc,recc,lpctx,lpcty,lpctz,&
             enxcc,enxc,ex(1),vxc,&
             cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc,&
             ukfactor,timer)
         else
           call pbe(lscgga,lxcpot,&
             nconso,rdensr,volc,recc,lpctx,lpcty,lpctz,&
             enxcc,enxc,ex(1),vxc,&
             cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc,&
             ukfactor)
         endif
      else 
!       not allowed vaue for iscxc
        write(nconso,*) 'Error in auxmod, value of iscxc = ',iscxc
        call clexit(nconso)
      endif
      
!     Subtract partialcore charge again
      do m = 1,nplwv
        if (nspin.eq.1) then
          rdensr(m,1) = rdensr(m,1) - rho_core(m)
        endif
        if (nspin.eq.2) then
          rdensr(m,1) = rdensr(m,1) - 0.5d0*rho_core(m)
          rdensr(m,2) = rdensr(m,2) - 0.5d0*rho_core(m)
        endif
      enddo 

      return 
      end


!--------------------------------------------------------------------------

!     subroutine for initialization of the dnlg0 array

      subroutine idnlg0(ngx,ngy,ngz,nplwv,recc,lpctx,lpcty,lpctz,dnlg0)
      implicit none
      integer ngx,ngy,ngz,nplwv
      real*8 recc(3,3)
      integer lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 dnlg0(nplwv,3)
! locals
      integer nr,nz,ny,nx
      real*8 gzx,gzy,gzz,gyz,gyy,gyx,gxz,gxy,gxx,gz,gy,gx
!
! Initialize Gx,Gy,Gz array
!
      nr=1
      do nz=1,ngz
         gzx=recc(3,1)*lpctz(nz)
         gzy=recc(3,2)*lpctz(nz)
         gzz=recc(3,3)*lpctz(nz)
         do ny=1,ngy
            gyx=recc(2,1)*lpcty(ny)
            gyy=recc(2,2)*lpcty(ny)
            gyz=recc(2,3)*lpcty(ny)
            do nx=1,ngx
               gxx=recc(1,1)*lpctx(nx)
               gxy=recc(1,2)*lpctx(nx)
               gxz=recc(1,3)*lpctx(nx)
               gx=gxx+gyx+gzx
               gy=gxy+gyy+gzy
               gz=gxz+gyz+gzz
               dnlg0(nr,1)=gx
               dnlg0(nr,2)=gy
               dnlg0(nr,3)=gz
               nr=nr+1
            enddo
         enddo
      enddo
      return
      end

