#include "definitions.h"
      subroutine anguid(nconso)
      write(nconso,*) '@(#)angula.F	1.22 7/1/99'
      return
      end

      subroutine angula(cptwfp,nplwkp,overls,overlp,overld,atomldos,&
                        nlnum,mmaxx,mmax,&
                        rlog,radius,phiatm,phir2v,&
                        efermi,recc,wtkpt,cvion,&
                        occ,eigen,nkpnum,nkpibz,nkpunf,lkpinv,&
                        ncut,nener,wldos,enemin,enemax,ecut,rcutoff,&
#                       include "apply_h_args.h" 
                        ,timer,nconso)
      use van_us_data_module, only : bohr,linitvkb
      use us_hpsi_module


! Calculate the local density of states, ldos. 
! The one-electron wave functions are projected onto atomic wave functions.
! Wavefunction given in cptwfp. 
! Energy resolved ldos are given in overls,overlp,overld.
! Integral up the Fermi energy are given in  atomldos.

      implicit none
#include H_TIMES_B_DECL

      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      integer    nplwkp
      integer    ncut,nener
      real*8     overls(nions,ncut)
      real*8     overlp(3,nions,ncut),overld(5,nions,ncut)
      real*8     atomldos(nener,9,nions,ncut)
      integer    nlnum(nspec),mmaxx,mmax(nspec)
      real*8     rlog(nspec),radius(mmaxx,nspec)
      real*8     phiatm(mmaxx,0:2,nspec), phir2v(mmaxx)
      real*8     efermi,timer(*)

      real*8     recc(3,3),wtkpt
      complex*16 cvion(nplwv)
      real*8     occ(nbands),eigen(nbands)
      integer    nkpnum, nkpibz(nkpnum),nkpunf(3,3,nkpnum)
      logical*4  lkpinv(nkpnum)
      real*8     wldos,enemin,enemax,ecut,rcutoff

      integer nconso
      

! local variables
!     automatic arrays
      real*8     dwork1(nrplwv,3), sdnlg(nrplwv,3)
      real*8     dwor12(nrplwv,0:8)
      complex*16 cwork2(nrplwv,0:8)
      complex*16 cwor11(nrplwv),phafac(nrplwv),dummy(1) 
      complex*WF_PRECISION spsi(nrplwv),atmpsi(nrplwv),psi(nrplwv)
      complex*WF_PRECISION psi1(nrplwv)
      real*8     worint(mmaxx)
      real*8 vgnl  (nrplwv_global,0:2,nspec)
      

      logical*4 ldoit
      real*8   simps
      external simps
      real*8   scale(0:8),s1(3,3)
      real*8   eps,q1,q2
      logical*4 lproj(0:2)
      logical*4 inversion,lhpsi,lspsi,lcalbec
      parameter(eps=1.0d-7)
      integer    nkp1,nsp,i1,im,ilm,icut,ni,nene,il,nkpall,mu,nb,ig
      integer    niold,ir,m,i,j,immax,nkpused,nn
      real*8     a1,a2,a3,z1,y1,x1,x,y,z
      real*8     fnorm,anorm,fac,arg,bessel,gkdotr,fct
      real*8     wfac,wful,gdotr,dofull,dohalf,ove,rcut
      complex*16 cp,coverl,cnorm,cnorm1,cnorm2
      integer    idebug  
      parameter  (idebug=4) 

      nkpused = nkpnum

! initialize the counters

      do 5000 icut=1,ncut
!        if (nkp.eq.1) then
            do 1020 ni=1,nions
               overls(ni,icut)=0.0d0
               do 1200 im=1,3
                  overlp(im,ni,icut)=0.0d0
 1200          continue
               do 1210 im=1,5
                  overld(im,ni,icut)=0.0d0
 1210          continue
               do 1000 ilm=1,9
                  do 1000 nene=1,nener
                     atomldos(nene,ilm,ni,icut)=0.0d0
 1000             continue
 1010          continue
 1020       continue
!        endif

! Set up the normalized s-,p- and d-wave functions (for R=(0,0,0) )
! for each species
! These atomic functions are expanded in the plane waves for this
! particular k-point. After this expansion, the overlap with the one-
! electron functions is a straight forward dot-product.

         ni=1
         do 3130 nsp=1,nspec
            do 2120 il=0,2

! calculate the integral of j_l(|kr|)*phi_l(r)r^2
! Remember that the phiatm-array contains sqrt(4pi)*phi_l(r)
! The factor sqrt(4pi) will be cancelled by similar terms in the denominator
! of the spherical harmonics and in the expansion of a plane-wave in such.

               lproj(il)=.false.
               if (il.ge.nlnum(nsp)) goto 2110
               lproj(il)=.true.

! Cut off the radial function at rcut [bohr]

               rcut=100.0d0
               if (icut.eq.2) rcut=rcutoff/bohr
               do 2004 ir=1,mmax(nsp)
                  fac = (radius(ir,nsp)-rcut)/0.10d0
                  if (fac.gt.60.0d0) then 
                    fct = 0.0d0 
                  elseif (fac.lt.-60.0d0) then 
                    fct = 1.0d0 
                  else 
                    fct = 1.0d0/(1.0d0+exp(fac))  
                  endif
                  phir2v(ir)=phiatm(ir,il,nsp)*fct
 2004          continue

! Now Fourier transform: Loop over arg=|G+k| in units of 1/bohr

               do 2040 ig=1,nplwkp
                  arg=dnlkg(ig,0,nkp)*bohr
                  do 2000 ir=1,mmax(nsp)
                     worint(ir)=phir2v(ir)*radius(ir,nsp)**2
 2000             continue
                  ldoit=.true.

! Treat the |(G+k) r|=0 analytically (Bessel=1 for s, =0 for p and d)

                  if (arg.lt.1.d-4) then
                     if (il.ne.0) then
                        ldoit=.false.
                     endif
                  else

! Treat the general |(G+k) r|<>0 case numerically

                    do 2030 ir=1,mmax(nsp)

! Set up the spherical Bessel functions: j_0, j_1 or j_2
! j_l+1(kr)=(2*l+1)/kr j_l(kr) - j_l-1(kr), l>0

                     gkdotr=arg*radius(ir,nsp)
                     if (il.eq.0) then
                        if (gkdotr.lt.eps) then 
                          bessel = 1.0d0 
                        else
                          bessel=sin(gkdotr)/gkdotr
                        endif
                     else
                       if (gkdotr.lt.eps) then
                         bessel = 0.0d0 
                       else
                         bessel=(sin(gkdotr)/gkdotr-cos(gkdotr))/gkdotr 
                         if (il.eq.2) then
                           bessel=(3.*bessel-sin(gkdotr))/gkdotr
                         endif
                       endif
                     endif
                     worint(ir)=bessel*worint(ir)
 2030               continue
                  endif

! Perform the integration (if not analytically zero)

                 if (ldoit) then
                  if (radius(1,nsp).lt.eps) then 
                    call radlg(mmax(nsp),worint,radius(1,nsp),&
                             rlog(nsp), q1)
                  else
                    q1 = simps(mmax(nsp),worint,rlog(nsp) )
                  endif
                  vgnl(ig,il,1)=q1*(bohr**3)
                 else
                    vgnl(ig,il,1)=0.0d0
                 endif
 2040         continue

! Continue here if no projection for this il

 2110          continue
               
 2120       continue

! Loop over the symmetry operations that brings this k-point through
! all corresponding k-points outside the IBZ
!          get actual k-point in case of a spin-pol calculation 
           nkp1 = nkp 
           if (nspin.eq.2) nkp1 = nint(float(nkp)/2.0)

            niold=ni
            if (icut.le.2) then
            do 3125 nkpall=1,nkpnum
               if (nkpibz(nkpall).eq.nkp1) then
                  ni=niold
#ifdef DEBUG
             write(*,*) 'ANG: k-points ',nkp1,nkpall,lkpinv(nkpall)
             do i = 1,3   
               write(*,*) 'ANG: k-points ',(nkpunf(i,j,nkpall),j=1,3)
             enddo
#endif DEBUG


! Change the cosine's (G+k)_i/|G+k|, to be applicable for this k-point.
! Note that the G's will now be in an unknown order (no ipwpad array
! can put then in the FFT grid). This however doesn't disturb for
! the present purpose, where only dot-products are to be calculated

! nkpibz(x=1..nkpnum):     The index of which IBZ k-point corresponds
!                          to the x'th k-point in the 1st Brillouin zone
! nkpunf(3,3,x=1..nkpnum): The matrix bringing the nkpibz(x)'th k-point
!                          from the IBZ to the x'th k-point in the
!                          1st Brillouin zone
! lkpinv: True if the nkpunf has been added the inversion without this
!         being present in the space group

! Generate the S^-1 matrix in Cartesian coordinates
                  call cartsG(dirc,recc,nkpunf(1,1,nkpall),s1)
                  do 6000 ig=1,nplwkp
                     do i = 1,3
                       dwork1(ig,i)=s1(i,1)*dnlkg(ig,1,nkp)&
                                   +s1(i,2)*dnlkg(ig,2,nkp)&
                                   +s1(i,3)*dnlkg(ig,3,nkp)
                       sdnlg(ig,i)= s1(i,1)*dnlg(ig,1,nkp)&
                                   +s1(i,2)*dnlg(ig,2,nkp)&
                                   +s1(i,3)*dnlg(ig,3,nkp)
                     enddo
 6000             continue

!                 recalculate vkb so that S|atmpsi> will be calculated correct,
!                 using sdnlg instead of dnlg
!                 argument cptwfp is not relevant. 
                  linitvkb(nkp) = .true.
                  nn = 1
                  call cal_vkb(nplwv,nrplwv,nrplwv_global,nplwkp,nkp, &
     &               nions,nspec,nionsp,nkpmem, &
     &               nbands,nkprun,sdnlg,posion,dirc,volc, &
     &               ngxs,ngys,ngzs,ecut,idebug,recc &
#ifdef PARAL
     &               , & 
#include             PARAL_ARGS
#endif
                      ) 

! Find the s,p and d wavefunctions in dwor12(:,0:8)
!                 
! s-radial function
                  il=0
                  if (lproj(il)) then
                     anorm = 0.0d0 
                     do 2050 ig=1,nplwkp
                        dwor12(ig,0) = vgnl(ig,il,1)
                        anorm = anorm + vgnl(ig,il,1)**2
 2050                continue
                  endif

! Multiply the p-radial function with the spherical harmonic + normalize

                  il=1
                  if (lproj(il)) then
                     do 2080 im=1,3
                        do 2070 ig=1,nplwkp
                           dwor12(ig,im)=vgnl(ig,il,1)*dwork1(ig,im)
 2070                   continue
 2080                continue
                  endif

! Multiply the d-radial function with the spherical harmonic + normalize
! The latter are the normalized versions of:
! 1: Y_20   2: Y_22+Y_2-2   3: Y_22-Y_2-2   4: Y_21-Y_2-1   5: Y_21+Y_2-1

                  il=2
                  if (lproj(il)) then
                     do 3070 m=1,nplwkp
                      dwor12(m,4)=vgnl(m,il,1)*&
                                  (3.d0*dwork1(m,3)**2-1.0d0)
                      dwor12(m,5)=vgnl(m,il,1)*(dwork1(m,1)**2&
                                                      -dwork1(m,2)**2)
                      dwor12(m,6)=vgnl(m,il,1)*dwork1(m,1)*dwork1(m,2)
                      dwor12(m,7)=vgnl(m,il,1)*dwork1(m,1)*dwork1(m,3)
                      dwor12(m,8)=vgnl(m,il,1)*dwork1(m,2)*dwork1(m,3)
 3070                continue
                  endif

! loop over the atoms of this species

                  do 3120 mu=1,nionsp(nsp)

! initialize phasefactors for this atom

               x=posion(1,mu,nsp)*dirc(1,1)+&
                 posion(2,mu,nsp)*dirc(2,1)+posion(3,mu,nsp)*dirc(3,1)
               y=posion(1,mu,nsp)*dirc(1,2)+&
                 posion(2,mu,nsp)*dirc(2,2)+posion(3,mu,nsp)*dirc(3,2)
               z=posion(1,mu,nsp)*dirc(1,3)+&
                 posion(2,mu,nsp)*dirc(2,3)+posion(3,mu,nsp)*dirc(3,3)
               do 3000 ig=1,nplwkp
                  gdotr=dwork1(ig,1)*x+dwork1(ig,2)*y+dwork1(ig,3)*z
                  gdotr=gdotr*dnlkg(ig,0,nkp)
                  phafac(ig)=dcmplx(cos(gdotr),sin(gdotr))
 3000          continue

!======================================================================
! Normalize the atomic s,p and d functions.
! If ultra-soft pp is used <atm_psi|S|atm_psi> should be normalized.
                  immax = 0
                  if (lproj(1)) immax = 3
                  if (lproj(2)) immax = 8
                  do im = 0,immax
                    do ig = 1,nplwkp
!                     move atomic orbital to the right position
                      atmpsi(ig) = conjg(phafac(ig))*&
                            dcmplx(dwor12(ig,im),0.0d0)
                      spsi(ig)   = atmpsi(ig)
                    enddo

                    lhpsi = .false.
                    lspsi = .true.
                    lcalbec = .true.
                    call S_TIMES_B(spsi,nplwkp,lhpsi,lspsi,lcalbec,1,&
#include                           H_TIMES_B_ARGS
                                   ,timer,reci_psi=atmpsi)

                    cnorm = dcmplx(0.0d0,0.0d0)
                    do ig = 1,nplwkp
                      cnorm = cnorm + conjg(atmpsi(ig))*spsi(ig)
!                     now move S|atmpsi> back to (0,0,0)
                      cwork2(ig,im) = phafac(ig)*spsi(ig)
                    enddo
                    scale(im) = 1.0d0/dble(cnorm)
                  enddo
!=====================================================================

! Loop over the bands

               do 3110 nb=1,nbands

                  wfac=occ(nb)/dble(nkpused)
                  wful=2.0d0  /dble(nkpused)/dble(nspin)

#ifdef CHKNORM
!                 check norm of wavefunctions
                  if (.not.lkpinv(nkpall)) then
                     do  ig=1,nplwkp
                        psi1(ig)=cptwfp(ig,nb)
                     enddo   
                  else
                     do ig=1,nplwkp
                       psi1(ig)=conjg(cptwfp(ig,nb))
                     enddo    
                  endif
                  call S_TIMES_B (psi1,dummy(1),spsi,nplwkp,&
                       .FALSE.,.TRUE.,&
#include                H_TIMES_B_ARGS
                        )
                  cnorm = dcmplx(0.0d0,0.0d0)
                  do ig = 1,nplwkp
                    cnorm = cnorm + conjg(psi1(ig))*spsi(ig)
                  enddo
                  write(*,*) 'angula norm ',nb,nkpall,cnorm
#endif CHKNORM

! If   S belongs to the space group:  no problem
! else the inversion has been added - and the wavefunction coefficients
!      must be complex conjugated

                   if (.not.lkpinv(nkpall)) then
                     do 3010 ig=1,nplwkp
                       cwor11(ig)=phafac(ig)*cptwfp(ig,nb)
 3010                continue
                   else
                     do 3015 ig=1,nplwkp
                       cwor11(ig)=phafac(ig)*conjg(cptwfp(ig,nb))
 3015                continue
                  endif

! Treat the s-potential

                  if (lproj(0)) then
                     coverl=dcmplx(0.0d0,0.0d0)
                     do 3020 ig=1,nplwkp
                        coverl=coverl+cwor11(ig)*cwork2(ig,0)
 3020                continue
                     ove=scale(0)*dble(conjg(coverl)*coverl)
!                    write(*,*) 'angula s-over',nb,mu,nkpall,ove,wfac
                     call ldosad(ove*wful,atomldos(1,1,ni,icut),&
                                 eigen(nb)-efermi,wldos,nener,&
                                 enemin,enemax)
                     overls(ni,icut)=overls(ni,icut)+ove*wfac
                  endif

! Projection onto Y_l=1,m

                  if (lproj(1)) then
                     do 3060 im=1,3
                        coverl=dcmplx(0.0d0,0.0d0)
                        do 3050 ig=1,nplwkp
                           coverl=coverl+cwor11(ig)*cwork2(ig,im)
 3050                   continue
                        ove=scale(im)*dble(conjg(coverl)*coverl)
                        call ldosad(ove*wful,atomldos(1,1+im,ni,icut),&
                                 eigen(nb)-efermi,wldos,nener,&
                                 enemin,enemax)
                        overlp(im,ni,icut)=overlp(im,ni,icut)+ove*wfac
 3060                continue
                  endif

! Projection onto Y_l=2,m

                  if (lproj(2)) then

! Calculate the F(m)=Sum_G' [ <j_2 dV phi|G'+k> Y(l=2,m)(G'+k) <G'+k|psi> ]

                     do 3100 im=1,5
                        coverl=(0.0d0,0.0d0)
                        do 3090 ig=1,nplwkp
                           coverl=coverl+cwor11(ig)*cwork2(ig,3+im)
 3090                   continue
                        ove=scale(im+3)*dble(conjg(coverl)*coverl)
                        call ldosad(ove*wful,atomldos(1,4+im,ni,icut),&
                                 eigen(nb)-efermi,wldos,nener,&
                                 enemin,enemax)
                        overld(im,ni,icut)=overld(im,ni,icut)+ove*wfac
 3100                continue
                  endif
 3110          continue
               ni=ni+1
 3120       continue
            endif
 3125       continue
         endif
 3130    continue

 5000 continue

      return
      end

      subroutine anguwr (kspin, ncut, nkprun, nions, nener,&
         enemin, enemax, overls, overlp, overld, aoldos,nspin)
      
      use netcdfinterface
      use run_context

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)

      dimension aoldos(nener,9,nions,ncut,nspin)
      dimension overls  (nions,ncut,nkprun)
      dimension overlp(3,nions,ncut,nkprun)
      dimension overld(5,nions,ncut,nkprun)
      dimension ovlp(9,2)
      integer   kspin(nkprun)
      character*2 spintxt(2)
      double precision energygrid(nener)
      integer          ordinal_map(9,ncut,nions)
      integer          ncid, status

!........................................................................
!     NetCDF mapping
!     Sum_k (overls, overlp, overld) -> AtomProjectedDOS_IntegratedDOS
!     aoldos                         -> AtomProjectedDOS_EnergyResolvedDOS
!     energygrid                     -> AtomProjectedDOS_EnergyGrid
!     ordinal_map                    -> AtomProjectedDOS_OrdinalMap
!........................................................................

      status = nf_open(netCDF_output_filename,NF_WRITE, ncid)
      if (status /= nf_noerr) stop "nf_open: error in angwr"

      call set_dos_grid(energygrid,nener,enemin,enemax)
      call set_ordinal_map(ordinal_map,9,ncut,nions)

      call setup_ldos_netcdf_defs(ncid, nener,9,ncut,nions,&
                                  energygrid,ordinal_map)

      spintxt(1) = 'UP'
      spintxt(2) = 'DN'
      if (nspin.eq.1) spintxt(1) = ' '

       do 5000 icut=1,ncut
        write(nconso,4010) 'atm','s','p_x','p_y','p_z',&
                          'd_zz','dxx-yy','d_xy','d_xz','d_yz'
 4010    format(1x,'AO_OVL  ',a5,9a7)

!        Sum up k-point contributions to the spin-state
!        given by kspin(nkp)

         do 4000 ni=1,nions
            do 1000 ilm = 1, 9
               ovlp(ilm,1) = 0.0d0
               ovlp(ilm,2) = 0.0d0
1000        continue
            do 1100 nkp = 1, nkprun
!              get spin state for this k-point
               ispin = kspin(nkp)
               ovlp(1,ispin) = ovlp(1,ispin) + overls(ni,icut,nkp)
               do 1050 im = 1, 3
                 ovlp(1+im,ispin) = ovlp(1+im,ispin)+&
                                    overlp(im,ni,icut,nkp) 
1050           continue
               do 1060 im = 1, 5
                 ovlp(4+im,ispin) = ovlp(4+im,ispin)+&
                                    overld(im,ni,icut,nkp)
1060           continue
1100        continue

            do 4050 ispin = 1,nspin 
              write(nconso,4020) icut,spintxt(ispin),ni,&
                                 (ovlp(ilm,ispin),ilm=1,9)
 4020         format(1x,'AO_OVL',i1,a2,i4,9f7.3)

! ............ add 1 to ordinal_map to get fortran index ....

              status = nfput(ncid,"AtomProjectedDOS_IntegratedDOS",&
                           ovlp(:,ispin),&
                           startnf=(/ispin, ordinal_map(1,icut,ni)+1/),&
                           countnf=(/1,9/))
              if (status /= nfif_ok) &
                  stop "nfput: AtomProjectedDOS_IntegratedDOS"

 4050       continue
  
 4000    continue

         do ispin = 1,nspin
           call ldoswr(aoldos,nener,nions,ncut,nspin,&
                 enemin,enemax,nconso,icut,ispin)
         enddo

 5000  continue

       call netcdf_write_aoldos(ncid,nener,9,nions,ncut,nspin,&
                                aoldos,ordinal_map, &
                                dble(nener-1)/(enemax-enemin)/2.0d0)

      status = nf_close(ncid) 
      if (status /= nf_noerr) stop "nf_close: error"


      return
      end
!......................................................................
      subroutine ldosad(ove,atomldos,eigen,wldos,nener,enemin,enemax)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension atomldos(nener)

      xdel=(enemax-enemin)/dble(nener-1)
      do 1000 nene=1,nener
         e1=xdel*(-0.5d0+nene-1)+enemin
         e2=xdel*( 0.5d0+nene-1)+enemin
         x1 = (e1 - eigen)/wldos
         x2 = (e2 - eigen)/wldos
         atomldos(nene) = atomldos(nene) + ove*( erfc(x1) - erfc(x2) )
 1000 continue
      return
      end
!....................................................................
      subroutine ldoswr(atomldos,nener,nions,ncut,nspin,enemin,enemax,&
                        nconso,icut,ispin)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension atomldos(nener,9,nions,ncut,nspin)
      character*2 spintxt(2)

      spintxt(1) = 'UP'
      spintxt(2) = 'DN'
      if (nspin.eq.1) spintxt(1) = ' '

      xdel=(enemax-enemin)/dble(nener-1)
      rdel=1.0d0/(2.0d0*xdel)
      do 1020 ni=1,nions
         do 1010 nene=1,nener
            e=xdel*dble(nene-1)+enemin
            write(nconso,1030) icut,spintxt(ispin),ni,e,&
                        (atomldos(nene,ilm,ni,icut,ispin)*rdel,ilm=1,9)
 1010    continue
 1020 continue
 1030 format(1x,'AO_LDOS',i1,a2,i3,f12.6,9f6.3)
      return
      end


      subroutine setup_ldos_netcdf_defs(ncid, nener,lmax,ncut,nions,&
                                        energygrid, ordinal_map)
!----------------------------------------------------------------
!     Auxillary function for netCDF write: make variable/attribute defs
!     NetCDF variable definitions etc
!
!     Sum_k (overls, overlp, overld) -> AtomProjectedDOS_IntegratedDOS
!     aoldos                         -> AtomProjectedDOS_EnergyResolvedDOS
!     energygrid                     -> AtomProjectedDOS_EnergyGrid
!     ordinal_map                    -> AtomProjectedDOS_OrdinalMap
!     setup netCDF dimensions: nener -> atomdos_energygrid_size
!                              lmax  -> atomdos_angular_channels
!                              ncut  -> atomdos_radial_orbs
!                   nions*lmax*ncut  -> atomdos_projections  (diagonal value)
!     At end: write auxillary arrays
!       energygrid   ->  AtomProjectedDOS_EnergyGrid
!       ordinal_map  ->  AtomProjectedDOS_OrdinalMap
!----------------------------------------------------------------
      use netcdfinterface
      use run_context

      implicit none
      integer          ncid, nener,lmax,ncut,nions
      double precision energygrid(nener)
      integer          ordinal_map(lmax,ncut,nions)
      integer          status,l,n
      integer          netcdf_ordinal_map(lmax,ncut,nions)

!.................................................
!
! ....... define dimensions ..........
!
      status = nfputglobaldim(ncid, "atomdos_energygrid_size", nener)

      if ((status /= nfif_ok).and.(status/=nfif_dimexist_butOKsize))&
          stop "nfputglobaldim: atomdos_energygrid_size"

      status = nfputglobaldim(ncid, "atomdos_angular_channels", lmax)
      if ((status /= nfif_ok).and.(status/=nfif_dimexist_butOKsize))&
          stop "nfputglobaldim: atomdos_angular_channels"

      status = nfputglobaldim(ncid, "atomdos_radial_orbs",      ncut)
      if ((status /= nfif_ok).and.(status/=nfif_dimexist_butOKsize)) &
          stop "nfputglobaldim: atomdos_radial_orbs"

      status = nfputglobaldim(ncid, "atomdos_projections", &
                              nions*lmax*ncut)
      if ((status /= nfif_ok).and.(status/=nfif_dimexist_butOKsize)) &
          stop "nfputglobaldim: atomdos_projections"
!
! ....... define variables ..........
!
      status = nfdefvar(ncid, "AtomProjectedDOS_IntegratedDOS", &
                        NF_DOUBLE,&
                        dim_name1="number_of_spin",&
                        dim_name2="atomdos_projections")
      if (status /= nfif_ok) &
          stop "nfdefvar: AtomProjectedDOS_IntegratedDOS"

      status = nfdefvar(ncid, "AtomProjectedDOS_EnergyResolvedDOS", &
                        NF_DOUBLE,&
                        dim_name1="atomdos_energygrid_size", &
                        dim_name2="number_of_spin", &
                        dim_name3="atomdos_projections")
      if (status /= nfif_ok) &
          stop "nfdefvar: AtomProjectedDOS_EnergyResolvedDOS"

      status = nfdefvar(ncid, "AtomProjectedDOS_EnergyGrid",&
                        NF_DOUBLE,&
                        dim_name1="atomdos_energygrid_size")
      if ((status /= nfif_ok).and.(status/=nfif_varexist_butOKdef)) &
          stop "nfdefvar: AtomProjectedDOS_EnergyGrid"

      status = nfdefvar(ncid, "AtomProjectedDOS_OrdinalMap",&
                        NF_INT,&
                        dim_name1="atomdos_angular_channels", &
                        dim_name2="atomdos_radial_orbs", &
                        dim_name3="number_of_dynamic_atoms")
      if ((status /= nfif_ok).and.(status/=nfif_varexist_butOKdef)) &
          stop "nfdefvar: AtomProjectedDOS_OrdinalMap"
!  
!  ....... set misc attributes .......
!
      status = nfput(ncid,"AtomProjectedDOS_IntegratedDOS%Description",&
                          "LDOS integrated up to the Fermi level")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_IntegratedDOS%Description"

      status =nfput(ncid,&
                   "AtomProjectedDOS_EnergyResolvedDOS%Description", &
                   "Energy resolved LDOS")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_EnergyResolvedDOS%Description"

      status = nfput(ncid,&
                    "AtomProjectedDOS_EnergyResolvedDOS%EnergyGrid", &
                    "netCDF variable: AtomProjectedDOS_EnergyGrid")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_EnergyResolvedDOS%EnergyGrid" 

      status = nfput(ncid,"AtomProjectedDOS_OrdinalMap%Description", &
              "Provides a map from quantum numbers to pure "//&
              "orbital sequence number")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_OrdinalMap%Description"

      status =nfput(ncid,"AtomProjectedDOS_OrdinalMap%AngularChannels", &
                    "s, p_x, p_y, p_z, d_zz, dxx-yy, d_xy, d_xz, d_yz")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_OrdinalMap%AngularChannels" 

      status = nfput(ncid,"AtomProjectedDOS_OrdinalMap%Description",   &
                           "Energy grid for AtomProjected LDOS")
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_OrdinalMap%Description"


! ... write auxillary maps: energygrid, ordinal_map
      

      status = nfput(ncid,"AtomProjectedDOS_EnergyGrid", energygrid)
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_EnergyGrid"


! ... convert the ordial_map to netcdf internal order netcdf_ordinal_map(lmax,ncut,nions)
      netcdf_ordinal_map = ordinal_map
      do l = 1,lmax 
        do n = 1,ncut 
           call Reorder_atomvector(nconso, netcdf_ordinal_map(l,n,:), "internal_to_netCDF")
        enddo 
      enddo
      status = nfput(ncid,"AtomProjectedDOS_OrdinalMap", netcdf_ordinal_map)
      if (status /= nfif_ok) &
          stop "nfput: AtomProjectedDOS_OrdinalMap"
!----------------------------------------------------------------
      end


      subroutine netcdf_write_aoldos(ncid,nener,lmax,nions,ncut,nspin,&
                                     aoldos,ordinal_map, normfac)
!----------------------------------------------------------------
!     Auxillary function for netCDF write
!----------------------------------------------------------------
      use netcdfinterface
      use run_context

      implicit none
      integer          ncid,nener,lmax,nions,ncut,nspin
      double precision aoldos(nener,lmax,nions,ncut,nspin),normfac
      integer          ordinal_map(lmax,ncut,nions)

      integer          status, il,icut,ion,ispin
      integer          netcdf_aoldos(nener,lmax,nions) ! for writing in Netcdf order


      do icut = 1, ncut
         do ion = 1, nions
               do il = 1, lmax  
      do ispin = 1, nspin
!.................  add 1 to ordinal_map to get fortran index ....
                  status = nfput(ncid,&
                      "AtomProjectedDOS_EnergyResolvedDOS",&
                       normfac*aoldos(:,il,ion,icut,ispin),&
                       startnf=(/1,ispin,ordinal_map(il,icut,ion)+1/),&
                       countnf=(/nener,1,1/) )
                  if (status /= nfif_ok) &
                       stop "nfput: AtomProjectedDOS_EnergyResolvedDOS"
               enddo
            enddo
         enddo
      enddo
!----------------------------------------------------------------
      end



      subroutine set_dos_grid(energygrid,nener,enemin,enemax)
!----------------------------------------------------------------
!     Auxillary function for netCDF write: set the energy grid of 
!     AtomProjectedDOS_EnergyResolved into work array energygrid
!----------------------------------------------------------------
      implicit none
      integer nener
      double precision energygrid(nener), enemin, enemax
      integer nene
      double precision xdel

      xdel=(enemax-enemin)/dble(nener-1)
      do nene=1,nener
         energygrid(nene)=xdel*dble(nene-1)+enemin
      enddo
!----------------------------------------------------------------
      end

      subroutine set_ordinal_map(ordinal_map,lmax,ncut,nions)
!----------------------------------------------------------------
!     Auxillary function for netCDF write: set the ordinal map, i.e.
!     (L,n,R) -> projection number for the diagonal density matrix
!
!  ===> SET ORDINAL MAP ACCORDING TO C-INDEXING, I.E. STARTING AT 0 <===
!  ===> FORTRAN USERS MUST ADD 1                                    <===
!----------------------------------------------------------------
      implicit none
      integer  lmax,ncut,nions
      integer  ordinal_map(lmax, ncut, nions)
      integer  l,iorb,ion,inc
      inc = 0
      do ion = 1,nions
         do iorb = 1, ncut
            do l = 1, lmax
               ordinal_map(l,iorb,ion) = inc
               inc = inc + 1 
            enddo
         enddo
      enddo
!----------------------------------------------------------------
      end

      subroutine angfft(cinG,coutR,&
           nplwkp,ngx,ngy,ngz,nplwv,nrplwv,ipwpad )

      implicit none

      integer nplwv
      integer nrplwv
      complex*16 coutR(nplwv)
      complex*16 cinG(nrplwv)
      integer nplwkp
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)

!     locals

      integer m,ig
      

      do 6350 m=1,nplwv
         coutR(m)=(0.0d0,0.0d0)
 6350 continue
!     Fold the wavefunction into the 3D-FFT grid
      do 6360 ig=1,nplwkp
         coutR(ipwpad(ig))=cinG(ig)
 6360 continue
      
!     transform the wavefunction into real space
      
      call fft3d(coutR,ngx,ngy,ngz,1)
      
      return
      end

      subroutine angfre(rinG,coutR,&
           nplwkp,ngx,ngy,ngz,nplwv,nrplwv,ipwpad )

      implicit none

      integer nplwv
      integer nrplwv
      real*8  rinG(nrplwv)
      complex*16 coutR(nplwv)
      integer nplwkp
      integer ngx,ngy,ngz
      integer ipwpad(nrplwv)

!     locals

      integer m,ig
      

      do 6350 m=1,nplwv
         coutR(m)=(0.0d0,0.0d0)
 6350 continue
!     Fold the wavefunction into the 3D-FFT grid
      do 6360 ig=1,nplwkp
         coutR(ipwpad(ig))=rinG(ig)
 6360 continue
      
!     transform the wavefunction into real space
      
      call fft3d(coutR,ngx,ngy,ngz,1)
      
      return
      end



#ifdef NEVER
!------------------------ not used -----------------------------------
! Begin shifting the origin
! set flag that the origin hasn't been shifted for this k-point

      iorigi=0
 
! Usage:
!  The ionic positions are changed (by hand) from
!  the old run (with an existing wavefunction file) to the
!  new run by adding (1-a1,1-a2,1-a3).
!  Therefore, the new origin expressed in the old coordinates
!  lies at (a1,a2,a3), and every wavefunction must be multiplied
!  with the proper phasefactor, exp((G+k).(a1,a2,a3)).
 
                  if (iorigi.eq.0) then
                     a1=0.0d0
                     a2=0.0d0
                     a3=0.0d0
 
! Convert to cartesian coordinates

                     x1=a1*dirc(1,1)+a2*dirc(2,1)+a3*dirc(3,1)
                     y1=a1*dirc(1,2)+a2*dirc(2,2)+a3*dirc(3,2)
                     z1=a1*dirc(1,3)+a2*dirc(2,3)+a3*dirc(3,3)
 
! Loop over plane waves for this particular band (and k-point)
 
                     do 3005 m=1,nplwkp
                      gdotr=dwork1(m,1)*x1+dwork1(m,2)*y1+dwork1(m,3)*z1
                        gdotr=gdotr*dnlkg(m,0,nkp)
                        cp=dcmplx(cos(gdotr),sin(gdotr))
                        spsi(m)=cp*spsi(m)
 3005                continue
                     if (nb.eq.nbands) iorigi=1
                  endif
 
! End shifting the origin
#endif NEVER

