#include "definitions.h"
      subroutine addusdens_id(nconso)
      write(nconso,*) '@(#)addusdens.F	1.15 7/1/99'
      return
      end
!------------------------------------------------------------------------------
      subroutine addusdens( &
                  nplwv,nrplwv,nrplwv_global,nions,nspec,&
                  nionsp, nbands, nkprun, wtkpt, kpoint, occ, &
                  efermi,eigen, rdensr,  &
                  ngx,ngy,ngz,&
                  posion,dirc,volc,nconso&
#ifdef PARAL
                  ,&
#include PARAL_ARGS
#endif
                 ,timer)
!------------------------------------------------------------------------------
!
!   For the US pseudo-potential add the hard-part of the density. 
!
!    1.  becsum(n,m,I) =  sum(i) <psi_i|beta_n> <beta_m|psi_i>   (I site index) 

!    2.  calculate Qnm from qrad in calcusdens

!    3.  n(G)_hard = sum(i,nm,I)   Qnm(G) <psi_i|beta_n> <beta_m|psi_i>

!    2.  Fourier transform n(G)_hard to realspace

!    3.  add to rdensr(r) 
!      
!-----------------------------------------------------------------------------
      use van_us_data_module
      implicit none
      integer nplwv,nrplwv,nrplwv_global,nions,nspec,nionsp(nspec)
      integer nbands,nkprun,kpoint
      real*8  efermi,eigen(nbands), wtkpt(nkprun),occ(nbands,nkprun)
      real*8  rdensr(nplwv)
      integer ngx,ngy,ngz
      real*8  posion(3,nions,nspec),dirc(3,3),volc
      integer nconso
#ifdef PARAL
#include      PARAL_DECL
#endif
      real*8 timer(*)

!     local arrays (automatic) 
      complex*16 qg(ngdens_max), aux(nplwv)

      integer jkb,kbnd,i,iv,jv,na,it,n1
      real*8  w,wg
      real*8 ZERO 
      parameter (ZERO=0.0d0) 


!     first calculate becsum, sum_{a in occ} <a|b_n><b_m|a>
      w=1.0d0*wtkpt(kpoint)
!     zero becsum for this k-point
      becsum(1:nhm,1:nhm,1:nions,kpoint) = 0.0d0
!     loop over bands
      do kbnd=1, nbands
          wg  =  occ(kbnd,kpoint)
          jkb = 0
          do na = 1, nions
               it = ityp(na)
               do iv=1, nh(it)
                 do jv=iv, nh(it)
                   becsum(iv,jv,na,kpoint) = becsum(iv,jv,na,kpoint)+w*wg*&
                          conjg(becp(jkb+iv,kbnd,kpoint))*&
                          becp(jkb+jv,kbnd,kpoint)
                 enddo
               enddo
               jkb = jkb +nh(it)
          enddo
      enddo
      do na = 1, nions
         it = ityp(na)
         do iv=1, nh(it)
            do jv=iv+1, nh(it)
               becsum(jv,iv,na,kpoint) = conjg(becsum(iv,jv,na,kpoint))
            enddo
         enddo
      enddo

      qg(1:ngdens_max) = dcmplx(0.0d0,0.0d0) 
      aux(1:nplwv)     = dcmplx(0.0d0,0.0d0) 
!     calculate bec_n bec_m q_nm in fourier space
      call calcusdens(&
              nplwv,nrplwv,nrplwv_global,nions,nspec,&
              nionsp,nbands, nkprun, kpoint,qg,&
              posion,dirc,volc,.false.,0,nconso&
#ifdef PARAL
                  ,&
#include PARAL_ARGS
#endif 
                 ,timer)

!     write(nconso,*) 'Number of US electrons ',qg(1),kpoint
!     call uflush(nconso)
      do i=1,ngdens_max
         aux(ipwpadG(i,0)) = qg(i)
      enddo
!     convert aux to realspace
      call fft3d(aux,ngx,ngy,ngz,1)
      do i=1,nplwv
         rdensr(i)  = rdensr(i) + dble(aux(i))
      end do

      return
      end

      subroutine xydens(ngx,ngy,ngz,rdensr,aux) 

      implicit   none
      integer    ngx,ngy,ngz
      complex*16 rdensr(ngx,ngy,ngz)
      complex*16 aux(ngx,ngy,ngz) 
      real*8     d1,d2,d1all,d2all
      integer    nx,ny,nz


      d1all = 0.0d0
      d2all = 0.0d0
      do nz = 1,ngz
        d1 = 0.0d0
        d2 = 0.0d0
        do nx = 1,ngx
          do ny = 1,ngy
             d1 = d1 + dble(rdensr(nx,ny,nz) )
             d2 = d2 + dble(aux(nx,ny,nz))
             d1all = d1all + rdensr(nx,ny,nz)
             d2all = d2all + dble(aux(nx,ny,nz))
          enddo
        enddo
        write(*,*) 'DENS ',nz,d1/dble(ngx*ngy),d2/(ngx*ngy)
      enddo
        write(*,*) 'SUMDENS ',d1all,d2all
      return 
      end

      subroutine xydens1(ngx,ngy,ngz,rdensr,aux)
 
      implicit   none
      integer    ngx,ngy,ngz
      real*8     rdensr(ngx,ngy,ngz)
      complex*16 aux(ngx,ngy,ngz)
      real*8     d1,d2,d1all,d2all
      integer    nx,ny,nz
 
 
      d1all = 0.0d0
      d2all = 0.0d0
      do nz = 1,ngz
        d1 = 0.0d0
        d2 = 0.0d0
        do nx = 1,ngx
          do ny = 1,ngy
             d1 = d1 + rdensr(nx,ny,nz)
             d2 = d2 + dble(aux(nx,ny,nz))
             d1all = d1all + rdensr(nx,ny,nz)
             d2all = d2all + dble(aux(nx,ny,nz))
          enddo
        enddo
        write(*,*) 'DENS ',nz,d1/dble(ngx*ngy),d2/(ngx*ngy)
      enddo
        write(*,*) 'SUMDENS ',d1all,d2all
      return
      end

      


!----------------------------------------------------------------------
      subroutine calcusdens(&
                      nplwv,nrplwv,nrplwv_global,nions,nspec, &
                      nionsp,nbands, nkprun, kpoint,qg,&
                      posion,dirc,volc,use_dylm,index,nconso&
#ifdef PARAL
                  ,&
#include PARAL_ARGS
#endif 
                 ,timer)
!---------------------------------------------------------------------- 
! 
!     Calculate Qnm <psi|beta><beta|psi> in reciprocal space
!
!     input  : 
!                qr   :  Q_L(|r|) in reciprocal space  (qrad) 
!                becs :  sum(i) <beta_n|psi_i> <psi_i|beta_m>
!                ylm  :  spherical-harmonic calculated in setuspot 
!
!     output : 
!               qg  : Qnm <psi|beta> <beta|psi> 
!               aux : structure factor 
!                                        ^
!     1.  Q_nm(G) = sum(LM) c(LM,nm) Ylm(G)  Q_L(nm)  
!         c(LM,nm) is Clebsch-Gordon coefficients
! 
!          I 
!     2.  Q_nm(G)  = Qnm(G)  exp(-i G R ) 
!
!                    I               I I    
!     3.  sum(I,nm) Q_nm(G) <psi|beta> <beta|psi>  
!
!     If use_dylm is true d Ylm/dx1x2 is used in place of 
!     Ylm (used only by stress_us) 
!
!----------------------------------------------------------------------
      use van_us_data_module
      use stress_module, only : x1_index,x2_index
#ifdef PARAL 
      use par_functions_module
#endif PARAL
      implicit   none 
      integer    nplwv,nrplwv,nrplwv_global,nions,nspec,nionsp(nspec)
      integer    nbands,nkprun,kpoint
      complex*16 qg(ngdens_max)
      real*8     posion(3,nions,nspec),dirc(3,3)
      real*8     volc
      logical*4  use_dylm
      integer    index
      integer    nconso
      real*8     timer(*)
#ifdef PARAL
#include      PARAL_DECL
#endif

!     locals 
      integer recl,j  
#ifdef VPP500
      parameter(recl = 2048)
#else 
      parameter(recl = 1024)
#endif
      complex*16 aux1(recl)
      complex*16 strfac(recl) 
      complex*16 qgm(recl,(nhm*(nhm+1))/2)
      real*8 ylmk0(recl ,lqx*lqx),gx1gx2divgabs(recl)

      integer    inr,jkb,i,nsp,iv,jv,na,ik,mu,x1,x2
      integer    imin,imax,nnh
      real*8     arg,xyz(3),ZERO,eps 
      real*8     g1(ngdens,3),gg1(ngdens)
      parameter  (ZERO=0.0d0,eps=1d-10)
      logical*4  lrec

!     For parallel program we need to use g1
!     goffs = 0 for serial program
      do i = 1,ngdens
        do j = 1,3
          g1(i,j) = g(i+goffs,j)
        enddo
        gg1(i) = gg(i+goffs)
      enddo

 
#ifdef QRAD_SWAP 
      if (nspec.gt.1) then
         call openqrad(ngl)
      endif
#endif QRAD_SWAP
 
!     calculate bec_n bec_m q_nm in fourier space
      do nsp =1,nspec

#ifdef QRAD_SWAP 
            if (nspec.gt.1) then 
              call readqrad(ngldim,ngl,nsp,qrad,maxindex) 
            endif
#endif QRAD_SWAP


            imax = 0
            lrec = .true. 
10          continue
            imin = imax
            imax = imin + recl
            if (imax.ge.ngdens) then 
               imax=ngdens 
               lrec=.false. 
            endif

           
            if (use_dylm) then 
                x1 = x1_index(index)
                x2 = x2_index(index)
                if (abs(gg(imin+1)).lt.eps) then 
                  gx1gx2divgabs(1) = 0.0d0
                  do ik = imin+2,imax
                    gx1gx2divgabs(ik-imin) = g(ik,x1)*g(ik,x2)/gg(ik)
                  enddo         
                else
                  do ik = imin+1,imax
                    gx1gx2divgabs(ik-imin) = g(ik,x1)*g(ik,x2)/gg(ik)
                  enddo         
                endif
                call dylmr2(lqx**2,imin,imax,ngdens,g1,gg1, & 
                            recl, (lqx)**2,ylmk0, gx1gx2divgabs, x1,x2)        
            else
!             calculate ylmk0 for imin,imax
              call ylmr2(lqx**2,imin,imax,ngdens,g1,gg1,recl,&
                    (lqx)**2,ylmk0)
            endif

            inr = 1
            nnh = nh(nsp)
            do iv = 1, nnh
              do jv = iv, nnh
!               get Qnm (qgm) 
                call qvan2(imin,imax,iv,jv,nsp,recl,qgm(1,inr),ylmk0,&
                 qrad,ngdens_max,nspec,ngldim,igtongl,nhm,indv,&
                 nhtol,nhtom,ap,lpx,lpl,ivjv2index, & 
                 nbrx,nlx,mx,nbrx2dim,lqx)
                inr = inr + 1
               enddo
            enddo
            do na = 1,nions
              if (ityp(na).eq.nsp) then 
!                get the structure factor
                 call xyzposna(nions,nspec,nionsp,posion,na,dirc,xyz)
                 do ik=imin+1,imax
                     arg = (g(ik+goffs,1)*xyz(1)+g(ik+goffs,2)*xyz(2)&
                            + g(ik+goffs,3)*xyz(3))
                     strfac(ik-imin) = dcmplx(cos(arg),-sin(arg))
                 enddo

                 inr = 1
                 aux1(1:recl) = dcmplx(0.0d0,0.0d0) 
                 do iv = 1, nh(nsp)
                    do jv = iv, nh(nsp)
                      if (iv .eq. jv) then
                        do i=1,imax-imin
                          aux1(i)=aux1(i)+qgm(i,inr)*becsum(iv,jv,na,kpoint)
                        enddo
                      else
                        do i=1,imax-imin
                          aux1(i) = aux1(i)+ &
                     qgm(i,inr)*(becsum(iv,jv,na,kpoint)+becsum(jv,iv,na,kpoint))
                        enddo
                      endif
                      inr = inr +1
                    enddo
                 enddo
                 do i=imin+1,imax
                    qg(i+goffs) = qg(i+goffs)+&
                                  aux1(i-imin)*strfac(i-imin)
                 enddo
              endif  ! ityp .eq. nsp
            enddo
            if (lrec) goto 10
      enddo

#ifdef PARAL
!     assemble the qg on each process
      call par_sum_complex('A',qg,qg,ngdens_max,ngdens_max,1,&
#include PARAL_ARGS
           ,   timer)
#endif PARAL


#ifdef QRAD_SWAP 
      if (nspec.gt.1) close(44) ! qrad swap-file
#endif QRAD_SWAP 

      return
      end

!----------------------------------------------------------------------
subroutine wannier(lmastr,vkpt,&
#include         "apply_h_args.h"
                ,timer)
      use van_us_data_module
      use run_context
      use netcdfinterface
!---------------------------------------------------------------------- 
! 
! calculate                                        ^
!     1.  Q_nm(G) = sum(LM) c(LM,nm) Ylm(G)  Q_L(nm)  
!         c(LM,nm) is Clebsch-Gordon coefficients
! 
!          I 
!     2.  Q_nm(G)  = Qnm(G)  exp(-i G R ) 
!
!                                 I     I
!     3.  Int(dr exp(-Ga*r) Q_nm(r)) = Q_nm(G=Ga)
!
!     This is returned in the NetCDF variable WannierAugumentationFactor
!
!----------------------------------------------------------------------
      implicit none
#     include  "apply_h_decl.h"
      logical*4 lmastr
      real*8 vkpt  (3,nkprun)
      real*8     timer(*)

!     locals 
      integer j,GI,i1,i2,i3
      complex*16 strfac(7)
      ! complex*16 qgm(7,(nhm*(nhm+1))/2)
      complex*16 qgm(7,nhm*nhm)
      real*8 ylmk0(7 ,lqx*lqx)

      integer    inr,jkb,i,nsp,iv,jv,na,ik,mu,x1,x2,imin,imax,n(3)
      integer    nnh,ngdens1,igtongl1(7),ig,n1,n2,n3,nkp1
      integer    max_projector_per_atom,status,ncid
      real*8     arg,xyz(3),ZERO,eps,diff,mindiff
      real*8     g1(7,3),gg1(7),realw,imagw
      integer    map_to_wflist(ngx,ngy,ngz),GIlist(7,3)
      parameter  (ZERO=0.0d0,eps=1d-10,ngdens1=7)
      real*8, allocatable ::   wannierfactor(:,:,:,:,:) 
      real*8, allocatable ::   structurefactor(:,:,:) 
!     real_complex,GI,nions,max_projector_per_atom,max_projector_per_atom

      if (.not.lmastr) return

!     see for this direction we have more kpoints
      mindiff = 1000.
      n = 1
      do i = 1,3
          do nkp1 = 1,nkprun-1
             diff = dabs(vkpt(i,nkp1)-vkpt(i,nkp1+1))
             if (diff.gt.1e-5) then 
                if (diff.lt.mindiff) mindiff = diff
                n(i) = 2
             endif
          enddo
          if (n(i).gt.1) then 
             n(i) = nint(1.0/mindiff)
          endif
          write(nconso,*) 'Wannier: kpoints in direction n ',i,n(i)
      enddo



!     allocate wannierfactor
      max_projector_per_atom = maxval(nh(:))
      allocate(wannierfactor(2,7,nions,max_projector_per_atom,& 
                             max_projector_per_atom))

      GIlist(1,:) = (/0,0,0/)
      GIlist(2,:) = (/1,0,0/)
      GIlist(3,:) = (/0,1,0/)
      GIlist(4,:) = (/0,0,1/)
      GIlist(5,:) = (/1,1,0/)
      GIlist(6,:) = (/1,0,1/)
      GIlist(7,:) = (/0,1,1/)

      wannierfactor(:,:,:,:,:) = 0.0
      do i = 1,ngdens 
        i1 = ipwpadG(i,1) 
        i2 = ipwpadG(i,2) 
        i3 = ipwpadG(i,3) 
        map_to_wflist(i1,i2,i3) = i 
      enddo

      do GI = 1,7 

        ! setup list of reciprocal wavevectors G_I, 
        ! and setup a new igtongl list 
        n1 = GIlist(GI,1) +1
        n2 = GIlist(GI,2) +1
        n3 = GIlist(GI,3) +1
        ig = map_to_wflist(n1,n2,n3) 
        g1 (GI,1:3) = g(ig,1:3)
        gg1(GI)     = gg(ig)
        igtongl1(GI) = igtongl(ig)
      enddo

      ! loop over the G_(x,y,z) values 
      imin = 0
      imax = 7
#ifdef QRAD_SWAP 
      if (nspec.gt.1) then
         call openqrad(ngl)
      endif
#endif QRAD_SWAP
 
!     calculate q_nm in fourier space
      do nsp =1,nspec

#ifdef QRAD_SWAP 
            if (nspec.gt.1) then 
              call readqrad(ngldim,ngl,nsp,qrad,maxindex) 
            endif
#endif QRAD_SWAP


!           calculate ylmk0 for GI
            call ylmr2(lqx**2,imin,imax,ngdens1,g1,gg1,7,&
                    (lqx)**2,ylmk0)

            inr = 1
            nnh = nh(nsp)
            do iv = 1, nnh
               do jv = 1, nnh
!               get Qnm (qgm) 
                call qvan2(imin,imax,iv,jv,nsp,ngdens1,qgm(1,inr),ylmk0,&
                 qrad,ngdens1,nspec,ngldim,igtongl1,nhm,indv,&
                 nhtol,nhtom,ap,lpx,lpl,ivjv2index, & 
                 nbrx,nlx,mx,nbrx2dim,lqx)
               ! write(*,*) 'test ',iv,jv,qgm(:,inr)
                inr = inr + 1
               enddo
            enddo
            do na = 1,nions
              if (ityp(na).eq.nsp) then 
!                get the structure factor
                 call xyzposna(nions,nspec,nionsp,posion,na,dirc,xyz)
                 do GI=1,imax
                   arg = (g1(GI,1)*xyz(1)+g1(GI,2)*xyz(2)&
                            + g1(GI,3)*xyz(3))
                   strfac(GI) = dcmplx(cos(arg),-sin(arg))
                 enddo

                 inr = 1
                 do iv = 1, nh(nsp)
                    do jv = 1, nh(nsp)
                        do GI = 1,imax
                          realw = dreal(strfac(GI)*qgm(GI,inr))
                          imagw = dimag(strfac(GI)*qgm(GI,inr))
                          ! write(*,*) 'GI,iv,jv,na ',GI,iv,jv,na,realw,imagw
                          wannierfactor(1,GI,na,iv,jv) =realw
                          wannierfactor(2,GI,na,iv,jv) =imagw
                          ! wannierfactor(1,GI,na,jv,iv) =realw
                          ! wannierfactor(2,GI,na,jv,iv) =imagw
                        enddo
                        inr = inr + 1 
                    enddo 
                 enddo 
              endif  ! ityp .eq. nsp
            enddo
      enddo          ! nsp

#ifdef QRAD_SWAP 
      if (nspec.gt.1) close(44) ! qrad swap-file
#endif QRAD_SWAP 


!     write wannierfactor to netcdf file 
      status = nf_open(netCDF_output_filename,NF_WRITE, ncid )
      if (status /= nf_noerr) call abort_calc(nconso,  &
                   "wannier -> nfopen")

!     make sure we have the dim7 dimension
      status = nfputglobaldim(ncid,'dim7',7)
      if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize)) then
        write(nconso,*) 'nfputglobaldim: error writing dim7',&
        status
        call clexit(nconso)
      endif

      status = nfput(ncid,'WannierAugFactor',wannierfactor,     & 
                     dim_name1='real_complex',dim_name2='dim7', & 
                     dim_name3='number_of_dynamic_atoms',      &
	             dim_name4='max_projectors_per_atom',       & 
                     dim_name5='max_projectors_per_atom') 


!     save structure factor
      allocate(structurefactor(2,3,nions))
      do na = 1,nions
!          get the structure factor
           call xyzposna(nions,nspec,nionsp,posion,na,dirc,xyz)
           do GI=1,3
               arg = (g1(GI+1,1)*xyz(1)/float(n(1))+ & 
                      g1(GI+1,2)*xyz(2)/float(n(2))+&
                      g1(GI+1,3)*xyz(3)/float(n(3)))
               strfac(GI) = dcmplx(cos(arg),-sin(arg))
               structurefactor(1,GI,na) = dreal(strfac(GI))
               structurefactor(2,GI,na) = dimag(strfac(GI))
           enddo
      enddo
      status = nfput(ncid,'StructureFactor',structurefactor,    & 
                     dim_name1='real_complex',dim_name2='dim3', & 
                     dim_name3='number_of_dynamic_atoms')

      if (status /= nf_noerr) call abort_calc(nconso,  &
                   "wannier -> nfput WannierAugFactor")


      status = nf_close(ncid)
      return
      end
