from ASE.Calculators import PairPotential
from ASE import ListOfAtoms, Atom
from ASE.Dynamics import MDMin, ConjugateGradient
from ASE.Trajectories import NetCDFTrajectory
from ASE.Filters import Subset, NudgedElasticBand
from ASE.Visualization import RasMol
from ASE.Trajectories import NetCDFTrajectory
from math import sqrt


a = 4.05
b = a / sqrt(2)
h = b / 2
initial = ListOfAtoms([Atom('Al', (0, 0, 0)),
                       Atom('Al', (a / 2, b / 2, -h))],
                      periodic=(1, 1, 0),
                      cell=(a, b, -2 * h))
initial = initial.Repeat((3, 4, 2))
initial.append(Atom('Al', (a / 2, b / 2, h)))
#plot = RasMol(initial, (3, 2, 1))

final = initial.Copy()
print final[0].GetCartesianPosition()
final[0].SetCartesianPosition((-a / 2, -b / 2, h))
final[-1].SetCartesianPosition((0, 0, 0))
images = [initial]
for i in range(5):
    images.append(initial.Copy())
images.append(final)
for image in images:
    image.SetCalculator(PairPotential())

mask = [atom.GetCartesianPosition()[2] > -2.5 * h
                      for atom in initial]
image_subsets = [Subset(image, mask=mask) for image in images]

for endpoint in [image_subsets[0], image_subsets[-1]]:
    cg = ConjugateGradient(endpoint, fmax=0.05)
    cg.Converge()
    
neb = NudgedElasticBand(image_subsets)
neb.SetInterpolatedPositions()
minimizer = MDMin(neb, dt=0.08)
minimizer.Run(77)
print neb.GetListOfEnergies()

def NEBTrajectory(images, filename):
    atoms = images[0].Copy()
    traj = NetCDFTrajectory(filename, atoms)
    traj.Update()
    for image in images[1:]:
        atoms.SetCartesianPositions(image.GetCartesianPositions())
        traj.Update()
