from Dacapo import Dacapo
from ASE.Visualization.VTK import VTKPlotWaveFunction, VTKPlotAtoms

atoms = Dacapo.ReadAtoms('AlH_ontop.nc')

#Make a wavefunction plot, one has to give to band and the
#k-point the plot should be made for
#spin=0, if nonmagnetic calculation, otherwise spin=0 or 1
#k-points are numbered as can be seen in calc.GetIBZKpoints()
p1 = VTKPlotWaveFunction(atoms, band=3, kpointnumber = 6, spin=0)

#The wavefunction can be repeated
p1.SetPeriods((2,2,1))

#parent=p1 is used to indicate that the atoms should be plotted
#into the same plot as the wave function
p2 = VTKPlotAtoms(atoms,  parent=p1)
p2.SetPeriods((1, 1, 2))
p1.Update()


#If the unit cell at another place should be depicted
p1.SetTranslation((0, 0,-30))

#Usually one wants to pick a single isosurface and only look
#at that, otherwise it is hard to see anything
#Now change to only one contour at 2.5 and make it opaque
p1.SetRepresentationToIsoSurface2(contourvalues=[0.1])
p1.Render()
isosurface2=p1.GetIsoSurface2()
isosurface2.SetContourValues([0.1])
isosurface2.GetActorProperty().SetOpacity(1.0)
p1.Render()


#Save as BMP file with enlargement 2
p1.SaveAsBMP("wavefunction.bmp",2)
